ALTER TABLE ADR.ACTIVATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ACTIVATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.ACTIVATION
(
  ACTIVATION_ID             NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20),
  STD_MHDATASOURCE_ID       NUMBER(20),
  STD_NAMEDCONTINGENCY_ID   NUMBER(20),
  STD_TERMINATIONREASON_ID  NUMBER(20),
  STD_SPECIALOPERATION_ID   NUMBER(20),
  ACTIVATION_BEGIN_DATE     DATE,
  ACTIVATION_END_DATE       DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(18)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ACTIVATION IS 'A period that a veteran was activated or mobilized to active duty.';

COMMENT ON COLUMN ADR.ACTIVATION.ACTIVATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ACTIVATION.STD_MHDATASOURCE_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.ACTIVATION.STD_NAMEDCONTINGENCY_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.ACTIVATION.STD_TERMINATIONREASON_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.ACTIVATION.STD_SPECIALOPERATION_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.ACTIVATION.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.ACTIVATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ACTIVATION.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.ACTIVATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ACTIVATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ACT_MHDS_FK_I ON ADR.ACTIVATION
(STD_MHDATASOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ACT_NC_FK_I ON ADR.ACTIVATION
(STD_NAMEDCONTINGENCY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ACT_PK ON ADR.ACTIVATION
(ACTIVATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ACT_PRSN_FK_I ON ADR.ACTIVATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ACT_SO_FK_I ON ADR.ACTIVATION
(STD_SPECIALOPERATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ACT_TR_FK_I ON ADR.ACTIVATION
(STD_TERMINATIONREASON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ACTIVATION_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.ACTIVATION
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into ACTIVATION_H
        (
        ACTIVATION_H_ID,
        ACTIVATION_ID,
        PERSON_ID,
        STD_MHDATASOURCE_ID,
        STD_NAMEDCONTINGENCY_ID,
        STD_TERMINATIONREASON_ID,
        STD_SPECIALOPERATION_ID,
        ACTIVATION_BEGIN_DATE,
        ACTIVATION_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        ACTIVATION_H_S.nextval,
        :old.ACTIVATION_ID,
        :old.PERSON_ID,
        :old.STD_MHDATASOURCE_ID,
        :old.STD_NAMEDCONTINGENCY_ID,
        :old.STD_TERMINATIONREASON_ID,
        :old.STD_SPECIALOPERATION_ID,
        :old.ACTIVATION_BEGIN_DATE,
        :old.ACTIVATION_END_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into ACTIVATION_H
        (
        ACTIVATION_H_ID,
        ACTIVATION_ID,
        PERSON_ID,
        STD_MHDATASOURCE_ID,
        STD_NAMEDCONTINGENCY_ID,
        STD_TERMINATIONREASON_ID,
        STD_SPECIALOPERATION_ID,
        ACTIVATION_BEGIN_DATE,
        ACTIVATION_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        ACTIVATION_H_S.nextval,
        :new.ACTIVATION_ID,
        :new.PERSON_ID,
        :new.STD_MHDATASOURCE_ID,
        :new.STD_NAMEDCONTINGENCY_ID,
        :new.STD_TERMINATIONREASON_ID,
        :new.STD_SPECIALOPERATION_ID,
        :new.ACTIVATION_BEGIN_DATE,
        :new.ACTIVATION_END_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end ACTIVATION_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ACTIVATION FOR ADR.ACTIVATION;


ALTER TABLE ADR.ACTIVATION ADD (
  CONSTRAINT ACT_PK
  PRIMARY KEY
  (ACTIVATION_ID)
  USING INDEX ADR.ACT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ACTIVATION ADD (
  CONSTRAINT RELATIONSHIP43 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ACTIVATION TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.ACTIVATION TO ADR_RW;

GRANT SELECT ON ADR.ACTIVATION TO ES_R;

GRANT INSERT, SELECT ON ADR.ACTIVATION TO ES_RW;
ALTER TABLE ADR.ACTIVATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ACTIVATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ACTIVATION_H
(
  ACTIVATION_H_ID           NUMBER(20)          NOT NULL,
  ACTIVATION_ID             NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20),
  STD_SPECIALOPERATION_ID   NUMBER(20),
  STD_TERMINATIONREASON_ID  NUMBER(20),
  STD_NAMEDCONTINGENCY_ID   NUMBER(20),
  STD_MHDATASOURCE_ID       NUMBER(20),
  ACTIVATION_BEGIN_DATE     DATE,
  ACTIVATION_END_DATE       DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(18)          NOT NULL,
  HISTORY_CREATED_DATE      DATE,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ACTIVATION_H IS 'A period that a veteran was activated or mobilized to active duty.';

COMMENT ON COLUMN ADR.ACTIVATION_H.ACTIVATION_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ACTIVATION_H.ACTIVATION_ID IS 'Unique identifier for an Activation';

COMMENT ON COLUMN ADR.ACTIVATION_H.PERSON_ID IS 'Person Identifier';

COMMENT ON COLUMN ADR.ACTIVATION_H.STD_SPECIALOPERATION_ID IS 'New SDS lookup';

COMMENT ON COLUMN ADR.ACTIVATION_H.STD_TERMINATIONREASON_ID IS 'New SDS lookup';

COMMENT ON COLUMN ADR.ACTIVATION_H.STD_NAMEDCONTINGENCY_ID IS 'New SDS lookup';

COMMENT ON COLUMN ADR.ACTIVATION_H.STD_MHDATASOURCE_ID IS 'New SDS lookup';

COMMENT ON COLUMN ADR.ACTIVATION_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.ACTIVATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ACTIVATION_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.ACTIVATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ACTIVATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.ACTIVATION_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.ACT_H_PERSON_ID ON ADR.ACTIVATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ACT_H_PK ON ADR.ACTIVATION_H
(ACTIVATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ACTIVATION_H FOR ADR.ACTIVATION_H;


ALTER TABLE ADR.ACTIVATION_H ADD (
  CONSTRAINT AVCON_1252960469_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ACT_H_PK
  PRIMARY KEY
  (ACTIVATION_H_ID)
  USING INDEX ADR.ACT_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ACTIVATION_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.ACTIVATION_H TO ADR_RW;

GRANT SELECT ON ADR.ACTIVATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ACTIVATION_H TO ES_RW;
DROP TABLE ADR.ACTIVEAGG CASCADE CONSTRAINTS;

CREATE TABLE ADR.ACTIVEAGG
(
  PERID                 VARCHAR2(11 BYTE),
  ICN                   VARCHAR2(29 BYTE),
  EDIPI                 VARCHAR2(20 BYTE),
  SSN                   VARCHAR2(9 BYTE),
  LN                    VARCHAR2(35 BYTE),
  FN                    VARCHAR2(25 BYTE),
  MN                    VARCHAR2(25 BYTE),
  SUF                   VARCHAR2(10 BYTE),
  DOB                   VARCHAR2(8 BYTE),
  DOD                   VARCHAR2(14 BYTE),
  GENDER                VARCHAR2(1 BYTE),
  ENR_DTE               VARCHAR2(8 BYTE),
  CV_ELIG               VARCHAR2(8 BYTE),
  ELIG_VERIFIED         VARCHAR2(1 BYTE),
  ENR_CODE              VARCHAR2(2 BYTE),
  PRIORITY              VARCHAR2(2 BYTE),
  ENR_CRE_DTE           VARCHAR2(8 BYTE),
  ADD_TYPE              VARCHAR2(1 BYTE),
  BAI                   VARCHAR2(1 BYTE),
  ADDRESS_ID            VARCHAR2(11 BYTE),
  ST1                   VARCHAR2(70 BYTE),
  ST2                   VARCHAR2(70 BYTE),
  ST3                   VARCHAR2(70 BYTE),
  CITY                  VARCHAR2(60 BYTE),
  STATE                 VARCHAR2(5 BYTE),
  ZIP                   VARCHAR2(5 BYTE),
  ZIP4                  VARCHAR2(4 BYTE),
  COUNTRY               VARCHAR2(3 BYTE),
  ADT                   VARCHAR2(14 BYTE),
  PFA                   VARCHAR2(25 BYTE),
  PCF                   VARCHAR2(10 BYTE),
  HPN                   VARCHAR2(35 BYTE),
  CPN                   VARCHAR2(25 BYTE),
  WPN                   VARCHAR2(25 BYTE),
  APN                   VARCHAR2(25 BYTE),
  TSTART                VARCHAR2(8 BYTE),
  TEND                  VARCHAR2(8 BYTE),
  PF_NO                 VARCHAR2(6 BYTE),
  PF_NAME               VARCHAR2(80 BYTE),
  VCE                   VARCHAR2(3 BYTE),
  SCI                   VARCHAR2(1 BYTE),
  SC_PCT                VARCHAR2(3 BYTE),
  SAI                   VARCHAR2(1 BYTE),
  SALIST                VARCHAR2(25 BYTE),
  NSCI                  VARCHAR2(1 BYTE),
  NLE_ES                VARCHAR2(1 BYTE),
  STA_VISN              VARCHAR2(2 BYTE),
  STA_NO                VARCHAR2(6 BYTE),
  STA_NAME              VARCHAR2(75 BYTE),
  EE_FLAG               VARCHAR2(1 BYTE),
  DISTANCE              VARCHAR2(21 BYTE),
  OPP_FLAG              VARCHAR2(1 BYTE),
  ADR_LON               VARCHAR2(20 BYTE),
  ADR_LAT               VARCHAR2(20 BYTE),
  STA_ST1               VARCHAR2(70 BYTE),
  STA_ST2               VARCHAR2(50 BYTE),
  STA_ST3               VARCHAR2(50 BYTE),
  STA_CITY              VARCHAR2(25 BYTE),
  STA_STATE             VARCHAR2(2 BYTE),
  STA_ZIP               VARCHAR2(5 BYTE),
  STA_ZIP4              VARCHAR2(4 BYTE),
  STA_LON               VARCHAR2(20 BYTE),
  STA_LAT               VARCHAR2(20 BYTE),
  LOC_NAME              VARCHAR2(30 BYTE),
  GEO_DATE              VARCHAR2(8 BYTE),
  SOFTWARE_VER          VARCHAR2(50 BYTE),
  STATUS                VARCHAR2(1 BYTE),
  STATUS_DATE           VARCHAR2(1 BYTE),
  MAILING_EXCEPTION     VARCHAR2(1 BYTE),
  TIME_COHORT           VARCHAR2(1 BYTE),
  BASIC_ELIG            VARCHAR2(1 BYTE),
  GEO_TIME_FRAME_BEGIN  VARCHAR2(14 BYTE),
  GEO_TIME_FRAME_END    VARCHAR2(14 BYTE),
  WT_RUN_TIME           VARCHAR2(14 BYTE),
  VBA_DOD               VARCHAR2(8 BYTE),
  EVER_GEO_CODED        INTEGER,
  CALC_TYPE             VARCHAR2(2 BYTE),
  DD_BASIC_ELIG         VARCHAR2(1 BYTE),
  DD_NLE_ES             VARCHAR2(1 BYTE),
  VISN                  VARCHAR2(2 BYTE),
  URH                   VARCHAR2(1 BYTE),
  FIPS                  VARCHAR2(5 BYTE),
  MARKET                VARCHAR2(4 BYTE),
  SUBMARKET             VARCHAR2(6 BYTE),
  SECTOR                VARCHAR2(8 BYTE),
  STATE_FIPS            VARCHAR2(2 BYTE),
  S_CLASS_NAME          VARCHAR2(20 BYTE),
  OUTPATIENTRATING      VARCHAR2(25 BYTE),
  PAR_STA_NO            VARCHAR2(6 BYTE),
  PARENTSTATIONCL       VARCHAR2(80 BYTE),
  SH_PAR_STA            VARCHAR2(6 BYTE),
  VA_SITE               VARCHAR2(1 BYTE),
  ST                    VARCHAR2(2 BYTE),
  POD                   VARCHAR2(1 BYTE),
  SHAR                  VARCHAR2(1 BYTE),
  HCC                   NUMBER(3),
  MSCBOC                NUMBER(3),
  NEWVAMC               NUMBER(3),
  PCCBOC                NUMBER(3),
  COCCLASSIFICATIONID   NUMBER(3),
  VAH                   NUMBER(3),
  CD                    VARCHAR2(20 BYTE),
  CONT                  VARCHAR2(1 BYTE),
  PROV                  INTEGER,
  VACAA_LIST_DATE       DATE,
  NLE_ES_DATE           VARCHAR2(14 BYTE),
  COUNTY_NAME           VARCHAR2(50 BYTE),
  MARKET_NAME           VARCHAR2(50 BYTE),
  DATASOURCE            VARCHAR2(10 BYTE),
  DISTRICT              VARCHAR2(2 BYTE),
  STA_DISTRICT_VISN     VARCHAR2(5 BYTE),
  RECORD_CREATED_TS     DATE                    DEFAULT TRUNC (SYSDATE)       NOT NULL,
  WT_INFO_CONCATTED     CLOB
)
LOB (WT_INFO_CONCATTED) STORE AS SECUREFILE (
  TABLESPACE  L_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  NOCACHE
  LOGGING)
NOCOMPRESS 
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOLOGGING
PARTITION BY RANGE (RECORD_CREATED_TS)
INTERVAL( NUMTODSINTERVAL (1, 'DAY'))
(  
  PARTITION P1 VALUES LESS THAN (TO_DATE(' 2016-11-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_DATA_01
    LOB (WT_INFO_CONCATTED) STORE AS SECUREFILE (
      TABLESPACE  L_DATA_01
      ENABLE      STORAGE IN ROW
      CHUNK       8192
      RETENTION
      NOCACHE
      LOGGING)
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-05-27 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_DATA_01
    LOB (WT_INFO_CONCATTED) STORE AS SECUREFILE (
      TABLESPACE  L_DATA_01
      ENABLE      STORAGE IN ROW
      CHUNK       8192
      RETENTION
      NOCACHE
      LOGGING
          STORAGE    (
                      INITIAL          128M
                      NEXT             128M
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                      FLASH_CACHE      DEFAULT
                      CELL_FLASH_CACHE DEFAULT
                     ))
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-05-31 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_DATA_01
    LOB (WT_INFO_CONCATTED) STORE AS SECUREFILE (
      TABLESPACE  L_DATA_01
      ENABLE      STORAGE IN ROW
      CHUNK       8192
      RETENTION
      NOCACHE
      LOGGING
          STORAGE    (
                      INITIAL          128M
                      NEXT             128M
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                      FLASH_CACHE      DEFAULT
                      CELL_FLASH_CACHE DEFAULT
                     ))
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_DATA_01
    LOB (WT_INFO_CONCATTED) STORE AS SECUREFILE (
      TABLESPACE  L_DATA_01
      ENABLE      STORAGE IN ROW
      CHUNK       8192
      RETENTION
      NOCACHE
      LOGGING
          STORAGE    (
                      INITIAL          128M
                      NEXT             128M
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                      FLASH_CACHE      DEFAULT
                      CELL_FLASH_CACHE DEFAULT
                     ))
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-06-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_DATA_01
    LOB (WT_INFO_CONCATTED) STORE AS SECUREFILE (
      TABLESPACE  L_DATA_01
      ENABLE      STORAGE IN ROW
      CHUNK       8192
      RETENTION
      NOCACHE
      LOGGING
          STORAGE    (
                      INITIAL          128M
                      NEXT             128M
                      MINEXTENTS       1
                      MAXEXTENTS       UNLIMITED
                      PCTINCREASE      0
                      BUFFER_POOL      DEFAULT
                      FLASH_CACHE      DEFAULT
                      CELL_FLASH_CACHE DEFAULT
                     ))
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;


CREATE INDEX ADR.ACTIVEAGG_PERID_NU ON ADR.ACTIVEAGG
(PERID)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
NOLOGGING
LOCAL (  
  PARTITION P1
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ACTIVEAGG FOR ADR.ACTIVEAGG;


GRANT SELECT ON ADR.ACTIVEAGG TO ADR_R;

GRANT DELETE, INDEX, INSERT, SELECT, UPDATE ON ADR.ACTIVEAGG TO EEUSR;

GRANT SELECT ON ADR.ACTIVEAGG TO VETCHOICEUSR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ACTIVEAGG TO VETCHOICEUSR_RW;
ALTER TABLE ADR.ACTIVEAGG_TRACKER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ACTIVEAGG_TRACKER CASCADE CONSTRAINTS;

CREATE TABLE ADR.ACTIVEAGG_TRACKER
(
  ACTIVEAGG_TRACKER_ID  NUMBER(20)              NOT NULL,
  LOADING_STATUS        VARCHAR2(20 BYTE)       DEFAULT 'NO',
  LOG_MESSAGE           VARCHAR2(500 BYTE),
  PREVIOUS_ACTIVE_DATE  DATE                    DEFAULT TRUNC (SYSDATE)       NOT NULL,
  CURRENT_ACTIVE_DATE   DATE                    DEFAULT TRUNC (SYSDATE)       NOT NULL,
  RECORD_CREATED_TS     DATE                    DEFAULT SYSDATE               NOT NULL,
  RECORD_MODIFIED_TS    DATE                    DEFAULT SYSDATE               NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ACTIVEAGG_TRACKER IS 'Stores all metadata required for the OPP extract such TEMP table names and keeps track what to execute and when along with loading times';

COMMENT ON COLUMN ADR.ACTIVEAGG_TRACKER.LOG_MESSAGE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ACTIVEAGG_TRACKER.PREVIOUS_ACTIVE_DATE IS 'Previous active day for which data is made available for users';

COMMENT ON COLUMN ADR.ACTIVEAGG_TRACKER.CURRENT_ACTIVE_DATE IS 'current active day for which data is loaded into table';

COMMENT ON COLUMN ADR.ACTIVEAGG_TRACKER.RECORD_CREATED_TS IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ACTIVEAGG_TRACKER.RECORD_MODIFIED_TS IS 'Date of this modification to the record.';


CREATE UNIQUE INDEX ADR.ACTIVEAGG_TRACKER_PK ON ADR.ACTIVEAGG_TRACKER
(ACTIVEAGG_TRACKER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ACTIVEAGG_TRACKER_BUR_TRGR
   BEFORE UPDATE
   ON ADR.ACTIVEAGG_TRACKER
   REFERENCING NEW AS New OLD AS Old
   FOR EACH ROW
DECLARE
BEGIN

   :new.RECORD_MODIFIED_TS := SYSDATE;
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.put_line (SUBSTR (   DBMS_UTILITY.FORMAT_CALL_STACK
                                    || DBMS_UTILITY.format_error_stack
                                    || DBMS_UTILITY.format_error_backtrace,
                                    1,
                                    2000));
END ACTIVEAGG_TRACKER_BUR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM ACTIVEAGG_TRACKER FOR ADR.ACTIVEAGG_TRACKER;


ALTER TABLE ADR.ACTIVEAGG_TRACKER ADD (
  CONSTRAINT LOADING_STATUS_CHK
  CHECK (LOADING_STATUS IN ('YES','FAIL'))
  ENABLE VALIDATE,
  CONSTRAINT APP_LOG_PK
  PRIMARY KEY
  (ACTIVEAGG_TRACKER_ID)
  USING INDEX ADR.ACTIVEAGG_TRACKER_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ACTIVEAGG_TRACKER TO ADR_R;

GRANT SELECT, UPDATE ON ADR.ACTIVEAGG_TRACKER TO EEUSR;

GRANT SELECT ON ADR.ACTIVEAGG_TRACKER TO VETCHOICEUSR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ACTIVEAGG_TRACKER TO VETCHOICEUSR_RW;
ALTER TABLE ADR.ADDRESS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADDRESS CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADDRESS
(
  ADDRESS_ID                     NUMBER(20),
  PERSON_ID                      NUMBER(20),
  INSURANCE_ID                   NUMBER(20),
  STD_ADDRESSTYPE_ID             NUMBER(20),
  ADDRESS_CHANGE_SRC_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ADDRESS_INVALID_TYPE_ID        NUMBER(20),
  NCOA_STATUS_TYPE_ID            NUMBER(20),
  NCOA_DELIVERY_TYPE_ID          NUMBER(20),
  NCOA_ZIP_MATCH_TYPE_ID         NUMBER(20),
  NCOA_ZIP_NO_MATCH_TYPE_ID      NUMBER(20),
  ADDRESS_LINE1                  VARCHAR2(100 BYTE),
  ADDRESS_LINE2                  VARCHAR2(100 BYTE),
  ADDRESS_LINE3                  VARCHAR2(100 BYTE),
  CITY                           VARCHAR2(60 BYTE),
  STATE_CODE                     VARCHAR2(50 BYTE),
  COUNTY_CODE                    VARCHAR2(50 BYTE),
  PROVINCE_CODE                  VARCHAR2(50 BYTE),
  ZIP_CODE                       VARCHAR2(20 BYTE),
  ZIP_PLUS_4                     VARCHAR2(10 BYTE),
  POSTAL_CODE                    VARCHAR2(20 BYTE),
  COUNTRY_CODE                   VARCHAR2(50 BYTE),
  ADDRESS_CHANGE_EFFECTIVE_DATE  DATE,
  ADDRESS_INVALIDATED_DATE       DATE,
  NCOA_ADDRESS_CHECK_DATE        DATE,
  ADDRESS_START_DATE_TXT         VARCHAR2(14 BYTE),
  ADDRESS_END_DATE_TXT           VARCHAR2(14 BYTE),
  ADDRESS_PHONE_NUMBER           VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  RECORD_MODIFIED_SRC_NAME       VARCHAR2(30 BYTE),
  PERSON_RELATION_ID             NUMBER(20),
  CASSCERTIFIEDTYPE_ID           NUMBER(20),
  CASS_CERTIFIED_DATE            DATE,
  PURPOSE_OF_USE_TYPE_ID         NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADDRESS IS 'The ADDRESS table contains the components of primary, temporary, and confidential addresses for persons and addresses for insurance companies. This table also contains data used in the checking of values with National Change of Address (NCOA). Maintains all types of addresses for Persons. Also stores Insurance Company address. Foreign Keys present in table: PERSON_ID INSURANCE_ID ADDRESS_TYPE_ID (Types of addresses applicable to persons - Residential, Business etc.) ADDRESS_CHANGE_SRC_TYPE_ID (Source of the address change such as HEC, NCOA etc.) STD_INSTITUTION_ID (Site making the address change) ADDRESS_INVALID_TYPE_ID (Why the address cannot be used - Homeless, Undeliverable etc.) NCOA_STATUS_TYPE_ID ( Sent to NCOA, Not sent or Checked by NCOA) NCOA_DELIVERY_TYPE_ID ( Address good No Address Change, Foreign move etc.) NCOA_ZIP_MATCH_TYPE_ID (Building/High-Rise, Rural Route etc.) NCOA_ZIP_NO_MATCH_TYPE_ID DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ADDRESS.PERSON_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.INSURANCE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.STD_ADDRESSTYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_CHANGE_SRC_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_INVALID_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_STATUS_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_DELIVERY_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_ZIP_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_ZIP_NO_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS.CITY IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.ADDRESS.COUNTY_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS.POSTAL_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS.COUNTRY_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof addresswentintoeffect.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_INVALIDATED_DATE IS 'Dateonwhichanaddress wasdeterminedtobe invalid.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_ADDRESS_CHECK_DATE IS 'Dateonwhichanaddress wascheckedagainstNCOA. Dateaddresscheckedwith NCOAisdefinedasa validdatethatissetby theAAConcetheNCOA checkiscompleted.Fortherecordsthatare returnedtoADRviathe NCOAAddresscheckfile- thisdatewillbethe NCOADateChecked containedonthatfile. ForRecordsreturnedvia anaddresschangethis datewillbethedatethe Z05(addresssource= NCOA)datawasuploaded ontheADR.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_START_DATE_TXT IS 'Addressstartdateis definedasthedatean addressbecamevalidto useforaparty.Address startdatecanbea futuredate.Address becomesactive/current onthestartdate.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_END_DATE_TXT IS 'Addressenddateis definedasthedatean addressstoppedbeing usedforaparty.Address enddatecannotbebefore addressstartdate. Addressenddatecanbea futuredate.Address becomesinactiveonthe enddate.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_PHONE_NUMBER IS 'Telephone number associated with a temporary address.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.ADDRESS.PERSON_RELATION_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.PURPOSE_OF_USE_TYPE_ID IS 'Foreign Key on ADR.PURPOSE_OF_USE_TYPE';


CREATE INDEX ADR.ADDR_INSURANCE_FK_I ON ADR.ADDRESS
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ADDR_PK ON ADR.ADDRESS
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_PRSNREL_FK_I ON ADR.ADDRESS
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_PRSN_FK_I ON ADR.ADDRESS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STDADDRTYPE_FK_I ON ADR.ADDRESS
(STD_ADDRESSTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STDINST_FK_I ON ADR.ADDRESS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_ADDRCHGSRC_FK_I ON ADR.ADDRESS
(ADDRESS_CHANGE_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_ADDRDELFLR_FK_I ON ADR.ADDRESS
(ADDRESS_INVALID_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOADELTYP_FK_I ON ADR.ADDRESS
(NCOA_DELIVERY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOASTATYP_FK_I ON ADR.ADDRESS
(NCOA_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOAZIPMCH_FK_I ON ADR.ADDRESS
(NCOA_ZIP_MATCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOAZIPNOMTCH_FK_I ON ADR.ADDRESS
(NCOA_ZIP_NO_MATCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ADDRESS_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON ADR.ADDRESS FOR EACH ROW
declare
    mDML char(1);
begin

  if DELETING then
    insert into ADDRESS_H
    (
    ADDRESS_H_ID,
    ADDRESS_ID  ,
    PERSON_ID   ,
    INSURANCE_ID,
    STD_ADDRESSTYPE_ID,
    ADDRESS_CHANGE_SRC_TYPE_ID,
    STD_INSTITUTION_ID        ,
    ADDRESS_INVALID_TYPE_ID   ,
    NCOA_STATUS_TYPE_ID       ,
    NCOA_DELIVERY_TYPE_ID     ,
    NCOA_ZIP_MATCH_TYPE_ID    ,
    ADDRESS_LINE1             ,
    ADDRESS_LINE2             ,
    ADDRESS_LINE3             ,
    CITY                      ,
    STATE_CODE                ,
    COUNTY_CODE               ,
    PROVINCE_CODE             ,
    POSTAL_CODE               ,
    ZIP_PLUS_4                ,
    COUNTRY_CODE              ,
    ADDRESS_CHANGE_EFFECTIVE_DATE,
    ADDRESS_INVALIDATED_DATE  ,
    NCOA_ADDRESS_CHECK_DATE   ,
    ADDRESS_START_DATE_TXT   ,
    ADDRESS_END_DATE_TXT     ,
    RECORD_CREATED_BY         ,
    RECORD_CREATED_DATE       ,
    RECORD_MODIFIED_BY        ,
    RECORD_MODIFIED_DATE      ,
    RECORD_MODIFIED_COUNT     ,
    ADDRESS_PHONE_NUMBER,
    ZIP_CODE                  ,
    NCOA_ZIP_NO_MATCH_TYPE_ID ,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    CASSCERTIFIEDTYPE_ID,
    CASS_CERTIFIED_DATE,
    purpose_of_use_type_id,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    ADDRESS_h_s.nextval,
    :old.ADDRESS_ID  ,
    :old.PERSON_ID   ,
    :old.INSURANCE_ID,
    :old.STD_ADDRESSTYPE_ID,
    :old.ADDRESS_CHANGE_SRC_TYPE_ID,
    :old.STD_INSTITUTION_ID        ,
    :old.ADDRESS_INVALID_TYPE_ID   ,
    :old.NCOA_STATUS_TYPE_ID       ,
    :old.NCOA_DELIVERY_TYPE_ID     ,
    :old.NCOA_ZIP_MATCH_TYPE_ID    ,
    :old.ADDRESS_LINE1             ,
    :old.ADDRESS_LINE2             ,
    :old.ADDRESS_LINE3             ,
    :old.CITY                      ,
    :old.STATE_CODE                ,
    :old.COUNTY_CODE               ,
    :old.PROVINCE_CODE             ,
    :old.POSTAL_CODE               ,
    :old.ZIP_PLUS_4                ,
    :old.COUNTRY_CODE              ,
    :old.ADDRESS_CHANGE_EFFECTIVE_DATE,
    :old.ADDRESS_INVALIDATED_DATE  ,
    :old.NCOA_ADDRESS_CHECK_DATE   ,
    :old.ADDRESS_START_DATE_TXT   ,
    :old.ADDRESS_END_DATE_TXT     ,
    :old.RECORD_CREATED_BY         ,
    :old.RECORD_CREATED_DATE       ,
    :old.RECORD_MODIFIED_BY        ,
    :old.RECORD_MODIFIED_DATE      ,
    :old.RECORD_MODIFIED_COUNT     ,
    :old.ADDRESS_PHONE_NUMBER,
    :old.ZIP_CODE                  ,
    :old.NCOA_ZIP_NO_MATCH_TYPE_ID ,
    :old.RECORD_MODIFIED_SRC_NAME,
    :old.PERSON_RELATION_ID,
    :old.CASSCERTIFIEDTYPE_ID,
    :old.CASS_CERTIFIED_DATE,
    :old.purpose_of_use_type_id,
    'D'
    );
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into ADDRESS_H
    (
    ADDRESS_H_ID,
    ADDRESS_ID  ,
    PERSON_ID   ,
    INSURANCE_ID,
    STD_ADDRESSTYPE_ID,
    ADDRESS_CHANGE_SRC_TYPE_ID,
    STD_INSTITUTION_ID        ,
    ADDRESS_INVALID_TYPE_ID   ,
    NCOA_STATUS_TYPE_ID       ,
    NCOA_DELIVERY_TYPE_ID     ,
    NCOA_ZIP_MATCH_TYPE_ID    ,
    ADDRESS_LINE1             ,
    ADDRESS_LINE2             ,
    ADDRESS_LINE3             ,
    CITY                      ,
    STATE_CODE                ,
    COUNTY_CODE               ,
    PROVINCE_CODE             ,
    POSTAL_CODE               ,
    ZIP_PLUS_4                ,
    COUNTRY_CODE              ,
    ADDRESS_CHANGE_EFFECTIVE_DATE,
    ADDRESS_INVALIDATED_DATE  ,
    NCOA_ADDRESS_CHECK_DATE   ,
    ADDRESS_START_DATE_TXT   ,
    ADDRESS_END_DATE_TXT     ,
    RECORD_CREATED_BY         ,
    RECORD_CREATED_DATE       ,
    RECORD_MODIFIED_BY        ,
    RECORD_MODIFIED_DATE      ,
    RECORD_MODIFIED_COUNT     ,
    ADDRESS_PHONE_NUMBER,
    ZIP_CODE                  ,
    NCOA_ZIP_NO_MATCH_TYPE_ID ,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    CASSCERTIFIEDTYPE_ID,
    CASS_CERTIFIED_DATE,
    purpose_of_use_type_id,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    ADDRESS_h_s.nextval,
    :new.ADDRESS_ID  ,
    :new.PERSON_ID   ,
    :new.INSURANCE_ID,
    :new.STD_ADDRESSTYPE_ID,
    :new.ADDRESS_CHANGE_SRC_TYPE_ID,
    :new.STD_INSTITUTION_ID        ,
    :new.ADDRESS_INVALID_TYPE_ID   ,
    :new.NCOA_STATUS_TYPE_ID       ,
    :new.NCOA_DELIVERY_TYPE_ID     ,
    :new.NCOA_ZIP_MATCH_TYPE_ID    ,
    :new.ADDRESS_LINE1             ,
    :new.ADDRESS_LINE2             ,
    :new.ADDRESS_LINE3             ,
    :new.CITY                      ,
    :new.STATE_CODE                ,
    :new.COUNTY_CODE               ,
    :new.PROVINCE_CODE             ,
    :new.POSTAL_CODE               ,
    :new.ZIP_PLUS_4                ,
    :new.COUNTRY_CODE              ,
    :new.ADDRESS_CHANGE_EFFECTIVE_DATE,
    :new.ADDRESS_INVALIDATED_DATE  ,
    :new.NCOA_ADDRESS_CHECK_DATE   ,
    :new.ADDRESS_START_DATE_TXT   ,
    :new.ADDRESS_END_DATE_TXT     ,
    :new.RECORD_CREATED_BY         ,
    :new.RECORD_CREATED_DATE       ,
    :new.RECORD_MODIFIED_BY        ,
    :new.RECORD_MODIFIED_DATE      ,
    :new.RECORD_MODIFIED_COUNT     ,
    :new.ADDRESS_PHONE_NUMBER,
    :new.ZIP_CODE                  ,
    :new.NCOA_ZIP_NO_MATCH_TYPE_ID ,
    :new.RECORD_MODIFIED_SRC_NAME,
    :new.PERSON_RELATION_ID,
    :new.CASSCERTIFIEDTYPE_ID,
    :new.CASS_CERTIFIED_DATE,
    :new.purpose_of_use_type_id,
    mDML
    );
  end if;

end ADDRESS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ADDRESS FOR ADR.ADDRESS;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067422
  CHECK ("ADDRESS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067423
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067424
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067425
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067426
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067427
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_PK
  PRIMARY KEY
  (ADDRESS_ID)
  USING INDEX ADR.ADDR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOADELTYP_FK 
  FOREIGN KEY (NCOA_DELIVERY_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOADELIVERYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOASTATYP_FK 
  FOREIGN KEY (NCOA_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOASTATUSTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOAZIPMCH_FK 
  FOREIGN KEY (NCOA_ZIP_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOAZIPNOMTCH_FK 
  FOREIGN KEY (NCOA_ZIP_NO_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPNOMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT PURPOSE_OF_USE_FK 
  FOREIGN KEY (PURPOSE_OF_USE_TYPE_ID) 
  REFERENCES ADR.PURPOSE_OF_USE_TYPE (PURPOSE_OF_USE_TYPE_ID)
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ADDRESS TO ADREXT;

GRANT SELECT ON ADR.ADDRESS TO ADRTMP;

GRANT SELECT ON ADR.ADDRESS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDRESS TO ADR_RW;

GRANT INSERT, SELECT, UPDATE ON ADR.ADDRESS TO ESCISSEEDINGUSR;

GRANT SELECT ON ADR.ADDRESS TO ES_R;

GRANT INSERT, SELECT ON ADR.ADDRESS TO ES_RW;

GRANT SELECT ON ADR.ADDRESS TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.ADDRESS TO PSIM_ADR_RW;
ALTER TABLE ADR.ADDRESS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADDRESS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADDRESS_H
(
  ADDRESS_H_ID                   NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  ADDRESS_ID                     NUMBER(20),
  PERSON_ID                      NUMBER(20),
  INSURANCE_ID                   NUMBER(20),
  STD_ADDRESSTYPE_ID             NUMBER(20),
  ADDRESS_CHANGE_SRC_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ADDRESS_INVALID_TYPE_ID        NUMBER(20),
  NCOA_STATUS_TYPE_ID            NUMBER(20),
  NCOA_DELIVERY_TYPE_ID          NUMBER(20),
  NCOA_ZIP_MATCH_TYPE_ID         NUMBER(20),
  NCOA_ZIP_NO_MATCH_TYPE_ID      NUMBER(20),
  NCOA_ADDRESS_CHECK_DATE        DATE,
  ADDRESS_LINE1                  VARCHAR2(100 BYTE),
  ADDRESS_LINE2                  VARCHAR2(100 BYTE),
  ADDRESS_LINE3                  VARCHAR2(100 BYTE),
  CITY                           VARCHAR2(60 BYTE),
  STATE_CODE                     VARCHAR2(50 BYTE),
  COUNTY_CODE                    VARCHAR2(50 BYTE),
  PROVINCE_CODE                  VARCHAR2(50 BYTE),
  ZIP_CODE                       VARCHAR2(20 BYTE),
  ZIP_PLUS_4                     VARCHAR2(10 BYTE),
  POSTAL_CODE                    VARCHAR2(20 BYTE),
  COUNTRY_CODE                   VARCHAR2(50 BYTE),
  ADDRESS_CHANGE_EFFECTIVE_DATE  DATE,
  ADDRESS_INVALIDATED_DATE       DATE,
  ADDRESS_START_DATE_TXT         VARCHAR2(14 BYTE),
  ADDRESS_END_DATE_TXT           VARCHAR2(14 BYTE),
  ADDRESS_PHONE_NUMBER           VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  RECORD_MODIFIED_SRC_NAME       VARCHAR2(30 BYTE),
  PERSON_RELATION_ID             NUMBER(20),
  CASSCERTIFIEDTYPE_ID           NUMBER(20),
  CASS_CERTIFIED_DATE            DATE,
  PURPOSE_OF_USE_TYPE_ID         NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADDRESS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ADDRESS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.PERSON_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.INSURANCE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.STD_ADDRESSTYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_CHANGE_SRC_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.STD_INSTITUTION_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_INVALID_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_STATUS_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_DELIVERY_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_ZIP_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_ZIP_NO_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_ADDRESS_CHECK_DATE IS 'Dateonwhichanaddress wascheckedagainstNCOA. Dateaddresscheckedwith NCOAisdefinedasa validdatethatissetby theAAConcetheNCOA checkiscompleted.Fortherecordsthatare returnedtoADRviathe NCOAAddresscheckfile- thisdatewillbethe NCOADateChecked containedonthatfile. ForRecordsreturnedvia anaddresschangethis datewillbethedatethe Z05(addresssource= NCOA)datawasuploaded ontheADR.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.CITY IS 'Cityisdefinedasthe nameofacityusedfor anaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.ADDRESS_H.COUNTY_CODE IS 'FIPSCountyCODEis definedasthelast3 charactersoftheFIPS state/countycode.The FIPScountycodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied5-DIGITFIPSCODEis definedasthe2digit statecode+3digit countycode.This5digit FIPScodeisassociated withtheveterans permanentmailing address,Ifnopermanent mailingaddressis supplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied';

COMMENT ON COLUMN ADR.ADDRESS_H.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS_H.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS_H.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS_H.POSTAL_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS_H.COUNTRY_CODE IS 'Countryisdefinedasthe uniqueidentifier assignedbythe International Organizationof Standardizationfora country.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof addresswentintoeffect.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_INVALIDATED_DATE IS 'Dateonwhichanaddress wasdeterminedtobe invalid.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_START_DATE_TXT IS 'Addressstartdateis definedasthedatean addressbecamevalidto useforaparty.Address startdatecanbea futuredate.Address becomesactive/current onthestartdate.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_END_DATE_TXT IS 'Addressenddateis definedasthedatean addressstoppedbeing usedforaparty.Address enddatecannotbebefore addressstartdate. Addressenddatecanbea futuredate.Address becomesinactiveonthe enddate.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_PHONE_NUMBER IS 'Telephone number associated with a temporary address.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n. history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.ADDRESS_H.PERSON_RELATION_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';


CREATE INDEX ADR.ADDRESS_ID_NU_I ON ADR.ADDRESS_H
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE UNIQUE INDEX ADR.ADDRH_PK ON ADR.ADDRESS_H
(ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDRH_PRSNID_NU_I ON ADR.ADDRESS_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ADDRESS_H FOR ADR.ADDRESS_H;


ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_062
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067248
  CHECK ("ADDRESS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067249
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067250
  CHECK ("ADDRESS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067251
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067252
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067253
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067254
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067255
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ADDRH_PK
  PRIMARY KEY
  (ADDRESS_H_ID)
  USING INDEX ADR.ADDRH_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT ADDR_H_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ADDRESS_H TO ADR_R;

GRANT SELECT ON ADR.ADDRESS_H TO ADR_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDRESS_H TO ESCISSEEDINGUSR;

GRANT SELECT ON ADR.ADDRESS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ADDRESS_H TO ES_RW;

GRANT SELECT ON ADR.ADDRESS_H TO PSIM_ADR_R;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADDR_CONFIDENTIAL_DTL CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADDR_CONFIDENTIAL_DTL
(
  ADDR_CONFIDENTIAL_DTL_ID       NUMBER(20)     NOT NULL,
  ADDRESS_ID                     NUMBER(20)     NOT NULL,
  STD_CONFIDENTIALADDRESSCAT_ID  NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADDR_CONFIDENTIAL_DTL IS 'Person Service Demographics (PSD) concept of confidential address is different from ESR: PSD wants to track whether or not a Person  record is sensitive and has a confidential address vs. ESR just marks an address as being confidential';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.ADDR_CONFIDENTIAL_DTL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.STD_CONFIDENTIALADDRESSCAT_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ADDRCONF_ADDR_FK_I ON ADR.ADDR_CONFIDENTIAL_DTL
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDRCONF_CNFADDRTYP_FK_I ON ADR.ADDR_CONFIDENTIAL_DTL
(STD_CONFIDENTIALADDRESSCAT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ADDRCONF_PK ON ADR.ADDR_CONFIDENTIAL_DTL
(ADDR_CONFIDENTIAL_DTL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ADDR_CONF_DTL_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.ADDR_CONFIDENTIAL_DTL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ADDR_CONFIDENTIAL_DTL_H
		(
                ADDR_CONFIDENTIAL_DTL_H_ID,
 		ADDR_CONFIDENTIAL_DTL_ID,
 		ADDRESS_ID,
 		STD_CONFIDENTIALADDRESSCAT_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ADDR_CONFIDENTIAL_DTL_H_s.nextval,
		:old.ADDR_CONFIDENTIAL_DTL_ID,
		:old.ADDRESS_ID,
		:old.STD_CONFIDENTIALADDRESSCAT_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into ADDR_CONFIDENTIAL_DTL_H
		(
                ADDR_CONFIDENTIAL_DTL_H_ID,
 		ADDR_CONFIDENTIAL_DTL_ID,
 		ADDRESS_ID,
 		STD_CONFIDENTIALADDRESSCAT_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ADDR_CONFIDENTIAL_DTL_H_s.nextval,
		:new.ADDR_CONFIDENTIAL_DTL_ID,
		:new.ADDRESS_ID,
		:new.STD_CONFIDENTIALADDRESSCAT_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY ,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ADDR_CONF_DTL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ADDR_CONFIDENTIAL_DTL FOR ADR.ADDR_CONFIDENTIAL_DTL;


ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL ADD (
  CONSTRAINT ADDRCONF_PK
  PRIMARY KEY
  (ADDR_CONFIDENTIAL_DTL_ID)
  USING INDEX ADR.ADDRCONF_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL ADD (
  CONSTRAINT ADDRCONF_ADDR_FK 
  FOREIGN KEY (ADDRESS_ID) 
  REFERENCES ADR.ADDRESS (ADDRESS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDR_CONFIDENTIAL_DTL TO ADR_RW;

GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL TO ES_R;

GRANT INSERT, SELECT ON ADR.ADDR_CONFIDENTIAL_DTL TO ES_RW;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADDR_CONFIDENTIAL_DTL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADDR_CONFIDENTIAL_DTL_H
(
  ADDR_CONFIDENTIAL_DTL_H_ID     NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  ADDR_CONFIDENTIAL_DTL_ID       NUMBER(20)     NOT NULL,
  ADDRESS_ID                     NUMBER(20)     NOT NULL,
  STD_CONFIDENTIALADDRESSCAT_ID  NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADDR_CONFIDENTIAL_DTL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.ADDR_CONFIDENTIAL_DTL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ADDR_CONFIDENTIAL_DTL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ADDRCONFH_PK ON ADR.ADDR_CONFIDENTIAL_DTL_H
(ADDR_CONFIDENTIAL_DTL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ADDR_CONFIDENTIAL_DTL_H FOR ADR.ADDR_CONFIDENTIAL_DTL_H;


ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H ADD (
  CONSTRAINT ADDR_CONFIDENTIAL_DTL_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('''U''', '''I''', '''D'''))
  ENABLE VALIDATE,
  CONSTRAINT ADDRCONFH_PK
  PRIMARY KEY
  (ADDR_CONFIDENTIAL_DTL_H_ID)
  USING INDEX ADR.ADDRCONFH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ADR_RW;

GRANT SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ADDR_CONFIDENTIAL_DTL_H TO ES_RW;
ALTER TABLE ADR.ADR_DB_VER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADR_DB_VER CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADR_DB_VER
(
  DB_VERSION      VARCHAR2(20 BYTE),
  DB_CREATE_DATE  DATE                          NOT NULL,
  ADR_DB_VER_ID   NUMBER(20)                    NOT NULL,
  ADR_CR          VARCHAR2(20 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADR_DB_VER IS 'LOOKUP TABLE';


CREATE UNIQUE INDEX ADR.ADR_DBVER_CR_UK ON ADR.ADR_DB_VER
(ADR_CR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ADR_DBVER_VERSION_UK ON ADR.ADR_DB_VER
(DB_VERSION, ADR_CR)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ADR_DB_VER FOR ADR.ADR_DB_VER;


ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_PK
  PRIMARY KEY
  (ADR_DB_VER_ID)
  DISABLE NOVALIDATE,
  CONSTRAINT ADR_DBVER_CR_UK
  UNIQUE (ADR_CR)
  USING INDEX ADR.ADR_DBVER_CR_UK
  ENABLE VALIDATE,
  CONSTRAINT ADR_DBVER_VERSION_UK
  UNIQUE (DB_VERSION, ADR_CR)
  USING INDEX ADR.ADR_DBVER_VERSION_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ADR_DB_VER TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.ADR_DB_VER TO ADR_RW;

GRANT SELECT ON ADR.ADR_DB_VER TO ES_R;

GRANT INSERT, SELECT ON ADR.ADR_DB_VER TO ES_RW;

GRANT SELECT ON ADR.ADR_DB_VER TO PUBLIC;
ALTER TABLE ADR.APP_PARAMETER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.APP_PARAMETER CASCADE CONSTRAINTS;

CREATE TABLE ADR.APP_PARAMETER
(
  APP_PARAMETER_ID       NUMBER(20)             NOT NULL,
  APP_PARAMETER_TYPE_ID  NUMBER(20)             NOT NULL,
  APP_PARAMETER_UNIT_ID  NUMBER(20),
  APPLICATION_NAME       VARCHAR2(80 BYTE),
  PARAMETER_NAME         VARCHAR2(50 BYTE)      NOT NULL,
  PARAMETER_DESCRIPTION  VARCHAR2(250 BYTE)     NOT NULL,
  PARAMETER_VALUE        VARCHAR2(1000 BYTE)    NOT NULL,
  PARAMETER_DATA_LENGTH  NUMBER(10),
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.APP_PARAMETER IS 'This table stores the various parameters used by the application, in support of non-hardcoded programming best practices.';

COMMENT ON COLUMN ADR.APP_PARAMETER.APP_PARAMETER_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.APP_PARAMETER.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.APP_PARAMETER.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.APP_PARAMETER.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.APP_PARAMETER.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.APP_PARAMETER.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.APP_PARAMETER.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE INDEX ADR.APARAM_STD_APARAMTYP_FK_I ON ADR.APP_PARAMETER
(APP_PARAMETER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.APARAM_STD_APARAMU_FK_I ON ADR.APP_PARAMETER
(APP_PARAMETER_UNIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.APPLPARAM_PK ON ADR.APP_PARAMETER
(APP_PARAMETER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.APPLPARAM_U_CODE_UK ON ADR.APP_PARAMETER
(PARAMETER_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM APP_PARAMETER FOR ADR.APP_PARAMETER;


ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT AVCON_1172521913_INACT_114
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT APPLPARAM_PK
  PRIMARY KEY
  (APP_PARAMETER_ID)
  USING INDEX ADR.APPLPARAM_PK
  ENABLE VALIDATE,
  CONSTRAINT APPLPARAM_U_CODE_UK
  UNIQUE (PARAMETER_NAME)
  USING INDEX ADR.APPLPARAM_U_CODE_UK
  ENABLE VALIDATE);

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APARAM_STD_APARAMTYP_FK 
  FOREIGN KEY (APP_PARAMETER_TYPE_ID) 
  REFERENCES ADRREF.STD_APPPARAMETERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT APARAM_STD_APARAMU_FK 
  FOREIGN KEY (APP_PARAMETER_UNIT_ID) 
  REFERENCES ADRREF.STD_APPPARAMETERUNIT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.APP_PARAMETER TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.APP_PARAMETER TO ADR_RW;

GRANT SELECT ON ADR.APP_PARAMETER TO ES_R;

GRANT INSERT, SELECT ON ADR.APP_PARAMETER TO ES_RW;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BATCH_REQUEST_FACILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.BATCH_REQUEST_FACILITY
(
  BATCH_REQUEST_FACILITY_ID  NUMBER(20)         NOT NULL,
  STD_INSTITUTION_ID         NUMBER(20)         NOT NULL,
  HANDBOOK_BATCH_REQUEST_ID  NUMBER(20)         NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  PARENT_STD_INSTITUTION_ID  NUMBER(20)         NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BATCH_REQUEST_FACILITY IS 'A record of parent preferred facilities used to select veterans for a particular batch request.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.BATREQFAC_HNDBATREQ_FK_I ON ADR.BATCH_REQUEST_FACILITY
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.BATREQFAC_PK ON ADR.BATCH_REQUEST_FACILITY
(BATCH_REQUEST_FACILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BATCH_REQUEST_FAC_AUD_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.BATCH_REQUEST_FACILITY  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into BATCH_REQUEST_FACILITY_H
        (
        BATCH_REQUEST_FACILITY_H_ID,
        BATCH_REQUEST_FACILITY_ID,
        HANDBOOK_BATCH_REQUEST_ID,
        STD_INSTITUTION_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        PARENT_STD_INSTITUTION_ID
        )
        values
        (
        BATCH_REQUEST_FACILITY_H_S.nextval,
        :old.BATCH_REQUEST_FACILITY_ID,
        :old.HANDBOOK_BATCH_REQUEST_ID,
       :old.STD_INSTITUTION_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D',
        :old.PARENT_STD_INSTITUTION_ID
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into BATCH_REQUEST_FACILITY_H
        (
        BATCH_REQUEST_FACILITY_H_ID,
        BATCH_REQUEST_FACILITY_ID,
    HANDBOOK_BATCH_REQUEST_ID,
    STD_INSTITUTION_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        PARENT_STD_INSTITUTION_ID
        )
        values
        (
        BATCH_REQUEST_FACILITY_H_S.nextval,
        :new.BATCH_REQUEST_FACILITY_ID,
    :new.HANDBOOK_BATCH_REQUEST_ID,
    :new.STD_INSTITUTION_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML,
        :new.PARENT_STD_INSTITUTION_ID
        );
    end if;

end BATCH_REQUEST_FAC_AUD_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM BATCH_REQUEST_FACILITY FOR ADR.BATCH_REQUEST_FACILITY;


ALTER TABLE ADR.BATCH_REQUEST_FACILITY ADD (
  CONSTRAINT BATREQFAC_PK
  PRIMARY KEY
  (BATCH_REQUEST_FACILITY_ID)
  USING INDEX ADR.BATREQFAC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BATCH_REQUEST_FACILITY ADD (
  CONSTRAINT R_1061 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_FACILITY TO ADR_RW;

GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY TO ES_R;

GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_FACILITY TO ES_RW;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BATCH_REQUEST_FACILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BATCH_REQUEST_FACILITY_H
(
  BATCH_REQUEST_FACILITY_ID    NUMBER(20)       NOT NULL,
  STD_INSTITUTION_ID           NUMBER(20)       NOT NULL,
  HANDBOOK_BATCH_REQUEST_ID    NUMBER(20)       NOT NULL,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  HISTORY_CREATED_DATE         DATE             NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  BATCH_REQUEST_FACILITY_H_ID  NUMBER(20)       NOT NULL,
  PARENT_STD_INSTITUTION_ID    NUMBER(20)       NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BATCH_REQUEST_FACILITY_H IS 'A record of parent preferred facilities used to select veterans for a particular batch request.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_FACILITY_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.BATREQFACH_PK ON ADR.BATCH_REQUEST_FACILITY_H
(BATCH_REQUEST_FACILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BATCH_REQUEST_FACILITY_H FOR ADR.BATCH_REQUEST_FACILITY_H;


ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H ADD (
  CONSTRAINT BATREQFACH_PK
  PRIMARY KEY
  (BATCH_REQUEST_FACILITY_H_ID)
  USING INDEX ADR.BATREQFACH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_FACILITY_H TO ADR_RW;

GRANT SELECT ON ADR.BATCH_REQUEST_FACILITY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_FACILITY_H TO ES_RW;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP CASCADE CONSTRAINTS;

CREATE TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP
(
  BATCH_REQUEST_PRIORITY_GRP_ID  NUMBER(20)     NOT NULL,
  STD_ENROLLMENTPRIORGRP_ID      NUMBER(20)     NOT NULL,
  STD_ENROLLMENTPRIORSGRP_ID     NUMBER(20),
  HANDBOOK_BATCH_REQUEST_ID      NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP IS 'A parent priority group used to select veterans for a particular batch request.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.BATREQPRRGRP_HNDBTCREQ_FK_I ON ADR.BATCH_REQUEST_PRIORITY_GROUP
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.BTCREQPRRGRP_PK ON ADR.BATCH_REQUEST_PRIORITY_GROUP
(BATCH_REQUEST_PRIORITY_GRP_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BATCH_REQ_PRI_GRP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.BATCH_REQUEST_PRIORITY_GROUP  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into BATCH_REQUEST_PRIORITY_GROUP_H
        (
        BATCH_REQUEST_PRI_GRP_H_ID,
        BATCH_REQUEST_PRIORITY_GRP_ID,
    STD_ENROLLMENTPRIORSGRP_ID,
    STD_ENROLLMENTPRIORGRP_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        BATCH_REQUEST_PRI_GRP_H_ID_S.nextval,
        :old.BATCH_REQUEST_PRIORITY_GRP_ID,
    :old.STD_ENROLLMENTPRIORSGRP_ID,
    :old.STD_ENROLLMENTPRIORGRP_ID,
    :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into BATCH_REQUEST_PRIORITY_GROUP_H
        (
        BATCH_REQUEST_PRI_GRP_H_ID,
        BATCH_REQUEST_PRIORITY_GRP_ID,
    STD_ENROLLMENTPRIORSGRP_ID,
    STD_ENROLLMENTPRIORGRP_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        BATCH_REQUEST_PRI_GRP_H_ID_S.nextval,
        :new.BATCH_REQUEST_PRIORITY_GRP_ID,
    :new.STD_ENROLLMENTPRIORSGRP_ID,
    :new.STD_ENROLLMENTPRIORGRP_ID,
    :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end BATCH_REQ_PRI_GRP_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM BATCH_REQUEST_PRIORITY_GROUP FOR ADR.BATCH_REQUEST_PRIORITY_GROUP;


ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP ADD (
  CONSTRAINT BTCREQPRRGRP_PK
  PRIMARY KEY
  (BATCH_REQUEST_PRIORITY_GRP_ID)
  USING INDEX ADR.BTCREQPRRGRP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP ADD (
  CONSTRAINT R_1062 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ADR_RW;

GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ES_R;

GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP TO ES_RW;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H
(
  BATCH_REQUEST_PRIORITY_GRP_ID  NUMBER(20)     NOT NULL,
  STD_ENROLLMENTPRIORGRP_ID      NUMBER(20)     NOT NULL,
  STD_ENROLLMENTPRIORSGRP_ID     NUMBER(20),
  HANDBOOK_BATCH_REQUEST_ID      NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  HISTORY_CREATED_DATE           DATE           NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  BATCH_REQUEST_PRI_GRP_H_ID     NUMBER(20)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H IS 'A parent priority group used to select veterans for a particular batch request.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.BATCH_REQUEST_PRIORITY_GROUP_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.BATREQPRRGRPH_PK ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H
(BATCH_REQUEST_PRI_GRP_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BATCH_REQUEST_PRIORITY_GROUP_H FOR ADR.BATCH_REQUEST_PRIORITY_GROUP_H;


ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H ADD (
  CONSTRAINT BATREQPRRGRPH_PK
  PRIMARY KEY
  (BATCH_REQUEST_PRI_GRP_H_ID)
  USING INDEX ADR.BATREQPRRGRPH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ADR_RW;

GRANT SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_MST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_MST CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_MST
(
  BENEFICIARY_MST_ID     NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  MST_STATUS_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  MST_EVALUATION_DATE    DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_MST IS 'The BENEFICIARY_MST table shows that a person has been clinically determined to have suffered a Military Sexual Trauma, and includes the status of the determination, the site at which the determination was made. PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the Military Sexual Trauma data applies. MST_STATUS_TYPE_ID Foreign key to the MST_STATUS_TYPE table, which indicates the status of a persons screening for MST. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table, which indicates the site at which MST status was determined. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.BENEFICIARY_MST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.MST_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.MST_EVALUATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYMST_PK ON ADR.BENEFICIARY_MST
(BENEFICIARY_MST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMST_PRSN_FK_I ON ADR.BENEFICIARY_MST
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMST_STDINST_FK_I ON ADR.BENEFICIARY_MST
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMST_STD_MSTST_FK_I ON ADR.BENEFICIARY_MST
(MST_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_MST_AUDIR_TRGR
after Update or Delete or Insert
on ADR.BENEFICIARY_MST
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into BENEFICIARY_MST_H
		(
		BENEFICIARY_MST_H_ID,
		BENEFICIARY_MST_ID  ,
		PERSON_ID           ,
		MST_STATUS_TYPE_ID ,
		STD_INSTITUTION_ID  ,
		MST_EVALUATION_DATE,
		RECORD_CREATED_BY   ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY  ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_mst_h_s.nextval,
		:old.BENEFICIARY_MST_ID,
		:old.PERSON_ID        ,
		:old.MST_STATUS_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.MST_EVALUATION_DATE,
		:old.RECORD_CREATED_BY ,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_MST_H
		(
		BENEFICIARY_MST_H_ID,
		BENEFICIARY_MST_ID  ,
		PERSON_ID           ,
		MST_STATUS_TYPE_ID ,
		STD_INSTITUTION_ID ,
		MST_EVALUATION_DATE,
		RECORD_CREATED_BY  ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_mst_h_s.nextval,
		:new.BENEFICIARY_MST_ID,
		:new.PERSON_ID         ,
		:new.MST_STATUS_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.MST_EVALUATION_DATE,
		:new.RECORD_CREATED_BY  ,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end beneficiary_mst_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_MST FOR ADR.BENEFICIARY_MST;


ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PK
  PRIMARY KEY
  (BENEFICIARY_MST_ID)
  USING INDEX ADR.BNFYMST_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_MST TO ADREXT;

GRANT SELECT ON ADR.BENEFICIARY_MST TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_MST TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_MST TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_MST TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_MST_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_MST_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_MST_H
(
  BENEFICIARY_MST_H_ID   NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  BENEFICIARY_MST_ID     NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  MST_STATUS_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  MST_EVALUATION_DATE    DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_MST_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.BENEFICIARY_MST_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.BENEFICIARY_MST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.MST_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.MST_EVALUATION_DATE IS 'DateonwhichtheMST screeningwasconducted. Eitherbymedicalrecord orbyphysicalexam.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYMSTH_PK ON ADR.BENEFICIARY_MST_H
(BENEFICIARY_MST_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMSTH_PRSNID_NU_I ON ADR.BENEFICIARY_MST_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_MST_H FOR ADR.BENEFICIARY_MST_H;


ALTER TABLE ADR.BENEFICIARY_MST_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT BNFYMSTH_PK
  PRIMARY KEY
  (BENEFICIARY_MST_H_ID)
  USING INDEX ADR.BNFYMSTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ADR_R;

GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_MST_H TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_NTR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_NTR CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_NTR
(
  BENEFICIARY_NTR_ID              NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  NTR_DIAGNOSIS_SITE_ID           NUMBER(20),
  NTR_VERIFICATION_SITE_ID        NUMBER(20),
  NTR_VERIFY_METHOD_TYPE_ID       NUMBER(20),
  VERIFICATION_DATE               DATE,
  AVIATOR_PRE1955_IND             VARCHAR2(1 BYTE),
  NAVY_SUB_TRAINEE_PRE_1965_IND   VARCHAR2(1 BYTE),
  RECEIVED_NTR_TREATMENT_IND      VARCHAR2(1 BYTE),
  DIAGNOSED_HEAD_NECK_CANCER_IND  VARCHAR2(1 BYTE),
  HEAD_NECK_CANCER_DIAGNOSIS_DT   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_NTR IS 'The BENEFICIARY_NTR table shows that a person has been clinically determined to have suffered from Nose Throat Radium exposure. The table includes the site at which the determination was made, the verification date and method, and whether the person has been diagnosed and treated with cancer. PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the Nose, Throat, Radium data applies. NTR_DIAGNOSIS_SITE_ID Foreign key to STD_INSTITUTION table NTR_VERIFICATION_SITE_ID Foreign key to STD_INSTITUTION table NTR_VERIFY_METHOD_TYPE_ID Foreign key to the NTR_VERIFY_METHOD_TYPE table. Indicates which technique was used to verify a persons NTR status (for example, Military Record, Qualifying Military Service). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.BENEFICIARY_NTR_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NTR_DIAGNOSIS_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NTR_VERIFICATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NTR_VERIFY_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.VERIFICATION_DATE IS 'BR6805(NTR)Date/Time DiagnosisVerifiedis definedasthedateand timetheNose/Throat RadiumTreatment diagnosiswasverified.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.AVIATOR_PRE1955_IND IS 'Indicateswhetherornot apersonwasanaviator before1955,when exposurewasmorelikely tohavehappened.AviatiorPriorto1955is aquestionthatis presentedtotheuserif theveteranhasanswered YEStotheNTRIndicator. ThequestionisDidyou serveasanaviatorin theMilitarybeforeJan 31,1955?Thevalues includeYES/NO.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NAVY_SUB_TRAINEE_PRE_1965_IND IS 'Indicateswhetherornot apersonwasaNavy submarinetraineebefore 1955,whenexposurewas morelikelytohave happened.SubmarineTraineeprior to1965isaquestion thatispresentedtothe useriftheveteranhas answeredYEStotheNTR Indicator.Thequestion isDidyouhavesubmarine traininginthemilitary beforeJan1,1965?';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECEIVED_NTR_TREATMENT_IND IS 'ReceivedNTRTreatment definestheanswera veterangavetothe question:DIDYOURECEIVE NOSEORTHROATRADIUM TREATMENTSINTHE MILITARY?';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.DIAGNOSED_HEAD_NECK_CANCER_IND IS 'Indicateswhethera personhasbeendiagnosed withhead/neckcancer.DiagnosedwithCancerof HeadNeckisaquestion thatispresentedtothe useriftheveteranhas answeredYEStotheNTR Indicator.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYNTR_PK ON ADR.BENEFICIARY_NTR
(BENEFICIARY_NTR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_PRSN_FK_I ON ADR.BENEFICIARY_NTR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_STDINST_FK_I ON ADR.BENEFICIARY_NTR
(NTR_VERIFICATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_STDINST_H_FK_I ON ADR.BENEFICIARY_NTR
(NTR_DIAGNOSIS_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_STD_NTRVRFYMTD_FK_I ON ADR.BENEFICIARY_NTR
(NTR_VERIFY_METHOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_NTR_AUDIR_TRGR
after Update or Delete or Insert
on ADR.BENEFICIARY_NTR
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_NTR_H
		(
		BENEFICIARY_NTR_H_ID ,
		BENEFICIARY_NTR_ID       ,
		PERSON_ID                      ,
		NTR_DIAGNOSIS_SITE_ID ,
		NTR_VERIFICATION_SITE_ID ,
		NTR_VERIFY_METHOD_TYPE_ID,
		VERIFICATION_DATE            ,
		AVIATOR_PRE1955_IND        ,
		NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		RECEIVED_NTR_TREATMENT_IND     ,
		DIAGNOSED_HEAD_NECK_CANCER_IND,
		HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		RECORD_CREATED_BY              ,
		RECORD_CREATED_DATE         ,
		RECORD_MODIFIED_BY             ,
		RECORD_MODIFIED_DATE        ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_ntr_h_s.nextval,
		:old.BENEFICIARY_NTR_ID       ,
		:old.PERSON_ID                      ,
		:old.NTR_DIAGNOSIS_SITE_ID ,
		:old.NTR_VERIFICATION_SITE_ID ,
		:old.NTR_VERIFY_METHOD_TYPE_ID,
		:old.VERIFICATION_DATE            ,
		:old.AVIATOR_PRE1955_IND        ,
		:old.NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		:old.RECEIVED_NTR_TREATMENT_IND     ,
		:old.DIAGNOSED_HEAD_NECK_CANCER_IND,
		:old.HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		:old.RECORD_CREATED_BY              ,
		:old.RECORD_CREATED_DATE         ,
		:old.RECORD_MODIFIED_BY             ,
		:old.RECORD_MODIFIED_DATE        ,
		:old.RECORD_MODIFIED_COUNT     ,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_NTR_H
		(
		BENEFICIARY_NTR_H_ID ,
		BENEFICIARY_NTR_ID       ,
		PERSON_ID                      ,
		NTR_DIAGNOSIS_SITE_ID ,
		NTR_VERIFICATION_SITE_ID ,
		NTR_VERIFY_METHOD_TYPE_ID,
		VERIFICATION_DATE            ,
		AVIATOR_PRE1955_IND        ,
		NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		RECEIVED_NTR_TREATMENT_IND     ,
		DIAGNOSED_HEAD_NECK_CANCER_IND,
		HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		RECORD_CREATED_BY              ,
		RECORD_CREATED_DATE         ,
		RECORD_MODIFIED_BY             ,
		RECORD_MODIFIED_DATE        ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_ntr_h_s.nextval,
		:new.BENEFICIARY_NTR_ID       ,
		:new.PERSON_ID                      ,
		:new.NTR_DIAGNOSIS_SITE_ID ,
		:new.NTR_VERIFICATION_SITE_ID ,
		:new.NTR_VERIFY_METHOD_TYPE_ID,
		:new.VERIFICATION_DATE            ,
		:new.AVIATOR_PRE1955_IND        ,
		:new.NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		:new.RECEIVED_NTR_TREATMENT_IND     ,
		:new.DIAGNOSED_HEAD_NECK_CANCER_IND,
		:new.HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		:new.RECORD_CREATED_BY              ,
		:new.RECORD_CREATED_DATE         ,
		:new.RECORD_MODIFIED_BY             ,
		:new.RECORD_MODIFIED_DATE        ,
		:new.RECORD_MODIFIED_COUNT     ,
		mDML
		);

	end if;
end BENEFICIARY_NTR_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_NTR FOR ADR.BENEFICIARY_NTR;


ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_ID)
  USING INDEX ADR.BNFYNTR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_NTR TO ADREXT;

GRANT SELECT ON ADR.BENEFICIARY_NTR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_NTR TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_NTR TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_NTR TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_NTR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_NTR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_NTR_H
(
  BENEFICIARY_NTR_H_ID            NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  BENEFICIARY_NTR_ID              NUMBER(20),
  PERSON_ID                       NUMBER(20),
  NTR_DIAGNOSIS_SITE_ID           NUMBER(20),
  NTR_VERIFICATION_SITE_ID        NUMBER(20),
  NTR_VERIFY_METHOD_TYPE_ID       NUMBER(20),
  VERIFICATION_DATE               DATE,
  AVIATOR_PRE1955_IND             VARCHAR2(1 BYTE),
  NAVY_SUB_TRAINEE_PRE_1965_IND   VARCHAR2(1 BYTE),
  RECEIVED_NTR_TREATMENT_IND      VARCHAR2(1 BYTE),
  DIAGNOSED_HEAD_NECK_CANCER_IND  VARCHAR2(1 BYTE),
  HEAD_NECK_CANCER_DIAGNOSIS_DT   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_NTR_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.BENEFICIARY_NTR_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.BENEFICIARY_NTR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.NTR_DIAGNOSIS_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.NTR_VERIFICATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.NTR_VERIFY_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.VERIFICATION_DATE IS 'BR6805(NTR)Date/Time DiagnosisVerifiedis definedasthedateand timetheNose/Throat RadiumTreatment diagnosiswasverified.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.AVIATOR_PRE1955_IND IS 'Indicateswhetherornot apersonwasanaviator before1955,when exposurewasmorelikely tohavehappened.AviatiorPriorto1955is aquestionthatis presentedtotheuserif theveteranhasanswered YEStotheNTRIndicator. ThequestionisDidyou serveasanaviatorin theMilitarybeforeJan 31,1955?Thevalues includeYES/NO.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.NAVY_SUB_TRAINEE_PRE_1965_IND IS 'Indicateswhetherornot apersonwasaNavy submarinetraineebefore 1955,whenexposurewas morelikelytohave happened.SubmarineTraineeprior to1965isaquestion thatispresentedtothe useriftheveteranhas answeredYEStotheNTR Indicator.Thequestion isDidyouhavesubmarine traininginthemilitary beforeJan1,1965?';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.RECEIVED_NTR_TREATMENT_IND IS 'ReceivedNTRTreatment definestheanswera veterangavetothe question:DIDYOURECEIVE NOSEORTHROATRADIUM TREATMENTSINTHE MILITARY?';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.DIAGNOSED_HEAD_NECK_CANCER_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.HEAD_NECK_CANCER_DIAGNOSIS_DT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYNTRH_PK ON ADR.BENEFICIARY_NTR_H
(BENEFICIARY_NTR_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTRH_PRSNID_NU_I ON ADR.BENEFICIARY_NTR_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_NTR_H FOR ADR.BENEFICIARY_NTR_H;


ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_069
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067428
  CHECK ("BENEFICIARY_NTR_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067429
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067430
  CHECK ("BENEFICIARY_NTR_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067431
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067432
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067433
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067434
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067435
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067436
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT BNFYNTRH_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_H_ID)
  USING INDEX ADR.BNFYNTRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_NTR_H TO ADR_R;

GRANT SELECT ON ADR.BENEFICIARY_NTR_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_NTR_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_NTR_H TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_SCI
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_SCI CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_SCI
(
  BENEFICIARY_SCI_ID       NUMBER(20)           NOT NULL,
  PERSON_ID                NUMBER(20)           NOT NULL,
  STD_SPINALINJURYCODE_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_SCI IS 'The BENEFICIARY_SCI  table shows that a person has been clinically determined to have suffered a Spinal Cord Injury, and includes the status of the determination, the site at which the determination was made.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI.BENEFICIARY_SCI_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYSCI_PK ON ADR.BENEFICIARY_SCI
(BENEFICIARY_SCI_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYSCI_PRSN_FK_I ON ADR.BENEFICIARY_SCI
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYSCI_STDSPINAL_FK_I ON ADR.BENEFICIARY_SCI
(STD_SPINALINJURYCODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEF_SCI_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.BENEFICIARY_SCI
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_SCI_H
		(
		BENEFICIARY_SCI_H_ID,
		BENEFICIARY_SCI_ID,
		PERSON_ID,
		STD_SPINALINJURYCODE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_SCI_H_s.nextval,
		:old.BENEFICIARY_SCI_ID,
		:old.PERSON_ID,
		:old.STD_SPINALINJURYCODE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into BENEFICIARY_SCI_H
		(
		BENEFICIARY_SCI_H_ID,
		BENEFICIARY_SCI_ID,
		PERSON_ID,
		STD_SPINALINJURYCODE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_SCI_H_s.nextval,
		:new.BENEFICIARY_SCI_ID,
		:new.PERSON_ID,
		:new.STD_SPINALINJURYCODE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY ,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end BENEF_SCI_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_SCI FOR ADR.BENEFICIARY_SCI;


ALTER TABLE ADR.BENEFICIARY_SCI ADD (
  CONSTRAINT BNFYSCI_PK
  PRIMARY KEY
  (BENEFICIARY_SCI_ID)
  USING INDEX ADR.BNFYSCI_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_SCI ADD (
  CONSTRAINT BNFYSCI_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_SCI TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_SCI TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_SCI TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_SCI TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_SCI_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_SCI_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_SCI_H
(
  BENEFICIARY_SCI_H_ID     NUMBER(20),
  TRANSACTION_TYPE_CODE    VARCHAR2(1 BYTE),
  BENEFICIARY_SCI_ID       NUMBER(20),
  PERSON_ID                NUMBER(20),
  STD_SPINALINJURYCODE_ID  NUMBER(20),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE      DATE,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE     DATE,
  RECORD_MODIFIED_COUNT    NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_SCI_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.BENEFICIARY_SCI_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_SCI_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYSCIH_PK ON ADR.BENEFICIARY_SCI_H
(BENEFICIARY_SCI_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_SCI_H FOR ADR.BENEFICIARY_SCI_H;


ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT BENEFICIARY_SCI_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106522
  CHECK ("BENEFICIARY_SCI_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106523
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106524
  CHECK ("BENEFICIARY_SCI_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106525
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106526
  CHECK ("STD_SPINALINJURYCODE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106527
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106528
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106529
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106530
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106531
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT BNFYSCIH_PK
  PRIMARY KEY
  (BENEFICIARY_SCI_H_ID)
  USING INDEX ADR.BNFYSCIH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_SCI_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_SCI_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_SCI_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_SCI_H TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_TRAVEL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_TRAVEL CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_TRAVEL
(
  BENEFICIARY_TRAVEL_ID    NUMBER(20)           NOT NULL,
  PERSON_ID                NUMBER(20)           NOT NULL,
  STD_INSTITUTION_ID       NUMBER(20),
  INCOME_YEAR              NUMBER(4),
  TRAVEL_ELIGIBILITY_IND   VARCHAR2(1 BYTE),
  TRAVEL_CLAIM_DATE        DATE,
  TRAVEL_CERTIFIED_DATE    DATE,
  TRAVEL_CERTIFIED_AMOUNT  NUMBER(10,2),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_TRAVEL IS 'Detail regarding travel amount certified for a beneficiary to visit a Site (hospital) The BENEFICIARY_TRAVEL table shows that a person has been authorized to be reimbursed for travel for treatment. It also includes the dates of travel and the amount approved for reimbursement. PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the travel benefits data applies. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. Indicates the VHA site where the travel benefit was certified. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.BENEFICIARY_TRAVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.TRAVEL_ELIGIBILITY_IND IS 'BR3553EligibleIndicator isdefinedasacodeto indicateifthisperson isrequiredtoperforma BeneficiaryTraveltest toreceivebenefits.The acceptablevaluesare Yes/No.This determinationisdoneby VISTAandsenttotheHEC .Ifaveteranis30-100% serviceconnectedorin receiptofVAPensionhe isentitledto BeneficiaryTravelupon requestwithouttheneed tosupplyfinancial information. Thebelowbusinessrules areappliedonVISTA.The veteranisrequiredto supplyfinancial informationtodetermine ifhe/sheiseligibleto receivebeneficiary travel.Ifhe/shehasone ofthefollowingprimary orothereligibilities: Non-ServiceConnected ServiceConnected0% non-compensable Lessthan30%service connected WWIorMexicanBorder veteran PurpleHeart POWORtheveteranis inreceiptofMedicaidOR isinreceiptofMilitary RetirementDisabilityThe veteranisNOTrequired tosupplyfinancial informationtodetermine ifhe/sheiseligibleto receivebeneficiary travelbenefits. Ifhe/sheis/hasoneof thefollowing: TheveteranIsa DomiciliaryInpatient TheveteranIsDeceased Theveteranhasoneof thefollowing primary/other eligibilities 1.ReceivingVAPension 2.ServiceConnected30- 100%';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.TRAVEL_CLAIM_DATE IS 'Dateonwhichatravel benefitsclaimwas submitted.TravelClaimDate/Timeis definedasthe BeneficiaryTravelCLAIM date/timeDatemustbe precise.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.TRAVEL_CERTIFIED_DATE IS 'DateCertifiedisdefined asthedateofannual incomecertificationused intheBeneficialTravel Claimprocess.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.TRAVEL_CERTIFIED_AMOUNT IS 'AmountCertifiedis definedasthepatients annualincomeforthe previousyearasreported bythepatient.Ifthe veteranisrequiredtodo abeneficiarytraveltest thisnumberwillbe comparedtotheVA Pensionthresholdbased on#ofdependents.This comparisonisamanual comparisondoneonVISTA bythetravelclerk.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BENTRVL_PK ON ADR.BENEFICIARY_TRAVEL
(BENEFICIARY_TRAVEL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENTRVL_PRSN_FK_I ON ADR.BENEFICIARY_TRAVEL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENTRVL_STDINST_FK_I ON ADR.BENEFICIARY_TRAVEL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_TRVL_audir_trgr
after Update or Delete or Insert
ON ADR.BENEFICIARY_TRAVEL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_TRAVEL_H
		(
		BENEFICIARY_TRAVEL_H_ID,
		BENEFICIARY_TRAVEL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INCOME_YEAR,
		TRAVEL_CERTIFIED_AMOUNT,
		TRAVEL_CERTIFIED_DATE,
		TRAVEL_CLAIM_DATE,
		TRAVEL_ELIGIBILITY_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_TRAVEL_H_S.nextval,
		:old.BENEFICIARY_TRAVEL_ID,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.INCOME_YEAR,
		:old.TRAVEL_CERTIFIED_AMOUNT,
		:old.TRAVEL_CERTIFIED_DATE,
		:old.TRAVEL_CLAIM_DATE,
		:old.TRAVEL_ELIGIBILITY_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_TRAVEL_H
		(
		BENEFICIARY_TRAVEL_H_ID,
		BENEFICIARY_TRAVEL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INCOME_YEAR,
		TRAVEL_CERTIFIED_AMOUNT,
		TRAVEL_CERTIFIED_DATE,
		TRAVEL_CLAIM_DATE,
		TRAVEL_ELIGIBILITY_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_travel_h_s.nextval,
		:new.BENEFICIARY_TRAVEL_ID,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.INCOME_YEAR,
		:new.TRAVEL_CERTIFIED_AMOUNT,
		:new.TRAVEL_CERTIFIED_DATE,
		:new.TRAVEL_CLAIM_DATE,
		:new.TRAVEL_ELIGIBILITY_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;
end BENEFICIARY_TRVL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_TRAVEL FOR ADR.BENEFICIARY_TRAVEL;


ALTER TABLE ADR.BENEFICIARY_TRAVEL ADD (
  CONSTRAINT BENTRVL_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_ID)
  USING INDEX ADR.BENTRVL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_TRAVEL ADD (
  CONSTRAINT BENTRVL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_TRAVEL TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_TRAVEL TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_TRAVEL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_TRAVEL_H
(
  BENEFICIARY_TRAVEL_H_ID  NUMBER(20)           NOT NULL,
  TRANSACTION_TYPE_CODE    VARCHAR2(1 BYTE)     NOT NULL,
  BENEFICIARY_TRAVEL_ID    NUMBER(20)           NOT NULL,
  PERSON_ID                NUMBER(20)           NOT NULL,
  STD_INSTITUTION_ID       NUMBER(20),
  INCOME_YEAR              NUMBER(4),
  TRAVEL_ELIGIBILITY_IND   VARCHAR2(1 BYTE),
  TRAVEL_CLAIM_DATE        DATE,
  TRAVEL_CERTIFIED_DATE    DATE,
  TRAVEL_CERTIFIED_AMOUNT  NUMBER(10,2),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_TRAVEL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.BENEFICIARY_TRAVEL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.BENEFICIARY_TRAVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_ELIGIBILITY_IND IS 'BR3553EligibleIndicator isdefinedasacodeto indicateifthisperson isrequiredtoperforma BeneficiaryTraveltest toreceivebenefits.The acceptablevaluesare Yes/No.This determinationisdoneby VISTAandsenttotheHEC .Ifaveteranis30-100% serviceconnectedorin receiptofVAPensionhe isentitledto BeneficiaryTravelupon requestwithouttheneed tosupplyfinancial information. Thebelowbusinessrules areappliedonVISTA.The veteranisrequiredto supplyfinancial informationtodetermine ifhe/sheiseligibleto receivebeneficiary travel.Ifhe/shehasone ofthefollowingprimary orothereligibilities: Non-ServiceConnected ServiceConnected0% non-compensable Lessthan30%service connected WWIorMexicanBorder veteran PurpleHeart POWORtheveteranis inreceiptofMedicaidOR isinreceiptofMilitary RetirementDisabilityThe veteranisNOTrequired tosupplyfinancial informationtodetermine ifhe/sheiseligibleto receivebeneficiary travelbenefits. Ifhe/sheis/hasoneof thefollowing: TheveteranIsa DomiciliaryInpatient TheveteranIsDeceased Theveteranhasoneof thefollowing primary/other eligibilities 1.ReceivingVAPension 2.ServiceConnected30- 100%';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_CLAIM_DATE IS 'Dateonwhichatravel benefitsclaimwas submitted.TravelClaimDate/Timeis definedasthe BeneficiaryTravelCLAIM date/timeDatemustbe precise.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_CERTIFIED_DATE IS 'DateCertifiedisdefined asthedateofannual incomecertificationused intheBeneficialTravel Claimprocess.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_CERTIFIED_AMOUNT IS 'AmountCertifiedis definedasthepatients annualincomeforthe previousyearasreported bythepatient.Ifthe veteranisrequiredtodo abeneficiarytraveltest thisnumberwillbe comparedtotheVA Pensionthresholdbased on#ofdependents.This comparisonisamanual comparisondoneonVISTA bythetravelclerk.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BENTRVLH_PK ON ADR.BENEFICIARY_TRAVEL_H
(BENEFICIARY_TRAVEL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENTRVLH_PRSNID_NU_I ON ADR.BENEFICIARY_TRAVEL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_TRAVEL_H FOR ADR.BENEFICIARY_TRAVEL_H;


ALTER TABLE ADR.BENEFICIARY_TRAVEL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_006
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT BENTRVLH_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_H_ID)
  USING INDEX ADR.BENTRVLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ADR_R;

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_VISIT_SUMMARY CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_VISIT_SUMMARY
(
  BENEFICIARY_VISIT_SUMMARY_ID  NUMBER(20),
  PERSON_ID                     NUMBER(20),
  STD_INSTITUTION_ID            NUMBER(20),
  INCOME_YEAR                   NUMBER(4),
  INPATIENT_DAYS                VARCHAR2(20 BYTE),
  OUTPATIENT_VISITS_NUMBER      VARCHAR2(20 BYTE),
  LAST_VISIT_DATE               DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_VISIT_SUMMARY IS 'Detail concerning the Hospital visit summary information for a beneficiary during a calendar year. The BENEFICIARY_VISIT_SUMMARY table stores the number of inpatient and outpatient visits a patient has had, by income year. PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the visit summary data applies. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. Indicates the site that the person visited for treatment ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.BENEFICIARY_VISIT_SUMMARY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.INCOME_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.INPATIENT_DAYS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.LAST_VISIT_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BENVISSUM_PK ON ADR.BENEFICIARY_VISIT_SUMMARY
(BENEFICIARY_VISIT_SUMMARY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENVISSUM_PRSN_FK_I ON ADR.BENEFICIARY_VISIT_SUMMARY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENVISSUM_STDINST_FK_I ON ADR.BENEFICIARY_VISIT_SUMMARY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEF_VISIT_SUMM_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."BENEFICIARY_VISIT_SUMMARY" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_VISIT_SUMMARY_H
		(
		BENEFICIARY_VISIT_SUMMARY_H_ID,
		BENEFICIARY_VISIT_SUMMARY_ID   ,
		PERSON_ID                      ,
		STD_INSTITUTION_ID  ,
		INCOME_YEAR                  ,
		INPATIENT_DAYS             ,
		OUTPATIENT_VISITS_NUMBER ,
		LAST_VISIT_DATE               ,
		RECORD_CREATED_BY    ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE   ,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_VISIT_SUMMARY_H_S.nextval,
		:old.BENEFICIARY_VISIT_SUMMARY_ID   ,
		:old.PERSON_ID                      ,
		:old.STD_INSTITUTION_ID  ,
		:old.INCOME_YEAR                  ,
		:old.INPATIENT_DAYS             ,
		:old.OUTPATIENT_VISITS_NUMBER ,
		:old.LAST_VISIT_DATE               ,
		:old.RECORD_CREATED_BY    ,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY        ,
		:old.RECORD_MODIFIED_DATE   ,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_VISIT_SUMMARY_H
		(
		BENEFICIARY_VISIT_SUMMARY_H_ID,
		BENEFICIARY_VISIT_SUMMARY_ID   ,
		PERSON_ID                      ,
		STD_INSTITUTION_ID  ,
		INCOME_YEAR                  ,
		INPATIENT_DAYS             ,
		OUTPATIENT_VISITS_NUMBER ,
		LAST_VISIT_DATE               ,
		RECORD_CREATED_BY    ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE   ,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_VISIT_SUMMARY_H_S.nextval,
		:new.BENEFICIARY_VISIT_SUMMARY_ID   ,
		:new.PERSON_ID                      ,
		:new.STD_INSTITUTION_ID  ,
		:new.INCOME_YEAR                  ,
		:new.INPATIENT_DAYS             ,
		:new.OUTPATIENT_VISITS_NUMBER ,
		:new.LAST_VISIT_DATE               ,
		:new.RECORD_CREATED_BY    ,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY        ,
		:new.RECORD_MODIFIED_DATE   ,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end BENEF_VISIT_SUMM_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_VISIT_SUMMARY FOR ADR.BENEFICIARY_VISIT_SUMMARY;


ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067052
  CHECK ("BENEFICIARY_VISIT_SUMMARY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067053
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067054
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067055
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067056
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067057
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067058
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT BENVISSUM_PK
  PRIMARY KEY
  (BENEFICIARY_VISIT_SUMMARY_ID)
  USING INDEX ADR.BENVISSUM_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT BENVISSUM_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ADREXT;

GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_VISIT_SUMMARY TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
(
  BENEFICIARY_VISIT_SUMMARY_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  BENEFICIARY_VISIT_SUMMARY_ID    NUMBER(20),
  PERSON_ID                       NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  INCOME_YEAR                     NUMBER(4),
  INPATIENT_DAYS                  VARCHAR2(20 BYTE),
  OUTPATIENT_VISITS_NUMBER        VARCHAR2(20 BYTE),
  LAST_VISIT_DATE                 DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.BENEFICIARY_VISIT_SUMMARY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.BENEFICIARY_VISIT_SUMMARY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.INPATIENT_DAYS IS 'Numberofdaysaperson spentasaninpatientin ahospital.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.OUTPATIENT_VISITS_NUMBER IS 'Numberofoutpatient visitstoahospital.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_VISIT_SUMMARY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BENVISSUMH_PK ON ADR.BENEFICIARY_VISIT_SUMMARY_H
(BENEFICIARY_VISIT_SUMMARY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENVISSUMH_PRSNID_NU_I ON ADR.BENEFICIARY_VISIT_SUMMARY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_VISIT_SUMMARY_H FOR ADR.BENEFICIARY_VISIT_SUMMARY_H;


ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_055
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067000
  CHECK ("BENEFICIARY_VISIT_SUMMARY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067001
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067002
  CHECK ("BENEFICIARY_VISIT_SUMMARY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067003
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067004
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067005
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067006
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067007
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067008
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT BENVISSUMH_PK
  PRIMARY KEY
  (BENEFICIARY_VISIT_SUMMARY_H_ID)
  USING INDEX ADR.BENVISSUMH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ADR_R;

GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_VISIT_SUMMARY_H TO ES_RW;
ALTER TABLE ADR.BROKER_SERVICE_ERROR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BROKER_SERVICE_ERROR CASCADE CONSTRAINTS;

CREATE TABLE ADR.BROKER_SERVICE_ERROR
(
  BROKER_SERVICE_ERROR_ID  NUMBER(20)           NOT NULL,
  ERROR_TEXT               VARCHAR2(4000 BYTE),
  INTERNAL_ERROR_TEXT      VARCHAR2(500 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(18)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BROKER_SERVICE_ERROR IS 'Retention: 30 days';

COMMENT ON COLUMN ADR.BROKER_SERVICE_ERROR.BROKER_SERVICE_ERROR_ID IS 'The primary key, generated by the database system in numeric form. Used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_ERROR.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.BROKER_SERVICE_ERROR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_ERROR.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.BROKER_SERVICE_ERROR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_ERROR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BRSRVER_PK ON ADR.BROKER_SERVICE_ERROR
(BROKER_SERVICE_ERROR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BROKER_SERVICE_ERROR FOR ADR.BROKER_SERVICE_ERROR;


ALTER TABLE ADR.BROKER_SERVICE_ERROR ADD (
  CONSTRAINT BRSRVER_PK
  PRIMARY KEY
  (BROKER_SERVICE_ERROR_ID)
  USING INDEX ADR.BRSRVER_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BROKER_SERVICE_ERROR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BROKER_SERVICE_ERROR TO ADR_RW;

GRANT SELECT ON ADR.BROKER_SERVICE_ERROR TO ES_R;

GRANT INSERT, SELECT ON ADR.BROKER_SERVICE_ERROR TO ES_RW;
ALTER TABLE ADR.BROKER_SERVICE_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BROKER_SERVICE_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.BROKER_SERVICE_LOG
(
  BROKER_SERVICE_LOG_ID          NUMBER(20)     NOT NULL,
  BROKER_SERVICE_ERROR_ID        NUMBER(20),
  TRANSMISSION_TYPE_ID           NUMBER(20),
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_MESSAGESTATUS_ID           NUMBER(20),
  STD_HL7ACKNOWLEDGEMENTCODE_ID  NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  REF_BROKER_SERVICE_LOG_ID      NUMBER(20),
  TRANSMISSION_ID                NUMBER(20)     NOT NULL,
  TRANSMISSION_DATE              DATE           NOT NULL,
  RETRANSMISSION_COUNT           NUMBER(10)     NOT NULL,
  RETRANSMISSION_TEXT            VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(18)     NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION BROKER_SERVICE_LOG_P001 VALUES LESS THAN (TO_DATE(' 2016-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-11-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-01-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BROKER_SERVICE_LOG IS 'Transactions from VADIR thru ORUZ07 etc.

Retention: 30 days';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.BROKER_SERVICE_LOG_ID IS 'The primary key, generated by the database system in numeric form. Used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.REF_BROKER_SERVICE_LOG_ID IS 'Referenced Broker Server Log Identifier - Reference to a transmitted log record where it''s communication could not return all needed information. ';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_LOG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BRSRVL1_PK ON ADR.BROKER_SERVICE_LOG
(BROKER_SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE INDEX ADR.BRSRVLP_PERSMSGSTAT_I ON ADR.BROKER_SERVICE_LOG
(PERSON_ID, STD_MESSAGESTATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BRSRVL_TRN_FK_I ON ADR.BROKER_SERVICE_LOG
(TRANSMISSION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BROKER_SERVICE_LOG FOR ADR.BROKER_SERVICE_LOG;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVL1_PK
  PRIMARY KEY
  (BROKER_SERVICE_LOG_ID)
  USING INDEX ADR.BRSRVL1_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_BRSE_FK 
  FOREIGN KEY (BROKER_SERVICE_ERROR_ID) 
  REFERENCES ADR.BROKER_SERVICE_ERROR (BROKER_SERVICE_ERROR_ID)
  ENABLE VALIDATE,
  CONSTRAINT BRSL_PER_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DISABLE NOVALIDATE,
  CONSTRAINT BRSL_TRANSTYP_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BROKER_SERVICE_LOG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BROKER_SERVICE_LOG TO ADR_RW;

GRANT SELECT ON ADR.BROKER_SERVICE_LOG TO ES_R;

GRANT INSERT, SELECT ON ADR.BROKER_SERVICE_LOG TO ES_RW;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BROKER_SERVICE_PAYLOAD CASCADE CONSTRAINTS;

CREATE TABLE ADR.BROKER_SERVICE_PAYLOAD
(
  BROKER_SERVICE_PAYLOAD_ID  NUMBER(20)         NOT NULL,
  BROKER_SERVICE_LOG_ID      NUMBER(20)         NOT NULL,
  REQUEST_PAYLOAD            CLOB,
  RESPONSE_PAYLOAD           CLOB,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(18)         NOT NULL
)
LOB (REQUEST_PAYLOAD) STORE AS (
  TABLESPACE  M_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
LOB (RESPONSE_PAYLOAD) STORE AS (
  TABLESPACE  M_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BROKER_SERVICE_PAYLOAD IS 'Retention: 30 days';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.BROKER_SERVICE_PAYLOAD_ID IS 'The primary key, generated by the database system in numeric form. Used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.REQUEST_PAYLOAD IS 'Intended to hold XML. Initially with no online viewing.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BROKER_SERVICE_PAYLOAD.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.BRSRVPL_BRSRVL_FK_I ON ADR.BROKER_SERVICE_PAYLOAD
(BROKER_SERVICE_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.BRSRVPL_PK ON ADR.BROKER_SERVICE_PAYLOAD
(BROKER_SERVICE_PAYLOAD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BROKER_SERVICE_PAYLOAD FOR ADR.BROKER_SERVICE_PAYLOAD;


ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD ADD (
  CONSTRAINT BRSRVPL_PK
  PRIMARY KEY
  (BROKER_SERVICE_PAYLOAD_ID)
  USING INDEX ADR.BRSRVPL_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BROKER_SERVICE_PAYLOAD TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BROKER_SERVICE_PAYLOAD TO ADR_RW;

GRANT SELECT ON ADR.BROKER_SERVICE_PAYLOAD TO ES_R;

GRANT INSERT, SELECT ON ADR.BROKER_SERVICE_PAYLOAD TO ES_RW;
ALTER TABLE ADR.CANCEL_DECLINE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CANCEL_DECLINE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CANCEL_DECLINE
(
  CANCEL_DECLINE_ID              NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CANCEL_DECLINE_STATUS_TYPE_ID  NUMBER(20),
  CANCEL_DECLINE_REASON_TYPE_ID  NUMBER(20),
  CANCEL_DECLINE_IND             VARCHAR2(1 BYTE),
  CANCEL_DECLINE_EFFECTIVE_DATE  DATE,
  REMARKS                        VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CANCEL_DECLINE IS 'Stores details regarding the Beneficiarys cancellation from VA health care coverage. Also stores details in the event that enrolee has declined VA health care coverage. The CANCEL_DECLINE table stores data about a person who has cancelled or declined enrollment into the VHA system. It indicates the reason and effective date for the cancel/decline, as well as storing status and related remarks. PERSON_ID Foreign key to the PERSON table. Indicates the person who has cancelled or declined enrollment into the VHA healthcare system. CANCEL_DECLINE_STATUS_TYPE_ID Foreign key to the CANCEL_DECLINE_STATUS_TYPE table. Indicates the status of a persons request to cancel or decline enrollment (for example, pending completion, pending telephone calls). CANCEL_DECLINE_REASON_TYPE_ID Foreign key to the CANCEL_DECLINE_REASON_TYPE table. Indicates the reason the person cancelled or declined (for example, geographic access, other insurance). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.CANCEL_DECLINE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.CANCEL_DECLINE_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.CANCEL_DECLINE_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.CANCEL_DECLINE_IND IS 'Indicateswhethera personhascancelledor declinedenrollmentwith theVHAhealthcare system.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.CANCEL_DECLINE_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CANDEC_PK ON ADR.CANCEL_DECLINE
(CANCEL_DECLINE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CANDEC_PRSN_FK_I ON ADR.CANCEL_DECLINE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CANDEC_STD_CANDECRSN_FK_I ON ADR.CANCEL_DECLINE
(CANCEL_DECLINE_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CANDEC_STD_CANDEC_FK_I ON ADR.CANCEL_DECLINE
(CANCEL_DECLINE_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CANCEL_DECLINE_AUDIR_TRGR
after Update or Delete or Insert
on ADR.CANCEL_DECLINE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CANCEL_DECLINE_H
		(
		CANCEL_DECLINE_H_ID,
		CANCEL_DECLINE_ID,
		PERSON_ID,
		CANCEL_DECLINE_STATUS_TYPE_ID,
		CANCEL_DECLINE_REASON_TYPE_ID,
		CANCEL_DECLINE_IND,
		CANCEL_DECLINE_EFFECTIVE_DATE,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CANCEL_DECLINE_H_S.nextval,
		:old.CANCEL_DECLINE_ID,
		:old.PERSON_ID,
		:old.CANCEL_DECLINE_STATUS_TYPE_ID,
		:old.CANCEL_DECLINE_REASON_TYPE_ID,
		:old.CANCEL_DECLINE_IND,
		:old.CANCEL_DECLINE_EFFECTIVE_DATE,
		:old.REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CANCEL_DECLINE_H
		(
		CANCEL_DECLINE_H_ID,
		CANCEL_DECLINE_ID,
		PERSON_ID,
		CANCEL_DECLINE_STATUS_TYPE_ID,
		CANCEL_DECLINE_REASON_TYPE_ID,
		CANCEL_DECLINE_IND,
		CANCEL_DECLINE_EFFECTIVE_DATE,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CANCEL_DECLINE_H_S.nextval,
		:new.CANCEL_DECLINE_ID,
		:new.PERSON_ID,
		:new.CANCEL_DECLINE_STATUS_TYPE_ID,
		:new.CANCEL_DECLINE_REASON_TYPE_ID,
		:new.CANCEL_DECLINE_IND,
		:new.CANCEL_DECLINE_EFFECTIVE_DATE,
		:new.REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  CANCEL_DECLINE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CANCEL_DECLINE FOR ADR.CANCEL_DECLINE;


ALTER TABLE ADR.CANCEL_DECLINE ADD (
  CONSTRAINT CANDEC_PK
  PRIMARY KEY
  (CANCEL_DECLINE_ID)
  USING INDEX ADR.CANDEC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CANCEL_DECLINE ADD (
  CONSTRAINT CANDEC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CANCEL_DECLINE TO ADREXT;

GRANT SELECT ON ADR.CANCEL_DECLINE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CANCEL_DECLINE TO ADR_RW;

GRANT SELECT ON ADR.CANCEL_DECLINE TO ES_R;

GRANT INSERT, SELECT ON ADR.CANCEL_DECLINE TO ES_RW;
ALTER TABLE ADR.CANCEL_DECLINE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CANCEL_DECLINE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CANCEL_DECLINE_H
(
  CANCEL_DECLINE_H_ID            NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  CANCEL_DECLINE_ID              NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CANCEL_DECLINE_STATUS_TYPE_ID  NUMBER(20),
  CANCEL_DECLINE_REASON_TYPE_ID  NUMBER(20),
  CANCEL_DECLINE_IND             VARCHAR2(1 BYTE),
  CANCEL_DECLINE_EFFECTIVE_DATE  DATE,
  REMARKS                        VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CANCEL_DECLINE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_IND IS 'Indicateswhethera personhascancelledor declinedenrollmentwith theVHAhealthcare system.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CANDECH_PK ON ADR.CANCEL_DECLINE_H
(CANCEL_DECLINE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CANDECH_PRSNID_NU_I ON ADR.CANCEL_DECLINE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CANCEL_DECLINE_H FOR ADR.CANCEL_DECLINE_H;


ALTER TABLE ADR.CANCEL_DECLINE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_057
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CANDECH_PK
  PRIMARY KEY
  (CANCEL_DECLINE_H_ID)
  USING INDEX ADR.CANDECH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ADR_R;

GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ADR_RW;

GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CANCEL_DECLINE_H TO ES_RW;
ALTER TABLE ADR.CASSCERTIFIEDTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CASSCERTIFIEDTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CASSCERTIFIEDTYPE
(
  CASSCERTIFIEDTYPE_ID  NUMBER(20)              NOT NULL,
  CODE                  VARCHAR2(3 BYTE)        NOT NULL,
  NAME                  VARCHAR2(30 BYTE)       NOT NULL,
  DESCRIPTION           VARCHAR2(250 BYTE),
  CREATED               DATE                    NOT NULL,
  UPDATED               DATE,
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CASSCERTIFIEDTYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CASSCERTIFIEDTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.DESCRIPTION IS 'Description of the CASS status code';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.CASSCERTIFIEDTYPE_PK ON ADR.CASSCERTIFIEDTYPE
(CASSCERTIFIEDTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CASSCERTIFIEDTYPE FOR ADR.CASSCERTIFIEDTYPE;


ALTER TABLE ADR.CASSCERTIFIEDTYPE ADD (
  CONSTRAINT CASSCERTIFIEDTYPE_PK
  PRIMARY KEY
  (CASSCERTIFIEDTYPE_ID)
  USING INDEX ADR.CASSCERTIFIEDTYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CASSCERTIFIEDTYPE TO ADR_RW;

GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO ES_R;

GRANT INSERT, SELECT ON ADR.CASSCERTIFIEDTYPE TO ES_RW;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CATASTROPHIC_DISABILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.CATASTROPHIC_DISABILITY
(
  CATASTROPHIC_DISABILITY_ID      NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  CAT_DSBLTY_EVAL_MTHD_TYPE_ID    NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  CATASTROPHICALLY_DISABLED_IND   VARCHAR2(1 BYTE),
  CLINICAL_APPROVER_NAME          VARCHAR2(100 BYTE),
  CAT_DSBLTY_EVALUATION_DATE      DATE,
  DECISION_DATE                   DATE,
  CAT_DSBLTY_REVIEW_REQUESTED_DT  DATE,
  CAT_DSBLTY_REVIEW_INITIATED_DT  DATE,
  CAT_DSBLTY_REVIEW_NOTIFIED_DT   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CATASTROPHIC_DISABILITY IS 'The CATASTROPHIC_DISABILITY table shows that a person has been clinically determined to have a disability severe enough to be called catastrophic. The table includes the site at which the determination was made, the verification date and method. It also includes information about any reviews of this determination have taken place. PERSON_ID Foreign key to the PERSON table. Indicates the person who has been clinically determined to have a catastrophic disability. CAT_DSBLTY_EVAL_MTHD_TYPE_ID Foreign key to the CAT_DSBLTY_EVAL_MTHD_TYPE table. Indicates how the evaluation was done (for example, automated record review, physical examination). STD_INSTITUTION_ID Site at which the catastrophic disability determination was made. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_EVAL_MTHD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CATASTROPHICALLY_DISABLED_IND IS 'NULL =  no CD data
  2  `0 = no letter sent
  3  `1 = letter sent	';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CLINICAL_APPROVER_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_EVALUATION_DATE IS 'Reviewdateisdefinedas thedateofthe CatastrophicallyDisabled evaluation.Eitherby medicalrecordorby physicalexam.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.DECISION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_REVIEW_REQUESTED_DT IS 'Dateonwhicharequest toreviewapersons catastrophicdisability determinationwas received';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_REVIEW_INITIATED_DT IS 'Dateonwhich catastrophicdisability reviewwasinitiatedby theChiefofStaffor his/herdesignee.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_REVIEW_NOTIFIED_DT IS 'Dateonwhichthe affectedpersonwas notifiedaboutthe resultsofthereview.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CATDSBLTY_PK ON ADR.CATASTROPHIC_DISABILITY
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTY_PRSN_FK_I ON ADR.CATASTROPHIC_DISABILITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTY_STDINST_FK_I ON ADR.CATASTROPHIC_DISABILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTY_STD_EVALMTHD_FK_I ON ADR.CATASTROPHIC_DISABILITY
(CAT_DSBLTY_EVAL_MTHD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DISABILITY_AUDIR_TRGR
  AFTER UPDATE OR DELETE OR INSERT
  ON ADR.CATASTROPHIC_DISABILITY   FOR EACH ROW
DECLARE

    Mdml                               CHAR(1);

BEGIN

  IF DELETING THEN

    INSERT
    INTO      Catastrophic_Disability_H
              (Catastrophic_disability_h_id,
               Catastrophic_disability_id,
               Person_id,
               Cat_dsblty_eval_mthd_type_id,
               Std_institution_id,
               Clinical_approver_name,
               Catastrophically_disabled_ind,
               Cat_dsblty_evaluation_date,
               Decision_date,
               Record_created_by,
               Record_created_date,
               Record_modified_by,
               Record_modified_date,
               Record_modified_count,
               Cat_dsblty_review_requested_dt,
               Cat_dsblty_review_initiated_dt,
               Cat_dsblty_review_notified_dt,
               Transaction_type_code)
    VALUES    (ADR.Catastrophic_disability_h_s.NEXTVAL,
               :OLD.Catastrophic_disability_id     ,
               :OLD.Person_id                      ,
               :OLD.Cat_dsblty_eval_mthd_type_id   ,
               :OLD.Std_institution_id             ,
               :OLD.Clinical_approver_name,
               :OLD.Catastrophically_disabled_ind  ,
               :OLD.Cat_dsblty_evaluation_date     ,
               :OLD.Decision_date                  ,
               :OLD.Record_created_by   ,
               :OLD.Record_created_date            ,
               :OLD.Record_modified_by             ,
               :OLD.Record_modified_date        ,
               :OLD.Record_modified_count     ,
               :OLD.Cat_dsblty_review_requested_dt,
               :OLD.Cat_dsblty_review_initiated_dt,
               :OLD.Cat_dsblty_review_notified_dt  ,
               'D');

  ELSE

    IF UPDATING THEN

      Mdml := 'U';

    ELSE

      Mdml := 'I';

    END IF;

    INSERT
    INTO      ADR.Catastrophic_Disability_H
              (Catastrophic_disability_h_id,
               Catastrophic_disability_id,
               Person_id,
               Cat_dsblty_eval_mthd_type_id,
               Std_institution_id,
               Clinical_approver_name,
               Catastrophically_disabled_ind,
               Cat_dsblty_evaluation_date,
               Decision_date,
               Record_created_by,
               Record_created_date,
               Record_modified_by,
               Record_modified_date,
               Record_modified_count,
               Cat_dsblty_review_requested_dt,
               Cat_dsblty_review_initiated_dt,
               Cat_dsblty_review_notified_dt,
               Transaction_type_code)
    VALUES     (ADR.Catastrophic_disability_h_s.NEXTVAL,
                :NEW.Catastrophic_disability_id,
                :NEW.Person_id,
                :NEW.Cat_dsblty_eval_mthd_type_id,
                :NEW.Std_institution_id,
                :NEW.Clinical_approver_name,
                :NEW.Catastrophically_disabled_ind,
                :NEW.Cat_dsblty_evaluation_date,
                :NEW.Decision_date,
                :NEW.Record_created_by,
                :NEW.Record_created_date,
                :NEW.Record_modified_by,
                :NEW.Record_modified_date,
                :NEW.Record_modified_count,
                :NEW.Cat_dsblty_review_requested_dt,
                :NEW.Cat_dsblty_review_initiated_dt,
                :NEW.Cat_dsblty_review_notified_dt,
                Mdml);

  END IF;

END  Cat_Disability_Audir_Trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CATASTROPHIC_DISABILITY FOR ADR.CATASTROPHIC_DISABILITY;


ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_ID)
  USING INDEX ADR.CATDSBLTY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ADREXT;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CATASTROPHIC_DISABILITY TO ADR_RW;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ES_R;

GRANT INSERT, SELECT ON ADR.CATASTROPHIC_DISABILITY TO ES_RW;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CATASTROPHIC_DISABILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CATASTROPHIC_DISABILITY_H
(
  CATASTROPHIC_DISABILITY_H_ID    NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  CATASTROPHIC_DISABILITY_ID      NUMBER(20),
  PERSON_ID                       NUMBER(20),
  CAT_DSBLTY_EVAL_MTHD_TYPE_ID    NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  CLINICAL_APPROVER_NAME          VARCHAR2(100 BYTE),
  CATASTROPHICALLY_DISABLED_IND   VARCHAR2(1 BYTE),
  CAT_DSBLTY_EVALUATION_DATE      DATE,
  DECISION_DATE                   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CAT_DSBLTY_REVIEW_REQUESTED_DT  DATE,
  CAT_DSBLTY_REVIEW_INITIATED_DT  DATE,
  CAT_DSBLTY_REVIEW_NOTIFIED_DT   DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CATASTROPHIC_DISABILITY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CATASTROPHIC_DISABILITY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_EVAL_MTHD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CLINICAL_APPROVER_NAME IS 'Nameofthepersonwho madethecatastrophic disabilitydetermination. NameoftheChiefof StafforDesigneemaking theCatastrophically Disableddecision.Free text.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CATASTROPHICALLY_DISABLED_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_EVALUATION_DATE IS 'Reviewdateisdefinedas thedateofthe CatastrophicallyDisabled evaluation.Eitherby medicalrecordorby physicalexam.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.DECISION_DATE IS 'Dateofdecisionis definedasthedatethat theclinical determinationdecision wasmadebytheChiefof Stafforhis/her designee.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_REVIEW_REQUESTED_DT IS 'Dateonwhicharequest toreviewapersons catastrophicdisability determinationwas received';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_REVIEW_INITIATED_DT IS 'Dateonwhich catastrophicdisability reviewwasinitiatedby theChiefofStaffor his/herdesignee.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_REVIEW_NOTIFIED_DT IS 'Dateonwhichthe affectedpersonwas notifiedaboutthe resultsofthereview.';


CREATE UNIQUE INDEX ADR.CATDSBLTYH_PK ON ADR.CATASTROPHIC_DISABILITY_H
(CATASTROPHIC_DISABILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTYH_PRSNID_NU_I ON ADR.CATASTROPHIC_DISABILITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CATASTROPHIC_DISABILITY_H FOR ADR.CATASTROPHIC_DISABILITY_H;


ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_014
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066167
  CHECK ("CATASTROPHIC_DISABILITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066168
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066169
  CHECK ("CATASTROPHIC_DISABILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066170
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066171
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066172
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066173
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066174
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066175
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT CATDSBLTYH_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_H_ID)
  USING INDEX ADR.CATDSBLTYH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ADR_R;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ADR_RW;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_CONDITION CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_CONDITION
(
  CAT_DSBLTY_CONDITION_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  CONDITION_TYPE_ID           NUMBER(20)        NOT NULL,
  PRMNT_DSBLTY_STDYESNO_ID    NUMBER(20),
  DISABILITY_SCORE            NUMBER(3),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  PRMNT_DSBLTY_STDPERM_ID     NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_CONDITION IS 'The CAT_DSBLTY_CONDITION table is a child table of CATASTROPHIC_DISABILITY that shows the assessment tool used to evaluate the persons disability. CATASTROPHIC_DISABILITY_ID Foreign key to the CATASTROPHIC_DISABILITY table. CONDITION_TYPE_ID Foreign key to the CONDITION_TYPE table. Indicates what kind of disability a person has, according to the assessment tool used (for example, KATZ, FOLS). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.CAT_DSBLTY_CONDITION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.CONDITION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.DISABILITY_SCORE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSCOND_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_CONDITION
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSCOND_PK ON ADR.CAT_DSBLTY_CONDITION
(CAT_DSBLTY_CONDITION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSCOND_STDPERM_FK_I ON ADR.CAT_DSBLTY_CONDITION
(PRMNT_DSBLTY_STDPERM_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSCOND_STDYESNO_FK_I ON ADR.CAT_DSBLTY_CONDITION
(PRMNT_DSBLTY_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSCON_STD_CNDN_FK_I ON ADR.CAT_DSBLTY_CONDITION
(CONDITION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_COND_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_CONDITION
for each row
declare
       mDML char(1);
begin

    if DELETING then
        insert into CAT_DSBLTY_CONDITION_H
        (
        CAT_DSBLTY_CONDITION_H_ID,
        CAT_DSBLTY_CONDITION_ID,
        CATASTROPHIC_DISABILITY_ID,
        CONDITION_TYPE_ID         ,
        RECORD_CREATED_BY         ,
        RECORD_CREATED_DATE       ,
        RECORD_MODIFIED_BY        ,
        RECORD_MODIFIED_DATE      ,
        RECORD_MODIFIED_COUNT     ,
        PRMNT_DSBLTY_STDYESNO_ID  ,
        DISABILITY_SCORE          ,
        TRANSACTION_TYPE_CODE     ,
        PRMNT_DSBLTY_STDPERM_ID
        )
        values
        (
        CAT_DSBLTY_CONDITION_H_s.nextval,
        :old.CAT_DSBLTY_CONDITION_ID,
        :old.CATASTROPHIC_DISABILITY_ID,
        :old.CONDITION_TYPE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.PRMNT_DSBLTY_STDYESNO_ID,
        :old.DISABILITY_SCORE,
        'D',
        :old.PRMNT_DSBLTY_STDPERM_ID
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into CAT_DSBLTY_CONDITION_H
        (
        CAT_DSBLTY_CONDITION_H_ID,
        CAT_DSBLTY_CONDITION_ID,
        CATASTROPHIC_DISABILITY_ID,
        CONDITION_TYPE_ID         ,
        RECORD_CREATED_BY         ,
        RECORD_CREATED_DATE       ,
        RECORD_MODIFIED_BY        ,
        RECORD_MODIFIED_DATE      ,
        RECORD_MODIFIED_COUNT     ,
        PRMNT_DSBLTY_STDYESNO_ID  ,
        DISABILITY_SCORE          ,
        TRANSACTION_TYPE_CODE     ,
        PRMNT_DSBLTY_STDPERM_ID
        )
        values
        (
        CAT_DSBLTY_CONDITION_H_s.nextval,
        :new.CAT_DSBLTY_CONDITION_ID,
        :new.CATASTROPHIC_DISABILITY_ID,
        :new.CONDITION_TYPE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.PRMNT_DSBLTY_STDYESNO_ID,
        :new.DISABILITY_SCORE,
        mDML,
        :new.PRMNT_DSBLTY_STDPERM_ID
        );
    end if;

end  CAT_DSBLTY_COND_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_CONDITION FOR ADR.CAT_DSBLTY_CONDITION;


ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_ID)
  USING INDEX ADR.CATDSCOND_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_CONDITION TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_CONDITION TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_CONDITION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_CONDITION_H
(
  CAT_DSBLTY_CONDITION_H_ID   NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  CAT_DSBLTY_CONDITION_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  CONDITION_TYPE_ID           NUMBER(20)        NOT NULL,
  PRMNT_DSBLTY_STDYESNO_ID    NUMBER(20),
  DISABILITY_SCORE            NUMBER(3),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  PRMNT_DSBLTY_STDPERM_ID     NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_CONDITION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CAT_DSBLTY_CONDITION_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CAT_DSBLTY_CONDITION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CONDITION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.DISABILITY_SCORE IS 'BR3034Scoreisbasedon thefollowingand contingentonwhichCD conditionwasselected (FOLS,FIM,GAF,or KATZ).Eachonewill haveascoreassociated withit.FolsteinMini- MentalStateExamination (FOLS)isanumber between0-30,onthe Folstein.Mini-Mental StateExamination (MMSE).Functional IndependenceMeasure:The FIMcontains18measures in6domains.The13 MOTORITEMSarein4 domains:-self-care,- sphinctercontrol,- transfers,and- locomotion.Thevaluein thisfieldisbasedon thenumberofMOTORitems forwhichtheveteran receivedascoreof2or lower.FIMSScoreis0- 13.TheKatzIndexof ActivitiesofDaily Living(ADLs)assignsa numberfrom1to3in eachof6activities.1 isdependent,2isan intermediatelimitation, and3isindependent. TheKatzIndexmaybe usedtodeterminewhether aveteranis catastrophically disabled.Thisfieldmust containthenumberof permanentADLsforwhich theveteranreceiveda scoreof1(dependent). ItisNOTtheoverall scoreontheKATZtest (whichcanrangefrom0 to6.)GAFscoreisa numberbetween1and100.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSCONDH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_CONDITION_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSCONDH_PK ON ADR.CAT_DSBLTY_CONDITION_H
(CAT_DSBLTY_CONDITION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_CONDITION_H FOR ADR.CAT_DSBLTY_CONDITION_H;


ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_047
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CATDSCONDH_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_H_ID)
  USING INDEX ADR.CATDSCONDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ADR_R;

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DESCRIPTOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DESCRIPTOR
(
  CAT_DSBLTY_DESCRIPTOR_ID    NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  DESCRIPTOR_TYPE_ID          NUMBER(20)        NOT NULL,
  DETERMINATION_DATE          DATE,
  STD_INSTITUTION_ID          NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR.CAT_DSBLTY_DESCRIPTOR_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR.CATASTROPHIC_DISABILITY_ID IS 'FK to ADR.CATASTROPHIC_DISABILITY.CATASTROPHIC_DISABILITY_ID';


CREATE UNIQUE INDEX ADR.CAT_DSBLTY_DESCRIPTOR_PK ON ADR.CAT_DSBLTY_DESCRIPTOR
(CAT_DSBLTY_DESCRIPTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CAT_DSBL_CAT_DSBL_DESC_FK_I ON ADR.CAT_DSBLTY_DESCRIPTOR
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_DESC_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.CAT_DSBLTY_DESCRIPTOR
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.CAT_DSBLTY_DESCRIPTOR_H
        (CAT_DSBLTY_DESCRIPTOR_ID_H,
         CAT_DSBLTY_DESCRIPTOR_ID,
         CATASTROPHIC_DISABILITY_ID,
         DESCRIPTOR_TYPE_ID,
         DETERMINATION_DATE,
         STD_INSTITUTION_ID,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CAT_DSBLTY_DESCRIPTOR_H_S.NEXTVAL,
         :OLD.CAT_DSBLTY_DESCRIPTOR_ID,
         :OLD.CATASTROPHIC_DISABILITY_ID,
         :OLD.DESCRIPTOR_TYPE_ID,
         :OLD.DETERMINATION_DATE,
         :OLD.STD_INSTITUTION_ID,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_count,
         :OLD.Record_modified_date,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO ADR.CAT_DSBLTY_DESCRIPTOR_H
        (CAT_DSBLTY_DESCRIPTOR_ID_H,
         CAT_DSBLTY_DESCRIPTOR_ID,
         CATASTROPHIC_DISABILITY_ID,
         DESCRIPTOR_TYPE_ID,
         DETERMINATION_DATE,
         STD_INSTITUTION_ID,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CAT_DSBLTY_DESCRIPTOR_H_S.NEXTVAL,
         :NEW.CAT_DSBLTY_DESCRIPTOR_ID,
         :NEW.CATASTROPHIC_DISABILITY_ID,
         :NEW.DESCRIPTOR_TYPE_ID,
         :NEW.DETERMINATION_DATE,
         :NEW.STD_INSTITUTION_ID,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_count,
         :NEW.Record_modified_date,
         SYSDATE,
         mDML
        );

    END IF;

  END CAT_DSBLTY_DESC_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DESCRIPTOR FOR ADR.CAT_DSBLTY_DESCRIPTOR;


ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID)
  USING INDEX ADR.CAT_DSBLTY_DESCRIPTOR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_CAT_DSBLTY_DESC_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DESCRIPTOR TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H
(
  CAT_DSBLTY_DESCRIPTOR_ID_H  NUMBER(20)        NOT NULL,
  CAT_DSBLTY_DESCRIPTOR_ID    NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20),
  DESCRIPTOR_TYPE_ID          NUMBER(20),
  DETERMINATION_DATE          DATE,
  STD_INSTITUTION_ID          NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  HISTORY_CREATED_DATE        DATE              NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR_H.CAT_DSBLTY_DESCRIPTOR_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR_H.CATASTROPHIC_DISABILITY_ID IS 'FK to ADR.CATASTROPHIC_DISABILITY.CATASTROPHIC_DISABILITY_ID';


CREATE UNIQUE INDEX ADR.CAT_DSBLTY_DESCRIPTOR_H_PK ON ADR.CAT_DSBLTY_DESCRIPTOR_H
(CAT_DSBLTY_DESCRIPTOR_ID_H)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DESCRIPTOR_H FOR ADR.CAT_DSBLTY_DESCRIPTOR_H;


ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_H_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID_H)
  USING INDEX ADR.CAT_DSBLTY_DESCRIPTOR_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DIAGNOSIS CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DIAGNOSIS
(
  CAT_DSBLTY_DIAGNOSIS_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  DIAGNOSIS_TYPE_ID           NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_DIAGNOSIS IS 'The CAT_DSBLTY_DIAGNOSIS table is a child table of CATASTROPHIC_DISABILITY that shows the specific disability or disabilities with which the person has been diagnosed. CATASTROPHIC_DISABILITY_ID Foreign key to the CATASTROPHIC_DISABILITY table. DIAGNOSIS_TYPE_ID Foreign key to the DIAGNOSIS_TYPE. Indicates the type of disability that was diagnosed for a person (for example, paraplegia, legal blindness). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.CAT_DSBLTY_DIAGNOSIS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.DIAGNOSIS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSDIAG_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_DIAGNOSIS
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSDIAG_PK ON ADR.CAT_DSBLTY_DIAGNOSIS
(CAT_DSBLTY_DIAGNOSIS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSDIAG_STD_DIAGCD_FK_I ON ADR.CAT_DSBLTY_DIAGNOSIS
(DIAGNOSIS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_DIAG_audir_trgr
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_DIAGNOSIS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CAT_DSBLTY_DIAGNOSIS_H
		(
		CAT_DSBLTY_DIAGNOSIS_H_ID,
		CAT_DSBLTY_DIAGNOSIS_ID,
		CATASTROPHIC_DISABILITY_ID,
		DIAGNOSIS_TYPE_ID         ,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_DIAGNOSIS_H_S.nextval,
		:old.CAT_DSBLTY_DIAGNOSIS_ID,
		:old.CATASTROPHIC_DISABILITY_ID,
		:old.DIAGNOSIS_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CAT_DSBLTY_DIAGNOSIS_H
		(
		CAT_DSBLTY_DIAGNOSIS_H_ID,
		CAT_DSBLTY_DIAGNOSIS_ID,
		CATASTROPHIC_DISABILITY_ID,
		DIAGNOSIS_TYPE_ID         ,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_DIAGNOSIS_H_S.nextval,
		:new.CAT_DSBLTY_DIAGNOSIS_ID,
		:new.CATASTROPHIC_DISABILITY_ID,
		:new.DIAGNOSIS_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;


end  CAT_DSBLTY_DIAG_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DIAGNOSIS FOR ADR.CAT_DSBLTY_DIAGNOSIS;


ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_ID)
  USING INDEX ADR.CATDSDIAG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DIAGNOSIS TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
(
  CAT_DSBLTY_DIAGNOSIS_H_ID   NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  CAT_DSBLTY_DIAGNOSIS_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  DIAGNOSIS_TYPE_ID           NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.CAT_DSBLTY_DIAGNOSIS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.CAT_DSBLTY_DIAGNOSIS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.DIAGNOSIS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSDIAGH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_DIAGNOSIS_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSDIAGH_PK ON ADR.CAT_DSBLTY_DIAGNOSIS_H
(CAT_DSBLTY_DIAGNOSIS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DIAGNOSIS_H FOR ADR.CAT_DSBLTY_DIAGNOSIS_H;


ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_004
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CATDSDIAGH_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_H_ID)
  USING INDEX ADR.CATDSDIAGH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ADR_R;

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_PROCEDURE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_PROCEDURE
(
  CAT_DSBLTY_PROCEDURE_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  PROCEDURE_TYPE_ID           NUMBER(20)        NOT NULL,
  AFFECTED_EXTREMITY_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_PROCEDURE IS 'The CAT_DSBLTY_PROCEDURE table is a child table of CATASTROPHIC_DISABILITY that shows the specific procedure, usually an amputation or disarticulation was part of the cause of disability. CATASTROPHIC_DISABILITY_ID Foreign key to the CATASTROPHIC_DISABILITY table. PROCEDURE_TYPE_ID Foreign key for the PROCEDURE_TYPE table. Indicates a specific procedure that is part of the cause of the disability (for example, amputation or disarticulation). AFFECTED_EXTREMITY_TYPE_ID Foreign key to the AFFECTED_EXTREMITY_TYPE table. Indicates which of a persons extremities were affected by the procedure. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.CAT_DSBLTY_PROCEDURE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.PROCEDURE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.AFFECTED_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSBLPRC_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_PROCEDURE
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLPRC_DIAGXTRMTY_FK_I ON ADR.CAT_DSBLTY_PROCEDURE
(AFFECTED_EXTREMITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSBLPRC_PK ON ADR.CAT_DSBLTY_PROCEDURE
(CAT_DSBLTY_PROCEDURE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLPRC_STD_PROCCD_FK_I ON ADR.CAT_DSBLTY_PROCEDURE
(PROCEDURE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_PROC_audir_trgr
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_PROCEDURE
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into CAT_DSBLTY_PROCEDURE_H
		(
		CAT_DSBLTY_PROCEDURE_H_ID,
		CAT_DSBLTY_PROCEDURE_ID  ,
		CATASTROPHIC_DISABILITY_ID,
		PROCEDURE_TYPE_ID        ,
		AFFECTED_EXTREMITY_TYPE_ID,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_PROCEDURE_H_s.nextval,
		:old.CAT_DSBLTY_PROCEDURE_ID,
		:old.CATASTROPHIC_DISABILITY_ID,
		:old.PROCEDURE_TYPE_ID,
		:old.AFFECTED_EXTREMITY_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CAT_DSBLTY_PROCEDURE_H
		(
		CAT_DSBLTY_PROCEDURE_H_ID,
		CAT_DSBLTY_PROCEDURE_ID  ,
		CATASTROPHIC_DISABILITY_ID,
		PROCEDURE_TYPE_ID        ,
		AFFECTED_EXTREMITY_TYPE_ID,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_PROCEDURE_H_s.nextval,
		:new.CAT_DSBLTY_PROCEDURE_ID,
		:new.CATASTROPHIC_DISABILITY_ID,
		:new.PROCEDURE_TYPE_ID,
		:new.AFFECTED_EXTREMITY_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  CAT_DSBLTY_PROC_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_PROCEDURE FOR ADR.CAT_DSBLTY_PROCEDURE;


ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE ADD (
  CONSTRAINT CATDSBLPRC_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_ID)
  USING INDEX ADR.CATDSBLPRC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE ADD (
  CONSTRAINT CATDSBLPRC_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_PROCEDURE TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_PROCEDURE TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_PROCEDURE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_PROCEDURE_H
(
  CAT_DSBLTY_PROCEDURE_H_ID   NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  CAT_DSBLTY_PROCEDURE_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  PROCEDURE_TYPE_ID           NUMBER(20)        NOT NULL,
  AFFECTED_EXTREMITY_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_PROCEDURE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.CAT_DSBLTY_PROCEDURE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.CAT_DSBLTY_PROCEDURE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.PROCEDURE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.AFFECTED_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSBLPRH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_PROCEDURE_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSBLPRH_PK ON ADR.CAT_DSBLTY_PROCEDURE_H
(CAT_DSBLTY_PROCEDURE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_PROCEDURE_H FOR ADR.CAT_DSBLTY_PROCEDURE_H;


ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_035
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CATDSBLPRH_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_H_ID)
  USING INDEX ADR.CATDSBLPRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ADR_R;

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ES_RW;
ALTER TABLE ADR.CCN_CONTRACTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_CONTRACTOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_CONTRACTOR
(
  CCN_CONTRACTOR_ID      NUMBER(20)             NOT NULL,
  CONTRACTOR_NAME        VARCHAR2(100 BYTE)     NOT NULL,
  ISACTIVE               VARCHAR2(1 BYTE),
  START_DATE             DATE,
  END_DATE               DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL,
  CCN_CODE               VARCHAR2(20 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_CONTRACTOR IS 'Table will be used to hold CCN Contractors name';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.CCN_CONTRACTOR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.CONTRACTOR_NAME IS 'CCN Contractor Name';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.ISACTIVE IS 'active flag of the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.START_DATE IS 'start date of the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.END_DATE IS 'end date of the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_PK_I ON ADR.CCN_CONTRACTOR
(CCN_CONTRACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CCN_CONTRACTOR_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_CONTRACTOR
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_CONTRACTOR_H (CCN_CONTRACTOR_H_ID,
                                    CCN_CONTRACTOR_ID,
                                    CONTRACTOR_NAME,
                                    ISACTIVE,
                                    START_DATE,
                                    END_DATE,
                                    CCN_CODE,
                                    RECORD_CREATED_BY,
                                    RECORD_CREATED_DATE,
                                    RECORD_MODIFIED_BY,
                                    RECORD_MODIFIED_DATE,
                                    RECORD_MODIFIED_COUNT,
                                    HISTORY_CREATED_DATE,
                                    TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_H_S.NEXTVAL,
                   :old.CCN_CONTRACTOR_ID,
                   :old.CONTRACTOR_NAME,
                   :old.ISACTIVE,
                   :old.START_DATE,
                   :old.END_DATE,
                   :old.CCN_CODE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_CONTRACTOR_H (CCN_CONTRACTOR_H_ID,
                                    CCN_CONTRACTOR_ID,
                                    CONTRACTOR_NAME,
                                    ISACTIVE,
                                    START_DATE,
                                    END_DATE,
                                    CCN_CODE,
                                    RECORD_CREATED_BY,
                                    RECORD_CREATED_DATE,
                                    RECORD_MODIFIED_BY,
                                    RECORD_MODIFIED_DATE,
                                    RECORD_MODIFIED_COUNT,
                                    HISTORY_CREATED_DATE,
                                    TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_H_S.NEXTVAL,
                   :new.CCN_CONTRACTOR_ID,
                   :new.CONTRACTOR_NAME,
                   :new.ISACTIVE,
                   :new.START_DATE,
                   :new.END_DATE,
                   :new.CCN_CODE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   END IF;
END CCN_CONTRACTOR_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CCN_CONTRACTOR FOR ADR.CCN_CONTRACTOR;


ALTER TABLE ADR.CCN_CONTRACTOR ADD (
  CONSTRAINT CCN_CONTRACTOR_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_ID)
  USING INDEX ADR.CCN_CONTRACTOR_PK_I
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_CONTRACTOR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_CONTRACTOR TO ADR_RW;

GRANT SELECT ON ADR.CCN_CONTRACTOR TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_CONTRACTOR TO VETCHOICE_RW;
ALTER TABLE ADR.CCN_CONTRACTOR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_CONTRACTOR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_CONTRACTOR_H
(
  CCN_CONTRACTOR_H_ID    NUMBER(20)             NOT NULL,
  CCN_CONTRACTOR_ID      NUMBER(20)             NOT NULL,
  CONTRACTOR_NAME        VARCHAR2(100 BYTE)     NOT NULL,
  ISACTIVE               VARCHAR2(1 BYTE),
  START_DATE             DATE,
  END_DATE               DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL,
  HISTORY_CREATED_DATE   DATE                   NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE),
  CCN_CODE               VARCHAR2(20 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_CONTRACTOR_H IS 'Table will be used to hold CCN Contractors history info';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_H.HISTORY_CREATED_DATE IS 'the date this history record is created';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';


CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_H_PK_I ON ADR.CCN_CONTRACTOR_H
(CCN_CONTRACTOR_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_CONTRACTOR_H FOR ADR.CCN_CONTRACTOR_H;


ALTER TABLE ADR.CCN_CONTRACTOR_H ADD (
  CONSTRAINT CCN_CONTRACTOR_H_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_H_ID)
  USING INDEX ADR.CCN_CONTRACTOR_H_PK_I
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_CONTRACTOR_H TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_CONTRACTOR_H TO ADR_RW;

GRANT SELECT ON ADR.CCN_CONTRACTOR_H TO VETCHOICE_R;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_CONTRACTOR_REGION CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_CONTRACTOR_REGION
(
  CCN_CONTRACTOR_REGION_ID  NUMBER(20)          NOT NULL,
  CCN_CONTRACTOR_ID         NUMBER(20)          NOT NULL,
  CCN_REGION_ID             NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_CONTRACTOR_REGION IS 'Table (many to many between CCN_CONTRACTOR and CCN_REGION) will be used to hold CCN Contractors assigned to any Regions';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION.CCN_CONTRACTOR_ID IS 'FK to CCN_CONTRACTOR';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION.CCN_REGION_ID IS 'FK to CCN_REGION';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CCN_CONTRACTOR_ID_FK_I ON ADR.CCN_CONTRACTOR_REGION
(CCN_CONTRACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_REGION_PK_I ON ADR.CCN_CONTRACTOR_REGION
(CCN_CONTRACTOR_REGION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCN_REGION_ID_FK_I ON ADR.CCN_CONTRACTOR_REGION
(CCN_REGION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CCN_CONTRA_REGION_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_CONTRACTOR_REGION
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_CONTRACTOR_REGION_H (CCN_CONTRACTOR_REGION_H_ID,
                                           CCN_CONTRACTOR_REGION_ID,
                                           CCN_CONTRACTOR_ID,
                                           CCN_REGION_ID,
                                           RECORD_CREATED_BY,
                                           RECORD_CREATED_DATE,
                                           RECORD_MODIFIED_BY,
                                           RECORD_MODIFIED_DATE,
                                           RECORD_MODIFIED_COUNT,
                                           HISTORY_CREATED_DATE,
                                           TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_REGION_H_S.NEXTVAL,
                   :old.CCN_CONTRACTOR_REGION_ID,
                   :old.CCN_CONTRACTOR_ID,
                   :old.CCN_REGION_ID,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_CONTRACTOR_REGION_H (CCN_CONTRACTOR_REGION_H_ID,
                                           CCN_CONTRACTOR_REGION_ID,
                                           CCN_CONTRACTOR_ID,
                                           CCN_REGION_ID,
                                           RECORD_CREATED_BY,
                                           RECORD_CREATED_DATE,
                                           RECORD_MODIFIED_BY,
                                           RECORD_MODIFIED_DATE,
                                           RECORD_MODIFIED_COUNT,
                                           HISTORY_CREATED_DATE,
                                           TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_REGION_H_S.NEXTVAL,
                   :new.CCN_CONTRACTOR_REGION_ID,
                   :new.CCN_CONTRACTOR_ID,
                   :new.CCN_REGION_ID,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   END IF;
END CCN_CONTRA_REGION_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CCN_CONTRACTOR_REGION FOR ADR.CCN_CONTRACTOR_REGION;


ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_CONTRACTOR_REGION_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_REGION_ID)
  USING INDEX ADR.CCN_CONTRACTOR_REGION_PK_I
  ENABLE VALIDATE);

ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_CONTRACTOR_ID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCN_REGION_ID_FK 
  FOREIGN KEY (CCN_REGION_ID) 
  REFERENCES ADR.CCN_REGION (CCN_REGION_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_CONTRACTOR_REGION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_CONTRACTOR_REGION TO ADR_RW;

GRANT SELECT ON ADR.CCN_CONTRACTOR_REGION TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_CONTRACTOR_REGION TO VETCHOICE_RW;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_CONTRACTOR_REGION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_CONTRACTOR_REGION_H
(
  CCN_CONTRACTOR_REGION_H_ID  NUMBER(20)        NOT NULL,
  CCN_CONTRACTOR_REGION_ID    NUMBER(20)        NOT NULL,
  CCN_CONTRACTOR_ID           NUMBER(20)        NOT NULL,
  CCN_REGION_ID               NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  HISTORY_CREATED_DATE        DATE              NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_CONTRACTOR_REGION_H IS 'History table will be used to hold history for CCN_CONTRACTOR_REGION.';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION_H.HISTORY_CREATED_DATE IS 'the date this history record is created';

COMMENT ON COLUMN ADR.CCN_CONTRACTOR_REGION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';


CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_REGION_H_PK_I ON ADR.CCN_CONTRACTOR_REGION_H
(CCN_CONTRACTOR_REGION_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_CONTRACTOR_REGION_H FOR ADR.CCN_CONTRACTOR_REGION_H;


ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H ADD (
  CONSTRAINT CCN_CONTRACTOR_REGION_H_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_REGION_H_ID)
  USING INDEX ADR.CCN_CONTRACTOR_REGION_H_PK_I
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_CONTRACTOR_REGION_H TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_CONTRACTOR_REGION_H TO ADR_RW;

GRANT SELECT ON ADR.CCN_CONTRACTOR_REGION_H TO VETCHOICE_R;
ALTER TABLE ADR.CCN_FILETRANSFER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_FILETRANSFER CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_FILETRANSFER
(
  CCN_FILETRANSFER_ID    NUMBER(20)             NOT NULL,
  TRANSMISSION_TYPE_ID   NUMBER(20)             NOT NULL,
  VCADMISTATUS_TYPE_ID   NUMBER(20)             NOT NULL,
  DOC_REF                VARCHAR2(50 BYTE),
  FILE_NAME              VARCHAR2(60 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_FILETRANSFER IS 'Table to hold CCN file name and transfer status';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.CCN_FILETRANSFER_ID IS 'The primary key, generated by the database system in numeric, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.TRANSMISSION_TYPE_ID IS 'TRANSMISSION_TYPE_ID referenced by TRANSMISSION_TYPE';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.VCADMISTATUS_TYPE_ID IS 'VCADMISTATUS_TYPE_ID referenced by VCADMISTATUS_TYPE';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.DOC_REF IS 'is document reference being used by the file transfered';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.FILE_NAME IS 'is the file name';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CCNFITRANSFER_TRNSTYPEID_FK_I ON ADR.CCN_FILETRANSFER
(TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCNFITRANSF_VCADSTPIDD_FK_I ON ADR.CCN_FILETRANSFER
(VCADMISTATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CCN_FILETRANS_ID_PK_I ON ADR.CCN_FILETRANSFER
(CCN_FILETRANSFER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CCNFILETRANS_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_FILETRANSFER
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_FILETRANSFER_H (CCN_FILETRANSFER_H_ID,
                                      CCN_FILETRANSFER_ID,
                                      TRANSMISSION_TYPE_ID,
                                      VCADMISTATUS_TYPE_ID,
                                      DOC_REF,
                                      FILE_NAME,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_FILETRANSFER_H_S.NEXTVAL,
                   :old.CCN_FILETRANSFER_ID,
                   :old.TRANSMISSION_TYPE_ID,
                   :old.VCADMISTATUS_TYPE_ID,
                   :old.DOC_REF,
                   :old.FILE_NAME,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_FILETRANSFER_H (CCN_FILETRANSFER_H_ID,
                                      CCN_FILETRANSFER_ID,
                                      TRANSMISSION_TYPE_ID,
                                      VCADMISTATUS_TYPE_ID,
                                      DOC_REF,
                                      FILE_NAME,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_FILETRANSFER_H_S.NEXTVAL,
                   :new.CCN_FILETRANSFER_ID,
                   :new.TRANSMISSION_TYPE_ID,
                   :new.VCADMISTATUS_TYPE_ID,
                   :new.DOC_REF,
                   :new.FILE_NAME,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   END IF;
END CCNFILETRANS_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CCN_FILETRANSFER FOR ADR.CCN_FILETRANSFER;


ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCN_FILETRANS_ID_PK
  PRIMARY KEY
  (CCN_FILETRANSFER_ID)
  USING INDEX ADR.CCN_FILETRANS_ID_PK_I
  ENABLE VALIDATE);

ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCNFITRANSFER_TRNSTYPEID_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNFITRANSF_VCADSTPIDD_FK_I 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_FILETRANSFER TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_FILETRANSFER TO ADR_RW;

GRANT SELECT ON ADR.CCN_FILETRANSFER TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_FILETRANSFER TO VETCHOICE_RW;
ALTER TABLE ADR.CCN_FILETRANSFER_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_FILETRANSFER_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_FILETRANSFER_H
(
  CCN_FILETRANSFER_H_ID  NUMBER(20)             NOT NULL,
  CCN_FILETRANSFER_ID    NUMBER(20),
  TRANSMISSION_TYPE_ID   NUMBER(20),
  VCADMISTATUS_TYPE_ID   NUMBER(20),
  DOC_REF                VARCHAR2(50 BYTE),
  FILE_NAME              VARCHAR2(60 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE    DATE,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  RECORD_MODIFIED_COUNT  NUMBER(10),
  HISTORY_CREATED_DATE   DATE                   NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_FILETRANSFER_H IS 'The Standard History table name _H .Table to hold CCN file name and transfer status';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.CCN_FILETRANSFER_H_ID IS 'The primary key, generated by the database system in numeric, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.CCN_FILETRANSFER_ID IS 'The primary key of table CCN_FILETRANSFER';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.TRANSMISSION_TYPE_ID IS 'TRANSMISSION_TYPE_ID referenced by TRANSMISSION_TYPE';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.VCADMISTATUS_TYPE_ID IS 'VCADMISTATUS_TYPE_ID referenced by VCADMISTATUS_TYPE';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.DOC_REF IS 'is document reference being used by the file transfered';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.FILE_NAME IS 'is the file name';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.HISTORY_CREATED_DATE IS 'history record created by TRANSACTION_TYPE_CODE.';

COMMENT ON COLUMN ADR.CCN_FILETRANSFER_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';


CREATE UNIQUE INDEX ADR.CCNFILETRANSHID_PK_I ON ADR.CCN_FILETRANSFER_H
(CCN_FILETRANSFER_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_FILETRANSFER_H FOR ADR.CCN_FILETRANSFER_H;


ALTER TABLE ADR.CCN_FILETRANSFER_H ADD (
  CONSTRAINT CCNFILETRANSHID_PK
  PRIMARY KEY
  (CCN_FILETRANSFER_H_ID)
  USING INDEX ADR.CCNFILETRANSHID_PK_I
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_FILETRANSFER_H TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_FILETRANSFER_H TO ADR_RW;

GRANT SELECT ON ADR.CCN_FILETRANSFER_H TO VETCHOICE_R;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_RECEIVED_SERVICE_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_RECEIVED_SERVICE_LOG
(
  CCN_RECEIVED_SERVICE_LOG_ID  NUMBER(20)       NOT NULL,
  CCN_SERVICE_LOG_ID           NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  CCN_CONTRACTOR_ID            NUMBER(20)       NOT NULL,
  VCADMINSTATUS_TYPE_ID        NUMBER(20),
  ACK_DATE                     DATE             NOT NULL,
  COMMENTS                     VARCHAR2(200 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION CCNRECVDSRVLOG_P1 VALUES LESS THAN (TO_DATE(' 2017-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_RECEIVED_SERVICE_LOG IS 'Log table will be used to log any message while receiving Veterans information from CCN Contractors. the bridge tables for realization of the many to many relationship between CCN_SERVICE_LOG and CCN_CONTRACTOR tables';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.CCN_RECEIVED_SERVICE_LOG_ID IS 'The FK to the CCN_RECEIVED_SERVICE_LOG table';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.CCN_CONTRACTOR_ID IS 'FK to the CCN_CONTRACTOR table';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.COMMENTS IS 'comments to the acknowledgement';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CCN_RECEIVED_SERVICE_LOG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CCNRSERVLOG_CONTRACTORID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(CCN_CONTRACTOR_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCNRSERVLOG_PERSONID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCNRSERVLOG_VCADMNSTATPID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(VCADMINSTATUS_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CCN_RECEIVED_SERVICE_LOG_PK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(CCN_RECEIVED_SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RCVDSRVLOG_SRVLOGID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(CCN_SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_RECEIVED_SERVICE_LOG FOR ADR.CCN_RECEIVED_SERVICE_LOG;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCN_RECEIVED_SERVICE_LOG_PK
  PRIMARY KEY
  (CCN_RECEIVED_SERVICE_LOG_ID)
  USING INDEX ADR.CCN_RECEIVED_SERVICE_LOG_PK_I
  ENABLE VALIDATE);

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_CONTRACTORID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNRSERVLOG_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNRSERVLOG_VCADMNSTATPID_FK 
  FOREIGN KEY (VCADMINSTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT RCVDSRVLOG_SRVLOGID_FK 
  FOREIGN KEY (CCN_SERVICE_LOG_ID) 
  REFERENCES ADR.CCN_SERVICE_LOG (CCN_SERVICE_LOG_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_RECEIVED_SERVICE_LOG TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.CCN_RECEIVED_SERVICE_LOG TO ADR_RW;

GRANT SELECT ON ADR.CCN_RECEIVED_SERVICE_LOG TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_RECEIVED_SERVICE_LOG TO VETCHOICE_RW;
ALTER TABLE ADR.CCN_REGION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_REGION CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_REGION
(
  CCN_REGION_ID          NUMBER(20)             NOT NULL,
  REGION_NAME            VARCHAR2(100 BYTE)     NOT NULL,
  ISACTIVE               VARCHAR2(1 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_REGION IS 'Table will be used to hold CCN Regions name';

COMMENT ON COLUMN ADR.CCN_REGION.CCN_REGION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CCN_REGION.REGION_NAME IS 'CCN Region Name';

COMMENT ON COLUMN ADR.CCN_REGION.ISACTIVE IS 'active flag of the record';

COMMENT ON COLUMN ADR.CCN_REGION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_REGION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_REGION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_REGION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CCN_REGION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CCN_REGION_PK_I ON ADR.CCN_REGION
(CCN_REGION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_REGION FOR ADR.CCN_REGION;


ALTER TABLE ADR.CCN_REGION ADD (
  CONSTRAINT CCN_REGION_PK
  PRIMARY KEY
  (CCN_REGION_ID)
  USING INDEX ADR.CCN_REGION_PK_I
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_REGION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_REGION TO ADR_RW;

GRANT SELECT ON ADR.CCN_REGION TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_REGION TO VETCHOICE_RW;
ALTER TABLE ADR.CCN_REGION_STATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_REGION_STATE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_REGION_STATE
(
  CCN_REGION_STATE_ID    NUMBER(20)             NOT NULL,
  STATE_NAME             VARCHAR2(100 BYTE)     NOT NULL,
  CCN_REGION_ID          NUMBER(20)             NOT NULL,
  ISACTIVE               VARCHAR2(1 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_REGION_STATE IS 'Table will be used to hold CCN Region and State relation';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.CCN_REGION_STATE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.STATE_NAME IS 'state name for CCN';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.CCN_REGION_ID IS 'FK (many to 1) to CCN_REGION table  ';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.ISACTIVE IS 'active flag; 1 for active; 0 or others for inactive';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_REGION_STATE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CCN_REGION_STATE_PK_I ON ADR.CCN_REGION_STATE
(CCN_REGION_STATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CCN_REGION_STATE_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_REGION_STATE
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_REGION_STATE_H (CCN_REGION_STATE_H_ID,
                                      CCN_REGION_STATE_ID,
                                      STATE_NAME,
                                      CCN_REGION_ID,
                                      ISACTIVE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_REGION_STATE_H_S.NEXTVAL,
                   :old.CCN_REGION_STATE_ID,
                   :old.STATE_NAME,
                   :old.CCN_REGION_ID,
                   :old.ISACTIVE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,

                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_REGION_STATE_H (CCN_REGION_STATE_H_ID,
                                      CCN_REGION_STATE_ID,
                                      STATE_NAME,
                                      CCN_REGION_ID,
                                      ISACTIVE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_REGION_STATE_H_S.NEXTVAL,
                   :new.CCN_REGION_STATE_ID,
                   :new.STATE_NAME,
                   :new.CCN_REGION_ID,
                   :new.ISACTIVE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,

                   SYSDATE,
                   mDML);
   END IF;
END CCN_REGION_STATE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CCN_REGION_STATE FOR ADR.CCN_REGION_STATE;


ALTER TABLE ADR.CCN_REGION_STATE ADD (
  CONSTRAINT CCN_REGION_STATE_PK
  PRIMARY KEY
  (CCN_REGION_STATE_ID)
  USING INDEX ADR.CCN_REGION_STATE_PK_I
  ENABLE VALIDATE);

ALTER TABLE ADR.CCN_REGION_STATE ADD (
  CONSTRAINT CCNRSNSTA_REGION_ID_FK 
  FOREIGN KEY (CCN_REGION_ID) 
  REFERENCES ADR.CCN_REGION (CCN_REGION_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_REGION_STATE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_REGION_STATE TO ADR_RW;

GRANT SELECT ON ADR.CCN_REGION_STATE TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_REGION_STATE TO VETCHOICE_RW;
DROP TABLE ADR.CCN_REGION_STATE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_REGION_STATE_H
(
  CCN_REGION_STATE_H_ID  NUMBER(20)             NOT NULL,
  CCN_REGION_STATE_ID    NUMBER(20),
  STATE_NAME             VARCHAR2(100 BYTE),
  CCN_REGION_ID          NUMBER(20),
  ISACTIVE               VARCHAR2(1 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE    DATE,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  RECORD_MODIFIED_COUNT  NUMBER(10),
  HISTORY_CREATED_DATE   DATE                   NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CCN_REGION_STATE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.CCN_REGION_STATE_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.CCN_REGION_STATE_ID IS 'The primary key of CCN_REGION_STATE';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.STATE_NAME IS 'state name for CCN';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.CCN_REGION_ID IS 'FK (many to 1) to CCN_REGION table  ';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.ISACTIVE IS 'active flag; 1 for active; 0 or others for inactive';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.HISTORY_CREATED_DATE IS 'created date of this history record';

COMMENT ON COLUMN ADR.CCN_REGION_STATE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';


CREATE UNIQUE INDEX ADR.CCN_REGION_STATE_H_PK ON ADR.CCN_REGION_STATE_H
(CCN_REGION_STATE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_REGION_STATE_H FOR ADR.CCN_REGION_STATE_H;


GRANT SELECT ON ADR.CCN_REGION_STATE_H TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_REGION_STATE_H TO ADR_RW;

GRANT SELECT ON ADR.CCN_REGION_STATE_H TO VETCHOICE_R;
ALTER TABLE ADR.CCN_SERVICE_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CCN_SERVICE_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.CCN_SERVICE_LOG
(
  CCN_SERVICE_LOG_ID       NUMBER(20)           NOT NULL,
  PERSON_ID                NUMBER(20)           NOT NULL,
  EDIPI                    NUMBER(10),
  FIRST_NAME               VARCHAR2(35 BYTE),
  LAST_NAME                VARCHAR2(35 BYTE),
  MID_NAME                 VARCHAR2(25 BYTE),
  SUFFIX                   VARCHAR2(10 BYTE),
  DATE_OF_BIRTH            DATE,
  DATE_OF_DEATH            VARCHAR2(14 BYTE),
  BIRTH_SEX                VARCHAR2(1 BYTE),
  MAILING_ADDRESS_H_ID     NUMBER(20)           NOT NULL,
  EMAIL                    VARCHAR2(128 BYTE),
  VCELIGIBILITY_H_ID       NUMBER(20)           NOT NULL,
  HPHONE_NUM               VARCHAR2(50 BYTE),
  CPHONE_NUM               VARCHAR2(50 BYTE),
  TPHONE_NUM               VARCHAR2(50 BYTE),
  NOT_ENR_ES               VARCHAR2(1 BYTE),
  NOT_ENR_ES_DATE          DATE,
  VISN_GEO                 NUMBER(2),
  TRANSMISSION_TYPE_ID     NUMBER(20),
  TRANSMISSION_STTYPE_ID   NUMBER(20),
  TRANSMISSION_DATE        DATE                 NOT NULL,
  COMMENTS                 VARCHAR2(200 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL,
  CCN_FILETRANSFER_ID      NUMBER(20),
  RESI_ADDRESS_H_ID        NUMBER(20),
  PREFERRED_FACILITY_H_ID  NUMBER(20),
  GEOCODE_STATION_H_ID     NUMBER(20)
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (TRANSMISSION_DATE)
INTERVAL( NUMTOYMINTERVAL(3,'MONTH'))
SUBPARTITION BY HASH (PERSON_ID)
SUBPARTITION TEMPLATE
  (SUBPARTITION SRLOG_SP1 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP2 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP3 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP4 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP5 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP6 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP7 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP8 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP9 TABLESPACE L_DATA_01,
   SUBPARTITION SRLOG_SP10 TABLESPACE L_DATA_01
  )
(  
  PARTITION SRLOG_TRANSID_P01 VALUES LESS THAN (TO_DATE(' 2017-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE L_DATA_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE L_DATA_01 ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    NOLOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    SUBPARTITIONS 10 STORE IN (L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01,L_DATA_01)
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.CCN_SERVICE_LOG.GEOCODE_STATION_H_ID IS 'FK referenced to geocode_station_h table.';


CREATE UNIQUE INDEX ADR.CCNSERVLOG_CCNSERVLOG_ID_PK ON ADR.CCN_SERVICE_LOG
(CCN_SERVICE_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCNSERVLOG_MAILADDRHID_FK_I ON ADR.CCN_SERVICE_LOG
(MAILING_ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCNSERVLOG_PERSION_ID_NU ON ADR.CCN_SERVICE_LOG
(PERSON_ID)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION SRLOG_TRANSID_P01
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE M_INDEX_01 ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    STORE IN (M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01)
)
NOPARALLEL;

CREATE INDEX ADR.CCNSERVLOG_TRANSMISSION_ID_NU ON ADR.CCN_SERVICE_LOG
(TRANSMISSION_DATE)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION SRLOG_TRANSID_P01
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE M_INDEX_01 ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    STORE IN (M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01)
)
NOPARALLEL;

CREATE INDEX ADR.CCNSERVLOG_TRNSMNTYPEID_NU_I ON ADR.CCN_SERVICE_LOG
(TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CCNSERVLOG_VCELIGBTY_H_ID_FK_I ON ADR.CCN_SERVICE_LOG
(VCELIGIBILITY_H_ID)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION SRLOG_TRANSID_P01
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE M_INDEX_01 ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    STORE IN (M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01)
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CCN_SERVICE_LOG FOR ADR.CCN_SERVICE_LOG;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_CCNSERVLOG_ID_PK
  PRIMARY KEY
  (CCN_SERVICE_LOG_ID)
  USING INDEX ADR.CCNSERVLOG_CCNSERVLOG_ID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_H_ID) 
  REFERENCES ADR.GEOCODE_STATION_H (GEOCODE_STATION_H_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_MAILADDRHID_FK 
  FOREIGN KEY (MAILING_ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_PFFACHID_FK 
  FOREIGN KEY (PREFERRED_FACILITY_H_ID) 
  REFERENCES ADR.PREFERRED_FACILITY_H (PREFERRED_FACILITY_H_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_RESADRHID_FK 
  FOREIGN KEY (RESI_ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_TRANSTASTTYPEID_FK 
  FOREIGN KEY (TRANSMISSION_STTYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_TRANSTYPE_ID_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSERVLOG_VCELIGBTY_H_ID_FK 
  FOREIGN KEY (VCELIGIBILITY_H_ID) 
  REFERENCES ADR.VCELIGIBILITY_H (VCELIGIBILITY_H_ID)
  ENABLE VALIDATE,
  CONSTRAINT CCNSVCLOG_CCNFLTR_ID_FK 
  FOREIGN KEY (CCN_FILETRANSFER_ID) 
  REFERENCES ADR.CCN_FILETRANSFER (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CCN_SERVICE_LOG TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.CCN_SERVICE_LOG TO ADR_RW;

GRANT SELECT ON ADR.CCN_SERVICE_LOG TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CCN_SERVICE_LOG TO VETCHOICE_RW;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CLOSE_APL_RSN_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CLOSE_APL_RSN_TYPE
(
  CLOSE_APL_RSN_TYPE_ID  NUMBER(20)             NOT NULL,
  CODE                   VARCHAR2(2 BYTE)       NOT NULL,
  NAME                   VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(100 BYTE),
  ISACTIVE               CHAR(1 BYTE)           NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CLOSE_APL_RSN_TYPE IS 'lookup table for Close Application reasons';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.CLOSE_APL_RSN_TYPE_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.CODE IS 'code value';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.NAME IS 'name of the code';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.DESCRIPTION IS 'DESCRIPTION';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CLOSE_APL_RSN_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CLOSE_APL_RSN_TYPE_CD_UK ON ADR.CLOSE_APL_RSN_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CLOSE_APL_RSN_TYPE_NM_UK ON ADR.CLOSE_APL_RSN_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CLOSE_APL_RSN_TYPE_PK ON ADR.CLOSE_APL_RSN_TYPE
(CLOSE_APL_RSN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CLOSE_APL_RSN_TYPE FOR ADR.CLOSE_APL_RSN_TYPE;


ALTER TABLE ADR.CLOSE_APL_RSN_TYPE ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_PK
  PRIMARY KEY
  (CLOSE_APL_RSN_TYPE_ID)
  USING INDEX ADR.CLOSE_APL_RSN_TYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CLOSE_APL_RSN_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CLOSE_APL_RSN_TYPE TO ADR_RW;
ALTER TABLE ADR.CL_VERIFICATION_METHOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CL_VERIFICATION_METHOD CASCADE CONSTRAINTS;

CREATE TABLE ADR.CL_VERIFICATION_METHOD
(
  CL_VERIFICATION_METHOD_ID    NUMBER(20)       NOT NULL,
  SPECIAL_FACTOR_ID            NUMBER(20)       NOT NULL,
  CL_VERIFICATION_METHOD_CODE  NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CL_VERIFICATION_METHOD IS 'This table contains CAMP LEJEUNE eligibility verification method information.  A CAMP LEJEUNE special factor can have 0 to many different verification types.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.CL_VERIFICATION_METHOD_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.SPECIAL_FACTOR_ID IS 'FK to ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.CL_VERIFICATION_METHOD_CODE IS 'FK to ADRREF.STD_CLVERIFICATIONTYPE.ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n';


CREATE UNIQUE INDEX ADR.CL_VERIFICATION_METHOD_PK ON ADR.CL_VERIFICATION_METHOD
(CL_VERIFICATION_METHOD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.SP_FAC_ID_CL_VER_METH_CD_UI ON ADR.CL_VERIFICATION_METHOD
(SPECIAL_FACTOR_ID, CL_VERIFICATION_METHOD_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CL_VERIF_METHOD_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.CL_VERIFICATION_METHOD
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into CL_VERIFICATION_METHOD_H
        (
         CL_VERIFICATION_METHOD_H_ID,
         CL_VERIFICATION_METHOD_ID,
         SPECIAL_FACTOR_ID,
         CL_VERIFICATION_METHOD_CODE,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        values
        (
        CL_VERIFICATION_METHOD_H_S.nextval,
         :old.CL_VERIFICATION_METHOD_ID,
         :old.SPECIAL_FACTOR_ID,
         :old.CL_VERIFICATION_METHOD_CODE,
         :old.RECORD_CREATED_BY,
         :old.RECORD_CREATED_DATE,
         :old.RECORD_MODIFIED_BY,
         :old.RECORD_MODIFIED_DATE,
         :old.RECORD_MODIFIED_COUNT,
         sysdate,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;
        insert into CL_VERIFICATION_METHOD_H
        (
         CL_VERIFICATION_METHOD_H_ID,
         CL_VERIFICATION_METHOD_ID,
         SPECIAL_FACTOR_ID,
         CL_VERIFICATION_METHOD_CODE,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        values
        (
        CL_VERIFICATION_METHOD_H_S.nextval,
         :new.CL_VERIFICATION_METHOD_ID,
         :new.SPECIAL_FACTOR_ID,
         :new.CL_VERIFICATION_METHOD_CODE,
         :new.RECORD_CREATED_BY,
         :new.RECORD_CREATED_DATE,
         :new.RECORD_MODIFIED_BY,
         :new.RECORD_MODIFIED_DATE,
         :new.RECORD_MODIFIED_COUNT,
         sysdate,
        mDML
        );
    end if;

end CL_VERIF_METHOD_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CL_VERIFICATION_METHOD FOR ADR.CL_VERIFICATION_METHOD;


ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_ID)
  USING INDEX ADR.CL_VERIFICATION_METHOD_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT SPC_FAC_CL_VER_METH_FK 
  FOREIGN KEY (SPECIAL_FACTOR_ID) 
  REFERENCES ADR.SPECIAL_FACTOR (SPECIAL_FACTOR_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT STD_CLVERIFTYP_CLVERMETH_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CL_VERIFICATION_METHOD TO ADR_RW;

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD TO ES_R;

GRANT INSERT, SELECT ON ADR.CL_VERIFICATION_METHOD TO ES_RW;
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CL_VERIFICATION_METHOD_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CL_VERIFICATION_METHOD_H
(
  CL_VERIFICATION_METHOD_ID    NUMBER(20),
  SPECIAL_FACTOR_ID            NUMBER(20),
  CL_VERIFICATION_METHOD_CODE  NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  CL_VERIFICATION_METHOD_H_ID  NUMBER(20)       NOT NULL,
  HISTORY_CREATED_DATE         DATE             NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CL_VERIFICATION_METHOD_H IS 'This table contains CAMP LEJEUNE eligibility verification method information.  A CAMP LEJEUNE special factor can have 0 to many different verification types.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.CL_VERIFICATION_METHOD_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.SPECIAL_FACTOR_ID IS 'FK to ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.CL_VERIFICATION_METHOD_CODE IS 'FK to ADRREF.STD_CLVERIFICATIONTYPE.ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n';


CREATE UNIQUE INDEX ADR.CL_VERIFICATION_METHOD_H_PK ON ADR.CL_VERIFICATION_METHOD_H
(CL_VERIFICATION_METHOD_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CL_VERIFICATION_METHOD_H FOR ADR.CL_VERIFICATION_METHOD_H;


ALTER TABLE ADR.CL_VERIFICATION_METHOD_H ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_H_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_H_ID)
  USING INDEX ADR.CL_VERIFICATION_METHOD_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ADR_R;

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ADR_RW;

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ES_RW;
ALTER TABLE ADR.COMBAT_EPISODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_EPISODE CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_EPISODE
(
  COMBAT_EPISODE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  OEFOIFSOURCE_ID        NUMBER(20),
  COMBATPAYTYPE_ID       NUMBER(20),
  COMBATLOCATIONTYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  COMBAT_FROM_DATE_TXT   VARCHAR2(14 BYTE),
  COMBAT_TO_DATE_TXT     VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_EPISODE IS 'This holds the OEF / OIF functionality (enhancement to the Military Service determination, in the case of Operation Iraqi Freedom) This is like an upgraded Military Service / Military Service Episode / Conflict Detail structure';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.COMBAT_EPISODE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.OEFOIFSOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.COMBATPAYTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.COMBATLOCATIONTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CMBTEPSD_PK ON ADR.COMBAT_EPISODE
(COMBAT_EPISODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_PRSN_FK_I ON ADR.COMBAT_EPISODE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDCBTPAY_FK_I ON ADR.COMBAT_EPISODE
(COMBATPAYTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDCMBTLOC_FK_I ON ADR.COMBAT_EPISODE
(COMBATLOCATIONTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDINST_FK_I ON ADR.COMBAT_EPISODE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDOEFSRC_FK_I ON ADR.COMBAT_EPISODE
(OEFOIFSOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.COMBAT_EPISODE_audir_trgr
after Update or Delete or Insert
ON ADR.COMBAT_EPISODE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into COMBAT_EPISODE_H
		(
  		COMBAT_EPISODE_H_ID,
 		COMBAT_EPISODE_ID,
 		PERSON_ID,
 		OEFOIFSOURCE_ID,
 		COMBATPAYTYPE_ID,
 		COMBATLOCATIONTYPE_ID,
 		STD_INSTITUTION_ID,
 		COMBAT_FROM_DATE_TXT,
 		COMBAT_TO_DATE_TXT,
 		RECORD_CREATED_BY,
 		RECORD_CREATED_DATE,
 		RECORD_MODIFIED_BY,
 		RECORD_MODIFIED_DATE,
 		RECORD_MODIFIED_COUNT,
 		TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_EPISODE_H_S.nextval,
 		:OLD.COMBAT_EPISODE_ID,
 		:OLD.PERSON_ID,
 		:OLD.OEFOIFSOURCE_ID,
 		:OLD.COMBATPAYTYPE_ID,
 		:OLD.COMBATLOCATIONTYPE_ID,
 		:OLD.STD_INSTITUTION_ID,
 		:OLD.COMBAT_FROM_DATE_TXT,
 		:OLD.COMBAT_TO_DATE_TXT,
 		:OLD.RECORD_CREATED_BY,
 		:OLD.RECORD_CREATED_DATE,
 		:OLD.RECORD_MODIFIED_BY,
 		:OLD.RECORD_MODIFIED_DATE,
 		:OLD.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into COMBAT_EPISODE_H
		(
  		COMBAT_EPISODE_H_ID,
 		COMBAT_EPISODE_ID,
 		PERSON_ID,
 		OEFOIFSOURCE_ID,
 		COMBATPAYTYPE_ID,
 		COMBATLOCATIONTYPE_ID,
 		STD_INSTITUTION_ID,
 		COMBAT_FROM_DATE_TXT,
 		COMBAT_TO_DATE_TXT,
 		RECORD_CREATED_BY,
 		RECORD_CREATED_DATE,
 		RECORD_MODIFIED_BY,
 		RECORD_MODIFIED_DATE,
 		RECORD_MODIFIED_COUNT,
 		TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_EPISODE_H_S.nextval,
 		:NEW.COMBAT_EPISODE_ID,
 		:NEW.PERSON_ID,
 		:NEW.OEFOIFSOURCE_ID,
 		:NEW.COMBATPAYTYPE_ID,
 		:NEW.COMBATLOCATIONTYPE_ID,
		:NEW.STD_INSTITUTION_ID,
 		:NEW.COMBAT_FROM_DATE_TXT,
 		:NEW.COMBAT_TO_DATE_TXT,
 		:NEW.RECORD_CREATED_BY,
 		:NEW.RECORD_CREATED_DATE,
 		:NEW.RECORD_MODIFIED_BY,
 		:NEW.RECORD_MODIFIED_DATE,
 		:NEW.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end COMBAT_EPISODE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM COMBAT_EPISODE FOR ADR.COMBAT_EPISODE;


ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PK
  PRIMARY KEY
  (COMBAT_EPISODE_ID)
  USING INDEX ADR.CMBTEPSD_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COMBAT_EPISODE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_EPISODE TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_EPISODE TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_EPISODE TO ES_RW;
ALTER TABLE ADR.COMBAT_EPISODE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_EPISODE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_EPISODE_H
(
  COMBAT_EPISODE_H_ID    NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  COMBAT_EPISODE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  OEFOIFSOURCE_ID        NUMBER(20),
  COMBATPAYTYPE_ID       NUMBER(20),
  COMBATLOCATIONTYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  COMBAT_FROM_DATE_TXT   VARCHAR2(14 BYTE),
  COMBAT_TO_DATE_TXT     VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_EPISODE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBAT_EPISODE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBAT_EPISODE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.OEFOIFSOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBATPAYTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBATLOCATIONTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CMBTEPSDH_PK ON ADR.COMBAT_EPISODE_H
(COMBAT_EPISODE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSDH_PRSNID_NU_I ON ADR.COMBAT_EPISODE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COMBAT_EPISODE_H FOR ADR.COMBAT_EPISODE_H;


ALTER TABLE ADR.COMBAT_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CMBTEPSDH_PK
  PRIMARY KEY
  (COMBAT_EPISODE_H_ID)
  USING INDEX ADR.CMBTEPSDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COMBAT_EPISODE_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_EPISODE_H TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_EPISODE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_EPISODE_H TO ES_RW;
ALTER TABLE ADR.COMBAT_PAY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_PAY CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_PAY
(
  COMBAT_PAY_ID              NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  COMBATSERVICESOURCE_ID     NUMBER(20),
  COMBATSERVICELOCATION_ID   NUMBER(20),
  COMBAT_PAY_START_DATE_TXT  VARCHAR2(14 BYTE),
  COMBAT_PAY_END_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  STD_COMBATPAYTYPE_ID       NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_PAY IS 'This holds the OEF / OIF functionality (enhancement to the Military Service determination, in the case of Operation Iraqi Freedom) This is like an upgraded Military Service / Military Service Episode / Conflict Detail structure';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBAT_PAY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBATSERVICESOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBATSERVICELOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBAT_PAY_START_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.COMBAT_PAY.STD_COMBATPAYTYPE_ID IS 'Identifier for existing	SDS Combat Pay Type';


CREATE UNIQUE INDEX ADR.CMBTPAY_PK ON ADR.COMBAT_PAY
(COMBAT_PAY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_PRSN_FK_I ON ADR.COMBAT_PAY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_STDCBTPTYP_FK_I ON ADR.COMBAT_PAY
(STD_COMBATPAYTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_STDCBTSLOC_FK_I ON ADR.COMBAT_PAY
(COMBATSERVICELOCATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_STDCBTSSRC_FK_I ON ADR.COMBAT_PAY
(COMBATSERVICESOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.COMBAT_PAY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.COMBAT_PAY
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into COMBAT_PAY_H
		(
		 COMBAT_PAY_H_ID
 		,COMBAT_PAY_ID
 		,PERSON_ID
 		,COMBATSERVICESOURCE_ID
 		,COMBATSERVICELOCATION_ID
        ,STD_COMBATPAYTYPE_ID
 		,COMBAT_PAY_START_DATE_TXT
 		,COMBAT_PAY_END_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_PAY_H_S.nextval,
		:old.COMBAT_PAY_ID,
		:old.PERSON_ID ,
 		:old.COMBATSERVICESOURCE_ID,
 		:old.COMBATSERVICELOCATION_ID,
        :old.STD_COMBATPAYTYPE_ID,
 		:old.COMBAT_PAY_START_DATE_TXT,
 		:old.COMBAT_PAY_END_DATE_TXT,
 		:old.RECORD_CREATED_BY,
 		:old.RECORD_CREATED_DATE,
 		:old.RECORD_MODIFIED_BY,
 		:old.RECORD_MODIFIED_DATE,
 		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into COMBAT_PAY_H
		(
		 COMBAT_PAY_H_ID
 		,COMBAT_PAY_ID
 		,PERSON_ID
 		,COMBATSERVICESOURCE_ID
 		,COMBATSERVICELOCATION_ID
        ,STD_COMBATPAYTYPE_ID
 		,COMBAT_PAY_START_DATE_TXT
 		,COMBAT_PAY_END_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_PAY_H_S.nextval,
		:new.COMBAT_PAY_ID,
		:new.PERSON_ID ,
 		:new.COMBATSERVICESOURCE_ID,
 		:new.COMBATSERVICELOCATION_ID,
        :new.STD_COMBATPAYTYPE_ID,
 		:new.COMBAT_PAY_START_DATE_TXT,
 		:new.COMBAT_PAY_END_DATE_TXT,
 		:new.RECORD_CREATED_BY,
 		:new.RECORD_CREATED_DATE,
 		:new.RECORD_MODIFIED_BY,
 		:new.RECORD_MODIFIED_DATE,
 		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end COMBAT_PAY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM COMBAT_PAY FOR ADR.COMBAT_PAY;


ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PK
  PRIMARY KEY
  (COMBAT_PAY_ID)
  USING INDEX ADR.CMBTPAY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COMBAT_PAY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_PAY TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_PAY TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_PAY TO ES_RW;
ALTER TABLE ADR.COMBAT_PAY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_PAY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_PAY_H
(
  COMBAT_PAY_H_ID            NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  COMBAT_PAY_ID              NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  COMBATSERVICESOURCE_ID     NUMBER(20),
  COMBATSERVICELOCATION_ID   NUMBER(20),
  COMBAT_PAY_START_DATE_TXT  VARCHAR2(14 BYTE),
  COMBAT_PAY_END_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  STD_COMBATPAYTYPE_ID       NUMBER(20),
  HISTORY_CREATED_DATE       DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_PAY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBAT_PAY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBAT_PAY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBATSERVICESOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBATSERVICELOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBAT_PAY_START_DATE_TXT IS 'DatewhentheBeneficiary startedreceivingCombat Pay';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.STD_COMBATPAYTYPE_ID IS 'Identifier for existing  SDS Combat Pay Type';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.CMBTPAYH_PK ON ADR.COMBAT_PAY_H
(COMBAT_PAY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAYH_PRSNID_NU_I ON ADR.COMBAT_PAY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COMBAT_PAY_H FOR ADR.COMBAT_PAY_H;


ALTER TABLE ADR.COMBAT_PAY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_023
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CMBTPAYH_PK
  PRIMARY KEY
  (COMBAT_PAY_H_ID)
  USING INDEX ADR.CMBTPAYH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COMBAT_PAY_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_PAY_H TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_PAY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_PAY_H TO ES_RW;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_AAC_ERROR_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_AAC_ERROR_DETAIL
(
  COM_AAC_ERROR_DETAIL_ID  NUMBER(20)           NOT NULL,
  COM_MAILING_ID           NUMBER(20)           NOT NULL,
  COM_AAC_ERROR_TYPE_ID    NUMBER(20)           NOT NULL,
  REJECT_REASON_TEXT       VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_AAC_ERROR_DETAIL IS 'Contains detail reasons as to why the letter was rejected at the HEC The COM_AAC_ERROR_DETAIL table contains error reasons from the AAC error file for a letter. COM_MAILING_ID Foreign key to the COM_MAILING table. COM_AAC_ERROR_TYPE_ID Foreign key to the COM_AAC_ERROR_TYPE table.';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.COM_AAC_ERROR_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.REJECT_REASON_TEXT IS 'Textfieldusedto documentthereasonfor theAACtorejectthe mailingrecord';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_AAC_ERROR_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMAACERR_COMMAIL_FK_I ON ADR.COM_AAC_ERROR_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMAACERR_PK ON ADR.COM_AAC_ERROR_DETAIL
(COM_AAC_ERROR_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMAACERR_STD_COMERRTYP_FK_I ON ADR.COM_AAC_ERROR_DETAIL
(COM_AAC_ERROR_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_AAC_ERROR_DETAIL FOR ADR.COM_AAC_ERROR_DETAIL;


ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_PK
  PRIMARY KEY
  (COM_AAC_ERROR_DETAIL_ID)
  USING INDEX ADR.COMAACERR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT COMAACERR_STD_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_AAC_ERROR_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_AAC_ERROR_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.COM_AAC_ERROR_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_AAC_ERROR_DETAIL TO ES_RW;
ALTER TABLE ADR.COM_CANCELED_REQUEST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_CANCELED_REQUEST CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_CANCELED_REQUEST
(
  COM_CANCELED_REQUEST_ID  NUMBER(20)           NOT NULL,
  COM_MAILING_ID           NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_CANCELED_REQUEST IS 'The table stores data about cancelled export letter entries.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.COM_CANCELED_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMCNLPR_COMMAIL_FK_I ON ADR.COM_CANCELED_REQUEST
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMCNLPR_PK ON ADR.COM_CANCELED_REQUEST
(COM_CANCELED_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_CANCELED_REQUEST FOR ADR.COM_CANCELED_REQUEST;


ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_PK
  PRIMARY KEY
  (COM_CANCELED_REQUEST_ID)
  USING INDEX ADR.COMCNLPR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_CANCELED_REQUEST TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_CANCELED_REQUEST TO ADR_RW;

GRANT SELECT ON ADR.COM_CANCELED_REQUEST TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_CANCELED_REQUEST TO ES_RW;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_EMAIL_TEMPLATE CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_EMAIL_TEMPLATE
(
  COM_EMAIL_TEMPLATE_ID       NUMBER(20)        NOT NULL,
  EMAIL_TEMPLATE_NAME         VARCHAR2(100 BYTE),
  EMAIL_TEMPLATE_DESCRIPTION  VARCHAR2(250 BYTE),
  EMAIL_TEMPLATE_TEXT         VARCHAR2(4000 BYTE),
  EMAIL_RECIPIENT_LIST        VARCHAR2(4000 BYTE),
  EMAIL_SUBJECT_TITLE         VARCHAR2(250 BYTE),
  SITE_EMAIL_PREFIX           VARCHAR2(40 BYTE),
  SITE_EMAIL_TYPE_CD          VARCHAR2(1 BYTE),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_EMAIL_TEMPLATE IS 'The table contains data contained in the template used for email bulletins.';

COMMENT ON COLUMN ADR.COM_EMAIL_TEMPLATE.COM_EMAIL_TEMPLATE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_EMAIL_TEMPLATE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_EMAIL_TEMPLATE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_EMAIL_TEMPLATE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_EMAIL_TEMPLATE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_EMAIL_TEMPLATE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.COMEMLTPL_PK ON ADR.COM_EMAIL_TEMPLATE
(COM_EMAIL_TEMPLATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_EMAIL_TEMPLATE FOR ADR.COM_EMAIL_TEMPLATE;


ALTER TABLE ADR.COM_EMAIL_TEMPLATE ADD (
  CONSTRAINT COMEMLTPL_PK
  PRIMARY KEY
  (COM_EMAIL_TEMPLATE_ID)
  USING INDEX ADR.COMEMLTPL_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_EMAIL_TEMPLATE TO ADRTMP;

GRANT SELECT ON ADR.COM_EMAIL_TEMPLATE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_EMAIL_TEMPLATE TO ADR_RW;

GRANT SELECT ON ADR.COM_EMAIL_TEMPLATE TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_EMAIL_TEMPLATE TO ES_RW;
ALTER TABLE ADR.COM_FORM_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_FORM_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_FORM_STATISTICS
(
  COM_FORM_STATISTICS_ID          NUMBER(20)    NOT NULL,
  COM_TRANSMISSION_LOG_ID         NUMBER(20)    NOT NULL,
  FORM_NUMBER                     VARCHAR2(100 BYTE),
  FORM_NUMBER_ERROR_REASON_TEXT   VARCHAR2(4000 BYTE),
  FORM_NUMBER_REJECT_REASON_TEXT  VARCHAR2(4000 BYTE),
  FORM_NUMBER_RECORD_COUNT        NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_FORM_STATISTICS IS 'Contains the statistics for letter mailings';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.COM_FORM_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.COM_TRANSMISSION_LOG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMFRMSTAT_COMTRANLOG_FK_I ON ADR.COM_FORM_STATISTICS
(COM_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMFRMSTAT_PK ON ADR.COM_FORM_STATISTICS
(COM_FORM_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_FORM_STATISTICS FOR ADR.COM_FORM_STATISTICS;


ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_PK
  PRIMARY KEY
  (COM_FORM_STATISTICS_ID)
  USING INDEX ADR.COMFRMSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_COMTRANLOG_FK 
  FOREIGN KEY (COM_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.COM_TRANSMISSION_LOG (COM_TRANSMISSION_LOG_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_FORM_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_FORM_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.COM_FORM_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_FORM_STATISTICS TO ES_RW;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_HEC_REJECT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_HEC_REJECT_DETAIL
(
  COM_HEC_REJECT_DETAIL_ID  NUMBER(20)          NOT NULL,
  COM_MAILING_ID            NUMBER(20)          NOT NULL,
  REJECT_REASON_TEXT        VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_HEC_REJECT_DETAIL IS 'Contains detail reasons as to why the letter was rejected at the HEC COM_MAILING_ID Foreign key to the COM_MAILING table.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.COM_HEC_REJECT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMRJCTDTL_COMMAIL_FK_I ON ADR.COM_HEC_REJECT_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMRJCTDTL_PK ON ADR.COM_HEC_REJECT_DETAIL
(COM_HEC_REJECT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_HEC_REJECT_DETAIL FOR ADR.COM_HEC_REJECT_DETAIL;


ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_PK
  PRIMARY KEY
  (COM_HEC_REJECT_DETAIL_ID)
  USING INDEX ADR.COMRJCTDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_HEC_REJECT_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ES_RW;
ALTER TABLE ADR.COM_LETTER_TEMPLATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_LETTER_TEMPLATE CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_LETTER_TEMPLATE
(
  COM_LETTER_TEMPLATE_ID        NUMBER(20)      NOT NULL,
  COM_LETTER_TYPE_ID            NUMBER(20)      NOT NULL,
  COM_LETTER_GENERATED_TYPE_ID  NUMBER(20),
  LETTER_TEMPLATE_NAME          VARCHAR2(100 BYTE),
  LETTER_TEMPLATE_DESCRIPTION   VARCHAR2(250 BYTE),
  LETTER_TEMPLATE_TEXT          VARCHAR2(4000 BYTE),
  LETTER_TEMPLATE_FORM_NUMBER   VARCHAR2(100 BYTE),
  LETTER_TEMPLATE_START_DATE    DATE,
  LETTER_TEMPLATE_END_DATE      DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_LETTER_TEMPLATE IS 'The table stores data for templates used to generate a particular type of letter. COM_LETTER_TYPE_ID Foreign key to the COM_LETTER_TYPE table. Indicates the general type of letter (for example, IVM, ENR). COM_LETTER_GENERATED_TYPE_ID Foreign key to the COM_LETTER_GENERATED_TYPE table. Indicates how a letter is generated (for example, manually or automatically).';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.COM_LETTER_TEMPLATE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.COM_LETTER_GENERATED_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.COMLTRTPL_PK ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMLTRTPL_STD_COMLTRGTYPE_FK_I ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_GENERATED_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMLTRTPL_STD_COMLTRTYPE_FK_I ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_LETTER_TEMPLATE FOR ADR.COM_LETTER_TEMPLATE;


ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_PK
  PRIMARY KEY
  (COM_LETTER_TEMPLATE_ID)
  USING INDEX ADR.COMLTRTPL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_STD_COMLTRGTYPE_FK 
  FOREIGN KEY (COM_LETTER_GENERATED_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERGENTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMLTRTPL_STD_COMLTRTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ADREXT;

GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_LETTER_TEMPLATE TO ADR_RW;

GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_LETTER_TEMPLATE TO ES_RW;
ALTER TABLE ADR.COM_MAILING
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_MAILING CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_MAILING
(
  COM_MAILING_ID                 NUMBER(20),
  WKF_CASE_ID                    NUMBER(20),
  PERSON_ID                      NUMBER(20),
  ADDRESS_TYPE_ID                NUMBER(20),
  COM_LETTER_TYPE_ID             NUMBER(20),
  COM_LETTER_TEMPLATE_ID         NUMBER(20),
  COM_AAC_REJECT_REASON_TYPE_ID  NUMBER(20),
  COM_MAILING_TRIGGER_TYPE_ID    NUMBER(20),
  AAC_EXTRACT_NUMBER             VARCHAR2(30 BYTE),
  OVERRIDE_IND                   VARCHAR2(1 BYTE),
  SSN                            VARCHAR2(20 BYTE),
  PREFIX                         VARCHAR2(12 BYTE),
  FIRST_NAME                     VARCHAR2(30 BYTE),
  MIDDLE_NAME                    VARCHAR2(30 BYTE),
  LAST_NAME                      VARCHAR2(40 BYTE),
  SUFFIX                         VARCHAR2(12 BYTE),
  TITLE                          VARCHAR2(50 BYTE),
  ADDRESS_LINE1                  VARCHAR2(100 BYTE),
  ADDRESS_LINE2                  VARCHAR2(100 BYTE),
  ADDRESS_LINE3                  VARCHAR2(100 BYTE),
  CITY                           VARCHAR2(60 BYTE),
  STATE_CODE                     VARCHAR2(50 BYTE),
  COUNTY_CODE                    VARCHAR2(50 BYTE),
  PROVINCE_CODE                  VARCHAR2(50 BYTE),
  ZIP_CODE                       VARCHAR2(20 BYTE),
  ZIP_PLUS_4                     VARCHAR2(10 BYTE),
  POSTAL_CODE                    VARCHAR2(20 BYTE),
  COUNTRY_CODE                   VARCHAR2(50 BYTE),
  MAILING_SENT_DATE              DATE,
  RECIPIENT_TYPE_TEXT            VARCHAR2(100 BYTE),
  REMAIL_STATUS_CODE             VARCHAR2(30 BYTE),
  REMARKS                        VARCHAR2(4000 BYTE),
  COM_MAILING_XML                VARCHAR2(4000 BYTE),
  BARCODE                        VARCHAR2(28 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  IVM_CASE_NUMBER                VARCHAR2(14 BYTE),
  CASE_CLOSURE_DATE              DATE,
  SENT_TO_IVM                    VARCHAR2(1 BYTE),
  IVM_COMMS_LOG_NUMBER           NUMBER(21),
  IPN_DATE                       DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_MAILING IS 'The COM_MAILING table acts a log to keep track of every mailing sent out from the ESR Communications subsystem. A mailing is defined as everything going into an envelope. WKF_CASE_ID Foreign key to the WKF_CASE table. PERSON_ID Foreign key to the PERSON table. Indicates the person with whom the letter is associated. ADDRESS_ID Foreign key to the ADDRESS table. Indicates the address used for the letter. COM_LETTER_TYPE_ID Foreign key to the COM_LETTER_TYPE table. Indicates the general type of letter (for example, IVM, ENR). COM_LETTER_TEMPLATE_ID Foreign key to the COM_LETTER_TEMPLATE table. COM_AAC_REJECT_REASON_TYPE_ID Foreign key to the COM_AAC_REJECT_REASON_TYPE table. Indicates the reasons a letter was rejected by AAC (for example, ZIP code not found in database, street address not found in ZIP code).';

COMMENT ON COLUMN ADR.COM_MAILING.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_MAILING.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COM_MAILING.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_MAILING.COM_LETTER_TEMPLATE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_MAILING.AAC_EXTRACT_NUMBER IS 'Batchidentifierusedby AAC.UsedinADRto associatethethemailing entrywithaparticular AACextractbatchjob.';

COMMENT ON COLUMN ADR.COM_MAILING.OVERRIDE_IND IS 'BR7458Enrollment OverrideFlagisdefined asaflagthatwhenset willinitiatethere- calculationofa veteransenrollment priority.Itisusedin thosecaseswherea veteranmayhavebeen placedinaRejected; StopNewEnrollmentsOR Rejected;Below EnrollmentGroup ThresholdEnrollment statuses.';

COMMENT ON COLUMN ADR.COM_MAILING.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.COM_MAILING.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.COM_MAILING.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.COM_MAILING.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.COM_MAILING.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.COM_MAILING.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.COM_MAILING.TITLE IS 'NameTitle';

COMMENT ON COLUMN ADR.COM_MAILING.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.COM_MAILING.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.COM_MAILING.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.COM_MAILING.CITY IS 'BR9Cityisdefinedas thenameofacityused foranaddress.';

COMMENT ON COLUMN ADR.COM_MAILING.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.COM_MAILING.COUNTY_CODE IS 'BR5293FIPSCountyCODE isdefinedasthelast3 charactersoftheFIPS state/countycode.The FIPScountycodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas suppliedBR73835-DIGITFIPSCODE isdefinedasthe2digit statecode+3digit countycode.This5digit FIPScodeisassociated withtheveterans permanentmailing address,Ifnopermanent mailingaddressis supplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied';

COMMENT ON COLUMN ADR.COM_MAILING.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COM_MAILING.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.COM_MAILING.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.COM_MAILING.POSTAL_CODE IS 'BR17Postalcodeis definedasthemailcode usedformaildeliveryto acountryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.COM_MAILING.COUNTRY_CODE IS 'BR15Countryisdefined astheuniqueidentifier assignedbythe International Organizationof Standardizationfora country.';

COMMENT ON COLUMN ADR.COM_MAILING.REMAIL_STATUS_CODE IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.COM_MAILING.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.COM_MAILING.COM_MAILING_XML IS 'Containsacopyofthe letterinXMLformat.';

COMMENT ON COLUMN ADR.COM_MAILING.BARCODE IS 'BARCODE-Storesaunique barcodegeneratedfor eachmailing';

COMMENT ON COLUMN ADR.COM_MAILING.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_MAILING.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_MAILING.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_MAILING.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_MAILING.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.COM_MAILING.IVM_COMMS_LOG_NUMBER IS 'External ID number from IVM';

COMMENT ON COLUMN ADR.COM_MAILING.IPN_DATE IS 'Initial Pending Notification Date.';


CREATE INDEX ADR.COMMAIL_BARCODE_NU_I ON ADR.COM_MAILING
(BARCODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_COMLETTYPE_FK_I ON ADR.COM_MAILING
(COM_LETTER_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_COMLTRTPL_FK_I ON ADR.COM_MAILING
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_FNAME_FB_I ON ADR.COM_MAILING
(UPPER("FIRST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE INDEX ADR.COMMAIL_LNAME_FB_I ON ADR.COM_MAILING
(UPPER("LAST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE INDEX ADR.COMMAIL_LSTNM_CITY_I ON ADR.COM_MAILING
(UPPER("LAST_NAME"), UPPER("CITY"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE INDEX ADR.COMMAIL_LSTNM_ZIP_I ON ADR.COM_MAILING
(UPPER("LAST_NAME"), UPPER("ZIP_CODE"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE INDEX ADR.COMMAIL_MNAME_FB_I ON ADR.COM_MAILING
(UPPER("MIDDLE_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE UNIQUE INDEX ADR.COMMAIL_PK ON ADR.COM_MAILING
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_PRSN_FK_I ON ADR.COM_MAILING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_SSN_NU_I ON ADR.COM_MAILING
(SSN)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_STD_ADDRTYPE_FK_I ON ADR.COM_MAILING
(ADDRESS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_STD_COMMLTRG_FK_I ON ADR.COM_MAILING
(COM_MAILING_TRIGGER_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_STD_COMRJCTRSN_FK_I ON ADR.COM_MAILING
(COM_AAC_REJECT_REASON_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMAIL_WKFCASE_FK_I ON ADR.COM_MAILING
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_MAILING FOR ADR.COM_MAILING;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT AVCON_1172521913_REMAI_000
  CHECK (REMAIL_STATUS_CODE IN ('REMAILED', 'RESEND'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067231
  CHECK ("COM_MAILING_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067232
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067233
  CHECK ("COM_LETTER_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067234
  CHECK ("COM_LETTER_TEMPLATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067235
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067236
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067237
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067238
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067239
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT COMMAIL_PK
  PRIMARY KEY
  (COM_MAILING_ID)
  USING INDEX ADR.COMMAIL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_COMLETTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMMAIL_COMLTRTPL_FK 
  FOREIGN KEY (COM_LETTER_TEMPLATE_ID) 
  REFERENCES ADR.COM_LETTER_TEMPLATE (COM_LETTER_TEMPLATE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT COMMAIL_STD_COMMLTRG_FK 
  FOREIGN KEY (COM_MAILING_TRIGGER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMMLTRIGGERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMMAIL_STD_COMRJCTRSN_FK 
  FOREIGN KEY (COM_AAC_REJECT_REASON_TYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMMAIL_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_MAILING TO ADREXT;

GRANT SELECT ON ADR.COM_MAILING TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_MAILING TO ADR_RW;

GRANT SELECT ON ADR.COM_MAILING TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_MAILING TO ES_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_MAILING TO VETCHOICE_RW;
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_MAILING_STATUS_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_MAILING_STATUS_DETAIL
(
  COM_MAILING_STATUS_DETAIL_ID  NUMBER(20),
  COM_MAILING_ID                NUMBER(20),
  COM_MAILING_STATUS_TYPE_ID    NUMBER(20),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_MAILING_STATUS_DETAIL IS 'The COM_MAILING_STATUS_DETAIL table stores status information for mailings sent out from the ESR subsystem. COM_MAILING_ID Foreign key to the COM_MAILING table. COM_MAILING_STATUS_TYPE_ID Foreign key to the COM_MAILING_STATUS_TYPE table.';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.COM_MAILING_STATUS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_MAILING_STATUS_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMMLSTAT_COMMAIL_FK_I ON ADR.COM_MAILING_STATUS_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMMLSTAT_PK ON ADR.COM_MAILING_STATUS_DETAIL
(COM_MAILING_STATUS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMMLSTAT_STD_COMAILSTAT_FK_I ON ADR.COM_MAILING_STATUS_DETAIL
(COM_MAILING_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_MAILING_STATUS_DETAIL FOR ADR.COM_MAILING_STATUS_DETAIL;


ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066319
  CHECK ("COM_MAILING_STATUS_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066320
  CHECK ("COM_MAILING_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066321
  CHECK ("COM_MAILING_STATUS_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066322
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066323
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066324
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066325
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066326
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT COMMLSTAT_PK
  PRIMARY KEY
  (COM_MAILING_STATUS_DETAIL_ID)
  USING INDEX ADR.COMMLSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT COMMLSTAT_STD_COMAILSTAT_FK 
  FOREIGN KEY (COM_MAILING_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMMAILINGSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ADREXT;

GRANT SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_MAILING_STATUS_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_MAILING_STATUS_DETAIL TO ES_RW;
ALTER TABLE ADR.COM_PRINT_CHECK
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_PRINT_CHECK CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_PRINT_CHECK
(
  COM_PRINT_CHECK_ID       NUMBER(20)           NOT NULL,
  COM_MAILING_ID           NUMBER(20),
  COM_PRINT_REQUEST_ID     NUMBER(20),
  COM_CANCELED_REQUEST_ID  NUMBER(20),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_PRINT_CHECK IS 'The table contains snapshots of what portion of the batch of letters that has been processed. Used to determine where to pick up since the last execution of the batch job. COM_MAILING_ID Foreign key to the COM_MAILING table. COM_PRINT_REQUEST_ID Foreign key to the COM_PRINT_REQUEST table. COM_CANCELED_REQUEST_ID Foreign key to the COM_CANCELED_REQUEST table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_PRINT_CHECK_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_PRINT_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_CANCELED_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMPRTCHK_COMCNLPR_FK_I ON ADR.COM_PRINT_CHECK
(COM_CANCELED_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMPRTCHK_COMMAIL_FK_I ON ADR.COM_PRINT_CHECK
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMPRTCHK_COMPRTREQ_FK_I ON ADR.COM_PRINT_CHECK
(COM_PRINT_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMPRTCHK_PK ON ADR.COM_PRINT_CHECK
(COM_PRINT_CHECK_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_PRINT_CHECK FOR ADR.COM_PRINT_CHECK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_PK
  PRIMARY KEY
  (COM_PRINT_CHECK_ID)
  USING INDEX ADR.COMPRTCHK_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMCNLPR_FK 
  FOREIGN KEY (COM_CANCELED_REQUEST_ID) 
  REFERENCES ADR.COM_CANCELED_REQUEST (COM_CANCELED_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMPRTCHK_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT COMPRTCHK_COMPRTREQ_FK 
  FOREIGN KEY (COM_PRINT_REQUEST_ID) 
  REFERENCES ADR.COM_PRINT_REQUEST (COM_PRINT_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_PRINT_CHECK TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_PRINT_CHECK TO ADR_RW;

GRANT SELECT ON ADR.COM_PRINT_CHECK TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_PRINT_CHECK TO ES_RW;
ALTER TABLE ADR.COM_PRINT_REQUEST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_PRINT_REQUEST CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_PRINT_REQUEST
(
  COM_PRINT_REQUEST_ID       NUMBER(20),
  COM_MAILING_ID             NUMBER(20),
  PRINT_REQUEST_UNIQUE_CODE  VARCHAR2(50 BYTE),
  TEMPLATE_FORM_NUMBER       VARCHAR2(100 BYTE),
  PRINT_REQUEST_XML          VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE        DATE,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE       DATE,
  RECORD_MODIFIED_COUNT      NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_PRINT_REQUEST IS 'This table contains the batch of letters that will be sent to AAC for printing COM_MAILING_ID Foreign key to the COM_MAILING table.';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.COM_PRINT_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.PRINT_REQUEST_UNIQUE_CODE IS 'Thisfieldwillbe stampedwitha combinationofthe PERSON_IDandthe LETTER_TEMPLATE_ID.A uniqueconstraintonthis fieldwillensurethat thesamepersondoesnot getaduplicateletteras partofonebatch.';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_PRINT_REQUEST.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMPRTREQ_COMMAIL_FK_I ON ADR.COM_PRINT_REQUEST
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMPRTREQ_PK ON ADR.COM_PRINT_REQUEST
(COM_PRINT_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMPRTREQ_U_PRINT_DUPLICATE_UK ON ADR.COM_PRINT_REQUEST
(PRINT_REQUEST_UNIQUE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_PRINT_REQUEST FOR ADR.COM_PRINT_REQUEST;


ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067224
  CHECK ("COM_PRINT_REQUEST_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067225
  CHECK ("COM_MAILING_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067226
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067227
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067228
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067229
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067230
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT COMPRTREQ_PK
  PRIMARY KEY
  (COM_PRINT_REQUEST_ID)
  USING INDEX ADR.COMPRTREQ_PK
  ENABLE VALIDATE,
  CONSTRAINT COMPRTREQ_U_PRINT_DUPLICATE_UK
  UNIQUE (PRINT_REQUEST_UNIQUE_CODE)
  USING INDEX ADR.COMPRTREQ_U_PRINT_DUPLICATE_UK
  ENABLE NOVALIDATE);

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_PRINT_REQUEST TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_PRINT_REQUEST TO ADR_RW;

GRANT SELECT ON ADR.COM_PRINT_REQUEST TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_PRINT_REQUEST TO ES_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_PRINT_REQUEST TO VETCHOICE_RW;
ALTER TABLE ADR.COM_TRANSMISSION_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_TRANSMISSION_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_TRANSMISSION_LOG
(
  COM_TRANSMISSION_LOG_ID       NUMBER(20)      NOT NULL,
  MESSAGE_TRANSMISSION_TYPE_ID  NUMBER(20),
  FILE_NAME                     VARCHAR2(100 BYTE),
  FILE_RECORD_COUNT             NUMBER(18),
  FILE_RECEIVED_DATE            DATE,
  TRANSMISSION_START_DATE       DATE,
  TRANSMISSION_END_DATE         DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_TRANSMISSION_LOG IS 'The COM_TRANSMISSION_LOG table records all inbound and outbound letters to and from the ESR communications subsystem. MESSAGE_TRANSMISSION_TYPE_ID Foreign key to the MESSAGE_TRANSMISSION_TYPE table.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.COM_TRANSMISSION_LOG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.COMTRANLOG_PK ON ADR.COM_TRANSMISSION_LOG
(COM_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMTRANS_STD_MSGTYP_FK_I ON ADR.COM_TRANSMISSION_LOG
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_TRANSMISSION_LOG FOR ADR.COM_TRANSMISSION_LOG;


ALTER TABLE ADR.COM_TRANSMISSION_LOG ADD (
  CONSTRAINT COMTRANLOG_PK
  PRIMARY KEY
  (COM_TRANSMISSION_LOG_ID)
  USING INDEX ADR.COMTRANLOG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_TRANSMISSION_LOG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_TRANSMISSION_LOG TO ADR_RW;

GRANT SELECT ON ADR.COM_TRANSMISSION_LOG TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_TRANSMISSION_LOG TO ES_RW;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFIDENTIAL_ADDR_CATGRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
(
  CONFIDENTIAL_ADDR_CATGRY_ID  NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  CONFIDENTIAL_ADDR_TYPE_ID    NUMBER(20)       NOT NULL,
  INACTIVE_FLAG                NUMBER(1)        DEFAULT 0                     NOT NULL,
  INACTIVE_DATE                DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFIDENTIAL_ADDR_CATGRY IS 'The CONFIDENTIAL_ADDR_CATGRY table stores the type of confidential address specified for a person. Addresses can be designated confidential by the associated person, and that person can indicate the address to be confidential for one or more of these categories: eligibility/enrollment, appointment/scheduling, copayments/veteran billing, medical records, and all others. Owner: PSD PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the address belongs. CONFIDENTIAL_ADDR_TYPE_ID Foreign key to the CONFIDENTIAL_ADDR_TYPE. Indicates which under what circumstances an address is considered confidential (for example, eligibility/enrollment, appointment/scheduling).';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.CONFIDENTIAL_ADDR_CATGRY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.CNFADDR_PK ON ADR.CONFIDENTIAL_ADDR_CATGRY
(CONFIDENTIAL_ADDR_CATGRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDR_PRSN_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDR_STDINST2_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDR_STD_CNFADDRCAT_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(CONFIDENTIAL_ADDR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CONF_ADDR_CATGRY_audir_trgr
after Update or Delete or Insert
ON ADR.CONFIDENTIAL_ADDR_CATGRY
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CONFIDENTIAL_ADDR_CATGRY_H
		(
		CONFIDENTIAL_ADDR_CATGRY_H_ID,
		CONFIDENTIAL_ADDR_CATGRY_ID  ,
		PERSON_ID                   ,
		CONFIDENTIAL_ADDR_TYPE_ID    ,
		INACTIVE_FLAG                ,
		INACTIVE_DATE                ,
		RECORD_CREATED_BY            ,
		RECORD_CREATED_DATE          ,
		RECORD_MODIFIED_BY           ,
		RECORD_MODIFIED_DATE         ,
		RECORD_MODIFIED_COUNT        ,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CONFIDENTIAL_ADDR_CATGRY_H_S.nextval,
		:old.CONFIDENTIAL_ADDR_CATGRY_ID  ,
		:old.PERSON_ID                   ,
		:old.CONFIDENTIAL_ADDR_TYPE_ID    ,
		:old.INACTIVE_FLAG                ,
		:old.INACTIVE_DATE                ,
		:old.RECORD_CREATED_BY            ,
		:old.RECORD_CREATED_DATE          ,
		:old.RECORD_MODIFIED_BY           ,
		:old.RECORD_MODIFIED_DATE         ,
		:old.RECORD_MODIFIED_COUNT        ,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CONFIDENTIAL_ADDR_CATGRY_H
		(
		CONFIDENTIAL_ADDR_CATGRY_H_ID,
		CONFIDENTIAL_ADDR_CATGRY_ID  ,
		PERSON_ID                   ,
		CONFIDENTIAL_ADDR_TYPE_ID    ,
		INACTIVE_FLAG                ,
		INACTIVE_DATE                ,
		RECORD_CREATED_BY            ,
		RECORD_CREATED_DATE          ,
		RECORD_MODIFIED_BY           ,
		RECORD_MODIFIED_DATE         ,
		RECORD_MODIFIED_COUNT        ,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CONFIDENTIAL_ADDR_CATGRY_H_S.nextval,
		:new.CONFIDENTIAL_ADDR_CATGRY_ID  ,
		:new.PERSON_ID                   ,
		:new.CONFIDENTIAL_ADDR_TYPE_ID    ,
		:new.INACTIVE_FLAG                ,
		:new.INACTIVE_DATE                ,
		:new.RECORD_CREATED_BY            ,
		:new.RECORD_CREATED_DATE          ,
		:new.RECORD_MODIFIED_BY           ,
		:new.RECORD_MODIFIED_DATE         ,
		:new.RECORD_MODIFIED_COUNT        ,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;
end CONF_ADDR_CATGRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CONFIDENTIAL_ADDR_CATGRY FOR ADR.CONFIDENTIAL_ADDR_CATGRY;


ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT AVCON_1172521913_INACT_046
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT CNFADDR_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_ID)
  USING INDEX ADR.CNFADDR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT CNFADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ADR_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ES_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.CONFIDENTIAL_ADDR_CATGRY TO PSIM_ADR_RW;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
(
  CONFIDENTIAL_ADDR_CATGRY_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  CONFIDENTIAL_ADDR_CATGRY_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CONFIDENTIAL_ADDR_TYPE_ID      NUMBER(20)     NOT NULL,
  INACTIVE_FLAG                  NUMBER(1)      DEFAULT 0                     NOT NULL,
  INACTIVE_DATE                  DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  RECORD_MODIFIED_SITE_ID        NUMBER(20),
  RECORD_MODIFIED_SRC_NAME       VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.CONFIDENTIAL_ADDR_CATGRY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.CONFIDENTIAL_ADDR_CATGRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.CNFADDRH_PK ON ADR.CONFIDENTIAL_ADDR_CATGRY_H
(CONFIDENTIAL_ADDR_CATGRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDRH_PRSNID_NU_I ON ADR.CONFIDENTIAL_ADDR_CATGRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CONFIDENTIAL_ADDR_CATGRY_H FOR ADR.CONFIDENTIAL_ADDR_CATGRY_H;


ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_010
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CNFADDRH_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_H_ID)
  USING INDEX ADR.CNFADDRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ADR_R;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ADR_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ES_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO PSIM_ADR_R;
ALTER TABLE ADR.CONFLICT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFLICT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFLICT_DETAIL
(
  CONFLICT_DETAIL_ID      NUMBER(20)            NOT NULL,
  MILITARY_SERVICE_ID     NUMBER(20)            NOT NULL,
  STD_COMBATLOCATION_ID   NUMBER(20),
  CONFLICT_FROM_DATE_TXT  VARCHAR2(14 BYTE),
  CONFLICT_TO_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFLICT_DETAIL IS 'The table stores information about conflicts the person has been a part of during their military service. MILITARY_SERVICE_ID Foreign key to the MILITARY_SERVICE table. CONFLICT_LOCATION_TYPE_ID Foreign key to the CONFLICT_LOCATION_TYPE table. Indicates the particular conflict in which a person participated as part of his or her military service (for example, Korea, Vietnam). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.CONFLICT_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.MILITARY_SERVICE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.CONFLICT_FROM_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.CONFLICT_TO_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CONFLDTL_MILSRVC_FK_I ON ADR.CONFLICT_DETAIL
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CONFLDTL_PK ON ADR.CONFLICT_DETAIL
(CONFLICT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CONFLDTL_STD_CMBTLOCN_FK_I ON ADR.CONFLICT_DETAIL
(STD_COMBATLOCATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CONFLICT_DETAIL_audir_trgr
after Update or Delete or Insert
ON ADR.CONFLICT_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CONFLICT_DETAIL_H
		(
		CONFLICT_DETAIL_H_ID ,
		CONFLICT_DETAIL_ID   ,
		MILITARY_SERVICE_ID  ,
		STD_COMBATLOCATION_ID,
		CONFLICT_FROM_DATE_TXT  ,
		CONFLICT_TO_DATE_TXT    ,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		CONFLICT_DETAIL_H_S.nextval,
		:old.CONFLICT_DETAIL_ID,
		:old.MILITARY_SERVICE_ID,
		:old.STD_COMBATLOCATION_ID,
		:old.CONFLICT_FROM_DATE_TXT,
		:old.CONFLICT_TO_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CONFLICT_DETAIL_H
		(
		CONFLICT_DETAIL_H_ID ,
		CONFLICT_DETAIL_ID   ,
		MILITARY_SERVICE_ID  ,
		STD_COMBATLOCATION_ID,
		CONFLICT_FROM_DATE_TXT  ,
		CONFLICT_TO_DATE_TXT    ,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		CONFLICT_DETAIL_H_S.nextval,
		:new.CONFLICT_DETAIL_ID,
		:new.MILITARY_SERVICE_ID,
		:new.STD_COMBATLOCATION_ID,
		:new.CONFLICT_FROM_DATE_TXT,
		:new.CONFLICT_TO_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  CONFLICT_DETAIL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CONFLICT_DETAIL FOR ADR.CONFLICT_DETAIL;


ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_ID)
  USING INDEX ADR.CONFLDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CONFLICT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CONFLICT_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.CONFLICT_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFLICT_DETAIL TO ES_RW;
ALTER TABLE ADR.CONFLICT_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFLICT_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFLICT_DETAIL_H
(
  CONFLICT_DETAIL_H_ID    NUMBER(20),
  TRANSACTION_TYPE_CODE   VARCHAR2(1 BYTE),
  CONFLICT_DETAIL_ID      NUMBER(20),
  MILITARY_SERVICE_ID     NUMBER(20),
  STD_COMBATLOCATION_ID   NUMBER(20),
  CONFLICT_FROM_DATE_TXT  VARCHAR2(14 BYTE),
  CONFLICT_TO_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE     DATE,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE    DATE,
  RECORD_MODIFIED_COUNT   NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFLICT_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.MILITARY_SERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_FROM_DATE_TXT IS 'Dateonwhichthe personsparticipationin aparticularconflict began.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_TO_DATE_TXT IS 'Dateonwhichthe personsparticipationin aparticularconflict ended.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CONFLDTLH_MILSRVC_NU_I ON ADR.CONFLICT_DETAIL_H
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CONFLDTLH_PK ON ADR.CONFLICT_DETAIL_H
(CONFLICT_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CONFLICT_DETAIL_H FOR ADR.CONFLICT_DETAIL_H;


ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_029
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066506
  CHECK ("CONFLICT_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066507
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066508
  CHECK ("CONFLICT_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066509
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066510
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066511
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066512
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066513
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066514
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT CONFLDTLH_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_H_ID)
  USING INDEX ADR.CONFLDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFLICT_DETAIL_H TO ES_RW;
ALTER TABLE ADR.CORRESPONDENCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CORRESPONDENCE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CORRESPONDENCE
(
  CORRESPONDENCE_ID              NUMBER(20),
  CORRESPONDENCE_TYPE_ID         NUMBER(20)     NOT NULL,
  CORRESPONDENCE_STATUS_ID       NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CORRESPONDENCE_STATUS_DATE     DATE,
  CORRESPONDENCE_EFFECTIVE_DATE  DATE,
  CORRESPONDENCE_DOCUMENT_ID     NUMBER(20),
  COM_LETTER_TEMPLATE_ID         NUMBER(20),
  EMAIL_TEMPLATE_ID              NUMBER(20),
  EMAIL_H_ID                     NUMBER(20),
  ADDRESS_H_ID                   NUMBER(20),
  ERROR_DESCRIPTION              VARCHAR2(1000 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CORRESPONDENCE IS 'This table contains correspondence details for VHA initiated communications to persons via mail, email or phone.';

COMMENT ON COLUMN ADR.CORRESPONDENCE.CORRESPONDENCE_ID IS 'PRIMARY KEY';

COMMENT ON COLUMN ADR.CORRESPONDENCE.CORRESPONDENCE_TYPE_ID IS 'FK to ADR.CORRESPONDENCE_TYPE. CORRESPONDENCE_TYPE_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.CORRESPONDENCE_STATUS_ID IS 'FK to ADR.CORRESPONDENCE_STATUS. CORRESPONDENCE_STATUS_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.PERSON_ID IS 'FK to ADR.PERSON.PERSON_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.CORRESPONDENCE_STATUS_DATE IS 'THE DATE THE STATUS CHANGE WAS RECIEVED ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.CORRESPONDENCE_EFFECTIVE_DATE IS 'THE DATE THE CORRESPONDENCE IS RETROACTIVELY EFFECTIVE ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.CORRESPONDENCE_DOCUMENT_ID IS 'FK to ADR.CORRESPONDENCE_DOCUMENT. CORRESPONDENCE_DOCUMENT_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.COM_LETTER_TEMPLATE_ID IS 'FK to ADR.COM_LETTER_TEMPLATE.COM_LETTER_TEMPLATE_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.EMAIL_TEMPLATE_ID IS 'FK to ADR.EMAIL_TEMPLATE.EMAIL_TEMPLATE_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.EMAIL_H_ID IS 'FK to ADR.EMAIL_H.EMAIL_H_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.ADDRESS_H_ID IS 'FK to ADR.ADDRESS_H.ADDRESS_H_ID ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.ERROR_DESCRIPTION IS 'REASON CORRESPONDENCE WAS NOT SUCCESSFUL ';

COMMENT ON COLUMN ADR.CORRESPONDENCE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CORRESPONDENCE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CORRESPONDENCE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ADDRESS_H_ID_FK_I ON ADR.CORRESPONDENCE
(ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COM_LETTER_TEMPLATE_ID_FK_I ON ADR.CORRESPONDENCE
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CORRESPONDENCE_DOC_ID_FK_I ON ADR.CORRESPONDENCE
(CORRESPONDENCE_DOCUMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_PK ON ADR.CORRESPONDENCE
(CORRESPONDENCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CORRESPONDENCE_STATUS_ID_FK_I ON ADR.CORRESPONDENCE
(CORRESPONDENCE_STATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CORRESPONDENCE_TYPE_ID_FK_I ON ADR.CORRESPONDENCE
(CORRESPONDENCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_H_ID_FK_I ON ADR.CORRESPONDENCE
(EMAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_TEMPLATE_ID_FK_I ON ADR.CORRESPONDENCE
(EMAIL_TEMPLATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PERSON_ID_FK_I ON ADR.CORRESPONDENCE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CORRESPONDENCE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.CORRESPONDENCE
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO CORRESPONDENCE_H
        (CORRESPONDENCE_H_ID,
         CORRESPONDENCE_ID,
         CORRESPONDENCE_TYPE_ID,
         CORRESPONDENCE_STATUS_ID,
         PERSON_ID ,
         CORRESPONDENCE_STATUS_DATE,
         CORRESPONDENCE_EFFECTIVE_DATE,
         CORRESPONDENCE_DOCUMENT_ID ,
         COM_LETTER_TEMPLATE_ID,
         EMAIL_TEMPLATE_ID ,
         EMAIL_H_ID  ,
         ADDRESS_H_ID,
         ERROR_DESCRIPTION ,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY ,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CORRESPONDENCE_H_S.NEXTVAL,
         :OLD.CORRESPONDENCE_ID,
         :OLD.CORRESPONDENCE_TYPE_ID,
         :OLD.CORRESPONDENCE_STATUS_ID,
         :OLD.PERSON_ID ,
         :OLD.CORRESPONDENCE_STATUS_DATE,
         :OLD.CORRESPONDENCE_EFFECTIVE_DATE,
         :OLD.CORRESPONDENCE_DOCUMENT_ID ,
         :OLD.COM_LETTER_TEMPLATE_ID,
         :OLD.EMAIL_TEMPLATE_ID ,
         :OLD.EMAIL_H_ID  ,
         :OLD.ADDRESS_H_ID,
         :OLD.ERROR_DESCRIPTION ,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_count,
         :OLD.Record_modified_date,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO CORRESPONDENCE_H
        (CORRESPONDENCE_H_ID,
         CORRESPONDENCE_ID,
         CORRESPONDENCE_TYPE_ID,
         CORRESPONDENCE_STATUS_ID,
         PERSON_ID ,
         CORRESPONDENCE_STATUS_DATE,
         CORRESPONDENCE_EFFECTIVE_DATE,
         CORRESPONDENCE_DOCUMENT_ID ,
         COM_LETTER_TEMPLATE_ID,
         EMAIL_TEMPLATE_ID ,
         EMAIL_H_ID  ,
         ADDRESS_H_ID,
         ERROR_DESCRIPTION ,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY ,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CORRESPONDENCE_H_S.NEXTVAL,
         :NEW.CORRESPONDENCE_ID,
         :NEW.CORRESPONDENCE_TYPE_ID,
         :NEW.CORRESPONDENCE_STATUS_ID,
         :NEW.PERSON_ID ,
         :NEW.CORRESPONDENCE_STATUS_DATE,
         :NEW.CORRESPONDENCE_EFFECTIVE_DATE,
         :NEW.CORRESPONDENCE_DOCUMENT_ID ,
         :NEW.COM_LETTER_TEMPLATE_ID,
         :NEW.EMAIL_TEMPLATE_ID ,
         :NEW.EMAIL_H_ID  ,
         :NEW.ADDRESS_H_ID,
         :NEW.ERROR_DESCRIPTION ,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_count,
         :NEW.Record_modified_date,
         SYSDATE,
         mDML
        );

    END IF;

  END CORRESPONDENCE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CORRESPONDENCE FOR ADR.CORRESPONDENCE;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_PK
  PRIMARY KEY
  (CORRESPONDENCE_ID)
  USING INDEX ADR.CORRESPONDENCE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_ADDR_H_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT CORRESPONDENCE_COM_LTR_TEMP_FK 
  FOREIGN KEY (COM_LETTER_TEMPLATE_ID) 
  REFERENCES ADR.COM_LETTER_TEMPLATE (COM_LETTER_TEMPLATE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CORRESPONDENCE_EMAIL_H_FK 
  FOREIGN KEY (EMAIL_H_ID) 
  REFERENCES ADR.EMAIL_H (EMAIL_H_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT CORRESPONDENCE_EMAIL_TEMP_FK 
  FOREIGN KEY (EMAIL_TEMPLATE_ID) 
  REFERENCES ADR.COM_EMAIL_TEMPLATE (COM_EMAIL_TEMPLATE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CORRESPONDENCE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT CORRPNDNC_CORRPNDNC_DOC_FK 
  FOREIGN KEY (CORRESPONDENCE_DOCUMENT_ID) 
  REFERENCES ADR.CORRESPONDENCE_DOCUMENT (CORRESPONDENCE_DOCUMENT_ID)
  ENABLE VALIDATE,
  CONSTRAINT CORRPNDNC_CORRPNDNC_STATUS_FK 
  FOREIGN KEY (CORRESPONDENCE_STATUS_ID) 
  REFERENCES ADR.CORRESPONDENCE_STATUS (CORRESPONDENCE_STATUS_ID)
  ENABLE VALIDATE,
  CONSTRAINT CORRPNDNC_CORRPNDNC_TYPE_FK 
  FOREIGN KEY (CORRESPONDENCE_TYPE_ID) 
  REFERENCES ADR.CORRESPONDENCE_TYPE (CORRESPONDENCE_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CORRESPONDENCE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE TO ADR_RW;

GRANT SELECT ON ADR.CORRESPONDENCE TO ES_R;

GRANT INSERT, SELECT ON ADR.CORRESPONDENCE TO ES_RW;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CORRESPONDENCE_DOCUMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.CORRESPONDENCE_DOCUMENT
(
  CORRESPONDENCE_DOCUMENT_ID  NUMBER(20)        NOT NULL,
  DOCUMENT_FILENAME           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  DOCUMENT                    CLOB
)
LOB (DOCUMENT) STORE AS SECUREFILE (
  TABLESPACE  L_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  COMPRESS    MEDIUM
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CORRESPONDENCE_DOCUMENT IS 'This table contains documents received that are related to the correspondence communication.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.CORRESPONDENCE_DOCUMENT_ID IS 'PRIMARY KEY.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.DOCUMENT_FILENAME IS 'NAME OF THE FILE';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_DOCUMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CORRESPONDENCE_DOCUMENT_PK ON ADR.CORRESPONDENCE_DOCUMENT
(CORRESPONDENCE_DOCUMENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CORRESPONDENCE_DOCUMENT FOR ADR.CORRESPONDENCE_DOCUMENT;


ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT ADD (
  CONSTRAINT CORRESPONDENCE_DOCUMENT_PK
  PRIMARY KEY
  (CORRESPONDENCE_DOCUMENT_ID)
  USING INDEX ADR.CORRESPONDENCE_DOCUMENT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CORRESPONDENCE_DOCUMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_DOCUMENT TO ADR_RW;

GRANT SELECT ON ADR.CORRESPONDENCE_DOCUMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_DOCUMENT TO ES_RW;
ALTER TABLE ADR.CORRESPONDENCE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CORRESPONDENCE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CORRESPONDENCE_H
(
  CORRESPONDENCE_H_ID            NUMBER(20)     NOT NULL,
  CORRESPONDENCE_ID              NUMBER(20)     NOT NULL,
  CORRESPONDENCE_TYPE_ID         NUMBER(20),
  CORRESPONDENCE_STATUS_ID       NUMBER(20),
  PERSON_ID                      NUMBER(20),
  CORRESPONDENCE_STATUS_DATE     DATE,
  CORRESPONDENCE_EFFECTIVE_DATE  DATE,
  CORRESPONDENCE_DOCUMENT_ID     NUMBER(20),
  COM_LETTER_TEMPLATE_ID         NUMBER(20),
  EMAIL_TEMPLATE_ID              NUMBER(20),
  EMAIL_H_ID                     NUMBER(20),
  ADDRESS_H_ID                   NUMBER(20),
  ERROR_DESCRIPTION              VARCHAR2(1000 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  HISTORY_CREATED_DATE           DATE           NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CORRESPONDENCE_H IS 'The Standard History table name appends _H to the end of the table name and adds three columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row and a History_Created_Date.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_H_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_ID IS 'Primary Key of base table';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_TYPE_ID IS 'ADR.Correspondence_Type ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_STATUS_ID IS 'ADR.Correspondence_STATUS ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.PERSON_ID IS 'ADR.PERSON ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_STATUS_DATE IS 'ADR.CORRESPONDENCE STATUS Date';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_EFFECTIVE_DATE IS 'ADR.CORRESPONDENCE EFFECTIVE Date';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.CORRESPONDENCE_DOCUMENT_ID IS 'ADR.CORRESPONDENCE_DOCUMENT ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.EMAIL_TEMPLATE_ID IS 'ADR.EMAIL.TEMPLATE ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.EMAIL_H_ID IS 'ADR.EMAIL_H ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.ADDRESS_H_ID IS ' ADDRESS_H ID';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.ERROR_DESCRIPTION IS 'ADR.CORRESPONDENCE ERROR_DESCRIPTION';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_H.HISTORY_CREATED_DATE IS 'Date History Record was Created';


CREATE UNIQUE INDEX ADR.CORRESPONDENCE_H_PK ON ADR.CORRESPONDENCE_H
(CORRESPONDENCE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CORRESPONDENCE_H FOR ADR.CORRESPONDENCE_H;


ALTER TABLE ADR.CORRESPONDENCE_H ADD (
  CONSTRAINT CORRESPONDENCE_H_PK
  PRIMARY KEY
  (CORRESPONDENCE_H_ID)
  USING INDEX ADR.CORRESPONDENCE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CORRESPONDENCE_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_H TO ADR_RW;

GRANT SELECT ON ADR.CORRESPONDENCE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_H TO ES_RW;
ALTER TABLE ADR.CORRESPONDENCE_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CORRESPONDENCE_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.CORRESPONDENCE_STATUS
(
  CORRESPONDENCE_STATUS_ID  NUMBER(20),
  CODE                      VARCHAR2(10 BYTE)   NOT NULL,
  NAME                      VARCHAR2(30 BYTE)   NOT NULL,
  DESCRIPTION               VARCHAR2(250 BYTE)  NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CORRESPONDENCE_STATUS IS 'This table contains reference lookup values to track the specific state of correspondence communications.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.CORRESPONDENCE_STATUS_ID IS 'PRIMARY KEY.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.CODE IS 'LOOKUP CODE SHORT NAME VALUE.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.NAME IS 'LOOKUP CODE LONG NAME VALUE.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.DESCRIPTION IS 'LOOKUP CODE DESCRIPTION.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CORRESPONDENCE_STATUS_CODE_UK ON ADR.CORRESPONDENCE_STATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_STATUS_PK ON ADR.CORRESPONDENCE_STATUS
(CORRESPONDENCE_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CORRESPOND_STATUS_NAME_NU_I ON ADR.CORRESPONDENCE_STATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CORRESPONDENCE_STATUS FOR ADR.CORRESPONDENCE_STATUS;


ALTER TABLE ADR.CORRESPONDENCE_STATUS ADD (
  CONSTRAINT CORRESPONDENCE_STATUS_PK
  PRIMARY KEY
  (CORRESPONDENCE_STATUS_ID)
  USING INDEX ADR.CORRESPONDENCE_STATUS_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CORRESPONDENCE_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_STATUS TO ADR_RW;

GRANT SELECT ON ADR.CORRESPONDENCE_STATUS TO ES_R;

GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_STATUS TO ES_RW;
ALTER TABLE ADR.CORRESPONDENCE_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CORRESPONDENCE_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CORRESPONDENCE_TYPE
(
  CORRESPONDENCE_TYPE_ID  NUMBER(20),
  CODE                    VARCHAR2(10 BYTE)     NOT NULL,
  NAME                    VARCHAR2(30 BYTE)     NOT NULL,
  DESCRIPTION             VARCHAR2(250 BYTE)    NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CORRESPONDENCE_TYPE IS 'This table contains reference lookup values to track the specific type of correspondence method.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.CORRESPONDENCE_TYPE_ID IS 'PRIMARY KEY.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.CODE IS 'LOOKUP CODE SHORT NAME VALUE.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.NAME IS 'LOOKUP CODE LONG NAME VALUE.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.DESCRIPTION IS 'LOOKUP CODE DESCRIPTION.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CORRESPONDENCE_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CORRESPONDENCE_TYPE_CODE_UK ON ADR.CORRESPONDENCE_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CORRESPONDENCE_TYPE_NAME_NU_I ON ADR.CORRESPONDENCE_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_TYPE_PK ON ADR.CORRESPONDENCE_TYPE
(CORRESPONDENCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CORRESPONDENCE_TYPE FOR ADR.CORRESPONDENCE_TYPE;


ALTER TABLE ADR.CORRESPONDENCE_TYPE ADD (
  CONSTRAINT CORRESPONDENCE_TYPE_PK
  PRIMARY KEY
  (CORRESPONDENCE_TYPE_ID)
  USING INDEX ADR.CORRESPONDENCE_TYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CORRESPONDENCE_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CORRESPONDENCE_TYPE TO ADR_RW;

GRANT SELECT ON ADR.CORRESPONDENCE_TYPE TO ES_R;

GRANT INSERT, SELECT ON ADR.CORRESPONDENCE_TYPE TO ES_RW;
ALTER TABLE ADR.DELIVERY_PREFERENCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.DELIVERY_PREFERENCE CASCADE CONSTRAINTS;

CREATE TABLE ADR.DELIVERY_PREFERENCE
(
  DELIVERY_PREFERENCE_ID         NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_DELIVERYPREFERENCETYPE_ID  NUMBER(20)     NOT NULL,
  STD_DELIVERYPREFSRCTYPE_ID     NUMBER(20)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.DELIVERY_PREFERENCE IS 'Prefered method of delivery to the veteran.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.DELIVERY_PREFERENCE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.STD_DELIVERYPREFERENCETYPE_ID IS 'ID of the veteran''s preference for delivery.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE.STD_DELIVERYPREFSRCTYPE_ID IS 'ID of the source application that specified the veteran''s preference for delivery.';


CREATE INDEX ADR.DLVPRF_DLVPRFSRCTYP_FK_I ON ADR.DELIVERY_PREFERENCE
(STD_DELIVERYPREFSRCTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DLVPRF_DLVPRFTYP_FK_I ON ADR.DELIVERY_PREFERENCE
(STD_DELIVERYPREFERENCETYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.DLVPRF_PK ON ADR.DELIVERY_PREFERENCE
(DELIVERY_PREFERENCE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DLVPRF_PRSN_FK_I ON ADR.DELIVERY_PREFERENCE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.DLVPRF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.DELIVERY_PREFERENCE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into DELIVERY_PREFERENCE_H
        (
        DELIVERY_PREFERENCE_H_ID,
        DELIVERY_PREFERENCE_ID,
        PERSON_ID,
        STD_DELIVERYPREFERENCETYPE_ID,
STD_DELIVERYPREFSRCTYPE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_H_S.nextval,
        :old.DELIVERY_PREFERENCE_ID,
        :old.PERSON_ID,
        :old.STD_DELIVERYPREFERENCETYPE_ID,
:old.STD_DELIVERYPREFSRCTYPE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into DELIVERY_PREFERENCE_H
        (
        DELIVERY_PREFERENCE_H_ID,
        DELIVERY_PREFERENCE_ID,
        PERSON_ID,
        STD_DELIVERYPREFERENCETYPE_ID,
STD_DELIVERYPREFSRCTYPE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_H_S.nextval,
        :new.DELIVERY_PREFERENCE_ID,
        :new.PERSON_ID,
        :new.STD_DELIVERYPREFERENCETYPE_ID,
:new.STD_DELIVERYPREFSRCTYPE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end DELIVERY_PREFERENCE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM DELIVERY_PREFERENCE FOR ADR.DELIVERY_PREFERENCE;


ALTER TABLE ADR.DELIVERY_PREFERENCE ADD (
  CONSTRAINT DLVPRF_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_ID)
  USING INDEX ADR.DLVPRF_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.DELIVERY_PREFERENCE ADD (
  CONSTRAINT DLVPRF_PRS_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.DELIVERY_PREFERENCE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE TO ADR_RW;

GRANT SELECT ON ADR.DELIVERY_PREFERENCE TO ES_R;

GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE TO ES_RW;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.DELIVERY_PREFERENCE_EMAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.DELIVERY_PREFERENCE_EMAIL
(
  DELIVERY_PREFERENCE_EMAIL_ID  NUMBER(20)      NOT NULL,
  STD_EMAILADDRESSTYPE_ID       NUMBER(20)      NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  DELIVERY_PREFERENCE_ID        NUMBER(20)      NOT NULL,
  EMAIL_ADDRESS                 VARCHAR2(128 BYTE) NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.DELIVERY_PREFERENCE_EMAIL IS 'Delivery Preference email address for a person.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.DELIVERY_PREFERENCE_EMAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.STD_EMAILADDRESSTYPE_ID IS 'Type of email address for delivery';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL.DELIVERY_PREFERENCE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';


CREATE INDEX ADR.DLVPRFEM_DLVPRF_FK_I ON ADR.DELIVERY_PREFERENCE_EMAIL
(DELIVERY_PREFERENCE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.DLVPRFEM_PK ON ADR.DELIVERY_PREFERENCE_EMAIL
(DELIVERY_PREFERENCE_EMAIL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DLVPRFEM_STD_EMAILADDRTYP_FK_I ON ADR.DELIVERY_PREFERENCE_EMAIL
(STD_EMAILADDRESSTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.DLVPRFEM_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.DELIVERY_PREFERENCE_EMAIL
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into DELIVERY_PREFERENCE_EMAIL_H
        (
        DELIVERY_PREFERENCE_EMAIL_H_ID,
        DELIVERY_PREFERENCE_EMAIL_ID,
DELIVERY_PREFERENCE_ID,
STD_EMAILADDRESSTYPE_ID,
EMAIL_ADDRESS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_EMAIL_H_S.nextval,
        :old.DELIVERY_PREFERENCE_EMAIL_ID,
        :old.DELIVERY_PREFERENCE_ID,
        :old.STD_EMAILADDRESSTYPE_ID,
        :old.EMAIL_ADDRESS,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into DELIVERY_PREFERENCE_EMAIL_H
        (
        DELIVERY_PREFERENCE_EMAIL_H_ID,
        DELIVERY_PREFERENCE_EMAIL_ID,
 	DELIVERY_PREFERENCE_ID,
	STD_EMAILADDRESSTYPE_ID,
EMAIL_ADDRESS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_EMAIL_H_S.nextval,
        :new.DELIVERY_PREFERENCE_EMAIL_ID,
        :new.DELIVERY_PREFERENCE_ID,
        :new.STD_EMAILADDRESSTYPE_ID,
        :new.EMAIL_ADDRESS,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end DLVPRFEM_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM DELIVERY_PREFERENCE_EMAIL FOR ADR.DELIVERY_PREFERENCE_EMAIL;


ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL ADD (
  CONSTRAINT DLVPRFEM_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_EMAIL_ID)
  USING INDEX ADR.DLVPRFEM_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL ADD (
  CONSTRAINT DLVPRFEM_DLVPRF_FK 
  FOREIGN KEY (DELIVERY_PREFERENCE_ID) 
  REFERENCES ADR.DELIVERY_PREFERENCE (DELIVERY_PREFERENCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE_EMAIL TO ADR_RW;

GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL TO ES_RW;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H
(
  DELIVERY_PREFERENCE_EMAIL_ID    NUMBER(20)    NOT NULL,
  STD_EMAILADDRESSTYPE_ID         NUMBER(20)    NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  DELIVERY_PREFERENCE_ID          NUMBER(20)    NOT NULL,
  EMAIL_ADDRESS                   VARCHAR2(128 BYTE) NOT NULL,
  HISTORY_CREATED_DATE            DATE          NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  DELIVERY_PREFERENCE_EMAIL_H_ID  NUMBER(20)    NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H IS 'Delivery Preference email address for a person.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.DELIVERY_PREFERENCE_EMAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.STD_EMAILADDRESSTYPE_ID IS 'Type of email address for delivery';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.DELIVERY_PREFERENCE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.TRANSACTION_TYPE_CODE IS 'Whether this row was written because of a Create, Update, or Delete.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_EMAIL_H.DELIVERY_PREFERENCE_EMAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';


CREATE UNIQUE INDEX ADR.DLVPRFEM_H_PK ON ADR.DELIVERY_PREFERENCE_EMAIL_H
(DELIVERY_PREFERENCE_EMAIL_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM DELIVERY_PREFERENCE_EMAIL_H FOR ADR.DELIVERY_PREFERENCE_EMAIL_H;


ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H ADD (
  CONSTRAINT DLVPRFEM_H_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_EMAIL_H_ID)
  USING INDEX ADR.DLVPRFEM_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ADR_RW;

GRANT SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE_EMAIL_H TO ES_RW;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.DELIVERY_PREFERENCE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.DELIVERY_PREFERENCE_H
(
  DELIVERY_PREFERENCE_ID         NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  HISTORY_CREATED_DATE           DATE           NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  DELIVERY_PREFERENCE_H_ID       NUMBER(20)     NOT NULL,
  STD_DELIVERYPREFERENCETYPE_ID  NUMBER(20)     NOT NULL,
  STD_DELIVERYPREFSRCTYPE_ID     NUMBER(20)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.DELIVERY_PREFERENCE_H IS 'Prefered method of delivery to the veteran.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.DELIVERY_PREFERENCE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.TRANSACTION_TYPE_CODE IS 'Whether this row was written because of a Create, Update, or Delete.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.DELIVERY_PREFERENCE_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.STD_DELIVERYPREFERENCETYPE_ID IS 'ID of the veteran''s preference for delivery.';

COMMENT ON COLUMN ADR.DELIVERY_PREFERENCE_H.STD_DELIVERYPREFSRCTYPE_ID IS 'ID of the source application that specified the veteran''s preference for delivery.';


CREATE UNIQUE INDEX ADR.DLVPRF_H_PK ON ADR.DELIVERY_PREFERENCE_H
(DELIVERY_PREFERENCE_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM DELIVERY_PREFERENCE_H FOR ADR.DELIVERY_PREFERENCE_H;


ALTER TABLE ADR.DELIVERY_PREFERENCE_H ADD (
  CONSTRAINT DLVPRF_H_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_H_ID)
  USING INDEX ADR.DLVPRF_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.DELIVERY_PREFERENCE_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.DELIVERY_PREFERENCE_H TO ADR_RW;

GRANT SELECT ON ADR.DELIVERY_PREFERENCE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.DELIVERY_PREFERENCE_H TO ES_RW;
ALTER TABLE ADR.DEPLOYMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.DEPLOYMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.DEPLOYMENT
(
  DEPLOYMENT_ID             NUMBER(20)          NOT NULL,
  ACTIVATION_ID             NUMBER(20)          NOT NULL,
  STD_TERMINATIONREASON_ID  NUMBER(20),
  STD_MHDATASOURCE_ID       NUMBER(20),
  STD_COUNTRY_ID            NUMBER(20),
  STD_SPECIALOPERATION_ID   NUMBER(20),
  DEPLOYMENT_BEGIN_DATE     DATE,
  DEPLOYMENT_END_DATE       DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(18)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.DEPLOYMENT IS 'Period that a veteran was deployed during an Activation';

COMMENT ON COLUMN ADR.DEPLOYMENT.DEPLOYMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DEPLOYMENT.ACTIVATION_ID IS 'Unique identifier for an Activation';

COMMENT ON COLUMN ADR.DEPLOYMENT.STD_TERMINATIONREASON_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.DEPLOYMENT.STD_MHDATASOURCE_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.DEPLOYMENT.STD_SPECIALOPERATION_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.DEPLOYMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.DEPLOYMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.DEPLOYMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.DEPLOYMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.DEPLOYMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.DEP_ACT_FK_I ON ADR.DEPLOYMENT
(ACTIVATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DEP_MHDS_FK_I ON ADR.DEPLOYMENT
(STD_MHDATASOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.DEP_PK ON ADR.DEPLOYMENT
(DEPLOYMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DEP_SC_FK_I ON ADR.DEPLOYMENT
(STD_COUNTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DEP_SO_FK_I ON ADR.DEPLOYMENT
(STD_SPECIALOPERATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.DEP_TR_FK_I ON ADR.DEPLOYMENT
(STD_TERMINATIONREASON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.DEPLOYMENT_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.DEPLOYMENT
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into DEPLOYMENT_H
        (
        DEPLOYMENT_H_ID,
        DEPLOYMENT_ID,
        ACTIVATION_ID,
        STD_TERMINATIONREASON_ID,
        STD_MHDATASOURCE_ID,
        STD_COUNTRY_ID,
        STD_SPECIALOPERATION_ID,
        DEPLOYMENT_BEGIN_DATE,
        DEPLOYMENT_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DEPLOYMENT_H_S.nextval,
        :old.DEPLOYMENT_ID,
        :old.ACTIVATION_ID,
        :old.STD_TERMINATIONREASON_ID,
        :old.STD_MHDATASOURCE_ID,
        :old.STD_COUNTRY_ID,
        :old.STD_SPECIALOPERATION_ID,
        :old.DEPLOYMENT_BEGIN_DATE,
        :old.DEPLOYMENT_END_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into DEPLOYMENT_H
        (
        DEPLOYMENT_H_ID,
        DEPLOYMENT_ID,
        ACTIVATION_ID,
        STD_TERMINATIONREASON_ID,
        STD_MHDATASOURCE_ID,
        STD_COUNTRY_ID,
        STD_SPECIALOPERATION_ID,
        DEPLOYMENT_BEGIN_DATE,
        DEPLOYMENT_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DEPLOYMENT_H_S.nextval,
        :new.DEPLOYMENT_ID,
        :new.ACTIVATION_ID,
        :new.STD_TERMINATIONREASON_ID,
        :new.STD_MHDATASOURCE_ID,
        :new.STD_COUNTRY_ID,
        :new.STD_SPECIALOPERATION_ID,
        :new.DEPLOYMENT_BEGIN_DATE,
        :new.DEPLOYMENT_END_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end DEPLOYMENT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM DEPLOYMENT FOR ADR.DEPLOYMENT;


ALTER TABLE ADR.DEPLOYMENT ADD (
  CONSTRAINT DEP_PK
  PRIMARY KEY
  (DEPLOYMENT_ID)
  USING INDEX ADR.DEP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.DEPLOYMENT ADD (
  CONSTRAINT DEP_ACT_FK 
  FOREIGN KEY (ACTIVATION_ID) 
  REFERENCES ADR.ACTIVATION (ACTIVATION_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.DEPLOYMENT TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.DEPLOYMENT TO ADR_RW;

GRANT SELECT ON ADR.DEPLOYMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.DEPLOYMENT TO ES_RW;
ALTER TABLE ADR.DEPLOYMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.DEPLOYMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.DEPLOYMENT_H
(
  DEPLOYMENT_H_ID           NUMBER(20)          NOT NULL,
  DEPLOYMENT_ID             NUMBER(20)          NOT NULL,
  ACTIVATION_ID             NUMBER(20)          NOT NULL,
  STD_TERMINATIONREASON_ID  NUMBER(20),
  STD_MHDATASOURCE_ID       NUMBER(20),
  STD_COUNTRY_ID            NUMBER(20),
  STD_SPECIALOPERATION_ID   NUMBER(20),
  DEPLOYMENT_BEGIN_DATE     DATE,
  DEPLOYMENT_END_DATE       DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(18)          NOT NULL,
  HISTORY_CREATED_DATE      DATE                NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.DEPLOYMENT_H IS 'Period that a veteran was deployed during an Activation';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.DEPLOYMENT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.DEPLOYMENT_ID IS 'Unique identifier for a  Deployment';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.ACTIVATION_ID IS 'FK to Activation';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.STD_COUNTRY_ID IS 'Existing Country';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.DEPLOYMENT_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.DEP_H_PK ON ADR.DEPLOYMENT_H
(DEPLOYMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM DEPLOYMENT_H FOR ADR.DEPLOYMENT_H;


ALTER TABLE ADR.DEPLOYMENT_H ADD (
  CONSTRAINT AVCON_1253310191_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT DEP_H_PK
  PRIMARY KEY
  (DEPLOYMENT_H_ID)
  USING INDEX ADR.DEP_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.DEPLOYMENT_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.DEPLOYMENT_H TO ADR_RW;

GRANT SELECT ON ADR.DEPLOYMENT_H TO ES_R;

GRANT INSERT, SELECT ON ADR.DEPLOYMENT_H TO ES_RW;
ALTER TABLE ADR.EGT_SETTING
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SETTING CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SETTING
(
  EGT_SETTING_ID              NUMBER(20)        NOT NULL,
  EGT_TYPE_ID                 NUMBER(20)        NOT NULL,
  PRIORITY_GROUP_TYPE_ID      NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID  NUMBER(20),
  REFERENCE_EGT_SETTING_ID    NUMBER(20),
  EGT_EFFECTIVE_DATE          DATE,
  FEDERAL_REGISTRY_DATE       DATE,
  CURRENT_EGT_FLAG            NUMBER(1)         DEFAULT 0                     NOT NULL,
  DISABLED_EGT_FLAG           NUMBER(1)         DEFAULT 0                     NOT NULL,
  REMARKS                     VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SETTING IS 'Enrollment Global Threshold setting for beneficiaries The EGT_SETTING table stores a record for Enrollment Group Threshold (EGT) that is set. This threshold dictates what the cutoff point is for persons receiving care from the VHA. Any person in an enrollment priority group less than or equal to the EGT setting is eligible to enroll in the VHA system and receive care; any person in an enrollment priority group greater than the threshold will not be eligible for enrollment. EGT_TYPE_ID Foreign key to the EGT_TYPE table. Indicates the type of setting (for example, annual fiscal year, enrollment decision). PRIORITY_GROUP_TYPE_ID Foreign key to the PRIORITY_GROUP_TYPE table. Indicates the Enrollment Priority Group that has been set (Group 1 through Group 8). PRIORITY_SUB_GROUP_TYPE_ID Foreign key to the PRIORITY_SUB_GROUP_TYPE table. Indicates the Enrollment Priority Group that has been set (for example, a, c). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EGT_SETTING.EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.EGT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.REFERENCE_EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.EGT_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.FEDERAL_REGISTRY_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.CURRENT_EGT_FLAG IS 'Flagusedtoindicate thatanEGTsettinghas beendisabled.DisabledIndicatoris usedifthisentrywas enteredinerror,this fieldshouldbeset.If theEGTthatthisrecord representsneedstobe disabledforanyreason (wrongEGTEffectDate, etcwasentered)thenthe EGTentryneedstobe disabled.Thiswill preventtheprocessingof alltheenrollment recordsfromtaking place.';

COMMENT ON COLUMN ADR.EGT_SETTING.DISABLED_EGT_FLAG IS 'Flagusedtoindicate thatanEGTsettinghas beendisabled.DisabledIndicatoris usedifthisentrywas enteredinerror,this fieldshouldbeset.If theEGTthatthisrecord representsneedstobe disabledforanyreason (wrongEGTEffectDate, etcwasentered)thenthe EGTentryneedstobe disabled.Thiswill preventtheprocessingof alltheenrollment recordsfromtaking place.';

COMMENT ON COLUMN ADR.EGT_SETTING.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EGTSETTING_EGTSETTING_FK_I ON ADR.EGT_SETTING
(REFERENCE_EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EGTSETTING_PK ON ADR.EGT_SETTING
(EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSETTING_STD_EGTTYP_FK_I ON ADR.EGT_SETTING
(EGT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSETTING_STD_ENRLPGRP_FK_I ON ADR.EGT_SETTING
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSETTING_STD_ENRLPSGRP_FK_I ON ADR.EGT_SETTING
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EGT_SETTING_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_SETTING
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EGT_SETTING_H
		(
		EGT_SETTING_H_ID,
		EGT_SETTING_ID  ,
		EGT_TYPE_ID     ,
		PRIORITY_GROUP_TYPE_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		EGT_EFFECTIVE_DATE        ,
		FEDERAL_REGISTRY_DATE     ,
		REMARKS                   ,
		DISABLED_EGT_FLAG         ,
		CURRENT_EGT_FLAG,
		REFERENCE_EGT_SETTING_ID,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SETTING_H_s.nextval,
		:old.EGT_SETTING_ID,
		:old.EGT_TYPE_ID,
		:old.PRIORITY_GROUP_TYPE_ID,
		:old.PRIORITY_SUB_GROUP_TYPE_ID,
		:old.EGT_EFFECTIVE_DATE,
		:old.FEDERAL_REGISTRY_DATE,
		:old.REMARKS,
		:old.DISABLED_EGT_FLAG,
		:old.CURRENT_EGT_FLAG,
		:old.REFERENCE_EGT_SETTING_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_SETTING_H
		(
		EGT_SETTING_H_ID,
		EGT_SETTING_ID  ,
		EGT_TYPE_ID     ,
		PRIORITY_GROUP_TYPE_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		EGT_EFFECTIVE_DATE        ,
		FEDERAL_REGISTRY_DATE     ,
		REMARKS                   ,
		DISABLED_EGT_FLAG         ,
		CURRENT_EGT_FLAG,
		REFERENCE_EGT_SETTING_ID,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		EGT_SETTING_H_s.nextval,
		:new.EGT_SETTING_ID,
		:new.EGT_TYPE_ID,
		:new.PRIORITY_GROUP_TYPE_ID,
		:new.PRIORITY_SUB_GROUP_TYPE_ID,
		:new.EGT_EFFECTIVE_DATE,
		:new.FEDERAL_REGISTRY_DATE,
		:new.REMARKS,
		:new.DISABLED_EGT_FLAG,
		:new.CURRENT_EGT_FLAG,
		:new.REFERENCE_EGT_SETTING_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  EGT_SETTING_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EGT_SETTING FOR ADR.EGT_SETTING;


ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT AVCON_1172521913_CURRE_000
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_DISAB_000
  CHECK (DISABLED_EGT_FLAG BETWEEN 0
AND 0 OR DISABLED_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT EGTSETTING_PK
  PRIMARY KEY
  (EGT_SETTING_ID)
  USING INDEX ADR.EGTSETTING_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT EGTSETTING_EGTSETTING_FK 
  FOREIGN KEY (REFERENCE_EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SETTING TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_SETTING TO ADR_RW;

GRANT SELECT ON ADR.EGT_SETTING TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SETTING TO ES_RW;
ALTER TABLE ADR.EGT_SETTING_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SETTING_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SETTING_H
(
  EGT_SETTING_H_ID            NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  EGT_SETTING_ID              NUMBER(20)        NOT NULL,
  EGT_TYPE_ID                 NUMBER(20)        NOT NULL,
  PRIORITY_GROUP_TYPE_ID      NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID  NUMBER(20),
  REFERENCE_EGT_SETTING_ID    NUMBER(20),
  EGT_EFFECTIVE_DATE          DATE,
  FEDERAL_REGISTRY_DATE       DATE,
  CURRENT_EGT_FLAG            NUMBER(1)         DEFAULT 0                     NOT NULL,
  DISABLED_EGT_FLAG           NUMBER(1)         DEFAULT 0                     NOT NULL,
  REMARKS                     VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SETTING_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_SETTING_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_SETTING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.REFERENCE_EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_EFFECTIVE_DATE IS 'DateonwhichtheEGT settingbecomes effective.TheEGTEffectiveDateis definedastheEffective DateforthisEGTtogo intoeffect.Itis referencedbythe determineenrollment businessrules.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.FEDERAL_REGISTRY_DATE IS 'FederalRegisterDate holdsthedatethatthe EGTchangewaspublished intheFederalRegister.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.CURRENT_EGT_FLAG IS 'Flagusedtoindicate thatanEGTsettinghas beendisabled.DisabledIndicatoris usedifthisentrywas enteredinerror,this fieldshouldbeset.If theEGTthatthisrecord representsneedstobe disabledforanyreason (wrongEGTEffectDate, etcwasentered)thenthe EGTentryneedstobe disabled.Thiswill preventtheprocessingof alltheenrollment recordsfromtaking place.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.DISABLED_EGT_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EGTSETTINH_PK ON ADR.EGT_SETTING_H
(EGT_SETTING_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EGT_SETTING_H FOR ADR.EGT_SETTING_H;


ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT AVCON_1172521913_CURRE_001
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_TRANS_045
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EGTSETTINH_PK
  PRIMARY KEY
  (EGT_SETTING_H_ID)
  USING INDEX ADR.EGTSETTINH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SETTING_H TO ADR_R;

GRANT SELECT ON ADR.EGT_SETTING_H TO ADR_RW;

GRANT SELECT ON ADR.EGT_SETTING_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SETTING_H TO ES_RW;
ALTER TABLE ADR.EGT_SITE_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SITE_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SITE_STATISTICS
(
  EGT_SITE_STATISTICS_ID          NUMBER(20)    NOT NULL,
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SITE_STATISTICS IS 'Enrollment Global Threshold statistics per site The EGT_SITE_STATISTICS table contains information by site about persons who are not enrolled. EGT_SETTING_ID Foreign key to the EGT_SETTING table. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. Indicates the site to which the statistics apply. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.EGT_SITE_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.EGT_STATISTICS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EGTSTSTIC_EGTSETTING_FK_I ON ADR.EGT_SITE_STATISTICS
(EGT_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EGTSTSTIC_PK ON ADR.EGT_SITE_STATISTICS
(EGT_SITE_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSTSTIC_STDINST_FK_I ON ADR.EGT_SITE_STATISTICS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EGT_SITE_STATISTICS_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_SITE_STATISTICS
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into EGT_SITE_STATISTICS_H
		(
		EGT_SITE_STATISTICS_H_ID,
		EGT_SITE_STATISTICS_ID,
		EGT_STATISTICS_ID,
		STD_INSTITUTION_ID,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		BENEFICIARY_PROCESSED_COUNT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SITE_STATISTICS_H_s.nextval,
		:old.EGT_SITE_STATISTICS_ID,
		:old.EGT_STATISTICS_ID,
		:old.STD_INSTITUTION_ID,
		:old.BENEFICIARY_NOT_ENROLLED_COUNT,
		:old.IN_PROCESS_CATGRY_COUNT,
		:old.ENROLLED_CATGRY_COUNT,
		:old.BENEFICIARY_PROCESSED_COUNT,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_SITE_STATISTICS_H
		(
		EGT_SITE_STATISTICS_H_ID,
		EGT_SITE_STATISTICS_ID,
		EGT_STATISTICS_ID,
		STD_INSTITUTION_ID,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		BENEFICIARY_PROCESSED_COUNT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SITE_STATISTICS_H_s.nextval,
		:new.EGT_SITE_STATISTICS_ID,
		:new.EGT_STATISTICS_ID,
		:new.STD_INSTITUTION_ID,
		:new.BENEFICIARY_NOT_ENROLLED_COUNT,
		:new.IN_PROCESS_CATGRY_COUNT,
		:new.ENROLLED_CATGRY_COUNT,
		:new.BENEFICIARY_PROCESSED_COUNT,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  EGT_SITE_STATISTICS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EGT_SITE_STATISTICS FOR ADR.EGT_SITE_STATISTICS;


ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_ID)
  USING INDEX ADR.EGTSTSTIC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_EGTSTAT_FK 
  FOREIGN KEY (EGT_STATISTICS_ID) 
  REFERENCES ADR.EGT_STATISTICS (EGT_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SITE_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_SITE_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.EGT_SITE_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SITE_STATISTICS TO ES_RW;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SITE_STATISTICS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SITE_STATISTICS_H
(
  EGT_SITE_STATISTICS_H_ID        NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  EGT_SITE_STATISTICS_ID          NUMBER(20)    NOT NULL,
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SITE_STATISTICS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.EGT_SITE_STATISTICS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.EGT_SITE_STATISTICS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.EGT_STATISTICS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EGTSTSTICH_PK ON ADR.EGT_SITE_STATISTICS_H
(EGT_SITE_STATISTICS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EGT_SITE_STATISTICS_H FOR ADR.EGT_SITE_STATISTICS_H;


ALTER TABLE ADR.EGT_SITE_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_051
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EGTSTSTICH_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_H_ID)
  USING INDEX ADR.EGTSTSTICH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ADR_R;

GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ADR_RW;

GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SITE_STATISTICS_H TO ES_RW;
ALTER TABLE ADR.EGT_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_STATISTICS
(
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  EGT_SETTING_ID                  NUMBER(20)    NOT NULL,
  EGT_STATUS_TYPE_ID              NUMBER(20),
  PROCESS_NUMBER                  VARCHAR2(20 BYTE),
  PROCESS_MESSAGE_DESCRIPTION     VARCHAR2(250 BYTE),
  PROCESS_START_DATE              DATE,
  PROCESS_END_DATE                DATE,
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_STATISTICS IS 'Enrollment Global Threshold Statistics ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EGT_STATISTICS.EGT_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.PROCESS_START_DATE IS 'BR2312ProcessStarted Date/Time:Holdsthe date/timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingstarted.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.PROCESS_END_DATE IS 'BR2316ProcessEnded Date/Timeisthe Date/Timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingended.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EGTSTAT_EGTSETTING_FK_I ON ADR.EGT_STATISTICS
(EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EGTSTAT_PK ON ADR.EGT_STATISTICS
(EGT_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSTAT_STD_EGTPRCST_FK_I ON ADR.EGT_STATISTICS
(EGT_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EGT_STATISTICS_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_STATISTICS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EGT_STATISTICS_H
		(
		EGT_STATISTICS_H_ID,
		EGT_STATISTICS_ID,
		EGT_SETTING_ID,
		PROCESS_START_DATE,
		PROCESS_END_DATE,
		BENEFICIARY_PROCESSED_COUNT,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		PROCESS_NUMBER,
		PROCESS_MESSAGE_DESCRIPTION,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EGT_STATISTICS_H_S.nextval,
		:old.EGT_STATISTICS_ID,
		:old.EGT_SETTING_ID,
		:old.PROCESS_START_DATE,
		:old.PROCESS_END_DATE,
		:old.BENEFICIARY_PROCESSED_COUNT,
		:old.BENEFICIARY_NOT_ENROLLED_COUNT,
		:old.PROCESS_NUMBER,
		:old.PROCESS_MESSAGE_DESCRIPTION,
		:old.IN_PROCESS_CATGRY_COUNT,
		:old.ENROLLED_CATGRY_COUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_STATISTICS_H
		(
		EGT_STATISTICS_H_ID,
		EGT_STATISTICS_ID,
		EGT_SETTING_ID,
		PROCESS_START_DATE,
		PROCESS_END_DATE,
		BENEFICIARY_PROCESSED_COUNT,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		PROCESS_NUMBER,
		PROCESS_MESSAGE_DESCRIPTION,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EGT_STATISTICS_H_S.nextval,
		:new.EGT_STATISTICS_ID,
		:new.EGT_SETTING_ID,
		:new.PROCESS_START_DATE,
		:new.PROCESS_END_DATE,
		:new.BENEFICIARY_PROCESSED_COUNT,
		:new.BENEFICIARY_NOT_ENROLLED_COUNT,
		:new.PROCESS_NUMBER,
		:new.PROCESS_MESSAGE_DESCRIPTION,
		:new.IN_PROCESS_CATGRY_COUNT,
		:new.ENROLLED_CATGRY_COUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end EGT_STATISTICS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EGT_STATISTICS FOR ADR.EGT_STATISTICS;


ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_PK
  PRIMARY KEY
  (EGT_STATISTICS_ID)
  USING INDEX ADR.EGTSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.EGT_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_STATISTICS TO ES_RW;
ALTER TABLE ADR.EGT_STATISTICS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_STATISTICS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_STATISTICS_H
(
  EGT_STATISTICS_H_ID             NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  EGT_SETTING_ID                  NUMBER(20)    NOT NULL,
  EGT_STATUS_TYPE_ID              NUMBER(20),
  PROCESS_NUMBER                  VARCHAR2(20 BYTE),
  PROCESS_MESSAGE_DESCRIPTION     VARCHAR2(250 BYTE),
  PROCESS_START_DATE              DATE,
  PROCESS_END_DATE                DATE,
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_STATISTICS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.EGT_STATISTICS_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.EGT_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.EGT_SETTING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.PROCESS_START_DATE IS 'BR2312ProcessStarted Date/Time:Holdsthe date/timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingstarted.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.PROCESS_END_DATE IS 'BR2316ProcessEnded Date/Timeisthe Date/Timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingended.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EGTSTATH_PK ON ADR.EGT_STATISTICS_H
(EGT_STATISTICS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EGT_STATISTICS_H FOR ADR.EGT_STATISTICS_H;


ALTER TABLE ADR.EGT_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_013
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EGTSTATH_PK
  PRIMARY KEY
  (EGT_STATISTICS_H_ID)
  USING INDEX ADR.EGTSTATH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_STATISTICS_H TO ADR_R;

GRANT SELECT ON ADR.EGT_STATISTICS_H TO ADR_RW;

GRANT SELECT ON ADR.EGT_STATISTICS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_STATISTICS_H TO ES_RW;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ELIGIBILITY_DETERMINATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.ELIGIBILITY_DETERMINATION
(
  ELIGIBILITY_DETERMINATION_ID  NUMBER(20)      NOT NULL,
  ENROLLMENT_DETERMINATION_ID   NUMBER(20)      NOT NULL,
  ELIGIBILITY_TYPE_ID           NUMBER(20),
  STD_ELIGIBILITYFACTOR_ID      NUMBER(20),
  PRIMARY_SECONDARY_OR_OTHER    VARCHAR2(1 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ELIGIBILITY_DETERMINATION IS 'The ELIGIBILITY_DETERMINATION table contains information about the eligibility codes applicable to a persons enrollment in the VHA Healthcare system. ENROLLMENT_DETERMINATION_ID Foreign key to the ENROLLMENT_DETERMINATION table. ELIGIBILITY_TYPE_ID Foreign key to the ELIGIBILITY_TYPE table. Indicates the eligibility codes associated with a particular person (for example, Service Connected 50% to 100%, Purple Heart). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.ELIGIBILITY_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.ENROLLMENT_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.ELIGIBILITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.STD_ELIGIBILITYFACTOR_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.PRIMARY_SECONDARY_OR_OTHER IS 'Indicateswhetheran eligibilityisaprimary, secondary,orother eligibility.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ELGBDETER_ENRLMNTDET_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ELGBDETER_PK ON ADR.ELIGIBILITY_DETERMINATION
(ELIGIBILITY_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBDETER_STDELGFCTR_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(STD_ELIGIBILITYFACTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBDETER_STD_ELGBTYCODE_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(ELIGIBILITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLLMENT_DETERM_MOD_DT_NDX ON ADR.ELIGIBILITY_DETERMINATION
(RECORD_MODIFIED_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ELIGIBILITY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.ELIGIBILITY_DETERMINATION
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ELIGIBILITY_DETERMINATION_H
		(
		ELIGIBILITY_DETERMINATION_H_ID,
		ELIGIBILITY_DETERMINATION_ID  ,
		ENROLLMENT_DETERMINATION_ID   ,
		ELIGIBILITY_TYPE_ID           ,
		PRIMARY_SECONDARY_OR_OTHER    ,
		STD_ELIGIBILITYFACTOR_ID	  ,
		RECORD_CREATED_BY             ,
		RECORD_CREATED_DATE           ,
		RECORD_MODIFIED_BY            ,
		RECORD_MODIFIED_DATE          ,
		RECORD_MODIFIED_COUNT         ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ELIGIBILITY_DETERMINATION_H_s.nextval,
		:old.ELIGIBILITY_DETERMINATION_ID,
		:old.ENROLLMENT_DETERMINATION_ID,
		:old.ELIGIBILITY_TYPE_ID,
		:old.PRIMARY_SECONDARY_OR_OTHER,
		:old.STD_ELIGIBILITYFACTOR_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ELIGIBILITY_DETERMINATION_H
		(
		ELIGIBILITY_DETERMINATION_H_ID,
		ELIGIBILITY_DETERMINATION_ID  ,
		ENROLLMENT_DETERMINATION_ID   ,
		ELIGIBILITY_TYPE_ID           ,
		PRIMARY_SECONDARY_OR_OTHER    ,
		STD_ELIGIBILITYFACTOR_ID,
		RECORD_CREATED_BY             ,
		RECORD_CREATED_DATE           ,
		RECORD_MODIFIED_BY            ,
		RECORD_MODIFIED_DATE          ,
		RECORD_MODIFIED_COUNT         ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ELIGIBILITY_DETERMINATION_H_s.nextval,
		:new.ELIGIBILITY_DETERMINATION_ID,
		:new.ENROLLMENT_DETERMINATION_ID,
		:new.ELIGIBILITY_TYPE_ID,
		:new.PRIMARY_SECONDARY_OR_OTHER,
		:new.STD_ELIGIBILITYFACTOR_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  ELIGIBILITY_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_DETERMINATION FOR ADR.ELIGIBILITY_DETERMINATION;


ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_001
  CHECK (PRIMARY_SECONDARY_OR_OTHER IN ('P', 'S', 'O'))
  ENABLE VALIDATE,
  CONSTRAINT ELGBDETER_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_ID)
  USING INDEX ADR.ELGBDETER_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT ELGBDETER_ENRLMNTDET_FK 
  FOREIGN KEY (ENROLLMENT_DETERMINATION_ID) 
  REFERENCES ADR.ENROLLMENT_DETERMINATION (ENROLLMENT_DETERMINATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_DETERMINATION TO ADR_RW;

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ES_R;

GRANT INSERT, SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ES_RW;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ELIGIBILITY_DETERMINATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ELIGIBILITY_DETERMINATION_H
(
  ELIGIBILITY_DETERMINATION_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  ELIGIBILITY_DETERMINATION_ID    NUMBER(20),
  ENROLLMENT_DETERMINATION_ID     NUMBER(20),
  ELIGIBILITY_TYPE_ID             NUMBER(20),
  STD_ELIGIBILITYFACTOR_ID        NUMBER(20),
  PRIMARY_SECONDARY_OR_OTHER      VARCHAR2(1 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ELIGIBILITY_DETERMINATION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.ELIGIBILITY_DETERMINATION_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.ELIGIBILITY_DETERMINATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.ENROLLMENT_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.ELIGIBILITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.STD_ELIGIBILITYFACTOR_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.PRIMARY_SECONDARY_OR_OTHER IS 'Indicateswhetheran eligibilityisaprimary, secondary,orother eligibility.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ELGBDETERH_ENRLMNTDET_NU_I ON ADR.ELIGIBILITY_DETERMINATION_H
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ELGBDETERH_PK ON ADR.ELIGIBILITY_DETERMINATION_H
(ELIGIBILITY_DETERMINATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLLMENT_DETERM_H_MOD_DT_NDX ON ADR.ELIGIBILITY_DETERMINATION_H
(RECORD_MODIFIED_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_DETERMINATION_H FOR ADR.ELIGIBILITY_DETERMINATION_H;


ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_075
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067559
  CHECK ("ELIGIBILITY_DETERMINATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067560
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067561
  CHECK ("ELIGIBILITY_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067562
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067563
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067564
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067565
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067566
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067567
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ELGBDETERH_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_H_ID)
  USING INDEX ADR.ELGBDETERH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ADR_R;

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ADR_RW;

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ELIGIBILITY_DETERMINATION_H TO ES_RW;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ELIGIBILITY_STATUS_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.ELIGIBILITY_STATUS_REASON
(
  ELIGIBILITY_STATUS_REASON_ID  NUMBER(20)      NOT NULL,
  CODE                          VARCHAR2(2 BYTE) NOT NULL,
  NAME                          VARCHAR2(50 BYTE) NOT NULL,
  DESCRIPTION                   VARCHAR2(100 BYTE),
  ISACTIVE                      CHAR(1 BYTE)    NOT NULL,
  INACTIVE_DATE                 DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
CACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ELIGIBILITY_STATUS_REASON IS 'Lookup table to hold eligibility status reason.';

COMMENT ON COLUMN ADR.ELIGIBILITY_STATUS_REASON.ELIGIBILITY_STATUS_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ELIGIBILITY_STATUS_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_STATUS_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ELIGIBILITY_STATUS_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_STATUS_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ELIGIBILITY_STATUS_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ELGBTY_STATUS_REASON_CODE_UK ON ADR.ELIGIBILITY_STATUS_REASON
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ELGBTY_STATUS_REASON_NM_UK ON ADR.ELIGIBILITY_STATUS_REASON
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ELIGIBILITY_STATUS_REASON_PK ON ADR.ELIGIBILITY_STATUS_REASON
(ELIGIBILITY_STATUS_REASON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_STATUS_REASON FOR ADR.ELIGIBILITY_STATUS_REASON;


ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON ADD (
  CONSTRAINT ELIGIBILITY_STATUS_REASON_PK
  PRIMARY KEY
  (ELIGIBILITY_STATUS_REASON_ID)
  USING INDEX ADR.ELIGIBILITY_STATUS_REASON_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ELIGIBILITY_STATUS_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_STATUS_REASON TO ADR_RW;

GRANT SELECT ON ADR.ELIGIBILITY_STATUS_REASON TO ES_R;

GRANT INSERT, SELECT ON ADR.ELIGIBILITY_STATUS_REASON TO ES_RW;
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ELIGIBILITY_VERIFICATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.ELIGIBILITY_VERIFICATION
(
  ELIGIBILITY_VERIFICATION_ID  NUMBER(20),
  PERSON_ID                    NUMBER(20),
  ELGBTY_STATUS_TYPE_ID        NUMBER(20),
  ELGBTY_VRFN_SOURCE_TYPE_ID   NUMBER(20),
  VBA_QUERY_STATUS_TYPE_ID     NUMBER(20),
  VBA_QUERY_STATUS_DATE        DATE,
  VBA_QUERY_SENT_DATE          DATE,
  STD_INSTITUTION_ID           NUMBER(20),
  VERIFICATION_METHOD_CODE     VARCHAR2(50 BYTE),
  ELIGIBILITY_STATUS_DATE_TXT  VARCHAR2(14 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  ELGBTY_STATUS_REASON_ID      NUMBER(20),
  ELGBTY_REASON_EXPLANATION    VARCHAR2(255 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ELIGIBILITY_VERIFICATION IS 'The table stores data about a persons eligibility status, including what method was used to verify the eligibility, what source was used to verify the eligibility (i.e. HINQ/VBA, Veteran Family Member, Other Source, Master Veteran Record, VAMC, or VIVA file from Austin) and at what site the verification was performed. PERSON_ID Foreign key to the PERSON table. ELGBTY_STATUS_TYPE_ID Foreign key to the ELGBTY_STATUS_TYPE table. Indicates the status of the verification (for example, Pending Verification, Verified). ELGBTY_VRFN_SOURCE_TYPE_ID Foreign key to the ELGBTY_VRFN_SOURCE_TYPE. Indicates the source from which verification data was received (for example, VBA, VistA). AAC_STATUS_TYPE_ID Foreign key to the AAC_STATUS_TYPE table. Indicates the status of the verification query to AAC (for example, Data Pending Review, AAC Data Rejected). STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. Indicates the site that initiated the verification. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.ELIGIBILITY_VERIFICATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.ELGBTY_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.ELGBTY_VRFN_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.VBA_QUERY_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.VBA_QUERY_STATUS_DATE IS 'Providesamigration targetforDATELAST UPDATEDATAAC (300.12/31)';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.VBA_QUERY_SENT_DATE IS 'Providesamigration targetforDatequery senttoAAC(300.12/33)';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.VERIFICATION_METHOD_CODE IS 'Codethatdescribes methodusedtoverify eligibility.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ELGBTYVRFY_PK ON ADR.ELIGIBILITY_VERIFICATION
(ELIGIBILITY_VERIFICATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBTYVRFY_PRSN_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBTYVRFY_STDINST_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBTYVRFY_STD_ELGBTST_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(ELGBTY_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBTYVRFY_STD_ELGVRSRC_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(ELGBTY_VRFN_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBTYVRFY_STD_VBAQURYST_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(VBA_QUERY_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ELIGIBILITY_VER_AUDIR_TRGR
   AFTER UPDATE OR DELETE OR INSERT
   ON ADR.ELIGIBILITY_VERIFICATION
   REFERENCING NEW AS NEW OLD AS OLD
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      INSERT INTO ELIGIBILITY_VERIFICATION_H (ELIGIBILITY_VERIFICATION_H_ID,
                                              ELIGIBILITY_VERIFICATION_ID,
                                              PERSON_ID,
                                              ELGBTY_STATUS_TYPE_ID,
                                              ELGBTY_VRFN_SOURCE_TYPE_ID,
                                              VBA_QUERY_STATUS_TYPE_ID,
                                              STD_INSTITUTION_ID,
                                              VERIFICATION_METHOD_CODE,
                                              ELIGIBILITY_STATUS_DATE_TXT,
                                              VBA_QUERY_STATUS_DATE,
                                              VBA_QUERY_SENT_DATE,
                                              elgbty_Status_reason_id,
                                              elgbty_reason_explanation,
                                              RECORD_CREATED_BY,
                                              RECORD_CREATED_DATE,
                                              RECORD_MODIFIED_BY,
                                              RECORD_MODIFIED_DATE,
                                              RECORD_MODIFIED_COUNT,
                                              TRANSACTION_TYPE_CODE)
           VALUES (ELIGIBILITY_VERIFICATION_H_s.NEXTVAL,
                   :old.ELIGIBILITY_VERIFICATION_ID,
                   :old.PERSON_ID,
                   :old.ELGBTY_STATUS_TYPE_ID,
                   :old.ELGBTY_VRFN_SOURCE_TYPE_ID,
                   :old.VBA_QUERY_STATUS_TYPE_ID,
                   :old.STD_INSTITUTION_ID,
                   :old.VERIFICATION_METHOD_CODE,
                   :old.ELIGIBILITY_STATUS_DATE_TXT,
                   :old.VBA_QUERY_STATUS_DATE,
                   :old.VBA_QUERY_SENT_DATE,
                   :old.elgbty_Status_reason_id,
                   :old.elgbty_reason_explanation,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   'D');
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO ELIGIBILITY_VERIFICATION_H (ELIGIBILITY_VERIFICATION_H_ID,
                                              ELIGIBILITY_VERIFICATION_ID,
                                              PERSON_ID,
                                              ELGBTY_STATUS_TYPE_ID,
                                              ELGBTY_VRFN_SOURCE_TYPE_ID,
                                              VBA_QUERY_STATUS_TYPE_ID,
                                              STD_INSTITUTION_ID,
                                              VERIFICATION_METHOD_CODE,
                                              ELIGIBILITY_STATUS_DATE_TXT,
                                              VBA_QUERY_STATUS_DATE,
                                              VBA_QUERY_SENT_DATE,
                                              elgbty_Status_reason_id,
                                              elgbty_reason_explanation,
                                              RECORD_CREATED_BY,
                                              RECORD_CREATED_DATE,
                                              RECORD_MODIFIED_BY,
                                              RECORD_MODIFIED_DATE,
                                              RECORD_MODIFIED_COUNT,
                                              TRANSACTION_TYPE_CODE)
           VALUES (ELIGIBILITY_VERIFICATION_H_s.NEXTVAL,
                   :new.ELIGIBILITY_VERIFICATION_ID,
                   :new.PERSON_ID,
                   :new.ELGBTY_STATUS_TYPE_ID,
                   :new.ELGBTY_VRFN_SOURCE_TYPE_ID,
                   :new.VBA_QUERY_STATUS_TYPE_ID,
                   :new.STD_INSTITUTION_ID,
                   :new.VERIFICATION_METHOD_CODE,
                   :new.ELIGIBILITY_STATUS_DATE_TXT,
                   :new.VBA_QUERY_STATUS_DATE,
                   :new.VBA_QUERY_SENT_DATE,
                   :new.elgbty_Status_reason_id,
                   :new.elgbty_reason_explanation,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   mDML);
   END IF;
END ELIGIBILITY_VER_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_VERIFICATION FOR ADR.ELIGIBILITY_VERIFICATION;


ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067367
  CHECK ("ELIGIBILITY_VERIFICATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067368
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067369
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067370
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067371
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067372
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067373
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ELGBTYVRFY_PK
  PRIMARY KEY
  (ELIGIBILITY_VERIFICATION_ID)
  USING INDEX ADR.ELGBTYVRFY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVERIFI_REASONID_FK 
  FOREIGN KEY (ELGBTY_STATUS_REASON_ID) 
  REFERENCES ADR.ELIGIBILITY_STATUS_REASON (ELIGIBILITY_STATUS_REASON_ID)
  ENABLE VALIDATE,
  CONSTRAINT ELGBTYVRFY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ADREXT;

GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_VERIFICATION TO ADR_RW;

GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ES_R;

GRANT INSERT, SELECT ON ADR.ELIGIBILITY_VERIFICATION TO ES_RW;
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ELIGIBILITY_VERIFICATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ELIGIBILITY_VERIFICATION_H
(
  ELIGIBILITY_VERIFICATION_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  ELIGIBILITY_VERIFICATION_ID    NUMBER(20),
  PERSON_ID                      NUMBER(20),
  ELGBTY_STATUS_TYPE_ID          NUMBER(20),
  ELGBTY_VRFN_SOURCE_TYPE_ID     NUMBER(20),
  VBA_QUERY_STATUS_TYPE_ID       NUMBER(20),
  VBA_QUERY_STATUS_DATE          DATE,
  VBA_QUERY_SENT_DATE            DATE,
  STD_INSTITUTION_ID             NUMBER(20),
  VERIFICATION_METHOD_CODE       VARCHAR2(50 BYTE),
  ELIGIBILITY_STATUS_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  ELGBTY_STATUS_REASON_ID        NUMBER(20),
  ELGBTY_REASON_EXPLANATION      VARCHAR2(255 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ELIGIBILITY_VERIFICATION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.ELIGIBILITY_VERIFICATION_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.ELIGIBILITY_VERIFICATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.ELGBTY_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.ELGBTY_VRFN_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.VBA_QUERY_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.VBA_QUERY_STATUS_DATE IS 'Providesamigration targetforDATELAST UPDATEDATAAC (300.12/31)';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.VBA_QUERY_SENT_DATE IS 'Providesamigration targetforDatequery senttoAAC(300.12/33)';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.VERIFICATION_METHOD_CODE IS 'Codethatdescribes methodusedtoverify eligibility.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ELIGIBILITY_VERIFICATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ELGBTYVRFH_PK ON ADR.ELIGIBILITY_VERIFICATION_H
(ELIGIBILITY_VERIFICATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBTYVRFH_PRSNID_NU_I ON ADR.ELIGIBILITY_VERIFICATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_VERIFICATION_H FOR ADR.ELIGIBILITY_VERIFICATION_H;


ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_031
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066537
  CHECK ("ELIGIBILITY_VERIFICATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066538
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066539
  CHECK ("ELIGIBILITY_VERIFICATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066540
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066541
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066542
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066543
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066544
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066545
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ELGBTYVRFH_PK
  PRIMARY KEY
  (ELIGIBILITY_VERIFICATION_H_ID)
  USING INDEX ADR.ELGBTYVRFH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ADR_R;

GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ADR_RW;

GRANT SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ELIGIBILITY_VERIFICATION_H TO ES_RW;
ALTER TABLE ADR.EMAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMAIL
(
  EMAIL_ID                     NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20),
  INSURANCE_ID                 NUMBER(20),
  EMAIL_TYPE_ID                NUMBER(20),
  EMAIL_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  EMAIL_ADDRESS                VARCHAR2(128 BYTE) NOT NULL,
  CHANGE_EFFECTIVE_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMAIL IS 'The table contains email address(es) for a Person and also for an Insurance company Maintains all types of email addresses for Persons. Also stores Insurance Company email address. PERSON_ID Foreign key to the PERSON table. INSURANCE_ID Foreign key to the INSURANCE table. EMAIL_TYPE_ID Foreign key to the EMAIL_TYPE table. Indicates the type of email address (for example, Private, Business). DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMAIL.INSURANCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_ADDRESS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE INDEX ADR.EMAIL_INSURANCE_FK_I ON ADR.EMAIL
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EMAIL_PK ON ADR.EMAIL
(EMAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_PRSN_FK_I ON ADR.EMAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STDINST2_FK_I ON ADR.EMAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STDINST_FK_I ON ADR.EMAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STD_EMAILADDRTYP_FK_I ON ADR.EMAIL
(EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STD_EMAILCHGSRC_FK_I ON ADR.EMAIL
(EMAIL_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EMAIL_audir_trgr
after Update or Delete or Insert
ON ADR.EMAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EMAIL_H
		(
		EMAIL_H_ID,
		EMAIL_ID,
		PERSON_ID,
		INSURANCE_ID,
		EMAIL_TYPE_ID,
		EMAIL_ADDRESS,
		CHANGE_EFFECTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		STD_INSTITUTION_ID,
		EMAIL_CHANGE_SOURCE_TYPE_ID,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMAIL_H_S.nextval,
		:old.EMAIL_ID,
		:old.PERSON_ID,
		:old.INSURANCE_ID,
		:old.EMAIL_TYPE_ID,
		:old.EMAIL_ADDRESS,
		:old.CHANGE_EFFECTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.STD_INSTITUTION_ID,
		:old.EMAIL_CHANGE_SOURCE_TYPE_ID,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EMAIL_H
		(
		EMAIL_H_ID,
		EMAIL_ID,
		PERSON_ID,
		INSURANCE_ID,
		EMAIL_TYPE_ID,
		EMAIL_ADDRESS,
		CHANGE_EFFECTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		STD_INSTITUTION_ID,
		EMAIL_CHANGE_SOURCE_TYPE_ID,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMAIL_H_S.nextval,
		:new.EMAIL_ID,
		:new.PERSON_ID,
		:new.INSURANCE_ID,
		:new.EMAIL_TYPE_ID,
		:new.EMAIL_ADDRESS,
		:new.CHANGE_EFFECTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.STD_INSTITUTION_ID,
		:new.EMAIL_CHANGE_SOURCE_TYPE_ID,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;

end EMAIL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EMAIL FOR ADR.EMAIL;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_PK
  PRIMARY KEY
  (EMAIL_ID)
  USING INDEX ADR.EMAIL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT EMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.EMAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMAIL TO ADR_RW;

GRANT SELECT ON ADR.EMAIL TO ESCISSEEDINGUSR;

GRANT SELECT ON ADR.EMAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.EMAIL TO ES_RW;

GRANT SELECT ON ADR.EMAIL TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.EMAIL TO PSIM_ADR_RW;
ALTER TABLE ADR.EMAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMAIL_H
(
  EMAIL_H_ID                   NUMBER(20),
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE),
  EMAIL_ID                     NUMBER(20),
  PERSON_ID                    NUMBER(20),
  INSURANCE_ID                 NUMBER(20),
  EMAIL_TYPE_ID                NUMBER(20),
  EMAIL_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  EMAIL_ADDRESS                VARCHAR2(128 BYTE),
  CHANGE_EFFECTIVE_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EMAIL_H.EMAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EMAIL_H.EMAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMAIL_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMAIL_H.INSURANCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL_H.EMAIL_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL_H.EMAIL_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.EMAIL_H.EMAIL_ADDRESS IS 'Theemailaddressforthe personorinsurance company.';

COMMENT ON COLUMN ADR.EMAIL_H.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.EMAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.EMAIL_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.EMAILH_PK ON ADR.EMAIL_H
(EMAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAILH_PRSNID_NU_I ON ADR.EMAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EMAIL_H FOR ADR.EMAIL_H;


ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_076
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067583
  CHECK ("EMAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067584
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067585
  CHECK ("EMAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067586
  CHECK ("EMAIL_ADDRESS" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067587
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067588
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067589
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067590
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067591
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT EMAILH_PK
  PRIMARY KEY
  (EMAIL_H_ID)
  USING INDEX ADR.EMAILH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EMAIL_H TO ADR_R;

GRANT SELECT ON ADR.EMAIL_H TO ADR_RW;

GRANT SELECT ON ADR.EMAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EMAIL_H TO ES_RW;

GRANT SELECT ON ADR.EMAIL_H TO PSIM_ADR_R;
ALTER TABLE ADR.EMERGENCY_RESPONSE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMERGENCY_RESPONSE CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMERGENCY_RESPONSE
(
  EMERGENCY_RESPONSE_ID     NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_EMERGENCYRESPONSE_ID  NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMERGENCY_RESPONSE IS 'This feature instituted in the aftermath of Hurricane Katrina. Table lists details of any emergency response assistance provided to the Beneficiary.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.EMERGENCY_RESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.STD_EMERGENCYRESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EMERGRESP_PK ON ADR.EMERGENCY_RESPONSE
(EMERGENCY_RESPONSE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMERGRESP_PRSN_FK_I ON ADR.EMERGENCY_RESPONSE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMERGRESP_STDEMRGNCY_FK_I ON ADR.EMERGENCY_RESPONSE
(STD_EMERGENCYRESPONSE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EMERG_RESPONSE_AUDIR_TRGR
after Update or Delete or Insert
on ADR.EMERGENCY_RESPONSE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EMERGENCY_RESPONSE_H
		(
		EMERGENCY_RESPONSE_H_ID,
 		EMERGENCY_RESPONSE_ID,
		PERSON_ID,
		STD_EMERGENCYRESPONSE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMERGENCY_RESPONSE_H_S.nextval,
 		:old.EMERGENCY_RESPONSE_ID,
		:old.PERSON_ID,
		:old.STD_EMERGENCYRESPONSE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EMERGENCY_RESPONSE_H
		(
		EMERGENCY_RESPONSE_H_ID,
 		EMERGENCY_RESPONSE_ID,
		PERSON_ID,
		STD_EMERGENCYRESPONSE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMERGENCY_RESPONSE_H_S.nextval,
 		:new.EMERGENCY_RESPONSE_ID,
		:new.PERSON_ID,
		:new.STD_EMERGENCYRESPONSE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end emerg_response_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EMERGENCY_RESPONSE FOR ADR.EMERGENCY_RESPONSE;


ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_ID)
  USING INDEX ADR.EMERGRESP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ADREXT;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMERGENCY_RESPONSE TO ADR_RW;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ES_R;

GRANT INSERT, SELECT ON ADR.EMERGENCY_RESPONSE TO ES_RW;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMERGENCY_RESPONSE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMERGENCY_RESPONSE_H
(
  EMERGENCY_RESPONSE_H_ID   NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  EMERGENCY_RESPONSE_ID     NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_EMERGENCYRESPONSE_ID  NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMERGENCY_RESPONSE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.EMERGENCY_RESPONSE_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.EMERGENCY_RESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.STD_EMERGENCYRESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EMERGRESH_PK ON ADR.EMERGENCY_RESPONSE_H
(EMERGENCY_RESPONSE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMERGRESH_PRSNID_NU_I ON ADR.EMERGENCY_RESPONSE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EMERGENCY_RESPONSE_H FOR ADR.EMERGENCY_RESPONSE_H;


ALTER TABLE ADR.EMERGENCY_RESPONSE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_025
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EMERGRESH_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_H_ID)
  USING INDEX ADR.EMERGRESH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ADR_R;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ADR_RW;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EMERGENCY_RESPONSE_H TO ES_RW;
ALTER TABLE ADR.EMPLOYMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMPLOYMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMPLOYMENT
(
  EMPLOYMENT_ID                 NUMBER(20),
  PERSON_ID                     NUMBER(20),
  PERSON_RELATION_ID            NUMBER(20),
  STD_EMPLOYMENTSTATUS_ID       NUMBER(20),
  EMPLOYEE_OCCUPATION           VARCHAR2(50 BYTE),
  EMPLOYER_FULL_NAME            VARCHAR2(100 BYTE),
  PHONE_NUMBER                  VARCHAR2(128 BYTE),
  ADDRESS_LINE1                 VARCHAR2(100 BYTE),
  ADDRESS_LINE2                 VARCHAR2(100 BYTE),
  ADDRESS_LINE3                 VARCHAR2(100 BYTE),
  CITY                          VARCHAR2(60 BYTE),
  STATE_CODE                    VARCHAR2(50 BYTE),
  COUNTY_CODE                   VARCHAR2(50 BYTE),
  PROVINCE_CODE                 VARCHAR2(50 BYTE),
  ZIP_CODE                      VARCHAR2(20 BYTE),
  ZIP_PLUS_4                    VARCHAR2(10 BYTE),
  POSTAL_CODE                   VARCHAR2(20 BYTE),
  COUNTRY_CODE                  VARCHAR2(50 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10),
  EMPLOYEE_RETIREMENT_DATE_TXT  VARCHAR2(14 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMPLOYMENT IS 'Stores Employer name and address, and also the Employee details such as Employment status and occupation';

COMMENT ON COLUMN ADR.EMPLOYMENT.EMPLOYMENT_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.EMPLOYMENT.STD_EMPLOYMENTSTATUS_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.EMPLOYMENT.EMPLOYEE_OCCUPATION IS 'Full Name';

COMMENT ON COLUMN ADR.EMPLOYMENT.EMPLOYER_FULL_NAME IS 'Full Name';

COMMENT ON COLUMN ADR.EMPLOYMENT.ADDRESS_LINE1 IS 'The free text form of the number and street or post office box of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.ADDRESS_LINE2 IS 'The free text supplemental to the number and street of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.ADDRESS_LINE3 IS 'The free text supplemental to the number and street of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.CITY IS 'The name of a city used for an address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.STATE_CODE IS 'FIPS STATE CODE is defined as the 2 characters FIPS State code. The FIPS State code is the first two characters of the 5-character FIPS code. The FIPS state code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is Required, it is associated with the Facility address in which the primary MT was supplied.
  2  State code is defines as the unique country code / state abbreviation combination found in the database that best identifies the state';

COMMENT ON COLUMN ADR.EMPLOYMENT.COUNTY_CODE IS 'FIPS County CODE is defined as the last 3 characters of the FIPS state/county code.  The FIPS county code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is required, it is associated with the Facility address  in which the primary MT was supplied
  2  5-DIGIT FIPS CODE is defined as the 2 digit state code + 3 digit county code. This 5 digit FIPS code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is required, it is associated with the Facility address  in which the primary MT was supplied';

COMMENT ON COLUMN ADR.EMPLOYMENT.ZIP_CODE IS 'Postal code is defined as the mail code used for mail delivery to a country other than the USA only.
  2  Acceptable format is free Text 5 - 10 characters.';

COMMENT ON COLUMN ADR.EMPLOYMENT.POSTAL_CODE IS 'Postal code is defined as the mail code used for mail delivery to a country other than the USA only.
  2  Acceptable format is free Text 5 - 10 characters.';

COMMENT ON COLUMN ADR.EMPLOYMENT.COUNTRY_CODE IS 'Country is defined as the unique identifier assigned by the International Organization of Standardization for a country.';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EMPLOY_EMPTSTAT_FK_I ON ADR.EMPLOYMENT
(STD_EMPLOYMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EMPLOY_PK ON ADR.EMPLOYMENT
(EMPLOYMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMPLOY_PRSNREL_FK_I ON ADR.EMPLOYMENT
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMPLOY_PRSN_FK_I ON ADR.EMPLOYMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EMPLOYMENT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."EMPLOYMENT" FOR EACH ROW
declare
    mDML char(1);
begin

  if DELETING then
    insert into EMPLOYMENT_H
    (
    EMPLOYMENT_H_ID,
    EMPLOYMENT_ID,
    PERSON_ID,
    PERSON_RELATION_ID,
    STD_EMPLOYMENTSTATUS_ID,
    EMPLOYEE_OCCUPATION,
    EMPLOYER_FULL_NAME,
    PHONE_NUMBER,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    CITY,
    STATE_CODE,
    COUNTY_CODE,
    PROVINCE_CODE,
    ZIP_CODE,
    ZIP_PLUS_4,
    POSTAL_CODE,
    COUNTRY_CODE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    EMPLOYEE_RETIREMENT_DATE_TXT,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    EMPLOYMENT_h_s.nextval,
    :old.EMPLOYMENT_ID ,
    :old.PERSON_ID,
    :old.PERSON_RELATION_ID,
    :old.STD_EMPLOYMENTSTATUS_ID,
    :old.EMPLOYEE_OCCUPATION,
    :old.EMPLOYER_FULL_NAME,
    :old.PHONE_NUMBER,
    :old.ADDRESS_LINE1,
    :old.ADDRESS_LINE2,
    :old.ADDRESS_LINE3,
    :old.CITY,
    :old.STATE_CODE,
    :old.COUNTY_CODE,
    :old.PROVINCE_CODE,
    :old.ZIP_CODE,
    :old.ZIP_PLUS_4,
    :old.POSTAL_CODE,
    :old.COUNTRY_CODE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY ,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    :old.EMPLOYEE_RETIREMENT_DATE_TXT,
    'D'
    );


  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;
    insert into EMPLOYMENT_H
    (
    EMPLOYMENT_H_ID,
    EMPLOYMENT_ID,
    PERSON_ID,
    PERSON_RELATION_ID,
    STD_EMPLOYMENTSTATUS_ID,
    EMPLOYEE_OCCUPATION,
    EMPLOYER_FULL_NAME,
    PHONE_NUMBER,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    CITY,
    STATE_CODE,
    COUNTY_CODE,
    PROVINCE_CODE,
    ZIP_CODE,
    ZIP_PLUS_4,
    POSTAL_CODE,
    COUNTRY_CODE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    EMPLOYEE_RETIREMENT_DATE_TXT,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    EMPLOYMENT_h_s.nextval,
    :new.EMPLOYMENT_ID ,
    :new.PERSON_ID,
    :new.PERSON_RELATION_ID,
    :new.STD_EMPLOYMENTSTATUS_ID,
    :new.EMPLOYEE_OCCUPATION,
    :new.EMPLOYER_FULL_NAME,
    :new.PHONE_NUMBER,
    :new.ADDRESS_LINE1,
    :new.ADDRESS_LINE2,
    :new.ADDRESS_LINE3,
    :new.CITY,
    :new.STATE_CODE,
    :new.COUNTY_CODE,
    :new.PROVINCE_CODE,
    :new.ZIP_CODE,
    :new.ZIP_PLUS_4,
    :new.POSTAL_CODE,
    :new.COUNTRY_CODE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY ,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    :new.EMPLOYEE_RETIREMENT_DATE_TXT,
    mDML
    );



  end if;

end EMPLOYMENT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EMPLOYMENT FOR ADR.EMPLOYMENT;


ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106532
  CHECK ("EMPLOYMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106534
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106535
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106536
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106537
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106538
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT EMPLOY_PK
  PRIMARY KEY
  (EMPLOYMENT_ID)
  USING INDEX ADR.EMPLOY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT EMPLOY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.EMPLOYMENT TO ADREXT;

GRANT SELECT ON ADR.EMPLOYMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMPLOYMENT TO ADR_RW;

GRANT SELECT ON ADR.EMPLOYMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.EMPLOYMENT TO ES_RW;
ALTER TABLE ADR.EMPLOYMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMPLOYMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMPLOYMENT_H
(
  EMPLOYMENT_H_ID               NUMBER(20),
  EMPLOYMENT_ID                 NUMBER(20),
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE),
  PERSON_ID                     NUMBER(20),
  PERSON_RELATION_ID            NUMBER(20),
  STD_EMPLOYMENTSTATUS_ID       NUMBER(20),
  EMPLOYEE_OCCUPATION           VARCHAR2(50 BYTE),
  EMPLOYER_FULL_NAME            VARCHAR2(100 BYTE),
  PHONE_NUMBER                  VARCHAR2(128 BYTE),
  ADDRESS_LINE1                 VARCHAR2(100 BYTE),
  ADDRESS_LINE2                 VARCHAR2(100 BYTE),
  ADDRESS_LINE3                 VARCHAR2(100 BYTE),
  CITY                          VARCHAR2(60 BYTE),
  STATE_CODE                    VARCHAR2(50 BYTE),
  COUNTY_CODE                   VARCHAR2(50 BYTE),
  PROVINCE_CODE                 VARCHAR2(50 BYTE),
  ZIP_CODE                      VARCHAR2(20 BYTE),
  ZIP_PLUS_4                    VARCHAR2(10 BYTE),
  POSTAL_CODE                   VARCHAR2(20 BYTE),
  COUNTRY_CODE                  VARCHAR2(50 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10),
  EMPLOYEE_RETIREMENT_DATE_TXT  VARCHAR2(14 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMPLOYMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.EMPLOYMENT_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.EMPLOYEE_OCCUPATION IS 'Full Name';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.EMPLOYER_FULL_NAME IS 'Full Name';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.ADDRESS_LINE1 IS 'The free text form of the number and street or post office box of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.ADDRESS_LINE2 IS 'The free text supplemental to the number and street of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.ADDRESS_LINE3 IS 'The free text supplemental to the number and street of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.CITY IS 'The name of a city used for an address.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.STATE_CODE IS 'FIPS STATE CODE is defined as the 2 characters FIPS State code. The FIPS State code is the first two characters of the 5-character FIPS code. The FIPS state code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is Required, it is associated with the Facility address in which the primary MT was supplied.
  2  State code is defines as the unique country code / state abbreviation combination found in the database that best identifies the state';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.COUNTY_CODE IS 'FIPS County CODE is defined as the last 3 characters of the FIPS state/county code.  The FIPS county code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is required, it is associated with the Facility address  in which the primary MT was supplied
  2  5-DIGIT FIPS CODE is defined as the 2 digit state code + 3 digit county code. This 5 digit FIPS code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is required, it is associated with the Facility address  in which the primary MT was supplied';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.ZIP_CODE IS 'Postal code is defined as the mail code used for mail delivery to a country other than the USA only.
  2  Acceptable format is free Text 5 - 10 characters.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.POSTAL_CODE IS 'Postal code is defined as the mail code used for mail delivery to a country other than the USA only.
  2  Acceptable format is free Text 5 - 10 characters.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.COUNTRY_CODE IS 'Country is defined as the unique identifier assigned by the International Organization of Standardization for a country.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMPLOYMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EMPLOYH_PK ON ADR.EMPLOYMENT_H
(EMPLOYMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMPLOY_H_PRSNREL_FK_I ON ADR.EMPLOYMENT_H
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMPLOY_H_PRSN_FK_I ON ADR.EMPLOYMENT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EMPLOYMENT_H FOR ADR.EMPLOYMENT_H;


ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT EMPLOYMENT_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106539
  CHECK ("EMPLOYMENT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106540
  CHECK ("EMPLOYMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106541
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106542
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106543
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106544
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106545
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106546
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT EMPLOYH_PK
  PRIMARY KEY
  (EMPLOYMENT_H_ID)
  USING INDEX ADR.EMPLOYH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EMPLOYMENT_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMPLOYMENT_H TO ADR_RW;

GRANT SELECT ON ADR.EMPLOYMENT_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EMPLOYMENT_H TO ES_RW;
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ENROLLMENT_DETERMINATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.ENROLLMENT_DETERMINATION
(
  ENROLLMENT_DETERMINATION_ID  NUMBER(20),
  PERSON_ID                    NUMBER(20),
  EGT_SETTING_ID               NUMBER(20),
  STD_ENROLLMENTSTATUS_ID      NUMBER(20),
  ENROLLMENT_DATA_SRC_TYPE_ID  NUMBER(20),
  PRIORITY_GROUP_TYPE_ID       NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID   NUMBER(20),
  APPLICATION_SITE_ID          NUMBER(20),
  ENROLLMENT_APPLICATION_DATE  DATE,
  ENROLLMENT_START_DATE        DATE,
  ENROLLMENT_END_DATE          DATE,
  CHANGE_EFFECTIVE_DATE        DATE,
  ENROLLMENT_OVERRIDDEN_FLAG   NUMBER(1)        DEFAULT 0,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  STD_ENROLLMENTPRIORGRP_ID    NUMBER(20),
  STD_ENROLLMENTPRIORSGRP_ID   NUMBER(20),
  CLOSE_APL_RSN_TYPE_ID        NUMBER(20),
  CLOSE_APP_REMARKS            VARCHAR2(4000 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ENROLLMENT_DETERMINATION IS 'The table stores data about a persons enrollment into the VHA Healthcare System, including information about when the application was submitted, when the enrollment started and ended, what priority group the person was in. There is also status and change information, as well as an indicator to show if the enrollment has been overridden. PERSON_ID Foreign key to the PERSON table. ENROLLMENT_STATUS_TYPE_ID Foreign key to the ENROLLMENT_STATUS_TYPE table. Indicates the status of a persons enrollment (for example, Verified, Rejected). ENROLLMENT_DATA_SRC_TYPE_ID Foreign key to the ENROLLMENT_DATA_SRC_TYPE table. Indicates the source of data for a persons enrollment (for example, HEC, VAMC). PRIORITY_GROUP_TYPE_ID Foreign key to the PRIORITY_GROUP_TYPE table. Indicates the Enrollment Priority Group the person falls into (Group 1 through Group 8). PRIORITY_SUB_GROUP_TYPE_ID Foreign key to the PRIORITY_SUB_GROUP_TYPE table. Indicates the Enrollment Priority Group the person falls into (for example, a, c). APPLICATION_SITE_ID Foreign key to the STD_INSTITUTION table. Indicates the site at which the application was initiated. EGT_SETTING_ID Foreign key to the EGT_SETTING table. Indicates the current EGT setting. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_DATA_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.APPLICATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_APPLICATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_OVERRIDDEN_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.CLOSE_APP_REMARKS IS 'Text including any additional information for the action on close application';


CREATE INDEX ADR.ENRLMNTDET_EGTSETTING_FK_I ON ADR.ENROLLMENT_DETERMINATION
(EGT_SETTING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ENRLMNTDET_PK ON ADR.ENROLLMENT_DETERMINATION
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_PRSN_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STDINST_FK_I ON ADR.ENROLLMENT_DETERMINATION
(APPLICATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLPGRP_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLPSGRP_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLSRC_FK_I ON ADR.ENROLLMENT_DETERMINATION
(ENROLLMENT_DATA_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLSTAT_FK_I ON ADR.ENROLLMENT_DETERMINATION
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ENROLLMENT_DETER_AUDIR_TRGR
    AFTER UPDATE OR DELETE OR INSERT
    ON ADR.ENROLLMENT_DETERMINATION
    FOR EACH ROW
DECLARE
    Mdml   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.Enrollment_Determination_H (Enrollment_determination_h_id,
                                                    Enrollment_determination_id,
                                                    Person_id,
                                                    Std_enrollmentstatus_id,
                                                    Enrollment_data_src_type_id,
                                                    Priority_group_type_id,
                                                    Priority_sub_group_type_id,
                                                    Application_site_id,
                                                    Egt_setting_id,
                                                    Enrollment_application_date,
                                                    Enrollment_start_date,
                                                    Enrollment_end_date,
                                                    Change_effective_date,
                                                    Enrollment_overridden_flag,
                                                    Record_created_by,
                                                    Record_created_date,
                                                    Record_modified_by,
                                                    Record_modified_date,
                                                    Record_modified_count,
                                                    Transaction_type_code,
                                                    Std_enrollmentpriorgrp_id,
                                                    Std_enrollmentpriorsgrp_id,
                                                    CLOSE_APL_RSN_TYPE_ID,
                                                         CLOSE_APP_REMARKS
)
             VALUES (ADR.Enrollment_determination_h_s.NEXTVAL,
                     :OLD.Enrollment_determination_id,
                     :OLD.Person_id,
                     :OLD.Std_enrollmentstatus_id,
                     :OLD.Enrollment_data_src_type_id,
                     :OLD.Priority_group_type_id,
                     :OLD.Priority_sub_group_type_id,
                     :OLD.Application_site_id,
                     :OLD.Egt_setting_id,
                     :OLD.Enrollment_application_date,
                     :OLD.Enrollment_start_date,
                     :OLD.Enrollment_end_date,
                     :OLD.Change_effective_date,
                     :OLD.Enrollment_overridden_flag,
                     :OLD.Record_created_by,
                     :OLD.Record_created_date,
                     :OLD.Record_modified_by,
                     :OLD.Record_modified_date,
                     :OLD.Record_modified_count,
                     'D',
                     :OLD.Std_enrollmentpriorgrp_id,
                     :OLD.Std_enrollmentpriorsgrp_id,
                     :OLD.CLOSE_APL_RSN_TYPE_ID,
                     :OLD.CLOSE_APP_REMARKS);
    ELSE
        IF UPDATING
        THEN
            Mdml := 'U';
        ELSE
            Mdml := 'I';
        END IF;

        INSERT INTO ADR.Enrollment_Determination_H (Enrollment_determination_h_id,
                                                    Enrollment_determination_id,
                                                    Person_id,
                                                    Std_enrollmentstatus_id,
                                                    Enrollment_data_src_type_id,
                                                    Priority_group_type_id,
                                                    Priority_sub_group_type_id,
                                                    Application_site_id,
                                                    Egt_setting_id,
                                                    Enrollment_application_date,
                                                    Enrollment_start_date,
                                                    Enrollment_end_date,
                                                    Change_effective_date,
                                                    Enrollment_overridden_flag,
                                                    Record_created_by,
                                                    Record_created_date,
                                                    Record_modified_by,
                                                    Record_modified_date,
                                                    Record_modified_count,
                                                    Transaction_type_code,
                                                    Std_enrollmentpriorgrp_id,
                                                    Std_enrollmentpriorsgrp_id,
                                                    CLOSE_APL_RSN_TYPE_ID,
                                                         CLOSE_APP_REMARKS)
             VALUES (ADR.Enrollment_determination_h_s.NEXTVAL,
                     :NEW.Enrollment_determination_id,
                     :NEW.Person_id,
                     :NEW.Std_enrollmentstatus_id,
                     :NEW.Enrollment_data_src_type_id,
                     :NEW.Priority_group_type_id,
                     :NEW.Priority_sub_group_type_id,
                     :NEW.Application_site_id,
                     :NEW.Egt_setting_id,
                     :NEW.Enrollment_application_date,
                     :NEW.Enrollment_start_date,
                     :NEW.Enrollment_end_date,
                     :NEW.Change_effective_date,
                     :NEW.Enrollment_overridden_flag,
                     :NEW.Record_created_by,
                     :NEW.Record_created_date,
                     :NEW.Record_modified_by,
                     :NEW.Record_modified_date,
                     :NEW.Record_modified_count,
                     Mdml,
                     :NEW.Std_enrollmentpriorgrp_id,
                     :NEW.Std_enrollmentpriorsgrp_id,
                     :NEW.CLOSE_APL_RSN_TYPE_ID,
                     :NEW.CLOSE_APP_REMARKS);
    END IF;
END ENROLLMENT_DETER_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_DETERMINATION FOR ADR.ENROLLMENT_DETERMINATION;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_ENROL_000
  CHECK (ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 0
AND 0 OR ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067374
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067375
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067376
  CHECK ("EGT_SETTING_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067377
  CHECK ("ENROLLMENT_OVERRIDDEN_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067378
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067379
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067380
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067381
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067382
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ENRLMNTDET_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_ID)
  USING INDEX ADR.ENRLMNTDET_PK
  ENABLE VALIDATE,
  CONSTRAINT PERSON_ID_UK
  UNIQUE (PERSON_ID)
  USING INDEX ADR.ENRLMNTDET_PRSN_FK_I
  ENABLE NOVALIDATE);

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_ID_FK 
  FOREIGN KEY (CLOSE_APL_RSN_TYPE_ID) 
  REFERENCES ADR.CLOSE_APL_RSN_TYPE (CLOSE_APL_RSN_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT ENRLMNTDET_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT ENRLMNTDET_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADREXT;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADRTMP;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ENROLLMENT_DETERMINATION TO ADR_RW;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO BIZFLOW_R;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ES_R;

GRANT INSERT, SELECT ON ADR.ENROLLMENT_DETERMINATION TO ES_RW;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO PSIM;
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ENROLLMENT_DETERMINATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ENROLLMENT_DETERMINATION_H
(
  ENROLLMENT_DETERMINATION_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  ENROLLMENT_DETERMINATION_ID    NUMBER(20),
  PERSON_ID                      NUMBER(20),
  STD_ENROLLMENTSTATUS_ID        NUMBER(20),
  ENROLLMENT_DATA_SRC_TYPE_ID    NUMBER(20),
  PRIORITY_GROUP_TYPE_ID         NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID     NUMBER(20),
  APPLICATION_SITE_ID            NUMBER(20),
  EGT_SETTING_ID                 NUMBER(20),
  ENROLLMENT_APPLICATION_DATE    DATE,
  ENROLLMENT_START_DATE          DATE,
  ENROLLMENT_END_DATE            DATE,
  CHANGE_EFFECTIVE_DATE          DATE,
  ENROLLMENT_OVERRIDDEN_FLAG     NUMBER(1)      DEFAULT 0,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  STD_ENROLLMENTPRIORGRP_ID      NUMBER(20),
  STD_ENROLLMENTPRIORSGRP_ID     NUMBER(20),
  CLOSE_APL_RSN_TYPE_ID          NUMBER(20),
  CLOSE_APP_REMARKS              VARCHAR2(4000 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ENROLLMENT_DETERMINATION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_DETERMINATION_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_DETERMINATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_DATA_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.APPLICATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.EGT_SETTING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_APPLICATION_DATE IS 'BR2260Enrollment ApplicationDateis definedasthedateof theapplicationfor enrollment.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_START_DATE IS 'BR2240EnrollmentDateis definedashestarting dateforthisenrollment.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_END_DATE IS 'BR7771Theenrollmentend dateisdefinedasthe enddateofthispersons enrollment.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.ENROLLMENT_OVERRIDDEN_FLAG IS 'BR7458Enrollment OverrideFlagisdefined asaflagthatwhenset willinitiatethere- calculationofa veteransenrollment priority.Itisusedin thosecaseswherea veteranmayhavebeen placedinaRejected; StopNewEnrollmentsOR Rejected;Below EnrollmentGroup ThresholdEnrollment statuses.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION_H.CLOSE_APP_REMARKS IS ' Text including any additional information for the action on close application';


CREATE INDEX ADR.ENRLMNTDEH_ENRLMNTDET_NU_I ON ADR.ENROLLMENT_DETERMINATION_H
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ENRLMNTDEH_PK ON ADR.ENROLLMENT_DETERMINATION_H
(ENROLLMENT_DETERMINATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDEH_PRSNID_NU_I ON ADR.ENROLLMENT_DETERMINATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_DETERMINATION_H FOR ADR.ENROLLMENT_DETERMINATION_H;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_054
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066981
  CHECK ("ENROLLMENT_DETERMINATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066982
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066983
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066984
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066985
  CHECK ("EGT_SETTING_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066986
  CHECK ("ENROLLMENT_OVERRIDDEN_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066987
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066988
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066989
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066990
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066991
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ENRLMNTDEH_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_H_ID)
  USING INDEX ADR.ENRLMNTDEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ADREXT;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ADR_R;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ADR_RW;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ENROLLMENT_DETERMINATION_H TO ES_RW;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ENROLLMENT_OVERRIDE CASCADE CONSTRAINTS;

CREATE TABLE ADR.ENROLLMENT_OVERRIDE
(
  ENROLLMENT_OVERRIDE_ID        NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  OVERRIDE_FLAG                 NUMBER(1)       DEFAULT 0,
  OVERRIDE_DATE                 DATE,
  STD_ENROLLMENTOVERRIDERSN_ID  NUMBER(20),
  REMARKS                       VARCHAR2(80 BYTE),
  OVERRIDE_CREATED_USER         VARCHAR2(30 BYTE),
  OVERRIDE_CREATED_DATE         DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ENROLLMENT_OVERRIDE IS 'The table contains a set of attributes stored in the database for the override instruction. The override instruction documents whether or not to override a persons enrollment. PERSON_ID Foreign key to the PERSON table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.ENROLLMENT_OVERRIDE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.OVERRIDE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.OVERRIDE_DATE IS 'Dateonwhichapersons enrollmentwas overridden.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.OVERRIDE_CREATED_USER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.OVERRIDE_CREATED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ENROLOVER_PK ON ADR.ENROLLMENT_OVERRIDE
(ENROLLMENT_OVERRIDE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLOVER_PRSN_FK_I ON ADR.ENROLLMENT_OVERRIDE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLOVER_STDENROVRD_FK_I ON ADR.ENROLLMENT_OVERRIDE
(STD_ENROLLMENTOVERRIDERSN_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ENROLLMENT_OVER_AUDIR_TRGR
after Update or Delete or Insert
on ADR.ENROLLMENT_OVERRIDE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ENROLLMENT_OVERRIDE_H
		(
		ENROLLMENT_OVERRIDE_H_ID,
		ENROLLMENT_OVERRIDE_ID,
		PERSON_ID,
		OVERRIDE_FLAG,
		OVERRIDE_DATE,
		STD_ENROLLMENTOVERRIDERSN_ID,
		REMARKS,
		OVERRIDE_CREATED_USER,
		OVERRIDE_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ENROLLMENT_OVERRIDE_H_S.nextval,
		:old.ENROLLMENT_OVERRIDE_ID,
		:old.PERSON_ID,
		:old.OVERRIDE_FLAG,
		:old.OVERRIDE_DATE,
		:old.STD_ENROLLMENTOVERRIDERSN_ID,
		:old.REMARKS,
		:old.OVERRIDE_CREATED_USER,
		:old.OVERRIDE_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ENROLLMENT_OVERRIDE_H
		(
		ENROLLMENT_OVERRIDE_H_ID,
		ENROLLMENT_OVERRIDE_ID,
		PERSON_ID,
		OVERRIDE_FLAG,
		OVERRIDE_DATE,
		STD_ENROLLMENTOVERRIDERSN_ID,
		REMARKS,
		OVERRIDE_CREATED_USER,
		OVERRIDE_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ENROLLMENT_OVERRIDE_H_S.nextval,
		:new.ENROLLMENT_OVERRIDE_ID,
		:new.PERSON_ID,
		:new.OVERRIDE_FLAG,
		:new.OVERRIDE_DATE,
		:new.STD_ENROLLMENTOVERRIDERSN_ID,
		:new.REMARKS,
		:new.OVERRIDE_CREATED_USER,
		:new.OVERRIDE_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  ENROLLMENT_OVER_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_OVERRIDE FOR ADR.ENROLLMENT_OVERRIDE;


ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT AVCON_1172521913_OVERR_000
  CHECK (OVERRIDE_FLAG BETWEEN 0 AND 0 OR OVERRIDE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT ENROLOVER_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_ID)
  USING INDEX ADR.ENROLOVER_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT ENROLOVER_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE TO ADREXT;

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ENROLLMENT_OVERRIDE TO ADR_RW;

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE TO ES_R;

GRANT INSERT, SELECT ON ADR.ENROLLMENT_OVERRIDE TO ES_RW;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ENROLLMENT_OVERRIDE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ENROLLMENT_OVERRIDE_H
(
  ENROLLMENT_OVERRIDE_H_ID      NUMBER(20)      NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  ENROLLMENT_OVERRIDE_ID        NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_ENROLLMENTOVERRIDERSN_ID  NUMBER(20),
  OVERRIDE_FLAG                 NUMBER(1)       DEFAULT 0,
  OVERRIDE_DATE                 DATE,
  REMARKS                       VARCHAR2(80 BYTE),
  OVERRIDE_CREATED_USER         VARCHAR2(30 BYTE),
  OVERRIDE_CREATED_DATE         DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ENROLLMENT_OVERRIDE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.ENROLLMENT_OVERRIDE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_FLAG IS 'Flagusedtoindicate thatapersons enrollmenthasbeen overridden.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_DATE IS 'Dateonwhichapersons enrollmentwas overridden.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_CREATED_USER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_CREATED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ENROLOVERH_PK ON ADR.ENROLLMENT_OVERRIDE_H
(ENROLLMENT_OVERRIDE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLOVERH_PRSNID_NU_I ON ADR.ENROLLMENT_OVERRIDE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_OVERRIDE_H FOR ADR.ENROLLMENT_OVERRIDE_H;


ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_039
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ENROLOVERH_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_H_ID)
  USING INDEX ADR.ENROLOVERH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ADR_R;

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ADR_RW;

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ES_RW;
ALTER TABLE ADR.FEE_BASIS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FEE_BASIS CASCADE CONSTRAINTS;

CREATE TABLE ADR.FEE_BASIS
(
  FEE_BASIS_ID                 NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  FEE_BASIS_PROGRAM_TYPE_ID    NUMBER(20),
  FEE_BASIS_TREATMENT_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  AUTHORIZATION_FROM_DATE      DATE,
  AUTHORIZATION_TO_DATE        DATE,
  FEE_BASIS_REPORT_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FEE_BASIS IS 'The table stores information about persons who use medical services outside the VHA, but paid for by the VHA because it is not feasible economically for care to be provided due to geographical inaccessibility. PERSON_ID Foreign key to the PERSON table. FEE_BASIS_PROGRAM_TYPE_ID Foreign key to the FEE_BASIS_PROGRAM_TYPE table. Indicates the type of fee basis program associated with the person (for example, Pharmacy, Outpatient). FEE_BASIS_TREATMENT_TYPE_ID Foreign key to the FEE_BASIS_TREATMENT_TYPE table. Indicates the applicable type of treatment for the fee basis program (for example, Short Term Fee Status, Home Nursing Services). STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_PROGRAM_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_TREATMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.FEE_BASIS.AUTHORIZATION_FROM_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.AUTHORIZATION_TO_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_REPORT_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FEEBASIS_PK ON ADR.FEE_BASIS
(FEE_BASIS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBASIS_PRSN_FK_I ON ADR.FEE_BASIS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBASIS_STDINST_FK_I ON ADR.FEE_BASIS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBSIS_STD_FEEBSISPROG_FK_I ON ADR.FEE_BASIS
(FEE_BASIS_PROGRAM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBSIS_STD_FEEBSISTRTMT_FK_I ON ADR.FEE_BASIS
(FEE_BASIS_TREATMENT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FEE_BASIS_audir_trgr
after Update or Delete or Insert
ON ADR.FEE_BASIS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FEE_BASIS_H
		(
		FEE_BASIS_H_ID,
		FEE_BASIS_ID,
		PERSON_ID,
		FEE_BASIS_PROGRAM_TYPE_ID,
		FEE_BASIS_TREATMENT_TYPE_ID,
		STD_INSTITUTION_ID,
		AUTHORIZATION_FROM_DATE,
		AUTHORIZATION_TO_DATE,
		FEE_BASIS_REPORT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FEE_BASIS_H_S.nextval,
		:old.FEE_BASIS_ID,
		:old.PERSON_ID,
		:old.FEE_BASIS_PROGRAM_TYPE_ID,
		:old.FEE_BASIS_TREATMENT_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.AUTHORIZATION_FROM_DATE,
		:old.AUTHORIZATION_TO_DATE,
		:old.FEE_BASIS_REPORT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FEE_BASIS_H
		(
		FEE_BASIS_H_ID,
		FEE_BASIS_ID,
		PERSON_ID,
		FEE_BASIS_PROGRAM_TYPE_ID,
		FEE_BASIS_TREATMENT_TYPE_ID,
		STD_INSTITUTION_ID,
		AUTHORIZATION_FROM_DATE,
		AUTHORIZATION_TO_DATE,
		FEE_BASIS_REPORT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FEE_BASIS_H_S.nextval,
		:new.FEE_BASIS_ID,
		:new.PERSON_ID,
		:new.FEE_BASIS_PROGRAM_TYPE_ID,
		:new.FEE_BASIS_TREATMENT_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.AUTHORIZATION_FROM_DATE,
		:new.AUTHORIZATION_TO_DATE,
		:new.FEE_BASIS_REPORT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FEE_BASIS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FEE_BASIS FOR ADR.FEE_BASIS;


ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PK
  PRIMARY KEY
  (FEE_BASIS_ID)
  USING INDEX ADR.FEEBASIS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FEE_BASIS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FEE_BASIS TO ADR_RW;

GRANT SELECT ON ADR.FEE_BASIS TO ES_R;

GRANT INSERT, SELECT ON ADR.FEE_BASIS TO ES_RW;
ALTER TABLE ADR.FEE_BASIS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FEE_BASIS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FEE_BASIS_H
(
  FEE_BASIS_H_ID               NUMBER(20),
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE),
  FEE_BASIS_ID                 NUMBER(20),
  PERSON_ID                    NUMBER(20),
  FEE_BASIS_PROGRAM_TYPE_ID    NUMBER(20),
  FEE_BASIS_TREATMENT_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  AUTHORIZATION_FROM_DATE      DATE,
  AUTHORIZATION_TO_DATE        DATE,
  FEE_BASIS_REPORT_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FEE_BASIS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.FEE_BASIS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.FEE_BASIS_PROGRAM_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.FEE_BASIS_TREATMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.FEE_BASIS_H.AUTHORIZATION_FROM_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.AUTHORIZATION_TO_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FEEBASISH_PK ON ADR.FEE_BASIS_H
(FEE_BASIS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBASISH_PRSNID_NU_I ON ADR.FEE_BASIS_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FEE_BASIS_H FOR ADR.FEE_BASIS_H;


ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_030
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066528
  CHECK ("FEE_BASIS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066529
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066530
  CHECK ("FEE_BASIS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066531
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066532
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066533
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066534
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066535
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066536
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FEEBASISH_PK
  PRIMARY KEY
  (FEE_BASIS_H_ID)
  USING INDEX ADR.FEEBASISH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FEE_BASIS_H TO ADR_R;

GRANT SELECT ON ADR.FEE_BASIS_H TO ADR_RW;

GRANT SELECT ON ADR.FEE_BASIS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FEE_BASIS_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_ASSET_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_ASSET_DETAIL
(
  FINANCIAL_ASSET_DETAIL_ID  NUMBER(20),
  FINANCIAL_STATEMENT_ID     NUMBER(20),
  FINANCIAL_ASSET_TYPE_ID    NUMBER(20),
  GROSS_AMOUNT               NUMBER(10,2),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE        DATE,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE       DATE,
  RECORD_MODIFIED_COUNT      NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_ASSET_DETAIL IS 'The FINANCIAL_ASSET_DETAIL table is a child table of the FINANCIAL_STATEMENT table that provides detailed amounts for different types of monetary assets a person has that would have an impact on their eligibility to enroll for VHA medical benefits. FINANCIAL_STATEMENT_ID Foreign key to the FINANCIAL_STATEMENT table. FINANCIAL_ASSET_TYPE_ID Foreign key to the FINANCIAL_ASSET_TYPE table. Indicates the kind of financial asset being documented (for example, Cash, Real Estate). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.FINANCIAL_ASSET_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.FINANCIAL_ASSET_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.GROSS_AMOUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.FINASTDTL_FINSTATE_FK_I ON ADR.FINANCIAL_ASSET_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINASTDTL_PK ON ADR.FINANCIAL_ASSET_DETAIL
(FINANCIAL_ASSET_DETAIL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINASTDTL_STD_ASSTTYP_FK_I ON ADR.FINANCIAL_ASSET_DETAIL
(FINANCIAL_ASSET_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FINAN_ASSET_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_ASSET_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FINANCIAL_ASSET_DETAIL_H
		(
		FINANCIAL_ASSET_DETAIL_H_ID,
		FINANCIAL_ASSET_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_ASSET_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_ASSET_DETAIL_H_S.nextval,
		:old.FINANCIAL_ASSET_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.FINANCIAL_ASSET_TYPE_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_ASSET_DETAIL_H
		(
		FINANCIAL_ASSET_DETAIL_H_ID,
		FINANCIAL_ASSET_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_ASSET_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_ASSET_DETAIL_H_S.nextval,
		:new.FINANCIAL_ASSET_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.FINANCIAL_ASSET_TYPE_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FINAN_ASSET_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_ASSET_DETAIL FOR ADR.FINANCIAL_ASSET_DETAIL;


ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067151
  CHECK ("FINANCIAL_ASSET_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067152
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067153
  CHECK ("FINANCIAL_ASSET_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067154
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067155
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067156
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067157
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067158
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINASTDTL_PK
  PRIMARY KEY
  (FINANCIAL_ASSET_DETAIL_ID)
  USING INDEX ADR.FINASTDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT FINASTDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_ASSET_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_ASSET_DETAIL TO ES_RW;
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_ASSET_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_ASSET_DETAIL_H
(
  FINANCIAL_ASSET_DETAIL_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE),
  FINANCIAL_ASSET_DETAIL_ID    NUMBER(20),
  FINANCIAL_STATEMENT_ID       NUMBER(20),
  FINANCIAL_ASSET_TYPE_ID      NUMBER(20),
  GROSS_AMOUNT                 NUMBER(10,2),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_ASSET_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.FINANCIAL_ASSET_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.FINANCIAL_ASSET_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.FINANCIAL_ASSET_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.GROSS_AMOUNT IS 'AssetAmountisdefined asthegrossannual dollaramountassociated withthespecificasset type.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_ASSET_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FINASTDTLH_PK ON ADR.FINANCIAL_ASSET_DETAIL_H
(FINANCIAL_ASSET_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_ASSET_DETAIL_H FOR ADR.FINANCIAL_ASSET_DETAIL_H;


ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_061
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067192
  CHECK ("FINANCIAL_ASSET_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067193
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067194
  CHECK ("FINANCIAL_ASSET_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067195
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067196
  CHECK ("FINANCIAL_ASSET_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067197
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067198
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067199
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067200
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067201
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINASTDTLH_PK
  PRIMARY KEY
  (FINANCIAL_ASSET_DETAIL_H_ID)
  USING INDEX ADR.FINASTDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_ASSET_DETAIL_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_DEBT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_DEBT_DETAIL
(
  FINANCIAL_DEBT_DETAIL_ID  NUMBER(20)          NOT NULL,
  FINANCIAL_STATEMENT_ID    NUMBER(20)          NOT NULL,
  GROSS_AMOUNT              NUMBER(10,2),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_DEBT_DETAIL IS 'The table is a child table of the FINANCIAL_STATEMENT table that provides detailed amounts for different types of monetary debts a person is liable for that would have an impact on their eligibility to enroll for VHA medical benefits. FINANCIAL_STATEMENT_ID Foreign key to the FINANCIAL_STATEMENT table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.FINANCIAL_DEBT_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.GROSS_AMOUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.FINDBTDTL_FINSTATE_FK_I ON ADR.FINANCIAL_DEBT_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINDBTDTL_PK ON ADR.FINANCIAL_DEBT_DETAIL
(FINANCIAL_DEBT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FINAN_DEBT_DET_AUDIR_TRGR
after Update or Delete or Insert
on ADR.FINANCIAL_DEBT_DETAIL
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
	d_prsnid	number	:= 0;
begin

	if DELETING then
		insert into FINANCIAL_DEBT_DETAIL_H
		(
		FINANCIAL_DEBT_DETAIL_H_ID,
		FINANCIAL_DEBT_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_DEBT_DETAIL_H_S.nextval,
		:old.FINANCIAL_DEBT_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
		select
			fs.person_id
		into
			d_prsnid
	  	from
			ADR.FINANCIAL_STATEMENT fs
	 	where 	financial_statement_id = :OLD.financial_statement_id;

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_DEBT_DETAIL_H
		(
		FINANCIAL_DEBT_DETAIL_H_ID,
		FINANCIAL_DEBT_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_DEBT_DETAIL_H_S.nextval,
		:new.FINANCIAL_DEBT_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
		select
			fs.person_id
		into
			d_prsnid
	  	from
			ADR.FINANCIAL_STATEMENT fs
	 	where 	financial_statement_id = :NEW.financial_statement_id;

	end if;

end  FINAN_DEBT_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_DEBT_DETAIL FOR ADR.FINANCIAL_DEBT_DETAIL;


ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL ADD (
  CONSTRAINT FINDBTDTL_PK
  PRIMARY KEY
  (FINANCIAL_DEBT_DETAIL_ID)
  USING INDEX ADR.FINDBTDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL ADD (
  CONSTRAINT FINDBTDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ADREXT;

GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_DEBT_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_DEBT_DETAIL TO ES_RW;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_DEBT_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_DEBT_DETAIL_H
(
  FINANCIAL_DEBT_DETAIL_H_ID  NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  FINANCIAL_DEBT_DETAIL_ID    NUMBER(20)        NOT NULL,
  FINANCIAL_STATEMENT_ID      NUMBER(20)        NOT NULL,
  GROSS_AMOUNT                NUMBER(10,2),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_DEBT_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.FINANCIAL_DEBT_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.FINANCIAL_DEBT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.GROSS_AMOUNT IS 'AssetAmountisdefined asthegrossannual dollaramountassociated withthespecificasset type.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_DEBT_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FINDBTDTLH_PK ON ADR.FINANCIAL_DEBT_DETAIL_H
(FINANCIAL_DEBT_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_DEBT_DETAIL_H FOR ADR.FINANCIAL_DEBT_DETAIL_H;


ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_074
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT FINDBTDTLH_PK
  PRIMARY KEY
  (FINANCIAL_DEBT_DETAIL_H_ID)
  USING INDEX ADR.FINDBTDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_DEBT_DETAIL_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_EXPENSE_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_EXPENSE_DETAIL
(
  FINANCIAL_EXPENSE_DETAIL_ID  NUMBER(20),
  FINANCIAL_STATEMENT_ID       NUMBER(20),
  FINANCIAL_EXPENSE_TYPE_ID    NUMBER(20),
  GROSS_AMOUNT                 NUMBER(10,2),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_EXPENSE_DETAIL IS 'The table is a child table of the FINANCIAL_STATEMENT table that provides detailed amounts for different types of monetary expenses a person has incurred that would have an impact on their eligibility to enroll for VHA medical benefits. FINANCIAL_STATEMENT_ID Foreign key to the FINANCIAL_STATEMENT table. FINANCIAL_EXPENSE_TYPE_ID Foreign key to the FINANCIAL_EXPENSE_TYPE table. Indicates the kind of financial expense being documented (for example, Adjusted Medical Expenses, Cost of Shelter). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.FINANCIAL_EXPENSE_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.FINANCIAL_EXPENSE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.GROSS_AMOUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.FINEXPDTL_FINSTATE_FK_I ON ADR.FINANCIAL_EXPENSE_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINEXPDTL_PK ON ADR.FINANCIAL_EXPENSE_DETAIL
(FINANCIAL_EXPENSE_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINEXPDTL_STD_EXPNSTYPE_FK_I ON ADR.FINANCIAL_EXPENSE_DETAIL
(FINANCIAL_EXPENSE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FINAN_EXP_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_EXPENSE_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FINANCIAL_EXPENSE_DETAIL_H
		(
		FINANCIAL_EXPENSE_DETAIL_H_ID,
		FINANCIAL_EXPENSE_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_EXPENSE_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_EXPENSE_DETAIL_H_S.nextval,
		:old.FINANCIAL_EXPENSE_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.FINANCIAL_EXPENSE_TYPE_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_EXPENSE_DETAIL_H
		(
		FINANCIAL_EXPENSE_DETAIL_H_ID,
		FINANCIAL_EXPENSE_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_EXPENSE_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_EXPENSE_DETAIL_H_S.nextval,
		:new.FINANCIAL_EXPENSE_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.FINANCIAL_EXPENSE_TYPE_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FINAN_EXP_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_EXPENSE_DETAIL FOR ADR.FINANCIAL_EXPENSE_DETAIL;


ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066410
  CHECK ("FINANCIAL_EXPENSE_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066411
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066412
  CHECK ("FINANCIAL_EXPENSE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066413
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066414
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066415
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066416
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066417
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINEXPDTL_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_ID)
  USING INDEX ADR.FINEXPDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT FINEXPDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_EXPENSE_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL TO ES_RW;
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
(
  FINANCIAL_EXPENSE_DETAIL_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  FINANCIAL_EXPENSE_DETAIL_ID    NUMBER(20),
  FINANCIAL_STATEMENT_ID         NUMBER(20),
  FINANCIAL_EXPENSE_TYPE_ID      NUMBER(20),
  GROSS_AMOUNT                   NUMBER(10,2),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_EXPENSE_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_EXPENSE_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_EXPENSE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.GROSS_AMOUNT IS 'AssetAmountisdefined asthegrossannual dollaramountassociated withthespecificasset type.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FINEXPDTLH_PK ON ADR.FINANCIAL_EXPENSE_DETAIL_H
(FINANCIAL_EXPENSE_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_EXPENSE_DETAIL_H FOR ADR.FINANCIAL_EXPENSE_DETAIL_H;


ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_017
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066241
  CHECK ("FINANCIAL_EXPENSE_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066242
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066243
  CHECK ("FINANCIAL_EXPENSE_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066244
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066245
  CHECK ("FINANCIAL_EXPENSE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066246
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066247
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066248
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066249
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066250
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINEXPDTLH_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_H_ID)
  USING INDEX ADR.FINEXPDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_INCOME_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_INCOME_DETAIL
(
  FINANCIAL_INCOME_DETAIL_ID  NUMBER(20),
  FINANCIAL_STATEMENT_ID      NUMBER(20),
  FINANCIAL_INCOME_TYPE_ID    NUMBER(20),
  GROSS_AMOUNT                NUMBER(10,2),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE         DATE,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE        DATE,
  RECORD_MODIFIED_COUNT       NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_INCOME_DETAIL IS 'The table is a child table of the FINANCIAL_STATEMENT table that provides detailed amounts for different types of monetary income a person earns that would have an impact on their eligibility to enroll for VHA medical benefits. FINANCIAL_STATEMENT_ID Foreign key to the FINANCIAL_STATEMENT table. FINANCIAL_INCOME_TYPE_ID Foreign key to the FINANCIAL_INCOME_TYPE table. Indicates the kind of financial income being documented (for example, Social Security, Military Retirement). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.FINANCIAL_INCOME_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.FINANCIAL_INCOME_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.GROSS_AMOUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.FININCDTL_STD_INCMTYP_FK_I ON ADR.FINANCIAL_INCOME_DETAIL
(FINANCIAL_INCOME_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FININCMDTL_FINSTATE_FK_I ON ADR.FINANCIAL_INCOME_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FININCMDTL_PK ON ADR.FINANCIAL_INCOME_DETAIL
(FINANCIAL_INCOME_DETAIL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FINAN_INC_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_INCOME_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FINANCIAL_INCOME_DETAIL_H
		(
		FINANCIAL_INCOME_DETAIL_H_ID,
		FINANCIAL_INCOME_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_INCOME_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_INCOME_DETAIL_H_S.nextval,
		:old.FINANCIAL_INCOME_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.FINANCIAL_INCOME_TYPE_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_INCOME_DETAIL_H
		(
		FINANCIAL_INCOME_DETAIL_H_ID,
		FINANCIAL_INCOME_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_INCOME_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_INCOME_DETAIL_H_S.nextval,
		:new.FINANCIAL_INCOME_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.FINANCIAL_INCOME_TYPE_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FINAN_INC_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_INCOME_DETAIL FOR ADR.FINANCIAL_INCOME_DETAIL;


ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067437
  CHECK ("FINANCIAL_INCOME_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067438
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067439
  CHECK ("FINANCIAL_INCOME_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067440
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067441
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067442
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067443
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067444
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FININCMDTL_PK
  PRIMARY KEY
  (FINANCIAL_INCOME_DETAIL_ID)
  USING INDEX ADR.FININCMDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT FININCMDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_INCOME_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_INCOME_DETAIL TO ES_RW;
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_INCOME_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_INCOME_DETAIL_H
(
  FINANCIAL_INCOME_DETAIL_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE),
  FINANCIAL_INCOME_DETAIL_ID    NUMBER(20),
  FINANCIAL_STATEMENT_ID        NUMBER(20),
  FINANCIAL_INCOME_TYPE_ID      NUMBER(20),
  GROSS_AMOUNT                  NUMBER(10,2),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_INCOME_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.FINANCIAL_INCOME_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.FINANCIAL_INCOME_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.FINANCIAL_INCOME_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.GROSS_AMOUNT IS 'AssetAmountisdefined asthegrossannual dollaramountassociated withthespecificasset type.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_INCOME_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FININCMDTH_PK ON ADR.FINANCIAL_INCOME_DETAIL_H
(FINANCIAL_INCOME_DETAIL_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_INCOME_DETAIL_H FOR ADR.FINANCIAL_INCOME_DETAIL_H;


ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_005
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065951
  CHECK ("FINANCIAL_INCOME_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065952
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065953
  CHECK ("FINANCIAL_INCOME_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065954
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065955
  CHECK ("FINANCIAL_INCOME_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065956
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065957
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065958
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065959
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065960
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FININCMDTH_PK
  PRIMARY KEY
  (FINANCIAL_INCOME_DETAIL_H_ID)
  USING INDEX ADR.FININCMDTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_INCOME_DETAIL_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_STATEMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_STATEMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_STATEMENT
(
  FINANCIAL_STATEMENT_ID          NUMBER(20),
  PERSON_ID                       NUMBER(20),
  PERSON_RELATION_ID              NUMBER(20),
  REF_FINANCIAL_STATEMENT_ID      NUMBER(20),
  FIN_STMT_MAPPING_TYPE_CODE      VARCHAR2(6 BYTE),
  INCOME_YEAR                     NUMBER(4),
  CONTRIBUTION_TO_SPOUSE_AMT      NUMBER(10,2),
  CONTRIBUTION_TO_DEPENDENT_AMT   NUMBER(10,2),
  DISCLOSED_FINANCIAL_INFO_IND    VARCHAR2(1 BYTE),
  VALID_DEPENDENT_IND             VARCHAR2(1 BYTE),
  SPOUSE_HAS_INCOME_IND           VARCHAR2(1 BYTE),
  MARRIED_CURR_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  MARRIED_PREV_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  DEPENDENT_INCOME_AVAILABLE_IND  VARCHAR2(1 BYTE),
  DEPENDENT_HAS_INCOME_IND        VARCHAR2(1 BYTE),
  DEPENDENT_IN_SCHOOL_IND         VARCHAR2(1 BYTE),
  LIVED_WITH_VETERAN_IND          VARCHAR2(1 BYTE),
  IS_INCAPABLE_SELF_SUPPORT_IND   VARCHAR2(1 BYTE),
  DEPENDENT_CHILDREN_COUNT        NUMBER(3),
  CHILD_SUPPORT_IND               VARCHAR2(1 BYTE),
  VERIFIED_DATE                   DATE,
  REMARKS                         VARCHAR2(4000 BYTE),
  POST_2005_DISPLAY_FORMAT_FLAG   NUMBER(1)     DEFAULT 0,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CONTRIBUTED_TO_SPOUSE_IND       VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_STATEMENT IS 'The table stores a record of a persons financial status. Expenses, income, assets, and debts are stored in the corresponding child detail tables, and the statement itself contains other financially relevant data, including whether the person has declined to provide income information, has dependent children, pays child support, and is incapable of self support. PERSON_ID Foreign key to the PERSON table. PERSON_RELATION_ID Foreign key to the PERSON_RELATION table. REF_FINANCIAL_STATEMENT_ID Foreign key to the FINANCIAL_STATEMENT table. Self referential constraint. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.REF_FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.FIN_STMT_MAPPING_TYPE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.INCOME_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CONTRIBUTION_TO_SPOUSE_AMT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CONTRIBUTION_TO_DEPENDENT_AMT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DISCLOSED_FINANCIAL_INFO_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.VALID_DEPENDENT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.SPOUSE_HAS_INCOME_IND IS 'Indicatorthatapersons spousehashisorherown income.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.MARRIED_CURR_CALENDAR_YEAR_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.MARRIED_PREV_CALENDAR_YEAR_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_INCOME_AVAILABLE_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_HAS_INCOME_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_IN_SCHOOL_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.LIVED_WITH_VETERAN_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.IS_INCAPABLE_SELF_SUPPORT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_CHILDREN_COUNT IS 'BR597Numberofdependent childrenisdefinedas thenumberofqualifying dependentchildrenthis veteranhas.Thisnumber isderivedbasedonthe dependentsDOB.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CHILD_SUPPORT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.VERIFIED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.POST_2005_DISPLAY_FORMAT_FLAG IS 'Flagtoindicatethaton thescreen,therecord shouldbeformattedin thepost-2005style.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CONTRIBUTED_TO_SPOUSE_IND IS 'This is a Yes/No indicator to show whether or not the Veteran contributed to Spousal or Dependent support during the income year.';


CREATE INDEX ADR.FINSTATE_FINSTATE_FK_I ON ADR.FINANCIAL_STATEMENT
(REF_FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINSTATE_PK ON ADR.FINANCIAL_STATEMENT
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATE_PRSNREL_FK_I ON ADR.FINANCIAL_STATEMENT
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATE_PRSN_FK_I ON ADR.FINANCIAL_STATEMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FIN_STD_FINANCIALMAP_FK_I ON ADR.FINANCIAL_STATEMENT
(FIN_STMT_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FINAN_STATEMENT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_STATEMENT" FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into FINANCIAL_STATEMENT_H
        (
        FINANCIAL_STATEMENT_H_ID,
        FINANCIAL_STATEMENT_ID,
        PERSON_ID,
        PERSON_RELATION_ID,
        REF_FINANCIAL_STATEMENT_ID,
        INCOME_YEAR,
        FIN_STMT_MAPPING_TYPE_CODE,
        CONTRIBUTION_TO_SPOUSE_AMT,
        CONTRIBUTION_TO_DEPENDENT_AMT,
        DISCLOSED_FINANCIAL_INFO_IND,
        SPOUSE_HAS_INCOME_IND,
        MARRIED_CURR_CALENDAR_YEAR_IND,
        MARRIED_PREV_CALENDAR_YEAR_IND,
        DEPENDENT_INCOME_AVAILABLE_IND,
        DEPENDENT_HAS_INCOME_IND,
        DEPENDENT_IN_SCHOOL_IND,
        LIVED_WITH_VETERAN_IND,
        IS_INCAPABLE_SELF_SUPPORT_IND,
        DEPENDENT_CHILDREN_COUNT,
        CHILD_SUPPORT_IND,
        VERIFIED_DATE,
        REMARKS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        VALID_DEPENDENT_IND,
        POST_2005_DISPLAY_FORMAT_FLAG,
        TRANSACTION_TYPE_CODE,
        CONTRIBUTED_TO_SPOUSE_IND
          )
        values
        (
        FINANCIAL_STATEMENT_H_S.nextval,
        :old.FINANCIAL_STATEMENT_ID,
        :old.PERSON_ID,
        :old.PERSON_RELATION_ID,
        :old.REF_FINANCIAL_STATEMENT_ID,
        :old.INCOME_YEAR,
        :old.FIN_STMT_MAPPING_TYPE_CODE,
        :old.CONTRIBUTION_TO_SPOUSE_AMT,
        :old.CONTRIBUTION_TO_DEPENDENT_AMT,
        :old.DISCLOSED_FINANCIAL_INFO_IND,
        :old.SPOUSE_HAS_INCOME_IND,
        :old.MARRIED_CURR_CALENDAR_YEAR_IND,
        :old.MARRIED_PREV_CALENDAR_YEAR_IND,
        :old.DEPENDENT_INCOME_AVAILABLE_IND,
        :old.DEPENDENT_HAS_INCOME_IND,
        :old.DEPENDENT_IN_SCHOOL_IND,
        :old.LIVED_WITH_VETERAN_IND,
        :old.IS_INCAPABLE_SELF_SUPPORT_IND,
        :old.DEPENDENT_CHILDREN_COUNT,
        :old.CHILD_SUPPORT_IND,
        :old.VERIFIED_DATE,
        :old.REMARKS,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.VALID_DEPENDENT_IND,
        :old.POST_2005_DISPLAY_FORMAT_FLAG,
        'D',
        :old.CONTRIBUTED_TO_SPOUSE_IND
        );

    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into FINANCIAL_STATEMENT_H
        (
        FINANCIAL_STATEMENT_H_ID,
        FINANCIAL_STATEMENT_ID,
        PERSON_ID,
        PERSON_RELATION_ID,
        REF_FINANCIAL_STATEMENT_ID,
        INCOME_YEAR,
        FIN_STMT_MAPPING_TYPE_CODE,
        CONTRIBUTION_TO_SPOUSE_AMT,
        CONTRIBUTION_TO_DEPENDENT_AMT,
        DISCLOSED_FINANCIAL_INFO_IND,
        SPOUSE_HAS_INCOME_IND,
        MARRIED_CURR_CALENDAR_YEAR_IND,
        MARRIED_PREV_CALENDAR_YEAR_IND,
        DEPENDENT_INCOME_AVAILABLE_IND,
        DEPENDENT_HAS_INCOME_IND,
        DEPENDENT_IN_SCHOOL_IND,
        LIVED_WITH_VETERAN_IND,
        IS_INCAPABLE_SELF_SUPPORT_IND,
        DEPENDENT_CHILDREN_COUNT,
        CHILD_SUPPORT_IND,
        VERIFIED_DATE,
        REMARKS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        VALID_DEPENDENT_IND,
        POST_2005_DISPLAY_FORMAT_FLAG,
        TRANSACTION_TYPE_CODE,
        CONTRIBUTED_TO_SPOUSE_IND
          )
        values
        (
        FINANCIAL_STATEMENT_H_S.nextval,
        :new.FINANCIAL_STATEMENT_ID,
        :new.PERSON_ID,
        :new.PERSON_RELATION_ID,
        :new.REF_FINANCIAL_STATEMENT_ID,
        :new.INCOME_YEAR,
        :new.FIN_STMT_MAPPING_TYPE_CODE,
        :new.CONTRIBUTION_TO_SPOUSE_AMT,
        :new.CONTRIBUTION_TO_DEPENDENT_AMT,
        :new.DISCLOSED_FINANCIAL_INFO_IND,
        :new.SPOUSE_HAS_INCOME_IND,
        :new.MARRIED_CURR_CALENDAR_YEAR_IND,
        :new.MARRIED_PREV_CALENDAR_YEAR_IND,
        :new.DEPENDENT_INCOME_AVAILABLE_IND,
        :new.DEPENDENT_HAS_INCOME_IND,
        :new.DEPENDENT_IN_SCHOOL_IND,
        :new.LIVED_WITH_VETERAN_IND,
        :new.IS_INCAPABLE_SELF_SUPPORT_IND,
        :new.DEPENDENT_CHILDREN_COUNT,
        :new.CHILD_SUPPORT_IND,
        :new.VERIFIED_DATE,
        :new.REMARKS,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.VALID_DEPENDENT_IND,
        :new.POST_2005_DISPLAY_FORMAT_FLAG,
        mDML,
        :new.CONTRIBUTED_TO_SPOUSE_IND
        );

    end if;

end  FINAN_STATEMENT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_STATEMENT FOR ADR.FINANCIAL_STATEMENT;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT AVCON_1172521913_POST__000
  CHECK (POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 0
AND 0 OR POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066079
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066080
  CHECK ("POST_2005_DISPLAY_FORMAT_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066081
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066082
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066083
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066084
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066085
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINSTATE_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_ID)
  USING INDEX ADR.FINSTATE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_FINSTATE_FK 
  FOREIGN KEY (REF_FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  DISABLE NOVALIDATE,
  CONSTRAINT FINSTATE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FINSTATE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ADREXT;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_STATEMENT TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_STATEMENT TO ES_RW;
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_STATEMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_STATEMENT_H
(
  FINANCIAL_STATEMENT_H_ID        NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  FINANCIAL_STATEMENT_ID          NUMBER(20),
  PERSON_ID                       NUMBER(20),
  PERSON_RELATION_ID              NUMBER(20),
  REF_FINANCIAL_STATEMENT_ID      NUMBER(20),
  INCOME_YEAR                     NUMBER(4),
  FIN_STMT_MAPPING_TYPE_CODE      VARCHAR2(6 BYTE),
  CONTRIBUTION_TO_SPOUSE_AMT      NUMBER(10,2),
  CONTRIBUTION_TO_DEPENDENT_AMT   NUMBER(10,2),
  DISCLOSED_FINANCIAL_INFO_IND    VARCHAR2(1 BYTE),
  SPOUSE_HAS_INCOME_IND           VARCHAR2(1 BYTE),
  MARRIED_CURR_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  MARRIED_PREV_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  VALID_DEPENDENT_IND             VARCHAR2(1 BYTE),
  DEPENDENT_CHILDREN_COUNT        NUMBER(3),
  DEPENDENT_INCOME_AVAILABLE_IND  VARCHAR2(1 BYTE),
  DEPENDENT_HAS_INCOME_IND        VARCHAR2(1 BYTE),
  DEPENDENT_IN_SCHOOL_IND         VARCHAR2(1 BYTE),
  LIVED_WITH_VETERAN_IND          VARCHAR2(1 BYTE),
  IS_INCAPABLE_SELF_SUPPORT_IND   VARCHAR2(1 BYTE),
  CHILD_SUPPORT_IND               VARCHAR2(1 BYTE),
  VERIFIED_DATE                   DATE,
  POST_2005_DISPLAY_FORMAT_FLAG   NUMBER(1),
  REMARKS                         VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CONTRIBUTED_TO_SPOUSE_IND       VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_STATEMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.FINANCIAL_STATEMENT_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.REF_FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.FIN_STMT_MAPPING_TYPE_CODE IS 'Hibernatemapping:used toidentifywhetherthis isaperson,spouse,or dependentstatement.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.CONTRIBUTION_TO_SPOUSE_AMT IS 'Dollaramountaperson contributestosupportof aspouse';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.CONTRIBUTION_TO_DEPENDENT_AMT IS 'Dollaramountaperson contributestosupportof adependent.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DISCLOSED_FINANCIAL_INFO_IND IS 'Indicatorthataperson, whenasked,declinedto provideincome information.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.SPOUSE_HAS_INCOME_IND IS 'Indicatorthatapersons spousehashisorherown income.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.MARRIED_CURR_CALENDAR_YEAR_IND IS 'Indicatesthattheperson wasmarriedinthe currentcalendaryear.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.MARRIED_PREV_CALENDAR_YEAR_IND IS 'Marriedlastcalendar yearisdefinedasan Indicatorofwhether veteranwasmarried duringlastcalendar year.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.VALID_DEPENDENT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_CHILDREN_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_INCOME_AVAILABLE_IND IS 'BR6803Incomeavailable isdefined,asan IndicatorYes/Nothe childsincomewas availabletotheveteran.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_HAS_INCOME_IND IS 'Childhasincomeis definedasanIndicator Yes/Nothechildhad incomeduringlast calendaryear.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_IN_SCHOOL_IND IS 'Dependentchildschool indicatorisdefinedas anindicatorIfthechild isbetweentheagesof18 and23indicateYes/Noif theyattendedschoollast calendaryear';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.LIVED_WITH_VETERAN_IND IS 'Livedwithpatientis definedasanIndicator whetherspouselivedwith patientduringlast calendaryear.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.IS_INCAPABLE_SELF_SUPPORT_IND IS 'DependentChildis PermanentlyIncapableOf Self-Support.Indicator isdefinedasan Indicatorifthechildis overtheageof18and becamepermanently incapableofselfsupport beforereachingtheage of18.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.VERIFIED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.POST_2005_DISPLAY_FORMAT_FLAG IS 'Flagtoindicatethaton thescreen,therecord shouldbeformattedin thepost-2005style.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.CONTRIBUTED_TO_SPOUSE_IND IS 'This is a Yes/No indicator to show whether or not the Veteran contributed to Spousal or Dependent support during the income year.';


CREATE INDEX ADR.FINSTATEH_FINSTATID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINSTATEH_PK ON ADR.FINANCIAL_STATEMENT_H
(FINANCIAL_STATEMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATEH_PRSNID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(PERSON_ID, FIN_STMT_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATEH_REFSTATID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(REF_FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_STATEMENT_H FOR ADR.FINANCIAL_STATEMENT_H;


ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_070
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067445
  CHECK ("FINANCIAL_STATEMENT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067446
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067447
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067448
  CHECK ("POST_2005_DISPLAY_FORMAT_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067449
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067450
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067451
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067452
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067453
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINSTATEH_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_H_ID)
  USING INDEX ADR.FINSTATEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_STATEMENT_H TO ES_RW;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE
(
  FUTURE_DISCHARGE_SRC_TYPE_ID  NUMBER(20)      NOT NULL,
  CODE                          VARCHAR2(2 BYTE) NOT NULL,
  NAME                          VARCHAR2(50 BYTE) NOT NULL,
  DESCRIPTION                   VARCHAR2(100 BYTE),
  ISACTIVE                      CHAR(1 BYTE)    NOT NULL,
  INACTIVE_DATE                 DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE IS 'lookup table to hold future discharge date source';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.FUTURE_DISCHARGE_SRC_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.CODE IS 'Code for the source';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.NAME IS 'Hold name of the Source';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.DESCRIPTION IS 'Hold name of the Source';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.ISACTIVE IS 'Hold 1/0 value';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.INACTIVE_DATE IS 'Date field to indicate when the list is inactive';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FUTURE_DISCHARGE_SRC_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FUTURE_DISCHARGE_SRC_TYPE_PK ON ADR.FUTURE_DISCHARGE_SRC_TYPE
(FUTURE_DISCHARGE_SRC_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FUTURE_DIS_SRC_TYPE_CD_UK ON ADR.FUTURE_DISCHARGE_SRC_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FUTURE_DIS_SRC_TYPE_NM_UK ON ADR.FUTURE_DISCHARGE_SRC_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FUTURE_DISCHARGE_SRC_TYPE FOR ADR.FUTURE_DISCHARGE_SRC_TYPE;


ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE ADD (
  CONSTRAINT FUTURE_DISCHARGE_SRC_TYPE_PK
  PRIMARY KEY
  (FUTURE_DISCHARGE_SRC_TYPE_ID)
  USING INDEX ADR.FUTURE_DISCHARGE_SRC_TYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FUTURE_DISCHARGE_SRC_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FUTURE_DISCHARGE_SRC_TYPE TO ADR_RW;
ALTER TABLE ADR.GEOCODE_STAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_STAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_STAGE
(
  GEOCODE_STAGE_ID        NUMBER(20)            NOT NULL,
  GEOCODE_STATION_ID      NUMBER(20),
  PERSON_ID               NUMBER(20),
  ADDRESS_H_ID            NUMBER(20),
  ADDR_EXACT_MATCH_IND    NUMBER(1),
  ADDRESS_LINE1           VARCHAR2(100 BYTE),
  ADDRESS_LINE2           VARCHAR2(100 BYTE),
  CITY                    VARCHAR2(60 BYTE),
  STATE                   VARCHAR2(2 BYTE),
  ZIP                     VARCHAR2(5 BYTE),
  ZIP_PLUS4               VARCHAR2(4 BYTE),
  COUNTRY                 VARCHAR2(50 BYTE),
  FIPS                    VARCHAR2(5 BYTE),
  NEW_VISN                VARCHAR2(2 BYTE),
  MARKET                  VARCHAR2(4 BYTE),
  SUBMARKET               VARCHAR2(6 BYTE),
  SECTOR                  VARCHAR2(8 BYTE),
  DISTRICT                VARCHAR2(4 BYTE),
  STATE_FIPS              VARCHAR2(2 BYTE),
  COUNTY_NAME             VARCHAR2(255 BYTE),
  DISTRICT_NAME           VARCHAR2(255 BYTE),
  MARKET_NAME             VARCHAR2(255 BYTE),
  STATE_BY_COUNTY         VARCHAR2(2 BYTE),
  URH_CODE                VARCHAR2(1 BYTE),
  CONGRESSIONAL_DISTRICT  VARCHAR2(20 BYTE),
  ADDR_LONGITUDE          NUMBER(20),
  ADDR_LATITUDE           NUMBER(20),
  DRIVING_DISTANCE        NUMBER(20),
  ADDR_LOCATION_NAME      VARCHAR2(59 BYTE),
  ADDR_MATCH_TYPE         VARCHAR2(2 BYTE),
  MATCH_ADDRESS           VARCHAR2(120 BYTE),
  GEOCODING_FLAG          VARCHAR2(1 BYTE),
  GEOCODE_SW_VER          VARCHAR2(50 BYTE),
  GEOCODE_DATE            DATE,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION GEOCODE_STAGE_P001 VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_STAGE IS 'Log of records sent to geocode service and data received';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.GEOCODE_STAGE_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.GEOCODE_STATION_ID IS 'FK to ADR.GEOCODE_STATION table';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDRESS_H_ID IS 'FK to ADR.ADDRESS_H table';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDR_EXACT_MATCH_IND IS 'Boolean Yes/No indicator of did Geocode match exactly to the address ES sent';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDRESS_LINE1 IS 'Street Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDRESS_LINE2 IS 'Street Address line 2';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.CITY IS 'City';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.STATE IS 'State for US (Province for non-US)';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ZIP IS '5-digit ZIP code';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ZIP_PLUS4 IS 'Four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.COUNTRY IS 'Country';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.FIPS IS 'County Federal Information Processing Standard code (2 state + 3 county digits)';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.NEW_VISN IS 'NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.MARKET IS 'Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.SUBMARKET IS 'Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.SECTOR IS 'Sector Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.DISTRICT IS 'VA District Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.STATE_FIPS IS 'County Federal Information Processing Standard code (2 digit state)';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.COUNTY_NAME IS 'County Name';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.DISTRICT_NAME IS 'VA District Name';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.MARKET_NAME IS 'Market Name';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.STATE_BY_COUNTY IS 'State determined based on county data joined to file (see CountyName)';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.CONGRESSIONAL_DISTRICT IS 'Congressional District';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDR_LONGITUDE IS 'Longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDR_LATITUDE IS 'Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.DRIVING_DISTANCE IS 'Driving Distance to nearest  station';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDR_LOCATION_NAME IS 'The name of the participating locator used for matching the address';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.ADDR_MATCH_TYPE IS 'M=Matched; U=Unmatched; T=Tied';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.MATCH_ADDRESS IS 'The address where the matched location actually resides based on geocoded results';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.GEOCODING_FLAG IS 'Geocoding flag 0, 1, 2, 3, 4, 5, Null';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.GEOCODE_SW_VER IS 'Geocoder Software Version';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.GEOCODE_DATE IS 'Date file was geocoded. Format: CYYMMDD where C = Century: 1=1800, 2=1900, C=2000';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_STAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.GEOCODE_STAGE_PK ON ADR.GEOCODE_STAGE
(RECORD_CREATED_DATE, GEOCODE_STAGE_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION GEOCODE_STAGE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.GS_PERSONID_IDX ON ADR.GEOCODE_STAGE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GS_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION GS_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION GS_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION GS_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_STAGE FOR ADR.GEOCODE_STAGE;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCODE_STAGE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_STAGE_ID)
  USING INDEX LOCAL
  ENABLE VALIDATE);

ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCD_STAGE_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT GEOCODE_STG_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT GS_TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.GEOCODE_STAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STAGE TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_STAGE TO ES_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_STAGE TO ES_RW;

GRANT SELECT ON ADR.GEOCODE_STAGE TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STAGE TO VETCHOICE_RW;
ALTER TABLE ADR.GEOCODE_STATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_STATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_STATION
(
  GEOCODE_STATION_ID        NUMBER(20)          NOT NULL,
  STD_INSTITUTION_ID        NUMBER(20),
  STATION_NUMBER            VARCHAR2(7 BYTE),
  STATION_ADRR_LINE1        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE2        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE3        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE4        VARCHAR2(100 BYTE),
  STATION_CITY              VARCHAR2(50 BYTE),
  STATION_STATE             VARCHAR2(2 BYTE),
  STATION_ZIP               VARCHAR2(5 BYTE),
  STATION_ZIP4              VARCHAR2(5 BYTE),
  VA_SITE_IND               VARCHAR2(1 BYTE),
  CONTRACTED_IND            VARCHAR2(1 BYTE),
  NUMBER_OF_PROVIDERS       NUMBER(8),
  PARENT_STATION            VARCHAR2(6 BYTE),
  PARENT_STA_COMPLEXITY     VARCHAR2(80 BYTE),
  PLANNED_OR_OPERATIONAL    VARCHAR2(1 BYTE),
  STATION_PHONE             VARCHAR2(12 BYTE),
  STATION_FAX               VARCHAR2(12 BYTE),
  SHARED_IND                VARCHAR2(1 BYTE),
  SHARED_PARENT_STATION     VARCHAR2(6 BYTE),
  HEALTHCARE_CENTER         NUMBER(8),
  MSCBOC                    NUMBER(8),
  NEW_VAMC                  NUMBER(8),
  PCCBOC                    NUMBER(8),
  COC_CLASSIFICATION_CODE   NUMBER(16),
  VA_HOSPITAL               NUMBER(8),
  VHA_SITE_CATEGORY_CODE    VARCHAR2(6 BYTE),
  SITE_CLASSIFICATION_NAME  VARCHAR2(150 BYTE),
  PRIMARY_SVC_TYPE          VARCHAR2(6 BYTE),
  OP_COC_CLASSIFICATION     VARCHAR2(25 BYTE),
  STATION_LONGITUDE         NUMBER(20),
  STATION_LATITUDE          NUMBER(20),
  STATION_NEW_VISN          VARCHAR2(6 BYTE),
  STATION_MARKET            VARCHAR2(4 BYTE),
  STATION_SUBMARKET         VARCHAR2(6 BYTE),
  STATION_COUNTYNAME        VARCHAR2(255 BYTE),
  STATION_DISTRICT          VARCHAR2(4 BYTE),
  STATION_DISTRICT_NAME     VARCHAR2(100 BYTE),
  STATION_URH_CODE          VARCHAR2(1 BYTE),
  STATION_OPERATION_DATE    DATE,
  VAST_EXTRACT_DATE         DATE,
  ACTIVE_START_DT           CHAR(20 BYTE),
  ACTIVE_END_DT             CHAR(20 BYTE),
  ACTIVE_FAG                CHAR(20 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  STATION_NAME              VARCHAR2(100 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_STATION IS 'List of stations provided by geocode service';

COMMENT ON COLUMN ADR.GEOCODE_STATION.GEOCODE_STATION_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STD_INSTITUTION_ID IS 'FK to ADR.STD_INSTITUTION table';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_NUMBER IS 'Unique site identifier - station identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE1 IS 'Station Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE2 IS 'Station Address line 2';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE3 IS 'Station Address line 3';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE4 IS 'Station Address line 4';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_CITY IS 'Station City';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_STATE IS 'Station State';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ZIP IS 'Station Zip';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ZIP4 IS 'Station four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VA_SITE_IND IS 'VA-owned site flag';

COMMENT ON COLUMN ADR.GEOCODE_STATION.CONTRACTED_IND IS 'V=VA; L=Leased; C=Contracted';

COMMENT ON COLUMN ADR.GEOCODE_STATION.NUMBER_OF_PROVIDERS IS 'Number of sites providing service under this station identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PARENT_STATION IS 'Administrative Parent Station';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PARENT_STA_COMPLEXITY IS 'Administrative Parent Station Complexity Level';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PLANNED_OR_OPERATIONAL IS 'Planned (P) or operational/activated (A)';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_PHONE IS 'Station phone number';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_FAX IS 'Station fax number';

COMMENT ON COLUMN ADR.GEOCODE_STATION.SHARED_IND IS 'Shared flag (indicates multiple station numbers operate at the same geographic location)';

COMMENT ON COLUMN ADR.GEOCODE_STATION.SHARED_PARENT_STATION IS 'First responsible site / parent of sharing site';

COMMENT ON COLUMN ADR.GEOCODE_STATION.HEALTHCARE_CENTER IS 'Health Care Center';

COMMENT ON COLUMN ADR.GEOCODE_STATION.MSCBOC IS 'Multi-Specialty Community-Based Outpatient Clinic';

COMMENT ON COLUMN ADR.GEOCODE_STATION.NEW_VAMC IS 'VA Medical Center';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PCCBOC IS 'Primary Care Community-Based Outpatient Clinic';

COMMENT ON COLUMN ADR.GEOCODE_STATION.COC_CLASSIFICATION_CODE IS 'Station Continuum of Care (CoC) classification. It will be blank for stations permanently deactivated prior to 10/1/14, as those stations never received a CoC Classification. It will also be blank for Vet Centers, Mobile Vet Centers, and Multicontract sites, as these dont receive CoC classifications.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VA_HOSPITAL IS 'VA Hospital';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VHA_SITE_CATEGORY_CODE IS 'Internal indicator that identifies whether a facility is classified according to VHA Handbook 1006.02  VHA Site Classifications and Definitions';

COMMENT ON COLUMN ADR.GEOCODE_STATION.SITE_CLASSIFICATION_NAME IS 'Site of care classifications name ';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PRIMARY_SVC_TYPE IS 'Primary service type';

COMMENT ON COLUMN ADR.GEOCODE_STATION.OP_COC_CLASSIFICATION IS 'Outpatient Detailed CoC Site Classification. Each point of service receives an outpatient care rating within the VHA site classifications based on the services provided at that location, including mental health, primary care, and specialty care.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_LONGITUDE IS 'Station longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_LATITUDE IS 'Station Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_NEW_VISN IS 'Station NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_MARKET IS 'Station Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_SUBMARKET IS 'Station Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_COUNTYNAME IS 'Station County Name';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_DISTRICT IS 'ID assigned to fit into the five Department Level Districts that are part of the MyVA Realignment';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_DISTRICT_NAME IS 'Stations assigned VA Department Level District Name';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_OPERATION_DATE IS 'Operational date of site: (A) is date opened/saw first patient; (P) is date planned to open. Format: CYYMMDD';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VAST_EXTRACT_DATE IS 'VAST extraction date. Format: CYYMMDD';

COMMENT ON COLUMN ADR.GEOCODE_STATION.ACTIVE_START_DT IS 'Date station became active';

COMMENT ON COLUMN ADR.GEOCODE_STATION.ACTIVE_END_DT IS 'Date station became inactive';

COMMENT ON COLUMN ADR.GEOCODE_STATION.ACTIVE_FAG IS 'Indicator of the stations active/inactive status';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_NAME IS 'Name of the VACAA facility';


CREATE UNIQUE INDEX ADR.GEOCODE_STATION_PK ON ADR.GEOCODE_STATION
(GEOCODE_STATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.GEOCODE_STATION_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.GEOCODE_STATION
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO GEOCODE_STATION_H (
         GEOCODE_STATION_H_ID  ,
         GEOCODE_STATION_ID,
         STD_INSTITUTION_ID,
         STATION_NUMBER,
         STATION_ADRR_LINE1,
         STATION_ADRR_LINE2,
         STATION_ADRR_LINE3 ,
         STATION_ADRR_LINE4,
         STATION_CITY ,
         STATION_STATE ,
         STATION_ZIP ,
         STATION_ZIP4,
         VA_SITE_IND ,
         CONTRACTED_IND ,
         NUMBER_OF_PROVIDERS,
         PARENT_STATION,
         PARENT_STA_COMPLEXITY,
         PLANNED_OR_OPERATIONAL,
         STATION_PHONE,
         STATION_FAX,
         SHARED_IND,
         SHARED_PARENT_STATION,
         HEALTHCARE_CENTER,
         MSCBOC,
         NEW_VAMC,
         PCCBOC,
         COC_CLASSIFICATION_CODE ,
         VA_HOSPITAL,
         VHA_SITE_CATEGORY_CODE,
         SITE_CLASSIFICATION_NAME,
         PRIMARY_SVC_TYPE ,
         OP_COC_CLASSIFICATION,
         STATION_LONGITUDE,
         STATION_LATITUDE,
         STATION_NEW_VISN,
         STATION_MARKET,
         STATION_SUBMARKET,
         STATION_COUNTYNAME,
         STATION_DISTRICT,
         STATION_DISTRICT_NAME,
         STATION_URH_CODE,
         STATION_OPERATION_DATE,
         VAST_EXTRACT_DATE ,
         ACTIVE_START_DT,
         ACTIVE_END_DT,
         ACTIVE_FAG,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         STATION_NAME ,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
         )
 VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
       :old.GEOCODE_STATION_ID,
       :old.STD_INSTITUTION_ID,
       :old.STATION_NUMBER,
       :old.STATION_ADRR_LINE1,
       :old.STATION_ADRR_LINE2,
       :old.STATION_ADRR_LINE3 ,
       :old.STATION_ADRR_LINE4,
       :old.STATION_CITY ,
       :old.STATION_STATE ,
       :old.STATION_ZIP ,
       :old.STATION_ZIP4,
       :old.VA_SITE_IND ,
       :old.CONTRACTED_IND ,
       :old.NUMBER_OF_PROVIDERS,
       :old.PARENT_STATION,
       :old.PARENT_STA_COMPLEXITY,
       :old.PLANNED_OR_OPERATIONAL,
       :old.STATION_PHONE,
       :old.STATION_FAX,
       :old.SHARED_IND,
       :old.SHARED_PARENT_STATION,
       :old.HEALTHCARE_CENTER,
       :old.MSCBOC,
       :old.NEW_VAMC,
       :old.PCCBOC,
       :old.COC_CLASSIFICATION_CODE ,
       :old.VA_HOSPITAL,
       :old.VHA_SITE_CATEGORY_CODE,
       :old.SITE_CLASSIFICATION_NAME,
       :old.PRIMARY_SVC_TYPE ,
       :old.OP_COC_CLASSIFICATION,
       :old.STATION_LONGITUDE,
       :old.STATION_LATITUDE,
       :old.STATION_NEW_VISN,
       :old.STATION_MARKET,
       :old.STATION_SUBMARKET,
       :old.STATION_COUNTYNAME,
       :old.STATION_DISTRICT,
       :old.STATION_DISTRICT_NAME,
       :old.STATION_URH_CODE,
       :old.STATION_OPERATION_DATE,
       :old.VAST_EXTRACT_DATE ,
       :old.ACTIVE_START_DT,
       :old.ACTIVE_END_DT,
       :old.ACTIVE_FAG,
       :old.RECORD_CREATED_BY,
       :old.RECORD_CREATED_DATE,
       :old.RECORD_MODIFIED_BY,
       :old.RECORD_MODIFIED_DATE,
       :old.RECORD_MODIFIED_COUNT,
       :old.STATION_NAME ,
       sysdate,
       mDML);
ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

       INSERT INTO GEOCODE_STATION_H (
         GEOCODE_STATION_H_ID  ,
         GEOCODE_STATION_ID,
         STD_INSTITUTION_ID,
         STATION_NUMBER,
         STATION_ADRR_LINE1,
         STATION_ADRR_LINE2,
         STATION_ADRR_LINE3 ,
         STATION_ADRR_LINE4,
         STATION_CITY ,
         STATION_STATE ,
         STATION_ZIP ,
         STATION_ZIP4,
         VA_SITE_IND ,
         CONTRACTED_IND ,
         NUMBER_OF_PROVIDERS,
         PARENT_STATION,
         PARENT_STA_COMPLEXITY,
         PLANNED_OR_OPERATIONAL,
         STATION_PHONE,
         STATION_FAX,
         SHARED_IND,
         SHARED_PARENT_STATION,
         HEALTHCARE_CENTER,
         MSCBOC,
         NEW_VAMC,
         PCCBOC,
         COC_CLASSIFICATION_CODE ,
         VA_HOSPITAL,
         VHA_SITE_CATEGORY_CODE,
         SITE_CLASSIFICATION_NAME,
         PRIMARY_SVC_TYPE ,
         OP_COC_CLASSIFICATION,
         STATION_LONGITUDE,
         STATION_LATITUDE,
         STATION_NEW_VISN,
         STATION_MARKET,
         STATION_SUBMARKET,
         STATION_COUNTYNAME,
         STATION_DISTRICT,
         STATION_DISTRICT_NAME,
         STATION_URH_CODE,
         STATION_OPERATION_DATE,
         VAST_EXTRACT_DATE ,
         ACTIVE_START_DT,
         ACTIVE_END_DT,
         ACTIVE_FAG,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         STATION_NAME ,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE)
 VALUES (GEOCODE_STATION_H_S.NEXTVAL  ,
        :new.GEOCODE_STATION_ID,
        :new.STD_INSTITUTION_ID,
        :new.STATION_NUMBER,
        :new.STATION_ADRR_LINE1,
        :new.STATION_ADRR_LINE2,
        :new.STATION_ADRR_LINE3 ,
        :new.STATION_ADRR_LINE4,
        :new.STATION_CITY ,
        :new.STATION_STATE ,
        :new.STATION_ZIP ,
        :new.STATION_ZIP4,
        :new.VA_SITE_IND ,
        :new.CONTRACTED_IND ,
        :new.NUMBER_OF_PROVIDERS,
        :new.PARENT_STATION,
        :new.PARENT_STA_COMPLEXITY,
        :new.PLANNED_OR_OPERATIONAL,
        :new.STATION_PHONE,
        :new.STATION_FAX,
        :new.SHARED_IND,
        :new.SHARED_PARENT_STATION,
        :new.HEALTHCARE_CENTER,
        :new.MSCBOC,
        :new.NEW_VAMC,
        :new.PCCBOC,
        :new.COC_CLASSIFICATION_CODE ,
        :new.VA_HOSPITAL,
        :new.VHA_SITE_CATEGORY_CODE,
        :new.SITE_CLASSIFICATION_NAME,
        :new.PRIMARY_SVC_TYPE ,
        :new.OP_COC_CLASSIFICATION,
        :new.STATION_LONGITUDE,
        :new.STATION_LATITUDE,
        :new.STATION_NEW_VISN,
        :new.STATION_MARKET,
        :new.STATION_SUBMARKET,
        :new.STATION_COUNTYNAME,
        :new.STATION_DISTRICT,
        :new.STATION_DISTRICT_NAME,
        :new.STATION_URH_CODE,
        :new.STATION_OPERATION_DATE,
        :new.VAST_EXTRACT_DATE ,
        :new.ACTIVE_START_DT,
        :new.ACTIVE_END_DT,
        :new.ACTIVE_FAG,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.STATION_NAME ,
        sysdate,
        mDML);
   END IF;

 END GEOCODE_STATION_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_STATION FOR ADR.GEOCODE_STATION;


ALTER TABLE ADR.GEOCODE_STATION ADD (
  CONSTRAINT GEOCODE_STATION_PK
  PRIMARY KEY
  (GEOCODE_STATION_ID)
  USING INDEX ADR.GEOCODE_STATION_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.GEOCODE_STATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STATION TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_STATION TO ES_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_STATION TO ES_RW;

GRANT SELECT ON ADR.GEOCODE_STATION TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STATION TO VETCHOICE_RW;
ALTER TABLE ADR.GEOCODE_STATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_STATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_STATION_H
(
  GEOCODE_STATION_H_ID      NUMBER(20)          NOT NULL,
  GEOCODE_STATION_ID        NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  STATION_NUMBER            VARCHAR2(7 BYTE),
  STATION_ADRR_LINE1        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE2        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE3        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE4        VARCHAR2(100 BYTE),
  STATION_CITY              VARCHAR2(50 BYTE),
  STATION_STATE             VARCHAR2(2 BYTE),
  STATION_ZIP               VARCHAR2(5 BYTE),
  STATION_ZIP4              VARCHAR2(5 BYTE),
  VA_SITE_IND               VARCHAR2(1 BYTE),
  CONTRACTED_IND            VARCHAR2(1 BYTE),
  NUMBER_OF_PROVIDERS       NUMBER(8),
  PARENT_STATION            VARCHAR2(6 BYTE),
  PARENT_STA_COMPLEXITY     VARCHAR2(80 BYTE),
  PLANNED_OR_OPERATIONAL    VARCHAR2(1 BYTE),
  STATION_PHONE             VARCHAR2(12 BYTE),
  STATION_FAX               VARCHAR2(12 BYTE),
  SHARED_IND                VARCHAR2(1 BYTE),
  SHARED_PARENT_STATION     VARCHAR2(6 BYTE),
  HEALTHCARE_CENTER         NUMBER(8),
  MSCBOC                    NUMBER(8),
  NEW_VAMC                  NUMBER(8),
  PCCBOC                    NUMBER(8),
  COC_CLASSIFICATION_CODE   NUMBER(16),
  VA_HOSPITAL               NUMBER(8),
  VHA_SITE_CATEGORY_CODE    VARCHAR2(6 BYTE),
  SITE_CLASSIFICATION_NAME  VARCHAR2(150 BYTE),
  PRIMARY_SVC_TYPE          VARCHAR2(6 BYTE),
  OP_COC_CLASSIFICATION     VARCHAR2(25 BYTE),
  STATION_LONGITUDE         NUMBER(20),
  STATION_LATITUDE          NUMBER(20),
  STATION_NEW_VISN          VARCHAR2(6 BYTE),
  STATION_MARKET            VARCHAR2(4 BYTE),
  STATION_SUBMARKET         VARCHAR2(6 BYTE),
  STATION_COUNTYNAME        VARCHAR2(255 BYTE),
  STATION_DISTRICT          VARCHAR2(4 BYTE),
  STATION_DISTRICT_NAME     VARCHAR2(100 BYTE),
  STATION_URH_CODE          VARCHAR2(1 BYTE),
  STATION_OPERATION_DATE    DATE,
  VAST_EXTRACT_DATE         DATE,
  ACTIVE_START_DT           CHAR(20 BYTE),
  ACTIVE_END_DT             CHAR(20 BYTE),
  ACTIVE_FAG                CHAR(20 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE       DATE,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE      DATE,
  RECORD_MODIFIED_COUNT     NUMBER(10),
  STATION_NAME              VARCHAR2(100 BYTE),
  HISTORY_CREATED_DATE      DATE                NOT NULL,
  TRANSACTION_TYPE_CODE     CHAR(1 BYTE)        NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION GEOCODESTATNH_RECRDT VALUES LESS THAN (TO_DATE(' 2017-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_STATION_H IS 'List of stations history provided by geocode service';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.GEOCODE_STATION_H_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.GEOCODE_STATION_ID IS 'FK to GEOCODE_STATION';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STD_INSTITUTION_ID IS 'FK to ADR.STD_INSTITUTION table';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_NUMBER IS 'Unique site identifier - station identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_ADRR_LINE1 IS 'Station Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_ADRR_LINE2 IS 'Station Address line 2';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_ADRR_LINE3 IS 'Station Address line 3';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_ADRR_LINE4 IS 'Station Address line 4';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_CITY IS 'Station City';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_STATE IS 'Station State';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_ZIP IS 'Station Zip';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_ZIP4 IS 'Station four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.VA_SITE_IND IS 'VA-owned site flag';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.CONTRACTED_IND IS 'V=VA; L=Leased; C=Contracted';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.NUMBER_OF_PROVIDERS IS 'Number of sites providing service under this station identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.PARENT_STATION IS 'Administrative Parent Station';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.PARENT_STA_COMPLEXITY IS 'Administrative Parent Station Complexity Level';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.PLANNED_OR_OPERATIONAL IS 'Planned (P) or operational/activated (A)';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_PHONE IS 'Station phone number';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_FAX IS 'Station fax number';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.SHARED_IND IS 'Shared flag (indicates multiple station numbers operate at the same geographic location)';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.SHARED_PARENT_STATION IS 'First responsible site / parent of sharing site';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.HEALTHCARE_CENTER IS 'Health Care Center';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.MSCBOC IS 'Multi-Specialty Community-Based Outpatient Clinic';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.NEW_VAMC IS 'VA Medical Center';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.PCCBOC IS 'Primary Care Community-Based Outpatient Clinic';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.COC_CLASSIFICATION_CODE IS 'Station Continuum of Care (CoC) classification. It will be blank for stations permanently deactivated prior to 10/1/14, as those stations never received a CoC Classification. It will also be blank for Vet Centers, Mobile Vet Centers, and Multicontract sites, as these dont receive CoC classifications.';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.VA_HOSPITAL IS 'VA Hospital';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.VHA_SITE_CATEGORY_CODE IS 'Internal indicator that identifies whether a facility is classified according to VHA Handbook 1006.02  VHA Site Classifications and Definitions';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.SITE_CLASSIFICATION_NAME IS 'Site of care classifications name ';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.PRIMARY_SVC_TYPE IS 'Primary service type';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.OP_COC_CLASSIFICATION IS 'Outpatient Detailed CoC Site Classification. Each point of service receives an outpatient care rating within the VHA site classifications based on the services provided at that location, including mental health, primary care, and specialty care.';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_LONGITUDE IS 'Station longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_LATITUDE IS 'Station Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_NEW_VISN IS 'Station NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_MARKET IS 'Station Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_SUBMARKET IS 'Station Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_COUNTYNAME IS 'Station County Name';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_DISTRICT IS 'ID assigned to fit into the five Department Level Districts that are part of the MyVA Realignment';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_DISTRICT_NAME IS 'Stations assigned VA Department Level District Name';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_OPERATION_DATE IS 'Operational date of site: (A) is date opened/saw first patient; (P) is date planned to open. Format: CYYMMDD';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.VAST_EXTRACT_DATE IS 'VAST extraction date. Format: CYYMMDD';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.ACTIVE_START_DT IS 'Date station became active';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.ACTIVE_END_DT IS 'Date station became inactive';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.ACTIVE_FAG IS 'Indicator of the stations active/inactive status';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.GEOCODE_STATION_H.STATION_NAME IS 'Name of the VACAA facility';


CREATE UNIQUE INDEX ADR.GEOCODE_STATION_H_PK ON ADR.GEOCODE_STATION_H
(GEOCODE_STATION_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.GEOCODE_ST_ID_NU_I ON ADR.GEOCODE_STATION_H
(GEOCODE_STATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_STATION_H FOR ADR.GEOCODE_STATION_H;


ALTER TABLE ADR.GEOCODE_STATION_H ADD (
  CONSTRAINT GEOCODE_STATION_H_PK
  PRIMARY KEY
  (GEOCODE_STATION_H_ID)
  USING INDEX ADR.GEOCODE_STATION_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.GEOCODE_STATION_H TO ADR_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_STATION_H TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_STATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_STATION_H TO ES_RW;
ALTER TABLE ADR.GEOCODE_TRANSMIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_TRANSMIT CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_TRANSMIT
(
  GEOCODE_TRANSMIT_ID     NUMBER(20)            NOT NULL,
  GEOCODE_STATION_ID      NUMBER(20),
  PERSON_ID               NUMBER(20),
  ADDRESS_H_ID            NUMBER(20),
  ADDR_EXACT_MATCH_IND    NUMBER(1),
  ADDRESS_LINE1           VARCHAR2(100 BYTE),
  ADDRESS_LINE2           VARCHAR2(100 BYTE),
  CITY                    VARCHAR2(60 BYTE),
  STATE                   VARCHAR2(2 BYTE),
  ZIP                     VARCHAR2(5 BYTE),
  ZIP_PLUS4               VARCHAR2(4 BYTE),
  COUNTRY                 VARCHAR2(50 BYTE),
  FIPS                    VARCHAR2(5 BYTE),
  NEW_VISN                VARCHAR2(2 BYTE),
  MARKET                  VARCHAR2(4 BYTE),
  SUBMARKET               VARCHAR2(6 BYTE),
  SECTOR                  VARCHAR2(8 BYTE),
  DISTRICT                VARCHAR2(4 BYTE),
  STATE_FIPS              VARCHAR2(2 BYTE),
  COUNTY_NAME             VARCHAR2(255 BYTE),
  DISTRICT_NAME           VARCHAR2(255 BYTE),
  MARKET_NAME             VARCHAR2(255 BYTE),
  STATE_BY_COUNTY         VARCHAR2(2 BYTE),
  URH_CODE                VARCHAR2(1 BYTE),
  CONGRESSIONAL_DISTRICT  VARCHAR2(20 BYTE),
  ADDR_LONGITUDE          NUMBER(20),
  ADDR_LATITUDE           NUMBER(20),
  DRIVING_DISTANCE        NUMBER(20),
  ADDR_LOCATION_NAME      VARCHAR2(59 BYTE),
  ADDR_MATCH_TYPE         VARCHAR2(2 BYTE),
  MATCH_ADDRESS           VARCHAR2(120 BYTE),
  GEOCODING_FLAG          VARCHAR2(1 BYTE),
  GEOCODE_SW_VER          VARCHAR2(200 BYTE),
  GEOCODE_DATE            DATE,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL,
  VCELIGIBILITY_ID        NUMBER(20)
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION GEOCODE_TRANSMIT_P001 VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_TRANSMIT IS 'Log of records sent to geocode service and data received';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.GEOCODE_TRANSMIT_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.GEOCODE_STATION_ID IS 'FK to ADR.GEOCODE_STATION table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDRESS_H_ID IS 'FK to ADR.ADDRESS_H table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDR_EXACT_MATCH_IND IS 'Boolean Yes/No indicator of did Geocode match exactly to the address ES sent';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDRESS_LINE1 IS 'Street Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDRESS_LINE2 IS 'Street Address line 2';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.CITY IS 'City';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.STATE IS 'State for US (Province for non-US)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ZIP IS '5-digit ZIP code';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ZIP_PLUS4 IS 'Four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.COUNTRY IS 'Country';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.FIPS IS 'County Federal Information Processing Standard code (2 state + 3 county digits)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.NEW_VISN IS 'NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.MARKET IS 'Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.SUBMARKET IS 'Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.SECTOR IS 'Sector Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.DISTRICT IS 'VA District Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.STATE_FIPS IS 'County Federal Information Processing Standard code (2 digit state)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.COUNTY_NAME IS 'County Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.DISTRICT_NAME IS 'VA District Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.MARKET_NAME IS 'Market Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.STATE_BY_COUNTY IS 'State determined based on county data joined to file (see CountyName)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.CONGRESSIONAL_DISTRICT IS 'Congressional District';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDR_LONGITUDE IS 'Longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDR_LATITUDE IS 'Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.DRIVING_DISTANCE IS 'Driving Distance to nearest  station';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDR_LOCATION_NAME IS 'The name of the participating locator used for matching the address';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.ADDR_MATCH_TYPE IS 'M=Matched; U=Unmatched; T=Tied';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.MATCH_ADDRESS IS 'The address where the matched location actually resides based on geocoded results';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.GEOCODING_FLAG IS 'Geocoding flag 0, 1, 2, 3, 4, 5, Null';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.GEOCODE_SW_VER IS 'Geocoder Software Version';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.GEOCODE_DATE IS 'Date file was geocoded. Format: CYYMMDD where C = Century: 1=1800, 2=1900, C=2000';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.GEOCODETRANS_VCELIG_FK_I ON ADR.GEOCODE_TRANSMIT
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.GEOCODE_TRANSMIT_PK ON ADR.GEOCODE_TRANSMIT
(RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION GEOCODE_TRANSMIT_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.GT_PERSONID_IDX ON ADR.GEOCODE_TRANSMIT
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GT_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION GT_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION GT_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION GT_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.GEOCODE_TRANSMIT_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.GEOCODE_TRANSMIT
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO GEOCODE_TRANSMIT_H (GEOCODE_TRANSMIT_H_ID,
                                      GEOCODE_TRANSMIT_ID,
                                      GEOCODE_STATION_ID,
                                      PERSON_ID,
                                      ADDRESS_H_ID,
                                      ADDR_EXACT_MATCH_IND,
                                      ADDRESS_LINE1,
                                      ADDRESS_LINE2,
                                      CITY,
                                      STATE,
                                      ZIP,
                                      ZIP_PLUS4,
                                      COUNTRY,
                                      FIPS,
                                      NEW_VISN,
                                      MARKET,
                                      SUBMARKET,
                                      SECTOR,
                                      DISTRICT,
                                      STATE_FIPS,
                                      COUNTY_NAME,
                                      DISTRICT_NAME,
                                      MARKET_NAME,
                                      STATE_BY_COUNTY,
                                      URH_CODE,
                                      CONGRESSIONAL_DISTRICT,
                                      ADDR_LONGITUDE,
                                      ADDR_LATITUDE,
                                      DRIVING_DISTANCE,
                                      ADDR_LOCATION_NAME,
                                      ADDR_MATCH_TYPE,
                                      MATCH_ADDRESS,
                                      GEOCODING_FLAG,
                                      GEOCODE_SW_VER,
                                      GEOCODE_DATE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      VCELIGIBILITY_ID,
                                      TRANSACTION_TYPE_CODE)
           VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
                   :old.GEOCODE_TRANSMIT_ID,
                   :old.GEOCODE_STATION_ID,
                   :old.PERSON_ID,
                   :old.ADDRESS_H_ID,
                   :old.ADDR_EXACT_MATCH_IND,
                   :old.ADDRESS_LINE1,
                   :old.ADDRESS_LINE2,
                   :old.CITY,
                   :old.STATE,
                   :old.ZIP,
                   :old.ZIP_PLUS4,
                   :old.COUNTRY,
                   :old.FIPS,
                   :old.NEW_VISN,
                   :old.MARKET,
                   :old.SUBMARKET,
                   :old.SECTOR,
                   :old.DISTRICT,
                   :old.STATE_FIPS,
                   :old.COUNTY_NAME,
                   :old.DISTRICT_NAME,
                   :old.MARKET_NAME,
                   :old.STATE_BY_COUNTY,
                   :old.URH_CODE,
                   :old.CONGRESSIONAL_DISTRICT,
                   :old.ADDR_LONGITUDE,
                   :old.ADDR_LATITUDE,
                   :old.DRIVING_DISTANCE,
                   :old.ADDR_LOCATION_NAME,
                   :old.ADDR_MATCH_TYPE,
                   :old.MATCH_ADDRESS,
                   :old.GEOCODING_FLAG,
                   :old.GEOCODE_SW_VER,
                   :old.GEOCODE_DATE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   :old.VCELIGIBILITY_ID,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO GEOCODE_TRANSMIT_H (GEOCODE_TRANSMIT_H_ID,
                                      GEOCODE_TRANSMIT_ID,
                                      GEOCODE_STATION_ID,
                                      PERSON_ID,
                                      ADDRESS_H_ID,
                                      ADDR_EXACT_MATCH_IND,
                                      ADDRESS_LINE1,
                                      ADDRESS_LINE2,
                                      CITY,
                                      STATE,
                                      ZIP,
                                      ZIP_PLUS4,
                                      COUNTRY,
                                      FIPS,
                                      NEW_VISN,
                                      MARKET,
                                      SUBMARKET,
                                      SECTOR,
                                      DISTRICT,
                                      STATE_FIPS,
                                      COUNTY_NAME,
                                      DISTRICT_NAME,
                                      MARKET_NAME,
                                      STATE_BY_COUNTY,
                                      URH_CODE,
                                      CONGRESSIONAL_DISTRICT,
                                      ADDR_LONGITUDE,
                                      ADDR_LATITUDE,
                                      DRIVING_DISTANCE,
                                      ADDR_LOCATION_NAME,
                                      ADDR_MATCH_TYPE,
                                      MATCH_ADDRESS,
                                      GEOCODING_FLAG,
                                      GEOCODE_SW_VER,
                                      GEOCODE_DATE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      VCELIGIBILITY_ID,
                                      TRANSACTION_TYPE_CODE)
          VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
                   :new.GEOCODE_TRANSMIT_ID,
                   :new.GEOCODE_STATION_ID,
                   :new.PERSON_ID,
                   :new.ADDRESS_H_ID,
                   :new.ADDR_EXACT_MATCH_IND,
                   :new.ADDRESS_LINE1,
                   :new.ADDRESS_LINE2,
                   :new.CITY,
                   :new.STATE,
                   :new.ZIP,
                   :new.ZIP_PLUS4,
                   :new.COUNTRY,
                   :new.FIPS,
                   :new.NEW_VISN,
                   :new.MARKET,
                   :new.SUBMARKET,
                   :new.SECTOR,
                   :new.DISTRICT,
                   :new.STATE_FIPS,
                   :new.COUNTY_NAME,
                   :new.DISTRICT_NAME,
                   :new.MARKET_NAME,
                   :new.STATE_BY_COUNTY,
                   :new.URH_CODE,
                   :new.CONGRESSIONAL_DISTRICT,
                   :new.ADDR_LONGITUDE,
                   :new.ADDR_LATITUDE,
                   :new.DRIVING_DISTANCE,
                   :new.ADDR_LOCATION_NAME,
                   :new.ADDR_MATCH_TYPE,
                   :new.MATCH_ADDRESS,
                   :new.GEOCODING_FLAG,
                   :new.GEOCODE_SW_VER,
                   :new.GEOCODE_DATE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   :new.VCELIGIBILITY_ID,
                   mDML);
   END IF;
END GEOCODE_TRANSMIT_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_TRANSMIT FOR ADR.GEOCODE_TRANSMIT;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODE_TRANSMIT_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  USING INDEX LOCAL
  ENABLE VALIDATE);

ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCD_TRNSMIT_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT GEOCODETRANS_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE,
  CONSTRAINT GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.GEOCODE_TRANSMIT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_TRANSMIT TO ES_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_TRANSMIT TO ES_RW;

GRANT SELECT ON ADR.GEOCODE_TRANSMIT TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT TO VETCHOICE_RW;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
(
  GEOCODE_TRANSMIT_ID     NUMBER(20)            NOT NULL,
  GEOCODE_STATION_ID      NUMBER(20),
  PERSON_ID               NUMBER(20),
  ADDRESS_H_ID            NUMBER(20),
  ADDR_EXACT_MATCH_IND    NUMBER(1),
  ADDRESS_LINE1           VARCHAR2(100 BYTE),
  ADDRESS_LINE2           VARCHAR2(100 BYTE),
  CITY                    VARCHAR2(60 BYTE),
  STATE                   VARCHAR2(2 BYTE),
  ZIP                     VARCHAR2(5 BYTE),
  ZIP_PLUS4               VARCHAR2(4 BYTE),
  COUNTRY                 VARCHAR2(50 BYTE),
  FIPS                    VARCHAR2(5 BYTE),
  NEW_VISN                VARCHAR2(2 BYTE),
  MARKET                  VARCHAR2(4 BYTE),
  SUBMARKET               VARCHAR2(6 BYTE),
  SECTOR                  VARCHAR2(8 BYTE),
  DISTRICT                VARCHAR2(4 BYTE),
  STATE_FIPS              VARCHAR2(2 BYTE),
  COUNTY_NAME             VARCHAR2(255 BYTE),
  DISTRICT_NAME           VARCHAR2(255 BYTE),
  MARKET_NAME             VARCHAR2(255 BYTE),
  STATE_BY_COUNTY         VARCHAR2(2 BYTE),
  URH_CODE                VARCHAR2(1 BYTE),
  CONGRESSIONAL_DISTRICT  VARCHAR2(20 BYTE),
  ADDR_LONGITUDE          NUMBER(20),
  ADDR_LATITUDE           NUMBER(20),
  DRIVING_DISTANCE        NUMBER(20),
  ADDR_LOCATION_NAME      VARCHAR2(59 BYTE),
  ADDR_MATCH_TYPE         VARCHAR2(2 BYTE),
  MATCH_ADDRESS           VARCHAR2(120 BYTE),
  GEOCODING_FLAG          VARCHAR2(1 BYTE),
  GEOCODE_SW_VER          VARCHAR2(50 BYTE),
  GEOCODE_DATE            DATE,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL,
  VCELIGIBILITY_ID        NUMBER(20)
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION GEOCODE_TRANSMIT_ARCHIVE_P001 VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE IS 'Log of records sent to geocode service and data received';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.GEOCODE_TRANSMIT_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.GEOCODE_STATION_ID IS 'FK to ADR.GEOCODE_STATION table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDRESS_H_ID IS 'FK to ADR.ADDRESS_H table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDR_EXACT_MATCH_IND IS 'Boolean Yes/No indicator of did Geocode match exactly to the address ES sent';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDRESS_LINE1 IS 'Street Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.CITY IS 'City';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.STATE IS 'State for US (Province for non-US)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ZIP IS '5-digit ZIP code';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ZIP_PLUS4 IS 'Four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.COUNTRY IS 'Country';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.FIPS IS 'County Federal Information Processing Standard code (2 state + 3 county digits)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.NEW_VISN IS 'NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.MARKET IS 'Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.SUBMARKET IS 'Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.SECTOR IS 'Sector Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.DISTRICT IS 'VA District Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.STATE_FIPS IS 'County Federal Information Processing Standard code (2 digit state)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.COUNTY_NAME IS 'County Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.DISTRICT_NAME IS 'VA District Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.MARKET_NAME IS 'Market Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.STATE_BY_COUNTY IS 'State determined based on county data joined to file (see CountyName)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.CONGRESSIONAL_DISTRICT IS 'Congressional District';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDR_LONGITUDE IS 'Longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDR_LATITUDE IS 'Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDR_LOCATION_NAME IS 'The name of the participating locator used for matching the address';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.ADDR_MATCH_TYPE IS 'M=Matched; U=Unmatched; T=Tied';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.MATCH_ADDRESS IS 'The address where the matched location actually resides based on geocoded results';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.GEOCODING_FLAG IS 'Geocoding flag 0, 1, 2, 3, 4, 5, Null';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.GEOCODE_SW_VER IS 'Geocoder Software Version';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.GEOCODE_DATE IS 'Date file was geocoded. Format: CYYMMDD where C = Century: 1=1800, 2=1900, C=2000';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_ARCHIVE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.GEOCDTRANSARCH_VCELIG_FK_I ON ADR.GEOCODE_TRANSMIT_ARCHIVE
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.GEOCODE_TRANSMIT_ARCHIVE_PK ON ADR.GEOCODE_TRANSMIT_ARCHIVE
(RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION GEOCODE_TRANSMIT_ARCHIVE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.GTA_PERSONID_IDX ON ADR.GEOCODE_TRANSMIT_ARCHIVE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GTA_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION GTA_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION GTA_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION GTA_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_TRANSMIT_ARCHIVE FOR ADR.GEOCODE_TRANSMIT_ARCHIVE;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCODE_TRANSMIT_ARCHIVE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  USING INDEX LOCAL
  ENABLE VALIDATE);

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCDTRANSARCH_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE,
  CONSTRAINT GEOCD_TRNSMIT_ARCH_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT GTA_GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT GTA_TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ES_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO ES_RW;

GRANT SELECT ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT_ARCHIVE TO VETCHOICE_RW;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_TRANSMIT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_TRANSMIT_H
(
  GEOCODE_TRANSMIT_H_ID   NUMBER(20)            NOT NULL,
  GEOCODE_TRANSMIT_ID     NUMBER(20)            NOT NULL,
  GEOCODE_STATION_ID      NUMBER(20),
  PERSON_ID               NUMBER(20),
  ADDRESS_H_ID            NUMBER(20),
  ADDR_EXACT_MATCH_IND    NUMBER(1),
  ADDRESS_LINE1           VARCHAR2(100 BYTE),
  ADDRESS_LINE2           VARCHAR2(100 BYTE),
  CITY                    VARCHAR2(60 BYTE),
  STATE                   VARCHAR2(2 BYTE),
  ZIP                     VARCHAR2(5 BYTE),
  ZIP_PLUS4               VARCHAR2(4 BYTE),
  COUNTRY                 VARCHAR2(50 BYTE),
  FIPS                    VARCHAR2(5 BYTE),
  NEW_VISN                VARCHAR2(2 BYTE),
  MARKET                  VARCHAR2(4 BYTE),
  SUBMARKET               VARCHAR2(6 BYTE),
  SECTOR                  VARCHAR2(8 BYTE),
  DISTRICT                VARCHAR2(4 BYTE),
  STATE_FIPS              VARCHAR2(2 BYTE),
  COUNTY_NAME             VARCHAR2(255 BYTE),
  DISTRICT_NAME           VARCHAR2(255 BYTE),
  MARKET_NAME             VARCHAR2(255 BYTE),
  STATE_BY_COUNTY         VARCHAR2(2 BYTE),
  URH_CODE                VARCHAR2(1 BYTE),
  CONGRESSIONAL_DISTRICT  VARCHAR2(20 BYTE),
  ADDR_LONGITUDE          NUMBER(20),
  ADDR_LATITUDE           NUMBER(20),
  DRIVING_DISTANCE        NUMBER(20),
  ADDR_LOCATION_NAME      VARCHAR2(59 BYTE),
  ADDR_MATCH_TYPE         VARCHAR2(2 BYTE),
  MATCH_ADDRESS           VARCHAR2(120 BYTE),
  GEOCODING_FLAG          VARCHAR2(1 BYTE),
  GEOCODE_SW_VER          VARCHAR2(200 BYTE),
  GEOCODE_DATE            DATE,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL,
  VCELIGIBILITY_ID        NUMBER(20),
  TRANSACTION_TYPE_CODE   CHAR(1 BYTE)
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION GEOCDTRANS_P01 VALUES LESS THAN (TO_DATE(' 2017-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_TRANSMIT_H IS 'Historical log of records sent to geocode service and data received';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.GEOCODE_TRANSMIT_H_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.GEOCODE_TRANSMIT_ID IS 'FK key index referenced from GEOCODE_TRANSMIT';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.GEOCODE_STATION_ID IS 'FK to ADR.GEOCODE_STATION table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDRESS_H_ID IS 'FK to ADR.ADDRESS_H table';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDR_EXACT_MATCH_IND IS 'Boolean Yes/No indicator of did Geocode match exactly to the address ES sent';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDRESS_LINE1 IS 'Street Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDRESS_LINE2 IS 'Street Address line 2';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.CITY IS 'City';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.STATE IS 'State for US (Province for non-US)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ZIP IS '5-digit ZIP code';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ZIP_PLUS4 IS 'Four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.COUNTRY IS 'Country';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.FIPS IS 'County Federal Information Processing Standard code (2 state + 3 county digits)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.NEW_VISN IS 'NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.MARKET IS 'Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.SUBMARKET IS 'Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.SECTOR IS 'Sector Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.DISTRICT IS 'VA District Identifier';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.STATE_FIPS IS 'County Federal Information Processing Standard code (2 digit state)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.COUNTY_NAME IS 'County Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.DISTRICT_NAME IS 'VA District Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.MARKET_NAME IS 'Market Name';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.STATE_BY_COUNTY IS 'State determined based on county data joined to file (see CountyName)';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.CONGRESSIONAL_DISTRICT IS 'Congressional District';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDR_LONGITUDE IS 'Longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDR_LATITUDE IS 'Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.DRIVING_DISTANCE IS 'Driving Distance to nearest  station';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDR_LOCATION_NAME IS 'The name of the participating locator used for matching the address';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.ADDR_MATCH_TYPE IS 'M=Matched; U=Unmatched; T=Tied';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.MATCH_ADDRESS IS 'The address where the matched location actually resides based on geocoded results';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.GEOCODING_FLAG IS 'Geocoding flag 0, 1, 2, 3, 4, 5, Null';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.GEOCODE_SW_VER IS 'Geocoder Software Version';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.GEOCODE_DATE IS 'Date file was geocoded. Format: CYYMMDD where C = Century: 1=1800, 2=1900, C=2000';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_TRANSMIT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.GEOCDTTNS_H_CRDTGEOTRNSID_NU_I ON ADR.GEOCODE_TRANSMIT_H
(RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION GEOCDTRANS_P01
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.GEOCDTTNS_H_PERSONID_NU_I ON ADR.GEOCODE_TRANSMIT_H
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P1
    TABLESPACE L_INDEX_01,  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P2
    TABLESPACE L_INDEX_01,  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P3
    TABLESPACE L_INDEX_01,  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P4
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE INDEX ADR.GEOCDTTNS_H_VCELIG_NU_I ON ADR.GEOCODE_TRANSMIT_H
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.GEOCODE_TRANSMIT_H_PK_I ON ADR.GEOCODE_TRANSMIT_H
(GEOCODE_TRANSMIT_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_TRANSMIT_H FOR ADR.GEOCODE_TRANSMIT_H;


ALTER TABLE ADR.GEOCODE_TRANSMIT_H ADD (
  CONSTRAINT GEOCODE_TRANSMIT_H_PK
  PRIMARY KEY
  (GEOCODE_TRANSMIT_H_ID)
  USING INDEX ADR.GEOCODE_TRANSMIT_H_PK_I
  ENABLE VALIDATE);

GRANT SELECT ON ADR.GEOCODE_TRANSMIT_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT_H TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_TRANSMIT_H TO ES_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_TRANSMIT_H TO ES_RW;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_BATCH_REQUEST CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_BATCH_REQUEST
(
  HANDBOOK_BATCH_REQUEST_ID       NUMBER(20)    NOT NULL,
  BATCH_RELEASE_DATE              DATE          NOT NULL,
  BATCH_CANCEL_DATE               DATE,
  MAX_PER_JOB_NUMBER              NUMBER(10),
  BATCH_RELEASE_SIZE              NUMBER(10),
  NOTE                            VARCHAR2(400 BYTE),
  STD_HANDBOOKRELEASECNTL_ID      NUMBER(20)    NOT NULL,
  STD_HANDBOOKBATCHREQUESTSTA_ID  NUMBER(20)    NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_BATCH_REQUEST IS 'A batch request for generation of documents';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.MAX_PER_JOB_NUMBER IS 'Maximum number of handbooks generated per request. Set by the user.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.BATCH_RELEASE_SIZE IS 'Actual number of veterans documents scheduled for this batch request';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.HNDBATREQ_PK ON ADR.HANDBOOK_BATCH_REQUEST
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDBATREQ_STDHDBRELCNT_FK_I ON ADR.HANDBOOK_BATCH_REQUEST
(STD_HANDBOOKRELEASECNTL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDBATREQ_STDHNDREQSTA_FK_I ON ADR.HANDBOOK_BATCH_REQUEST
(STD_HANDBOOKBATCHREQUESTSTA_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_BATCH_REQ_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.HANDBOOK_BATCH_REQUEST  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_BATCH_REQUEST_H
        (
        HANDBOOK_BATCH_REQUEST_H_ID,
        HANDBOOK_BATCH_REQUEST_ID,
    MAX_PER_JOB_NUMBER,
    BATCH_RELEASE_DATE,
    BATCH_RELEASE_SIZE,
    BATCH_CANCEL_DATE,
    NOTE,
    STD_HANDBOOKRELEASECNTL_ID,
    STD_HANDBOOKBATCHREQUESTSTA_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_BATCH_REQUEST_H_S.nextval,
        :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.MAX_PER_JOB_NUMBER,
        :old.BATCH_RELEASE_DATE,
        :old.BATCH_RELEASE_SIZE,
        :old.BATCH_CANCEL_DATE,
        :old.NOTE,
        :old.STD_HANDBOOKRELEASECNTL_ID,
       :OLD.STD_HANDBOOKBATCHREQUESTSTA_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_BATCH_REQUEST_H
        (
        HANDBOOK_BATCH_REQUEST_H_ID,
        HANDBOOK_BATCH_REQUEST_ID,
    MAX_PER_JOB_NUMBER,
    BATCH_RELEASE_DATE,
    BATCH_RELEASE_SIZE,
    BATCH_CANCEL_DATE,
    NOTE,
    STD_HANDBOOKRELEASECNTL_ID,
  STD_HANDBOOKBATCHREQUESTSTA_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_BATCH_REQUEST_H_S.nextval,
        :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.MAX_PER_JOB_NUMBER,
        :new.BATCH_RELEASE_DATE,
        :new.BATCH_RELEASE_SIZE,
        :new.BATCH_CANCEL_DATE,
        :new.NOTE,
        :new.STD_HANDBOOKRELEASECNTL_ID,
        :new.STD_HANDBOOKBATCHREQUESTSTA_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_BATCH_REQ_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_BATCH_REQUEST FOR ADR.HANDBOOK_BATCH_REQUEST;


ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT HNDBATREQ_PK
  PRIMARY KEY
  (HANDBOOK_BATCH_REQUEST_ID)
  USING INDEX ADR.HNDBATREQ_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT R_1051 
  FOREIGN KEY (STD_HANDBOOKRELEASECNTL_ID) 
  REFERENCES ADRREF.STD_HANDBOOKRELEASECONTROL (ID)
  ENABLE VALIDATE,
  CONSTRAINT R_1064 
  FOREIGN KEY (STD_HANDBOOKBATCHREQUESTSTA_ID) 
  REFERENCES ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_BATCH_REQUEST TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_BATCH_REQUEST TO ES_RW;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_BATCH_REQUEST_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_BATCH_REQUEST_H
(
  HANDBOOK_BATCH_REQUEST_ID       NUMBER(20)    NOT NULL,
  BATCH_RELEASE_DATE              DATE          NOT NULL,
  BATCH_CANCEL_DATE               DATE,
  MAX_PER_JOB_NUMBER              NUMBER(10),
  BATCH_RELEASE_SIZE              NUMBER(10),
  NOTE                            VARCHAR2(400 BYTE),
  STD_HANDBOOKRELEASECNTL_ID      NUMBER(20)    NOT NULL,
  STD_HANDBOOKBATCHREQUESTSTA_ID  NUMBER(20)    NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  HISTORY_CREATED_DATE            DATE          NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  HANDBOOK_BATCH_REQUEST_H_ID     NUMBER(20)    NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_BATCH_REQUEST_H IS 'A batch request for generation of documents';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.MAX_PER_JOB_NUMBER IS 'Maximum number of handbooks generated per request. Set by the user.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.BATCH_RELEASE_SIZE IS 'Actual number of veterans documents scheduled for this batch request';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HANDBOOK_BATCH_REQUEST_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.HNDBATREQH_PK ON ADR.HANDBOOK_BATCH_REQUEST_H
(HANDBOOK_BATCH_REQUEST_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_BATCH_REQUEST_H FOR ADR.HANDBOOK_BATCH_REQUEST_H;


ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H ADD (
  CONSTRAINT HNDBATREQH_PK
  PRIMARY KEY
  (HANDBOOK_BATCH_REQUEST_H_ID)
  USING INDEX ADR.HNDBATREQH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_BATCH_REQUEST_H TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_BATCH_REQUEST_H TO ES_RW;
ALTER TABLE ADR.HANDBOOK_DOCUMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_DOCUMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_DOCUMENT
(
  HANDBOOK_DOCUMENT_ID     NUMBER(20),
  DOCUMENT_TEXT            CLOB,
  HANDBOOK_MAIL_STATUS_ID  NUMBER(20),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE      DATE,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE     DATE,
  RECORD_MODIFIED_COUNT    NUMBER(10)
)
LOB (DOCUMENT_TEXT) STORE AS (
  TABLESPACE  L_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_DOCUMENT IS 'Text of the Handbook sent to the Configuration Management System (CMS).';

COMMENT ON COLUMN ADR.HANDBOOK_DOCUMENT.DOCUMENT_TEXT IS 'Contents of the Handbook as sent to the Content Management System (CMS)';

COMMENT ON COLUMN ADR.HANDBOOK_DOCUMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_DOCUMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_DOCUMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_DOCUMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_DOCUMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HNDDOC_HNDMALSTA_FK_I ON ADR.HANDBOOK_DOCUMENT
(HANDBOOK_MAIL_STATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HNDDOC_PK ON ADR.HANDBOOK_DOCUMENT
(HANDBOOK_DOCUMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_DOCUMENT FOR ADR.HANDBOOK_DOCUMENT;


ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186897
  CHECK ("HANDBOOK_DOCUMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186898
  CHECK ("HANDBOOK_MAIL_STATUS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186899
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186900
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186901
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186902
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186903
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT HNDDOC_PK
  PRIMARY KEY
  (HANDBOOK_DOCUMENT_ID)
  USING INDEX ADR.HNDDOC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT R_1059 
  FOREIGN KEY (HANDBOOK_MAIL_STATUS_ID) 
  REFERENCES ADR.HANDBOOK_MAIL_STATUS (HANDBOOK_MAIL_STATUS_ID)
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.HANDBOOK_DOCUMENT TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_DOCUMENT TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_DOCUMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_DOCUMENT TO ES_RW;
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_MAIL_QUEUE CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_MAIL_QUEUE
(
  HANDBOOK_MAIL_QUEUE_ID      NUMBER(20),
  COM_LETTER_TEMPLATE_ID      NUMBER(20),
  REMARK                      VARCHAR2(400 BYTE),
  STD_HANDBOOKRELEASECNTL_ID  NUMBER(20),
  HANDBOOK_BATCH_REQUEST_ID   NUMBER(20),
  PERSON_ID                   NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE         DATE,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE        DATE,
  RECORD_MODIFIED_COUNT       NUMBER(10),
  ADDRESS_ID                  NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_MAIL_QUEUE IS 'Veterans Health Benefits Communication created for a specific Veteran.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.HANDBOOK_MAIL_QUEUE_ID IS 'The identifier associated with a document request.
For example, the CMS Communications ID / Receipt String associated with the document request from ESR.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.COM_LETTER_TEMPLATE_ID IS 'HandBook Form Number.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HNDMALQUE_HNDBATREQ_FK ON ADR.HANDBOOK_MAIL_QUEUE
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDMALQUE_PER_FK ON ADR.HANDBOOK_MAIL_QUEUE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HNDMALQUE_PK ON ADR.HANDBOOK_MAIL_QUEUE
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDMALQUE_STDHNDBKRELCNT_FK ON ADR.HANDBOOK_MAIL_QUEUE
(STD_HANDBOOKRELEASECNTL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_MAIL_QUEUE_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."HANDBOOK_MAIL_QUEUE" FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_MAIL_QUEUE_H
        (
        HANDBOOK_MAIL_QUEUE_H_ID,
        HANDBOOK_MAIL_QUEUE_ID,
    COM_LETTER_TEMPLATE_ID,
    REMARK,
    STD_HANDBOOKRELEASECNTL_ID,
    PERSON_ID,
    ADDRESS_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_QUEUE_H_S.nextval,
        :old.HANDBOOK_MAIL_QUEUE_ID,
    :old.COM_LETTER_TEMPLATE_ID,
    :old.REMARK,
    :old.STD_HANDBOOKRELEASECNTL_ID,
    :old.PERSON_ID,
    :old.ADDRESS_ID,
    :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_MAIL_QUEUE_H
        (
        HANDBOOK_MAIL_QUEUE_H_ID,
        HANDBOOK_MAIL_QUEUE_ID,
    COM_LETTER_TEMPLATE_ID,
    REMARK,
    STD_HANDBOOKRELEASECNTL_ID,
    PERSON_ID,
    ADDRESS_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_QUEUE_H_S.nextval,
        :new.HANDBOOK_MAIL_QUEUE_ID,
    :new.COM_LETTER_TEMPLATE_ID,
    :new.REMARK,
    :new.STD_HANDBOOKRELEASECNTL_ID,
    :new.PERSON_ID,
    :new.ADDRESS_ID,
    :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_MAIL_QUEUE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_MAIL_QUEUE FOR ADR.HANDBOOK_MAIL_QUEUE;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186904
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186905
  CHECK ("COM_LETTER_TEMPLATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186906
  CHECK ("STD_HANDBOOKRELEASECNTL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186907
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186908
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186909
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186910
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186911
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186912
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT COMLOG_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_QUEUE_ID)
  USING INDEX ADR.HNDMALQUE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1050 
  FOREIGN KEY (STD_HANDBOOKRELEASECNTL_ID) 
  REFERENCES ADRREF.STD_HANDBOOKRELEASECONTROL (ID)
  ENABLE VALIDATE,
  CONSTRAINT R_1053 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT R_1065 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_QUEUE TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_QUEUE TO ES_RW;
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_MAIL_QUEUE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_MAIL_QUEUE_H
(
  HANDBOOK_MAIL_QUEUE_ID      NUMBER(20),
  COM_LETTER_TEMPLATE_ID      NUMBER(20),
  REMARK                      VARCHAR2(400 BYTE),
  STD_HANDBOOKRELEASECNTL_ID  NUMBER(20),
  HANDBOOK_BATCH_REQUEST_ID   NUMBER(20),
  PERSON_ID                   NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE         DATE,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE        DATE,
  RECORD_MODIFIED_COUNT       NUMBER(10),
  HISTORY_CREATED_DATE        DATE,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE),
  HANDBOOK_MAIL_QUEUE_H_ID    NUMBER(20),
  ADDRESS_ID                  NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_MAIL_QUEUE_H IS 'Veterans Health Benefits Communication created for a specific Veteran.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.COM_LETTER_TEMPLATE_ID IS 'HandBook Form Number.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_QUEUE_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.HNDBK_MAIL_QUEID_NU ON ADR.HANDBOOK_MAIL_QUEUE_H
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HNDMALQUEH_PK ON ADR.HANDBOOK_MAIL_QUEUE_H
(HANDBOOK_MAIL_QUEUE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_MAIL_QUEUE_H FOR ADR.HANDBOOK_MAIL_QUEUE_H;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186913
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186914
  CHECK ("COM_LETTER_TEMPLATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186915
  CHECK ("STD_HANDBOOKRELEASECNTL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186916
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186917
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186918
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186919
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186920
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186921
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186922
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186923
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186924
  CHECK ("HANDBOOK_MAIL_QUEUE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT HNDMALQUEH_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_QUEUE_H_ID)
  USING INDEX ADR.HNDMALQUEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_QUEUE_H TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_QUEUE_H TO ES_RW;
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_MAIL_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_MAIL_STATUS
(
  HANDBOOK_MAIL_STATUS_ID      NUMBER(20),
  STD_COMREJECTREASONTYPE_ID   NUMBER(20),
  HANDBOOK_MAIL_QUEUE_ID       NUMBER(20),
  CMS_FILE_GENERATED_DATE      DATE,
  SENT_TO_USPS_DATE            DATE,
  RETURNED_FROM_USPS_DATE      DATE,
  ERROR_TEXT                   VARCHAR2(400 BYTE),
  STD_HANDBOOKMAILSTATTYPE_ID  NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_MAIL_STATUS IS 'Status of a handbook mailing.  HANDBOOK_MAIL_QUEUE table holds the base request and HANDBOOK_MAIL_STATUS holds the corresponding status and associated fields. Every time the status changes, the corresponding fields are reset in the HANDBOOK_MAIL_STATUS table. For example, if the status changes to resend, then set nulls to fields for errors, dates, etc.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.HANDBOOK_MAIL_QUEUE_ID IS 'The identifier associated with a document request.
For example, the CMS Communications ID / Receipt String associated with the document request from ESR.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.SENT_TO_USPS_DATE IS 'Mailing sent to USPS date.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HNDMALSTA_HNDMALQUE_FK ON ADR.HANDBOOK_MAIL_STATUS
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HNDMALSTA_PK ON ADR.HANDBOOK_MAIL_STATUS
(HANDBOOK_MAIL_STATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDMALSTA_STDCOMREJREATYP_FK ON ADR.HANDBOOK_MAIL_STATUS
(STD_COMREJECTREASONTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDMALSTA_STDHNDBKMALSTATYP_FK ON ADR.HANDBOOK_MAIL_STATUS
(STD_HANDBOOKMAILSTATTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_MAIL_STATUS_AUD_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."HANDBOOK_MAIL_STATUS" FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_MAIL_STATUS_H
        (
        HANDBOOK_MAIL_STATUS_H_ID,
        HANDBOOK_MAIL_STATUS_ID,
    CMS_FILE_GENERATED_DATE,
    SENT_TO_USPS_DATE,
    HANDBOOK_MAIL_QUEUE_ID,
    STD_COMREJECTREASONTYPE_ID,
    STD_HANDBOOKMAILSTATTYPE_ID,
    ERROR_TEXT,
    RETURNED_FROM_USPS_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_STATUS_H_S.nextval,
        :old.HANDBOOK_MAIL_STATUS_ID,
    :old.CMS_FILE_GENERATED_DATE,
    :old.SENT_TO_USPS_DATE,
    :old.HANDBOOK_MAIL_QUEUE_ID,
    :old.STD_COMREJECTREASONTYPE_ID,
    :old.STD_HANDBOOKMAILSTATTYPE_ID,
    :old.ERROR_TEXT,
    :old.RETURNED_FROM_USPS_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_MAIL_STATUS_H
        (
        HANDBOOK_MAIL_STATUS_H_ID,
        HANDBOOK_MAIL_STATUS_ID,
    CMS_FILE_GENERATED_DATE,
    SENT_TO_USPS_DATE,
    HANDBOOK_MAIL_QUEUE_ID,
    STD_COMREJECTREASONTYPE_ID,
    STD_HANDBOOKMAILSTATTYPE_ID,
    ERROR_TEXT,
    RETURNED_FROM_USPS_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_STATUS_H_S.nextval,
        :new.HANDBOOK_MAIL_STATUS_ID,
    :new.CMS_FILE_GENERATED_DATE,
    :new.SENT_TO_USPS_DATE,
    :new.HANDBOOK_MAIL_QUEUE_ID,
    :new.STD_COMREJECTREASONTYPE_ID,
    :new.STD_HANDBOOKMAILSTATTYPE_ID,
    :new.ERROR_TEXT,
    :new.RETURNED_FROM_USPS_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_MAIL_STATUS_AUD_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_MAIL_STATUS FOR ADR.HANDBOOK_MAIL_STATUS;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186925
  CHECK ("HANDBOOK_MAIL_STATUS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186926
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186927
  CHECK ("STD_HANDBOOKMAILSTATTYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186928
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186929
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186930
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186931
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186932
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT HNDMALSTA_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_STATUS_ID)
  USING INDEX ADR.HNDMALSTA_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1057 
  FOREIGN KEY (HANDBOOK_MAIL_QUEUE_ID) 
  REFERENCES ADR.HANDBOOK_MAIL_QUEUE (HANDBOOK_MAIL_QUEUE_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT R_1058 
  FOREIGN KEY (STD_COMREJECTREASONTYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  ENABLE VALIDATE,
  CONSTRAINT R_1060 
  FOREIGN KEY (STD_HANDBOOKMAILSTATTYPE_ID) 
  REFERENCES ADRREF.STD_HANDBOOKMAILSTATTYPE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_STATUS TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_STATUS TO ES_RW;
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_MAIL_STATUS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_MAIL_STATUS_H
(
  HANDBOOK_MAIL_STATUS_ID      NUMBER(20),
  STD_COMREJECTREASONTYPE_ID   NUMBER(20),
  HANDBOOK_MAIL_QUEUE_ID       NUMBER(20),
  CMS_FILE_GENERATED_DATE      DATE,
  SENT_TO_USPS_DATE            DATE,
  RETURNED_FROM_USPS_DATE      DATE,
  ERROR_TEXT                   VARCHAR2(400 BYTE),
  STD_HANDBOOKMAILSTATTYPE_ID  NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  HISTORY_CREATED_DATE         DATE,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE),
  HANDBOOK_MAIL_STATUS_H_ID    NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_MAIL_STATUS_H IS 'Status of a handbook mailing.  HANDBOOK_MAIL_QUEUE table holds the base request and HANDBOOK_MAIL_STATUS holds the corresponding status and associated fields. Every time the status changes, the corresponding fields are reset in the HANDBOOK_MAIL_STATUS table. For example, if the status changes to resend, then set nulls to fields for errors, dates, etc.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.SENT_TO_USPS_DATE IS 'Mailing sent to USPS date.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HANDBOOK_MAIL_STATUS_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.HNDMALSTAH_CMSFLGENDT_NU_I ON ADR.HANDBOOK_MAIL_STATUS_H
(CMS_FILE_GENERATED_DATE, STD_HANDBOOKMAILSTATTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDMALSTAH_HNDMALQUE_NU_I ON ADR.HANDBOOK_MAIL_STATUS_H
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HNDMALSTAH_PK ON ADR.HANDBOOK_MAIL_STATUS_H
(HANDBOOK_MAIL_STATUS_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_MAIL_STATUS_H FOR ADR.HANDBOOK_MAIL_STATUS_H;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186933
  CHECK ("HANDBOOK_MAIL_STATUS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186934
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186935
  CHECK ("STD_HANDBOOKMAILSTATTYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186936
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186937
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186938
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186939
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186940
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186941
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186942
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00186943
  CHECK ("HANDBOOK_MAIL_STATUS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT HNDMALSTAH_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_STATUS_H_ID)
  USING INDEX ADR.HNDMALSTAH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_MAIL_STATUS_H TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_MAIL_STATUS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_MAIL_STATUS_H TO ES_RW;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_REQUEST_VETERAN CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_REQUEST_VETERAN
(
  HANDBOOK_REQUEST_VETERAN_ID  NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  HANDBOOK_BATCH_REQUEST_ID    NUMBER(20)       NOT NULL,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_REQUEST_VETERAN IS 'A veteran included in a batch request for document generation.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HNDREQVET_HNDBCHREQ_FK_I ON ADR.HANDBOOK_REQUEST_VETERAN
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HNDREQVET_PK ON ADR.HANDBOOK_REQUEST_VETERAN
(HANDBOOK_REQUEST_VETERAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HNDREQVET_PRSN_FK_I ON ADR.HANDBOOK_REQUEST_VETERAN
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_REQ_VET_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.HANDBOOK_REQUEST_VETERAN  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_REQUEST_VETERAN_H
        (
       HANDBOOK_REQUEST_VETERAN_H_ID,
       HANDBOOK_REQUEST_VETERAN_ID,
        HANDBOOK_BATCH_REQUEST_ID,
        PERSON_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
       HANDBOOK_REQUEST_VETERAN_H_S.nextval,
        :old.HANDBOOK_REQUEST_VETERAN_ID,
        :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.PERSON_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_REQUEST_VETERAN_H
        (
       HANDBOOK_REQUEST_VETERAN_H_ID,
       HANDBOOK_REQUEST_VETERAN_ID,
        HANDBOOK_BATCH_REQUEST_ID,
        PERSON_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
       HANDBOOK_REQUEST_VETERAN_H_S.nextval,
        :new.HANDBOOK_REQUEST_VETERAN_ID,
        :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.PERSON_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_REQ_VET_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_REQUEST_VETERAN FOR ADR.HANDBOOK_REQUEST_VETERAN;


ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT BATREQVET_PK
  PRIMARY KEY
  (HANDBOOK_REQUEST_VETERAN_ID)
  USING INDEX ADR.HNDREQVET_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT RELATIONSHIP69 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ON DELETE SET NULL
  ENABLE NOVALIDATE,
  CONSTRAINT R_1063 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_REQUEST_VETERAN TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_REQUEST_VETERAN TO ES_RW;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HANDBOOK_REQUEST_VETERAN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HANDBOOK_REQUEST_VETERAN_H
(
  HANDBOOK_REQUEST_VETERAN_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  HANDBOOK_BATCH_REQUEST_ID      NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  HANDBOOK_REQUEST_VETERAN_H_ID  NUMBER(20)     NOT NULL,
  HISTORY_CREATED_DATE           DATE           NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HANDBOOK_REQUEST_VETERAN_H IS 'A veteran included in a batch request for document generation.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HANDBOOK_REQUEST_VETERAN_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.HNDREQVETH_PK ON ADR.HANDBOOK_REQUEST_VETERAN_H
(HANDBOOK_REQUEST_VETERAN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP69 ON ADR.HANDBOOK_REQUEST_VETERAN_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HANDBOOK_REQUEST_VETERAN_H FOR ADR.HANDBOOK_REQUEST_VETERAN_H;


ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H ADD (
  CONSTRAINT HNDREQVETH_PK
  PRIMARY KEY
  (HANDBOOK_REQUEST_VETERAN_H_ID)
  USING INDEX ADR.HNDREQVETH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ADR_RW;

GRANT SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HANDBOOK_REQUEST_VETERAN_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFITS_APPLICATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFITS_APPLICATION
(
  HEALTH_BENEFITS_APPLICATION_ID  NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  APPLICATION_DATE                DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  STD_HEALTHBENEFITTYPE_ID        NUMBER(20),
  Z07_FROM_VISTA_IND              VARCHAR2(1 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFITS_APPLICATION IS 'Basic information about an application made for healthcare benefits. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.HEALTH_BENEFITS_APPLICATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.STD_INSTITUTION_ID IS 'Site at which the application was made.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.APPLICATION_DATE IS 'BR2260Enrollment ApplicationDateis definedasthedateof theapplicationfor enrollment. Migrated and calculated for each veteran with an enrollment record.. ';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.STD_HEALTHBENEFITTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.Z07_FROM_VISTA_IND IS 'Indicates whether or not the HL7 message for this person has come from VISTA - this is actually a derived value that is persisted in the database in order to save repeated queries on the huge HL7 log table';


CREATE UNIQUE INDEX ADR.HEALTHAPP_PK ON ADR.HEALTH_BENEFITS_APPLICATION
(HEALTH_BENEFITS_APPLICATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPP_PRSN_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPP_STDHEALTH_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(STD_HEALTHBENEFITTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPP_STDINST_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENF_APPLN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.HEALTH_BENEFITS_APPLICATION for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into HEALTH_BENEFITS_APPLICATION_H
    (
    HEALTH_BENEFITS_APPLN_H_ID,
    HEALTH_BENEFITS_APPLICATION_ID,
    PERSON_ID,
    STD_INSTITUTION_ID,
    APPLICATION_DATE,
    STD_HEALTHBENEFITTYPE_ID,
    Z07_FROM_VISTA_IND,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE
        )
    values
    (
    HEALTH_BENEFITS_APP_H_S.nextval,
    :old.HEALTH_BENEFITS_APPLICATION_ID,
    :old.PERSON_ID,
    :old.STD_INSTITUTION_ID,
    :old.APPLICATION_DATE,
    :old.STD_HEALTHBENEFITTYPE_ID,
    :old.Z07_FROM_VISTA_IND,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    'D'
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into HEALTH_BENEFITS_APPLICATION_H
    (
    HEALTH_BENEFITS_APPLN_H_ID,
    HEALTH_BENEFITS_APPLICATION_ID,
    PERSON_ID,
    STD_INSTITUTION_ID,
    APPLICATION_DATE,
    STD_HEALTHBENEFITTYPE_ID,
    Z07_FROM_VISTA_IND,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE
        )
    values
    (
    HEALTH_BENEFITS_APP_H_S.nextval,
    :new.HEALTH_BENEFITS_APPLICATION_ID,
    :new.PERSON_ID,
    :new.STD_INSTITUTION_ID,
    :new.APPLICATION_DATE,
    :new.STD_HEALTHBENEFITTYPE_ID,
    :new.Z07_FROM_VISTA_IND,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    mDML
    );

  end if;

end  HEALTH_BENF_APPLN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFITS_APPLICATION FOR ADR.HEALTH_BENEFITS_APPLICATION;


ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLICATION_ID)
  USING INDEX ADR.HEALTHAPP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ADREXT;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFITS_APPLICATION TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFITS_APPLICATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
(
  HEALTH_BENEFITS_APPLN_H_ID      NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  HEALTH_BENEFITS_APPLICATION_ID  NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  APPLICATION_DATE                DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  STD_HEALTHBENEFITTYPE_ID        NUMBER(20),
  Z07_FROM_VISTA_IND              VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFITS_APPLICATION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.HEALTH_BENEFITS_APPLN_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.HEALTH_BENEFITS_APPLICATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.APPLICATION_DATE IS 'BR2260Enrollment ApplicationDateis definedasthedateof theapplicationfor enrollment.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.Z07_FROM_VISTA_IND IS 'Indicates whether or not the HL7 message for this person has come from VISTA - this is actually a derived value that is persisted in the database in order to save repeated queries on the huge HL7 log table';


CREATE UNIQUE INDEX ADR.HEALTHAPPH_PK ON ADR.HEALTH_BENEFITS_APPLICATION_H
(HEALTH_BENEFITS_APPLN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPPH_PRSNID_NU_I ON ADR.HEALTH_BENEFITS_APPLICATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFITS_APPLICATION_H FOR ADR.HEALTH_BENEFITS_APPLICATION_H;


ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_018
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT HEALTHAPPH_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLN_H_ID)
  USING INDEX ADR.HEALTHAPPH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADREXT;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADR_R;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN
(
  HEALTH_BENEFIT_PLAN_ID       NUMBER(20)       NOT NULL,
  HEALTH_BENEFIT_PROFILE_ID    NUMBER(20)       NOT NULL,
  STD_HEALTHBENEFITPLAN_ID     NUMBER(20)       NOT NULL,
  HEALTH_BNFT_PLN_UPDATE_DATE  DATE,
  STD_DATACHANGESOURCE_ID      NUMBER(20)       NOT NULL,
  STD_INSTITUTION_ID           NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  OVERRIDE_FLAG                NUMBER(1),
  OVERRIDE_ASSIGNMENT          NUMBER(1),
  OVERRIDE_REASON              VARCHAR2(200 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PLAN IS 'A description of a type of benefit used to associate the authority for care to the provisioning of health care services for a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.HEALTH_BENEFIT_PLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.STD_HEALTHBENEFITPLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.STD_DATACHANGESOURCE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.STD_INSTITUTION_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HLTBNFPLN_HLTBNFPRF_FK_I ON ADR.HEALTH_BENEFIT_PLAN
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPLN_PK ON ADR.HEALTH_BENEFIT_PLAN
(HEALTH_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENEFIT_PLAN_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.Health_Benefit_Plan
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO Health_Benefit_Plan_H
        (Health_benefit_plan_h_id,
         Health_benefit_plan_id,
         Health_benefit_profile_id,
         Std_healthbenefitplan_id,
         Health_bnft_pln_update_date,
         Std_datachangesource_id,
         Std_institution_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Override_flag,
         Override_assignment,
         Override_reason,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Plan_H_S.NEXTVAL,
         :OLD.Health_benefit_plan_id,
         :OLD.Health_benefit_profile_id,
         :OLD.Std_healthbenefitplan_id,
         :OLD.Health_bnft_pln_update_date,
         :OLD.Std_datachangesource_id,
         :OLD.Std_institution_id,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         :OLD.Override_flag,
         :OLD.Override_assignment,
         :OLD.Override_reason,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into HEALTH_BENEFIT_PLAN_H
        (Health_benefit_plan_h_id,
         Health_benefit_plan_id,
         Health_benefit_profile_id,
         Std_healthbenefitplan_id,
         Health_bnft_pln_update_date,
         Std_datachangesource_id,
         Std_institution_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Override_flag,
         Override_assignment,
         Override_reason,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Plan_H_S.NEXTVAL,
         :NEW.Health_benefit_plan_id,
         :NEW.Health_benefit_profile_id,
         :NEW.Std_healthbenefitplan_id,
         :NEW.Health_bnft_pln_update_date,
         :NEW.Std_datachangesource_id,
         :NEW.Std_institution_id,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         :NEW.Override_flag,
         :NEW.Override_assignment,
         :NEW.Override_reason,
         mDML
        );

    END IF;

  END Health_Benefit_Plan_Audir_Trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN FOR ADR.HEALTH_BENEFIT_PLAN;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTHBENPLN_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_ID)
  USING INDEX ADR.HLTHBENPLN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTBNFPLN_HLTBNFPRF_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PROFILE_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PROFILE (HEALTH_BENEFIT_PROFILE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ES_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN TO VETCHOICE_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_DESC CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_DESC
(
  HLTH_BEN_PLAN_DESC_ID          NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_DESCRIPTION      CLOB           NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER         NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  HEALTH_BENEFIT_PLAN_DETAIL_ID  NUMBER(20)     NOT NULL
)
LOB (HLTH_BEN_PLAN_DESCRIPTION) STORE AS (
  TABLESPACE  L_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_DESC.HLTH_BEN_PLAN_DESC_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_DESC.HLTH_BEN_PLAN_DESCRIPTION IS 'Health Benefit Plan Description';


CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_PK ON ADR.HEALTH_BENEFIT_PLAN_DESC
(HLTH_BEN_PLAN_DESC_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HLTH_BEN_PLAN_DESC_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.HEALTH_BENEFIT_PLAN_DESC
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_DESC_H
        (HLTH_BEN_PLAN_DESC_H_ID,
         HLTH_BEN_PLAN_DESC_ID,
         HLTH_BEN_PLAN_DESCRIPTION,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         HEALTH_BENEFIT_PLAN_DETAIL_ID
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DESC_H_S.NEXTVAL,
         :OLD.HLTH_BEN_PLAN_DESC_ID,
         :OLD.HLTH_BEN_PLAN_DESCRIPTION,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         'D',
         :OLD.HEALTH_BENEFIT_PLAN_DETAIL_ID
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into ADR.HEALTH_BENEFIT_PLAN_DESC_H
        (HLTH_BEN_PLAN_DESC_H_ID,
         HLTH_BEN_PLAN_DESC_ID,
         HLTH_BEN_PLAN_DESCRIPTION,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         HEALTH_BENEFIT_PLAN_DETAIL_ID
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DESC_H_S.NEXTVAL,
         :NEW.HLTH_BEN_PLAN_DESC_ID,
         :NEW.HLTH_BEN_PLAN_DESCRIPTION,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         mDML,
         :NEW.HEALTH_BENEFIT_PLAN_DETAIL_ID
        );

    END IF;

  END HLTH_BEN_PLAN_DESC_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_DESC FOR ADR.HEALTH_BENEFIT_PLAN_DESC;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_DESC_ID)
  USING INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC ADD (
  CONSTRAINT HLTHBENPLANDESC_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PLAN_DETAIL_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PLAN_DETAIL (HEALTH_BENEFIT_PLAN_DETAIL_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H
(
  HLTH_BEN_PLAN_DESC_H_ID        NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_DESC_ID          NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_DESCRIPTION      CLOB,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER         NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  HISTORY_CREATED_DATE           DATE           NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  HEALTH_BENEFIT_PLAN_DETAIL_ID  NUMBER(20)     NOT NULL
)
LOB (HLTH_BEN_PLAN_DESCRIPTION) STORE AS (
  TABLESPACE  L_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_DESC_H.HLTH_BEN_PLAN_DESC_H_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_DESC_H.HLTH_BEN_PLAN_DESC_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_DESC_H.HLTH_BEN_PLAN_DESCRIPTION IS 'Health Benefit Plan Description';


CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_H_PK ON ADR.HEALTH_BENEFIT_PLAN_DESC_H
(HLTH_BEN_PLAN_DESC_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_DESC_H FOR ADR.HEALTH_BENEFIT_PLAN_DESC_H;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_H_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_DESC_H_ID)
  USING INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DESC_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL
(
  HEALTH_BENEFIT_PLAN_DETAIL_ID  NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_NAME_ID          NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_CODE             VARCHAR2(20 BYTE),
  HLTH_BEN_PLAN_COV_CODE         VARCHAR2(20 BYTE),
  HLTH_BEN_PLAN_EFF_DATE         DATE           NOT NULL,
  HLTH_BEN_PLAN_EXP_DATE         DATE,
  HLTH_BEN_PLAN_AUTO_IND         VARCHAR2(1 BYTE) DEFAULT '0' NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.HLTHBENPLANDET_HBPCCD_UI ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
(HLTH_BEN_PLAN_COV_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPLANDET_HBPCD_UI ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
(HLTH_BEN_PLAN_COV_CODE, HLTH_BEN_PLAN_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPLANDET_PK ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
(HEALTH_BENEFIT_PLAN_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HLTH_BEN_PLN_DTL_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
        (HEALTH_BENEFIT_PLAN_DET_H_ID,
         HEALTH_BENEFIT_PLAN_DETAIL_ID,
         HLTH_BEN_PLAN_NAME_ID,
         HLTH_BEN_PLAN_CODE,
      	 HLTH_BEN_PLAN_COV_CODE,
     	 HLTH_BEN_PLAN_EFF_DATE,
     	 HLTH_BEN_PLAN_EXP_DATE,
         HLTH_BEN_PLAN_AUTO_IND,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DETAIL_H_S.NEXTVAL,
         :OLD.HEALTH_BENEFIT_PLAN_DETAIL_ID,
     	 :OLD.HLTH_BEN_PLAN_NAME_ID,
    	 :OLD.HLTH_BEN_PLAN_CODE,
     	 :OLD.HLTH_BEN_PLAN_COV_CODE,
     	 :OLD.HLTH_BEN_PLAN_EFF_DATE,
    	 :OLD.HLTH_BEN_PLAN_EXP_DATE,
     	 :OLD.HLTH_BEN_PLAN_AUTO_IND,
     	 :OLD.RECORD_CREATED_BY,
     	 :OLD.RECORD_CREATED_DATE,
     	 :OLD.RECORD_MODIFIED_BY,
     	 :OLD.RECORD_MODIFIED_DATE,
     	 :OLD.RECORD_MODIFIED_COUNT,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
      (HEALTH_BENEFIT_PLAN_DET_H_ID,
         HEALTH_BENEFIT_PLAN_DETAIL_ID,
         HLTH_BEN_PLAN_NAME_ID,
         HLTH_BEN_PLAN_CODE,
         HLTH_BEN_PLAN_COV_CODE,
         HLTH_BEN_PLAN_EFF_DATE,
         HLTH_BEN_PLAN_EXP_DATE,
         HLTH_BEN_PLAN_AUTO_IND,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DETAIL_H_S.NEXTVAL,
           :NEW.HEALTH_BENEFIT_PLAN_DETAIL_ID,
           :NEW.HLTH_BEN_PLAN_NAME_ID,
           :NEW.HLTH_BEN_PLAN_CODE,
           :NEW.HLTH_BEN_PLAN_COV_CODE,
           :NEW.HLTH_BEN_PLAN_EFF_DATE,
           :NEW.HLTH_BEN_PLAN_EXP_DATE,
           :NEW.HLTH_BEN_PLAN_AUTO_IND,
           :NEW.RECORD_CREATED_BY,
           :NEW.RECORD_CREATED_DATE,
           :NEW.RECORD_MODIFIED_BY,
           :NEW.RECORD_MODIFIED_DATE,
           :NEW.RECORD_MODIFIED_COUNT,
         SYSDATE,
         mDML
      );

    END IF;

  END HLTH_BEN_PLAN_DESC_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_DETAIL FOR ADR.HEALTH_BENEFIT_PLAN_DETAIL;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL ADD (
  CONSTRAINT HLTHBENPLANDET_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_DETAIL_ID)
  USING INDEX ADR.HLTHBENPLANDET_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL ADD (
  CONSTRAINT HLTHBENPLNDTL_HLTHPLNNAMEID_FK 
  FOREIGN KEY (HLTH_BEN_PLAN_NAME_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PLAN_NAME (HLTH_BEN_PLAN_NAME_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
(
  HEALTH_BENEFIT_PLAN_DET_H_ID   NUMBER(20)     NOT NULL,
  HEALTH_BENEFIT_PLAN_DETAIL_ID  NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_NAME_ID          NUMBER(20)     NOT NULL,
  HLTH_BEN_PLAN_CODE             VARCHAR2(20 BYTE),
  HLTH_BEN_PLAN_COV_CODE         VARCHAR2(20 BYTE),
  HLTH_BEN_PLAN_EFF_DATE         DATE           NOT NULL,
  HLTH_BEN_PLAN_EXP_DATE         DATE,
  HLTH_BEN_PLAN_AUTO_IND         VARCHAR2(1 BYTE) DEFAULT 'O' NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  HISTORY_CREATED_DATE           DATE           NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.HLTH_BEN_PLAN_DETAIL_H_PK ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
(HEALTH_BENEFIT_PLAN_DET_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_DETAIL_H FOR ADR.HEALTH_BENEFIT_PLAN_DETAIL_H;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H ADD (
  CONSTRAINT HEALTH_BEN_PLAN_DETAIL_H_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_DET_H_ID)
  USING INDEX ADR.HLTH_BEN_PLAN_DETAIL_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_H
(
  HEALTH_BENEFIT_PLAN_H_ID     NUMBER(20)       NOT NULL,
  HEALTH_BENEFIT_PLAN_ID       NUMBER(20)       NOT NULL,
  HEALTH_BENEFIT_PROFILE_ID    NUMBER(20),
  STD_HEALTHBENEFITPLAN_ID     NUMBER(20),
  HEALTH_BNFT_PLN_UPDATE_DATE  DATE,
  STD_DATACHANGESOURCE_ID      NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  HISTORY_CREATED_DATE         DATE             NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  OVERRIDE_FLAG                NUMBER(1),
  OVERRIDE_ASSIGNMENT          NUMBER(1),
  OVERRIDE_REASON              VARCHAR2(200 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PLAN_H IS 'A description of a type of benefit used to associate the authority for care to the provisioning of health care services for a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HEALTH_BENEFIT_PLAN_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HEALTH_BENEFIT_PLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.STD_HEALTHBENEFITPLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.STD_DATACHANGESOURCE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.STD_INSTITUTION_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.HLTHBENPLNH_BENPLANID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE INDEX ADR.HLTHBENPLNH_BENPROFID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE UNIQUE INDEX ADR.HLTHBENPLNH_PK ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PLAN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HLTHBENPLNH_SHBPID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(STD_HEALTHBENEFITPLAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_H FOR ADR.HEALTH_BENEFIT_PLAN_H;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H ADD (
  CONSTRAINT HLTHBENPLNH_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_H_ID)
  USING INDEX ADR.HLTHBENPLNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_NAME CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_NAME
(
  HLTH_BEN_PLAN_NAME_ID       NUMBER(20)        NOT NULL,
  HLTH_BEN_PLAN_NAME          VARCHAR2(300 BYTE) NOT NULL,
  STD_HLTHBENEFITPLANTYPE_ID  NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_PK ON ADR.HEALTH_BENEFIT_PLAN_NAME
(HLTH_BEN_PLAN_NAME_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPLNDEFNM_UI ON ADR.HEALTH_BENEFIT_PLAN_NAME
(HLTH_BEN_PLAN_NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HLTH_BEN_PLN_NAM_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.HEALTH_BENEFIT_PLAN_NAME
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_NAME_H
          (HLTH_BEN_PLAN_NAME_H_ID ,
    	   HLTH_BEN_PLAN_NAME_ID,
   	   HLTH_BEN_PLAN_NAME,
    	   STD_HLTHBENEFITPLANTYPE_ID ,
           RECORD_CREATED_BY,
           RECORD_CREATED_DATE,
           RECORD_MODIFIED_BY,
           RECORD_MODIFIED_DATE,
           RECORD_MODIFIED_COUNT,
           HISTORY_CREATED_DATE ,
           TRANSACTION_TYPE_CODE
       )
      VALUES
        (HEALTH_BENEFIT_PLAN_NAME_H_S.NEXTVAL,
         :OLD.HLTH_BEN_PLAN_NAME_ID,
         :OLD.HLTH_BEN_PLAN_NAME,
         :OLD.STD_HLTHBENEFITPLANTYPE_ID,
         :OLD.RECORD_CREATED_BY,
         :OLD.RECORD_CREATED_DATE,
         :OLD.RECORD_MODIFIED_BY,
         :OLD.RECORD_MODIFIED_DATE,
         :OLD.RECORD_MODIFIED_COUNT,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_NAME_H
      (	HLTH_BEN_PLAN_NAME_H_ID ,
       	HLTH_BEN_PLAN_NAME_ID,
     	HLTH_BEN_PLAN_NAME,
     	STD_HLTHBENEFITPLANTYPE_ID ,
     	RECORD_CREATED_BY,
     	RECORD_CREATED_DATE,
     	RECORD_MODIFIED_BY,
     	RECORD_MODIFIED_DATE,
     	RECORD_MODIFIED_COUNT,
     	HISTORY_CREATED_DATE ,
     	TRANSACTION_TYPE_CODE
     )
     VALUES
     	(HEALTH_BENEFIT_PLAN_NAME_H_S.NEXTVAL,
     	:NEW.HLTH_BEN_PLAN_NAME_ID,
     	:NEW.HLTH_BEN_PLAN_NAME,
     	:NEW.STD_HLTHBENEFITPLANTYPE_ID,
     	:NEW.RECORD_CREATED_BY,
     	:NEW.RECORD_CREATED_DATE,
     	:NEW.RECORD_MODIFIED_BY,
     	:NEW.RECORD_MODIFIED_DATE,
     	:NEW.RECORD_MODIFIED_COUNT,
     	 SYSDATE,
         mDML
        );

    END IF;

  END HLTH_BEN_PLN_NAM_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_NAME FOR ADR.HEALTH_BENEFIT_PLAN_NAME;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_NAME_ID)
  USING INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME ADD (
  CONSTRAINT STD_HLTHBENEFITPLANTYPEID_FK 
  FOREIGN KEY (STD_HLTHBENEFITPLANTYPE_ID) 
  REFERENCES ADRREF.STD_HLTHBENEFITPLANTYPE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H
(
  HLTH_BEN_PLAN_NAME_H_ID     NUMBER(20)        NOT NULL,
  HLTH_BEN_PLAN_NAME_ID       NUMBER(20)        NOT NULL,
  HLTH_BEN_PLAN_NAME          VARCHAR2(300 BYTE) NOT NULL,
  STD_HLTHBENEFITPLANTYPE_ID  NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  HISTORY_CREATED_DATE        DATE              NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_H_PK ON ADR.HEALTH_BENEFIT_PLAN_NAME_H
(HLTH_BEN_PLAN_NAME_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_NAME_H FOR ADR.HEALTH_BENEFIT_PLAN_NAME_H;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_H_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_NAME_H_ID)
  USING INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_NAME_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PROFILE CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PROFILE
(
  HEALTH_BENEFIT_PROFILE_ID  NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PROFILE IS 'A collection of Health Benefit Plans associated to a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.PERSON_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HLTBNFPRF_PRSN_FK_I ON ADR.HEALTH_BENEFIT_PROFILE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPRF_PK ON ADR.HEALTH_BENEFIT_PROFILE
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENEFIT_PROF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.Health_Benefit_Profile
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO Health_Benefit_Profile_H
        (Health_benefit_profile_h_id,
         Health_benefit_profile_id,
         Person_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Profile_H_S.NEXTVAL,
         :OLD.Health_benefit_profile_id,
         :OLD.Person_id,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         'D' 
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO Health_Benefit_Profile_H
        (Health_benefit_profile_h_id,
         Health_benefit_profile_id,
         Person_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Profile_H_S.NEXTVAL,
         :NEW.Health_benefit_profile_id,
         :NEW.Person_id,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         mDML
        );

    END IF;

  END Health_Benefit_Prof_Audir_Trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PROFILE FOR ADR.HEALTH_BENEFIT_PROFILE;


ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTHBENPRF_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PROFILE_ID)
  USING INDEX ADR.HLTHBENPRF_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTBNFPRF_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PROFILE TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ES_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PROFILE TO VETCHOICE_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PROFILE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PROFILE_H
(
  HEALTH_BENEFIT_PROFILE_H_ID  NUMBER(20),
  HEALTH_BENEFIT_PROFILE_ID    NUMBER(20),
  PERSON_ID                    NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  HISTORY_CREATED_DATE         DATE,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PROFILE_H IS 'A collection of Health Benefit Plans associated to a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.HEALTH_BENEFIT_PROFILE_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.PERSON_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.HEALTHPROFH_PRSNID_NU_I ON ADR.HEALTH_BENEFIT_PROFILE_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPRFH_PK ON ADR.HEALTH_BENEFIT_PROFILE_H
(HEALTH_BENEFIT_PROFILE_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PROFILE_H FOR ADR.HEALTH_BENEFIT_PROFILE_H;


ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297522
  CHECK ("HEALTH_BENEFIT_PROFILE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297523
  CHECK ("HEALTH_BENEFIT_PROFILE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297524
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297525
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297526
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297527
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297528
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297529
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00297530
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT HLTHBENPRFH_PK
  PRIMARY KEY
  (HEALTH_BENEFI